/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// SrlDeviceContainer.h: interface for the CSrlDeviceContainer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SRLDEVICECONTAINER_H__540CE344_14F2_4A0A_B325_6674899CCED8__INCLUDED_)
#define AFX_SRLDEVICECONTAINER_H__540CE344_14F2_4A0A_B325_6674899CCED8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef class CSrlDeviceContainer *pSrlDeviceContainer;

//-----------------------------------------------------------
// Srl device is an object that has one or more SRL handles 
//   ( obtained via functions xx_open() - gc_Opem, dx_open etc.
//
// CSrlDeviceContainer is a
// List of Srl Devices and other CSrlDeviceContainers
//  Implement requests for group actions for all related Srl devices:
//      - Exit Request
//      - Determine if all devices reach specific state
//      - Determine if any device reach specific state
//      - Determine which device should handle event for specific handle
//      - Check all devices for TMO condition
//
//  Container itself could be SRL device. For Example:
//      CnfB1 is an Srl device and contains CnfB1C1, cnfB1C2 etc
//   
//

class CSrlDeviceContainer : public CSrlDevice {
public:

	CSrlDeviceContainer(DLG_DEVICE_TYPE devtype,
                        PCommonParams pCommonParams,
                        const char *name);
	virtual ~CSrlDeviceContainer();

    virtual const char *state_name(int state) {
        return common_state_name(state);
    }

    virtual bool ExitRequest();

    virtual bool AreSrlStates(int state, bool compare_flag, PSrlDevice *ppDev);
    virtual bool AnySrlState(int state, bool compare_flag,  PSrlDevice *ppDev);

    virtual bool AreYouHandle(int srl_handle, PSrlDevice *ppDev);

protected:
    virtual bool CheckTmo(); // Check for timeouts

// Container
public:
    void push_back(PSrlDevice pDev){
        m_DeviceList.push_back(pDev);
    }

    void remove(PSrlDevice pDev){
        m_DeviceList.remove(pDev);
    }

    size_t size(){
        return m_DeviceList.size();
    }

    list<PSrlDevice>::iterator begin(){
        return m_DeviceList.begin();
    };

    list<PSrlDevice>::iterator end(){
        return m_DeviceList.end();
    };
    
    void DumpMembers();


private:
    list <PSrlDevice > m_DeviceList;

}; // End of CSrlDeviceContainer

#endif // !defined(AFX_SRLDEVICECONTAINER_H__540CE344_14F2_4A0A_B325_6674899CCED8__INCLUDED_)
