/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************

//
// Some GlobalCall related functions (global scope)
//

#include "pdl.h"

static const char *CNF_MODULE_NAME = "GC_WRAPPER";

static bool gc_started = false; // indicates either gc was started

//*****************************************************************************
// Purpose	: 
//    invoke gc_Start
// Parameters:	
//    [in] pAppParams - Application parameters (from configuration file)
// Returns:	
//    bool
//*****************************************************************************
#define NUM_VIRTBOARDS 1
bool gc_start_wrapper(CnfDemoPrm  * pAppParams) {
bool brc = false;
    if (!gc_started) {
	    GC_START_STRUCT	gclib_start;
	    IPCCLIB_START_DATA cclibStartData;
	    IP_VIRTBOARD virtBoards[NUM_VIRTBOARDS];        // 
        
        // Init data structure and IP_VIRTBOARDS
		INIT_IPCCLIB_START_DATA(&cclibStartData, NUM_VIRTBOARDS, virtBoards);
        for (int inx = 0; inx < NUM_VIRTBOARDS; inx++ ){
              INIT_IP_VIRTBOARD(&(virtBoards[inx]));
        }

	    cclibStartData.num_boards = NUM_VIRTBOARDS;
	    cclibStartData.board_list = &(virtBoards[0]);
		cclibStartData.max_parm_data_size = MAX_SDP_MESSAGE;
		cclibStartData.media_operational_mode = pAppParams->GetCommonPrm()->m_call_control_mode;

        // Specify non-default parameters from configuration file
        int all_calls = pAppParams->GetRequestedNumberOfIptDevices();  // SIP/H323/IP
        int sip_calls = pAppParams->GetRequestedNumberOfIptDevices("SIP");
        int h323_calls = pAppParams->GetRequestedNumberOfIptDevices("H323");
        int ip_calls = pAppParams->GetRequestedNumberOfIptDevices("IP");
	    virtBoards[0].total_max_calls = all_calls;
	    virtBoards[0].h323_max_calls  = h323_calls + ip_calls;
	    virtBoards[0].sip_max_calls   = sip_calls + ip_calls;
        if (sip_calls){
            virtBoards[0].sip_msginfo_mask  = IP_SIP_MSGINFO_ENABLE | IP_SIP_MIME_ENABLE  ;
		                    //  IP_SIP_MSGINFO_ENABLE 
		                    //  IP_SIP_MIME_ENABLE  
		                    //  IP_SIP_FASTSTART_CODERS_IN_OFFERED
        }
        // Specify cc libraries to start
        int num_libs = 0;
        CCLIB_START_STRUCT cclib_start[3];
            cclib_start[num_libs].cclib_name = "GC_H3R_LIB";
            cclib_start[num_libs++].cclib_data = &cclibStartData;

            cclib_start[num_libs].cclib_name = "GC_IPM_LIB";
            cclib_start[num_libs++].cclib_data = 0;

            if ( pAppParams->GetRequestedNumberOfDtiDevices() > 0 ){
                 cclib_start[num_libs].cclib_name = "GC_DM3CC_LIB";
                 cclib_start[num_libs++].cclib_data = 0;
            }
            
    	gclib_start.num_cclibs = num_libs;
	    gclib_start.cclib_list = cclib_start;

        gc_dump(&gclib_start, LOG_DBG,  glb_pAppLog, CNF_MODULE_NAME);

        GLBLOG(LOG_DBG, CNF_MODULE_NAME,"***Entering gc_Start()");
          int rc =  gc_Start(&gclib_start);
        GLBLOG(RC(rc), CNF_MODULE_NAME,
                    "%d = gc_Start(%d ipt devices)",
                    rc, pAppParams->GetRequestedNumberOfIptDevices());

        if (rc == GC_SUCCESS){
            gc_started = true;
            brc = true;
        } else {
            process_gc_error(CNF_MODULE_NAME);
        } 
    }else { 
        GLBLOG(LOG_ERR1, CNF_MODULE_NAME,
                         "gc_Start:: GC is already started");
    }
 return brc;
}//	End of gc_start_wrapper()

//*****************************************************************************
// Purpose	: 
//    invoke gc_Stop
// Parameters:	
//    none
// Returns:	
//    bool
//*****************************************************************************
bool gc_stop_wrapper() {
bool brc = true;
   if ( gc_started) {
        GLBLOG(LOG_DBG, CNF_MODULE_NAME, "***Entering gc_Stop()");
          int rc = gc_Stop();
        GLBLOG(RC(rc), CNF_MODULE_NAME, "%d = gc_Stop()", rc );
        if (rc != GC_SUCCESS) {
            process_gc_error(CNF_MODULE_NAME);
            brc = false;
        }
        gc_started = false;
   }
   return brc;
} // End of gc_stop_wrapper()

//*****************************************************************************
// Purpose	: 
//    process latest gc error
// Parameters:	
//    [in] object name - used for Log purposes (use device name or module name)
// Returns:	
//    bool - false indicates error while processing - too bad :( 
//*****************************************************************************
bool process_gc_error(const char *name){
  // process error return as shown
GC_INFO gc_error_info;
int rc;
bool brc = true;
    rc = gc_ErrorInfo( &gc_error_info );
    GLBLOG(RC(rc), name, "%d = gc_ErrorInfo( &gc_error_info )", rc);
    if (rc == GC_SUCCESS) {
        gc_dump(&gc_error_info, LOG_APP, GLBLOGOBJ, CNF_MODULE_NAME);
    }else {
        brc = false;
    }
 return brc;
} // End of process_gc_error()

//*****************************************************************************
// Purpose	: 
//   Dump structure GC_INFO 
// Parameters:	
//    [in] GC_UNFO structure, Log type, Log object and name of the logging object
// Returns:	
//    none
//*****************************************************************************
void gc_dump(GC_INFO *pInfo, MSG_TYPE Msg, CGenLog *pLog, const char *name){
    pLog->Log(Msg, name, "GC    ErrorValue: = 0x%x - %s",pInfo->gcValue, pInfo->gcMsg);
    pLog->Log(Msg, name, "CClib ErrorValue: = 0x%x - %s",pInfo->ccValue, pInfo->ccMsg);
    pLog->Log(Msg, name, "CClib             = 0x%x - %s",pInfo->ccLibId, pInfo->ccLibName);
 return;
} // End of gc_dump()

//*****************************************************************************
// Purpose	: 
//   Dump structure GC_START
// Parameters:	
//    [in] GC_UNFO structure, Log type, Log object and name of the logging object
// Returns:	
//    none
//*****************************************************************************
extern void gc_dump(GC_START_STRUCT *pStart,MSG_TYPE Msg, CGenLog *pLog, const char *name){

    pLog->Log(Msg, name, "Num_cclibs = %d", pStart->num_cclibs);
    int inx;
    for (inx = 0; inx < pStart->num_cclibs; inx++) {
         gc_dump(&(pStart->cclib_list[inx]),Msg,pLog,name);
    }
} // End of gc_dump()

//*****************************************************************************
// Purpose	: 
//   Dump structure GC_START
// Parameters:	
//    [in] GC_UNFO structure, Log type, Log object and name of the logging object
// Returns:	
//    none
//*****************************************************************************
extern void gc_dump(CCLIB_START_STRUCT *pStart,MSG_TYPE Msg, CGenLog *pLog, const char *name){

    pLog->Log(Msg, name, " cclib_name  = %s",   pStart->cclib_name);
    pLog->Log(Msg, name, "  cclib_data = 0x%x", pStart->cclib_data);
} // End of gc_dump()

