/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// utils.h:
// Global functions
//
// interface for classes:
//       CNamedObj 
//       CNameTable
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_UTIL_H__3F1A529E_E713_4692_81C4_AAEA9606E1A1__INCLUDED_)
#define AFX_UTIL_H__3F1A529E_E713_4692_81C4_AAEA9606E1A1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

// Common include files
#include "win_unix.h"
#include <sys/timeb.h>

//   ------ Windows & Linux ---------

#ifdef WIN32
#  if _MSC_VER < 1300
//    for MSC 6.0 and earlier
#     pragma warning (disable:4018)   // signed/unsigned mismatch
#     pragma warning (disable:4100)   // unreferenced parameter
#     pragma warning (disable:4511)   // copy constructor could not be generated
#     pragma warning (disable:4512)   // assignment operator could not be generated
#     pragma warning (disable:4663)   // C++ language change: to explicitly specialize class template 'codecvt' use the following syntax:    template<> class codecvt<unsigned short,char,int> ...
#     pragma warning (disable:4245)   // conversion from 'const int' to 'const unsigned int', signed/unsigned mismatch
#  endif // MSC wer
#endif   // WIN

#include <string.h>
#include <list>

//#include <string>
//#include <queue>
//#include <vector>

#ifdef WIN32
#  if _MSC_VER < 1300
// for 6.0 and earlier
#     pragma warning (default:4018)   // back to original 
#     pragma warning (default:4511)
#     pragma warning (default:4512)
#     pragma warning (default:4663)
#     pragma warning (default:4245)
#  endif // MSC ver
#endif   // WIN

using namespace std;

// Max & Min

template <class T> 
  T tmax(T a, T b) {
      return a > b ? a : b ;
}; 

template <class T>
  T tmin(T a, T b) {
       return a > b ? b : a ;
}; 


// Demo version
extern const char * BINARY_VERSION_STRING;


#define YESNO(x)     (x?"Yes":" No")
#define CHECKNULL(x) (x?x:"<Null>")

#define MAXTOKEN 512
#define MAXUINT ((unsigned int)-1)

// return codes for compare
#define COMPARE_LESS  (-1)
#define COMPARE_GREAT 1
#define COMPARE_EQUAL 0

#define STR_NEWLINE "\n"
#define CHAR_NEWLINE '\n'



//-------------------------------------------------------
// Find a name in given name table
// A name table is: pair (name, code)
typedef struct {
  const char *name;
  int code;
}NAME_TABLE, *PNAME_TABLE;

bool str_findname(int code, const char **name, const NAME_TABLE *table );
bool str_findcode(const char *name, int *code, const NAME_TABLE *table );

class CNameTable {
 public:
     CNameTable(const NAME_TABLE *pTable)
         : m_pTable(pTable){
     }
     virtual ~CNameTable(){
     }

     const char *find_name(int code){
        const char *name;
        str_findname(code, &name, m_pTable);
        return name;
     }

     int find_code(const char *name) {
        int code;
        str_findcode(name,&code,m_pTable);
        return code;
     }
 private:
     const NAME_TABLE *m_pTable;
};



//-----------------------------
// Global functions
//-----------------------------
// Print message and wait a keystroke
extern void con_wait_a_key(int ret_code, const char *txt);

//-----------------------------------------------
// Utilities to store
// Delete previously stored (in *Holder) string 
bool str_deletestoredstring(char **Holder);

// allocate space and create Empty string holder by given length
bool str_storestring(char **Holder, size_t length);

// Allocate space and store a copy of the given string
bool str_storestring(char **Holder, const char *value);


// ----------------------------------------------
// Utilities to copy ( s_strcpy )
//------------------------------------------------------------------
// safe copy, guaranteed to be terminated with 0 and
// performs boundary check
// returns destination
char * str_safecopy(char *destination, size_t maxlen, const char *src);

// strings concatanetion
char * str_safecat( char *dest, size_t maxlen, const char *src1);
char * str_safecat( char *dest, size_t maxlen, const char *src1,
                                               const char *src2);
char * str_safecat( char *dest, size_t maxlen, const char *src1,
                                               const char *src2,
                                               const char *src3);

// Compare
int  str_compare( const char *str1, const char *str2);

// Inspect content
bool str_isnumber(const char *string);
bool str_getnumber(const char *string, int *result);
bool inline str_getnumber(const char *string, unsigned int *result){
    return str_getnumber(string, (int *)result);
}
bool str_getunsignednumber(const char *string, unsigned int *result);

//
// trim blanks 
char * str_rtrim(char *destination);         // from right
char * str_ltrim(char *destination);         // from left + shift
inline char * str_trim(char *destination){   // both
    return str_rtrim(str_ltrim(destination));
}

//
// A global request to exit
void glb_exit_request(bool is_internal, bool is_fatal);

//
// Get system time & convert to string
const char *  time_asstring();
void timeb_diff(struct timeb *  result,
	   		    struct timeb *  bgntime,
			    struct timeb *  endtime);
bool time_isgreater(int milliseconds,struct timeb * time); 

//
// Log objects should be defined

#include "FileLog.h"
#include "ConsoleLog.h"



// --------------------------------------------------------------------------
// An object that can measure time
// 
// TIMER
typedef class CTimer *PTimer;
class CTimer {
    public:
        CTimer() {
             memset(&m_timer,0,sizeof(m_timer));
             time_expire = 0;
             dflt_timer = 0;
        }

        // Polling mode 
        bool CheckTimer();

        // Start timer
        void StartTimer(int expire){
             ftime(&m_timer);
             time_expire = expire;
        };

        // Start timer with default value
        void StartTimer(){
             ftime(&m_timer);
             time_expire = dflt_timer;
        };

        // Stop timer
        void StopTimer(){
             memset(&m_timer,0,sizeof(m_timer));
             time_expire = 0;
        };
        
        void SetDfltTimer(int tmo){
             dflt_timer = tmo;   
        }

        int GetDfltTimer(){
             return dflt_timer;   
        }

    private:
        struct timeb m_timer;
        int    time_expire;  // in ms - how long to wait before
        int    dflt_timer;   // in ms - default value for start timer

};

//---------------------------------------------------------------------------
// An object that has name ( such as dxxxB1C1 )
// SetName allocates a space to store specified name
// UseName is using a name that is owned by other object (just set a pointer to the name)
typedef class CNamedObj *PNamedObj;
class CNamedObj {
 public:
     CNamedObj(){
        m_name_created = false; 
        m_sName = 0;
     };

     // constructor by name
     CNamedObj(const char *name){
        m_name_created = false; 
        m_sName = 0;
        SetName(name);
     };

     // copy constructor
     CNamedObj(CNamedObj &src){
        m_name_created = false; 
        m_sName = 0;
        SetName(src.GetName());
     };

     virtual ~CNamedObj(){
        if (m_name_created){
            str_deletestoredstring((char **)&m_sName);
            m_name_created = false;
        }
        m_sName = 0;
     };

     int operator == (CNamedObj &obj) {
         if (this == &obj){
             return 1;
         }
         return COMPARE_EQUAL == str_compare(GetName(),obj.GetName());
     }

     int operator > (CNamedObj &obj) {
         if (this == &obj){
             return 0;
        }
         return str_compare(GetName(),obj.GetName());
     }

     int operator < (CNamedObj &obj) {
         if (this == &obj){
             return false;
         }
         return str_compare(obj.GetName(), GetName());
     }    
          
     // Useing private copy of the name
     void SetName(const char *name){
           if (!m_name_created) {
                m_sName = 0;
           } 
           m_name_created = true;
           str_storestring((char **)&m_sName,name);
     }

     // Returns name
  	 const char *GetName(){
        if (!m_sName) {
			return "unknown";
        }
		return m_sName;
     };

     // Does it have name?
  	 bool HasName(){
		return m_sName != 0;
     };

     // Use name as provided, other object owns it
     void UseName(const char *name){
         if (m_name_created){
             str_deletestoredstring((char **)&m_sName);
         }
         m_name_created = false;
         m_sName = name;
     }

 private:
     const char *m_sName;
     bool m_name_created;
}; // class CNamedObj

//-------------------------------------------------------
// Container for NamedObj(ect's)
//------------------------------------------------------- 
class CObjList : public list<PNamedObj> {
public:

    CObjList(){};

    ~CObjList(){
        CNamedObj *pObj;
        while ( Get(&pObj) ) {
            delete pObj;
        }
    }

    void Dump(CGenLog *pLog){
        list<PNamedObj>::iterator pos;
        for (pos = begin(); pos != end(); ++pos) {
             pLog->Log(LOG_APP, "CObjList", "    %s", (*pos)->GetName());            
        } 
    }

    bool Define(const char *name){
        CNamedObj *pObj = new CNamedObj(name);
        push_back(pObj);
        return pObj != 0;
    }

    bool Get(CNamedObj ** ppObj) {
        if (size() ){
            *ppObj = front();
            pop_front();
            return true;
        }   
        return false;
    }

    bool Find( list<PNamedObj>::iterator *pPos, CNamedObj *pTemplate ){
         list <PNamedObj>::iterator pos;
         for (pos = begin(); pos != end(); ++pos ) {
             if ( (**pos) == *pTemplate ) {
                 *pPos = pos;
                 return true;
             } 
         } 
         return false;
    }

    bool Find( list<PNamedObj>::iterator *pPos, const char *name ){
         CNamedObj Template;
         Template.UseName(name);
         return Find(pPos, &Template);
    }
    
}; // class CObjList


#endif // AFX_UTIL_H__3F1A529E_E713_4692_81C4_AAEA9606E1A1__INCLUDED_
