#if !defined(RTSP_ENV_H)
#define RTSP_ENV_H

#include "liveMedia.hh"
#include "BasicUsageEnvironment.hh"
#include "GroupsockHelper.hh"
#include <string>
#include <boost/thread.hpp>

class CRTSPClient;

class CRTSPEnv {
public:
    ~CRTSPEnv();
    void armDroppedConnection(double timer, CRTSPClient* pClient);
    static void incomingRequestHandler(void* clientData, int mask);
    static void timeoutHandler(void* clientData); 
    static CRTSPEnv* Instance();
    static CRTSPEnv* pInst ;
    UsageEnvironment* GetEnv() { return env; }
    const char* GetAppName() { return progName.c_str(); }
    static void WorkerThreadFcn(CRTSPEnv*);
    static char watchVariable;
protected:
    CRTSPEnv();

private:
    UsageEnvironment* env;
    TaskScheduler* scheduler;
    std::string    progName;
    boost::thread  *workerThread;
};
#endif
