/**
* @file config.h
* @brief Multimedia demo config file utility header
* @date Feb 16, 2007
*
* DIALOGIC CONFIDENTIAL 
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to 
* the source code ("Material") are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its 
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced, 
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual 
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef _config_h
#define _config_h

#include <map>
#include <string>

// Global Variables
#define PROGRAM_NAME "multimediademo"
const int max_phone_number_size = 31;           // including trailing NULL
const int max_ip_size = 20;                     // including trailing NULL

typedef std::map<char, std::string> RTSP_URLS;

enum CALL_TYPE {
    CALL_TYPE_H323 = 0,
    CALL_TYPE_SIP   = 1
};

#define    RECORDING_DEFAULT    0
#define    RECORDING_IMMEDIATE  1
#define    RECORDING_MANUAL     2

typedef struct _CONFIGFILEOPTIONS {
   unsigned int      unConnections;
   bool              bTraceFlag;
   int               nTraceLevel;
   bool              bOutboundFlag;
   bool              bRunPstnOnly;
   bool              bUseAliasTable;
   int               nNumberOfCalls;
   int               interCallDelay;
   int               callDuration;
   int               nStartSpan;
   int               nStartIpmChan;
   int               nCallType;
   char              cPhoneNumber[max_phone_number_size];
   char              cDestIp[max_ip_size];
   char              cProxyIp[max_ip_size];
   int               nSipUdpPort;
   char              cVideoTranscodeDir[9];
   char              cAudioTranscodeDir[9];
   char              videoRes[10];
   int               maxBandwidth;
   int               maxFrameRate;
   char              audioCodec[12];
   char	             videoCodec[12];
   bool              bLowResVideo;
   char              cAVFileDir[256];
   char              cAudioFileFormat[9];
   char              cVideoFileFormat[9];
   bool              bWaitOnSIPAck;
   bool              bUseSipInfoDtmf;
   int               nDtmfDetectMode; 
   bool              bRepeatMenus;

   unsigned char     rxdciQcifValue[256];
   unsigned char     rxdciQcifSize;
   char              rxdciQcifStrValue[256];

   unsigned char     rxdciCifValue[256];
   unsigned char     rxdciCifSize;
   char              rxdciCifStrValue[256];

   unsigned char     txdciQcifValue[256];
   unsigned char     txdciQcifSize;
   char              txdciQcifStrValue[256];

   unsigned char     txdciCifValue[256];
   unsigned char     txdciCifSize;
   char              txdciCifStrValue[256];
  
   bool              bUseRecordMsg;
   bool              bRecordAudioOnly;
   int               nRecordTimeout;
   int               nMsgRepeatInterval;
   int               IFrameInterval;
#ifdef TDM_AUDIO
   char             cISDNGatewayIP[256];
   int              nISDNGatewayPort;
#endif

#ifdef USE_RTSP
   RTSP_URLS        m_rtspUrls;
#endif
   unsigned char    recordControl;
   unsigned char    h264SdpPacketizationMode;
   int              h264SdpProfileLevel;
} CONFIGFILEOPTIONS, *LP_CONFIGFILEOPTIONS;

// Function Declarations
bool    ProcessConfigFile(LP_CONFIGFILEOPTIONS lpConfigFileOpts, const char *configFile);
bool    TokenizeLine(char *line, char *token1, char *token2);
bool    VerifyTokenIsInteger(char *token);
bool    VerifyTokenIsIPAddress(char *token);
bool    VerifyTokenIsPhoneNumber(char *token);
bool    TokenCmp(char* token, char* str);

// Ignores white space - bumps line until it is pointing to non-whitespace
// Treats an = sign as white space
#define IGNORE_WHITE_SPACE(line)								\
	{															\
		while (*line && ((*line <= ' ') || (*line == '=')) )	\
		{														\
			line++;												\
		}														\
	}

#endif //_config_h

