/**
* @file locker.h
* @brief Multimedia demo locking mechanisms header
* @date Feb 16, 2007
*
* DIALOGIC CONFIDENTIAL 
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to 
* the source code ("Material") are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its 
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced, 
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual 
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

// Standard Include Files
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/timeb.h>
#include <string>
#include <vector>
#include <map>
using namespace std;

#ifdef WIN32
    #include <windows.h>
#else
    #include <stdio.h>
    #include <errno.h>
    #include <unistd.h>
    #include <stdarg.h>
    #include <netinet/in.h>
#endif



#ifndef WIN32
class CLocker {
public:
    // Class Constructor
    CLocker()
    {
        //Create a recursive mutex.
        pthread_mutexattr_t attr; 
        pthread_mutexattr_init(&attr);
        pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE_NP);
        pthread_mutex_init(&m_Mutex, &attr);
    }

    // Class Destructor
    virtual ~CLocker()
    {
        pthread_mutex_destroy(&m_Mutex);
    }

    // Class Member Functions
    bool Lock(void)
    {
        pthread_mutex_lock(&m_Mutex);
        return true;
    }

    bool Unlock(void)
    {
        pthread_mutex_unlock(&m_Mutex);
        return true;
    }

private:
    // Class Member Varibles
    pthread_mutex_t  m_Mutex;
};

#else

class CLocker {
public:
    // Class Constructor
    CLocker()
    {
        InitializeCriticalSection(&m_CS);
    }

    // Class Destructor
    virtual ~CLocker()
    {
        DeleteCriticalSection(&m_CS);
    }

    // Class Member Functions
    bool Lock(void)
    {
        EnterCriticalSection(&m_CS);
        return true;
    }

    bool Unlock(void)
    {
        LeaveCriticalSection(&m_CS);
        return true;
    }

private:
    // Class Member Variables
    CRITICAL_SECTION m_CS;
};
#endif
