/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2005-2006 Intel Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.      Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.      Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.      Neither the name Intel Corporation nor the names of its contributors
* may be used to endorse or promote products derived from this software
* without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/


#include "iptransport.h"

/*******************************************************************
* DESCRIPTION	:	Preperation is needed before opening a socket in WinNT  
*     RETURNS   :	SUCCESS / FAIL
********************************************************************/
int PDLPrepareCreateSocket()
{
	return 0;
}

/*******************************************************************
* DESCRIPTION	:	Cleanup is needed if opening socket failed  
*     RETURNS   :	SUCCESS 
********************************************************************/
int PDLInvalidSocket()
{
	return 0;
}

/*******************************************************************
* DESCRIPTION	:	Create thread
*     RETURNS   :	the thread handle
********************************************************************/
void* PDLCreateThread(void* pThreadFunction, long* pParam)
{
	pthread_t hThread;
        int       rc;

	rc	= pthread_create(&hThread,
				NULL,
				(void *(*) (void *))pThreadFunction,
				(void*)pParam);

        if ( 0 != rc)
        {
                return NULL;
        }
	return (void*)hThread;
}

/*******************************************************************
* DESCRIPTION	:	Close socket
*     RETURNS   :	value returned from closesocket
********************************************************************/
int PDLCloseSocket(int socket)
{
	int l_Retval = close(socket);
	return l_Retval;
}

/*******************************************************************
* DESCRIPTION	:	Accept connection
*     RETURNS   :	value returned from accept()
********************************************************************/
int	PDLaccept(int serverSocket, sockaddr* clientAddr, int* clientAddrSize)
{
	int l_Retval = accept(serverSocket, clientAddr, (socklen_t*)clientAddrSize);
	return l_Retval;
}
