/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2005-2006 Intel Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.      Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.      Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.      Neither the name Intel Corporation nor the names of its contributors
* may be used to endorse or promote products derived from this software
* without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/



#include <signal.h>
#include <pthread.h>
#include <sys/time.h>
#include <string.h> 
#include <ctype.h>
#include <gclib.h>
#include <srllib.h>
#include <ipmlib.h>
#include <fcntl.h>

#ifdef __cplusplus
extern "C" {
#endif

#define PLAYFILEFLAGS O_RDONLY
#define RECFILEFLAGS O_RDWR|O_CREAT|O_TRUNC
#define NOMODE -1

extern char* PDL_VERSION_STRING;

/*****FUNCTION***************************************************
*        NAME : PDLsr_getboardcnt
* DESCRIPTION : Gets the number of boards in the system
*       INPUT : ipProtocol - the IP protocol name
*               char *name - the class name
*      OUTPUT : number of boards
*     RETURNS : 0 - success   -1 - fail
*    CAUTIONS : None
****************************************************************/
long PDLsr_getboardcnt(int *boardNum,char *ipProtocol,char *name);
	
/*****FUNCTION***************************************************
*        NAME : PDLSetApplicationExitPath
* DESCRIPTION : set the signals for making appropriate exit from 
*               the application when these signals are recieved 
*       INPUT : pointer to funtion
*      OUTPUT : None
*     RETURNS : void 
*    CAUTIONS : None
****************************************************************/
void PDLSetApplicationExitPath(void (*pCloseWin)());


/*****FUNCTION***************************************************
*        NAME : PDLgetDate
* DESCRIPTION : Gets the current date
*       INPUT : pointer to string of date
*      OUTPUT : None
*     RETURNS : pointer to string of date
*    CAUTIONS : None
****************************************************************/
void  PDLgetDateAndTime(char *bufdate,char *buftime);

/*****FUNCTION***************************************************
*        NAME : PDLlower
* DESCRIPTION : converts the string to lower case
*       INPUT : pointer to string
*      OUTPUT : pointer to string in lower case
*     RETURNS : void
*    CAUTIONS : None
****************************************************************/
void PDLlower(char *p);

/*****FUNCTION***************************************************
*        NAME : PDLupper
* DESCRIPTION : converts the string to upper case
*       INPUT : pointer to string
*      OUTPUT : pointer to string in upper case
*     RETURNS : void
*    CAUTIONS : None
****************************************************************/
void PDLupper(char *lname);

/*****FUNCTION***************************************************
*        NAME : PDLstrncmp
* DESCRIPTION : Compare characters of two strings without regard to case
*       INPUT : pointer to string1 ,pointer to string2, number of characters to compare 
*      OUTPUT : None
*     RETURNS : 0 - if equal
*    CAUTIONS : None
****************************************************************/
int PDLstrncmp(char *name1, char *name2, int count);

/*****FUNCTION***************************************************
*        NAME : PDLsr_enbhdlr
* DESCRIPTION : enables the handle function callback_hdlr 
*       INPUT : pointer to function
*      OUTPUT : None
*     RETURNS : void
*    CAUTIONS : None
****************************************************************/
void PDLsr_enbhdlr(int (*callback_hdlr)());

/*****FUNCTION***************************************************
*        NAME : PDLsr_dishdlr
* DESCRIPTION : disables the handler function callback_hdlr 
*       INPUT : pointer to function
*      OUTPUT : None
*     RETURNS : void
*    CAUTIONS : None
****************************************************************/
void PDLsr_dishdlr(int (*callback_hdlr)());

/*****FUNCTION***************************************************
*        NAME : PDLsr_getevtdev
* DESCRIPTION : Gets the event device from SRL queue
*       INPUT : None
*      OUTPUT : None
*     RETURNS : long
*    CAUTIONS : None
****************************************************************/
long PDLsr_getevtdev();

/*****FUNCTION***************************************************
*        NAME : PDLsr_getevttype
* DESCRIPTION : Gets the event type from SRL queue
*       INPUT : None
*      OUTPUT : None
*     RETURNS : long
*    CAUTIONS : None
****************************************************************/
long PDLsr_getevttype();

/*****FUNCTION***************************************************
*        NAME : PDLsr_putevt
* DESCRIPTION : post an event on SRL queue
*       INPUT : None
*      OUTPUT : None
*     RETURNS : long
*    CAUTIONS : None
****************************************************************/
long PDLsr_putevt(long dev, unsigned long evt, long len, void  *datap, long err);

/*****FUNCTION***************************************************
*        NAME : PDLFileOpen
* DESCRIPTION : opens a .vox file either for play or record
*       INPUT : file name to open, openning flags, permision mode
*      OUTPUT : None
*     RETURNS : int
*    CAUTIONS : None
****************************************************************/
int PDLFileOpen(char* FileName, int flags, int pmode);

/*****FUNCTION***************************************************
*        NAME : PDLFileClose
* DESCRIPTION : closes a .vox file either for play or record
*       INPUT : handle -- the file descriptor to close
*      OUTPUT : None
*     RETURNS : int
*    CAUTIONS : None
****************************************************************/
int PDLFileClose(int handle);


/*****FUNCTION***************************************************
*        NAME : PDLGetVersion
* DESCRIPTION : Gets the current version of this component
*       INPUT : void
*      OUTPUT : none
*     RETURNS : version string
*    CAUTIONS : None
****************************************************************/
char* PDLGetVersion(void);

#ifdef __cplusplus
}
#endif /* def __cplusplus */
