/*******************************************************************************
* DIALOGIC CONFIDENTIAL      
* Copyright (C) 2008 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code ("Material") are owned by Dialogic Corporation or its 
* suppliers or licensors.  Title to the Material remains with Dialogic 
* Corporation or its suppliers and licensors.  The Material contains trade
* secrets and proprietary and confidential information of Dialogic or its 
* suppliers and licensors.  The Material is protected by worldwide copyright
* and trade secret laws and treaty provisions.  No part of the Material may be
* used, copied, reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way without Dialogic's prior express written
* permission.
* 
* No license under any patent, copyright, trade secret or other intellectual 
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise.  Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*******************************************************************************/

#ifndef __RTCPPARSERLIB_H__
#define __RTCPPARSERLIB_H__

/* STANDARD INCLUDES */
#include <stdlib.h>

#pragma pack(1)

// Data Types
typedef unsigned long	UInt32; 	// For representing 32 bits
typedef unsigned short	UInt16; 	// For representing 16 bits
typedef unsigned char	UInt8; 		// For representing 8 bits
typedef signed   char	Int8; 		// For representing 8 bits

/* DEFINES */

// Define for testing Endian Format
#define LITTLE_END		0
#define BIG_END			1


// Define to validate RTCP String
#define RTCP_PKT_VALID		1
#define RTCP_PKT_INVALID	-1

// Supported RTCP Packet Version
#define RTCP_VERSION		2


// RTCP Packet Types
#define RTCP_PKTTYPE_SR		200
#define RTCP_PKTTYPE_RR		201
#define RTCP_PKTTYPE_SDES	202
#define RTCP_PKTTYPE_BYE	203
#define RTCP_PKTTYPE_APP	204
#define RTCP_PKTTYPE_XR		207

// RTCP Extended Report (XR) Block Types
#define XR_LOSS_RLE_REPORT_BLOCK		1
#define XR_DUPLOSS_RLE_REPORT_BLOCK		2
#define XR_RPT_RCPT_TIMES_REPORT_BLOCK	 	3
#define XR_RECV_REF_TIME_REPORT_BLOCK	 	4
#define XR_DLRR_REPORT_BLOCK			5
#define XR_STATSUMMARY_REPORT_BLOCK		6
#define XR_VOIP_METRICS_REPORT_BLOCK	 	7
#define XR_HR_VOIP_REPORT_BLOCK			8
#define XR_HR_CONFIG_REPORT_BLOCK		9

// RTCP Extended Report High Resolution(XRHR) VOIP Metrics Report Block Types
#define XR_HR_VOIP_BASIC_LOSSDISCARD_SUBBLOCK	100				// local define, not per Draft
#define XR_HR_VOIP_DELAYPDV_SUBBLOCK			101				// local define, not per Draft
#define XR_HR_VOIP_BURSTGAP_SUBBLOCK			0x00
#define XR_HR_VOIP_PLAYOUT_SUBBLOCK				0x40
#define XR_HR_VOIP_CONCEALED_SECONDS_SUBBLOCK	0x20
#define XR_HR_VOIP_CALLQUALITY_SUBBLOCK			0x10
#define XR_HR_VOIP_SUBBLOCK_UNDEFINED			0xFF

// Big-endian mask for version, padding bit and packet type pair
#define RTCP_VALID_MASK (0xc000 | 0x2000 | 0xfe)
#define RTCP_VALID_VALUE ((RTCP_VERSION << 14) | RTCP_PKTTYPE_SR)


/*  ENUMERATIONS */

// Return Codes
typedef enum
{
	RTCP_SUCCESS = 	1,
    RTCP_FAILURE = 	-1
}eRTCP_Ret_Code;

// SDES Item Types
typedef enum
{
	SDES_ITEM_END      	=	0, 		
	SDES_ITEM_CNAME		=	1,
	SDES_ITEM_USER_NAME	=	2,
	SDES_ITEM_EMAIL		=	3,
	SDES_ITEM_PHONE		=	4,
	SDES_ITEM_LOC		=	5,
	SDES_ITEM_TOOL		=	6,
	SDES_ITEM_NOTE		=	7,
	SDES_ITEM_PRIV		=	8
}eSDES_Item_Type;

// RLE Chunk Types
typedef enum
{
	TERMINATING			=	0,
	RUNLENGTH			=	1,
	BITVECTOR			=	2
} eRLE_Chunk_Type;


/*   RTCP REPORT STRUCTURES */

  
// NOTE: The size indicated along with the structure members
// is the actual size of the elements as they appear in the RTCP Packet
// according to the Standards

// Common RTCP Header structure for all RTCP Packet Types
typedef struct
{
	UInt8			Version:2;		// 2 Bits 
	UInt8			Padding:1;		// 1 Bit
	UInt8			Count:5;		// 5 Bits
	UInt8			PacketType;		// 8 Bits
	UInt16			Length; 		// 16 Bits
} RTCP_Pkt_Header;


// Common Report Block structure found in Sender and Receiver Report Block Structures
typedef struct SRRR_ReportBlock_tag
{
	UInt32			Source_SSRC;		// 32 Bits
	UInt8			FractionLost;		// 8 Bits
	int			CumPktLost:24;		// 24 Bits
	UInt32			ExtendedHighSeqNum;	// 32 Bits
	UInt32			InterArrJitter;		// 32 Bits
	UInt32			LSR;			// 32 Bits
	UInt32			DLSR;			// 32 Bits
} SRRR_ReportBlock;

// Sender Report RTCP Packet (SR) 
typedef struct RTCP_Sender_Report_tag
{
	RTCP_Pkt_Header*	SR_Header;		// 32 Bits
	UInt32	 		Sender_SSRC;		// 32 Bits
	UInt32			NTPTimeStamp_Intgr;	// 32 Bits
	UInt32			NTPTimeStamp_Frac; 	// 32 Bits    
	UInt32 			RTPTimeStamp; 		// 32 Bits    
	UInt32 			PacketCount;		// 32 Bits
	UInt32 			OctetCount;		// 32 Bits
	SRRR_ReportBlock**	rptblk;			// Variable Length
	UInt8*			ProfileExt;		// Variable Length
} RTCP_Sender_Report;

// Receiver Report RTCP Packet (RR)
typedef struct RTCP_Receiver_Report_tag
{
	RTCP_Pkt_Header*	RR_Header;		// 32 Bits
	UInt32 	  		Sender_SSRC;		// 32 Bits
	SRRR_ReportBlock**	rptblk;			// Variable Length
	UInt8*			ProfileExt; 		// Variable Length
} RTCP_Receiver_Report;


// Source Description RTCP Report (SDES)
// SDES Item
typedef struct SDES_Item_tag
{
	UInt8			Type;			// 8 Bits
	UInt8			Length;			// 8 Bits
	UInt8* 			Text;			// Variable Length
} SDES_Item;

// SDES Chunk
typedef struct SDES_Chunk_tag
{
	UInt32			SSRC;			// 32 Bits
	SDES_Item*		ItemList;			// Variable Length
	UInt8			NumItems;		// Number of Items in this chunk
}SDES_Chunk;

typedef struct RTCP_SDES_tag
{
	RTCP_Pkt_Header*	SDES_Header;		// 32 Bits
	SDES_Chunk*		ChunkList;			// Variable Length
}RTCP_SDES;

// APP RTCP Report (APP)
typedef struct RTCP_APP_tag
{
	RTCP_Pkt_Header*	APP_Header;		// 32 Bits
	UInt32 			SSRC;			// 32 Bits
	UInt8			Name[4];		// 32 Bits
	UInt8*			ApplicationData;	// Variable Length
}RTCP_APP;	
	
// BYE RTCP Packet (BYE)

// Bye Block
typedef struct BYE_Block_tag
{
	UInt32			SSRC; 			// 32 Bits
}BYE_Block;

typedef struct RTCP_BYE_tag
{
	RTCP_Pkt_Header*	BYE_Header;		// 32 Bits
	BYE_Block*		ByeBlkList;			// Variable Length
}RTCP_BYE;

 
// XR RTCP Packet (XR) 



// Common XR Packet Data
typedef struct RTCP_XR_Header_tag
{
	UInt8			Version:2;		// 2 Bits 
	UInt8			Padding:1;		// 1 Bit
	UInt8			Reserved:5;		// 5 Bits
	UInt8			PacketType;		// 8 Bits
	UInt16			Length; 		// 16 Bits
	UInt32			SSRC;			// 32 Bits
} RTCP_XR_Header;

// XR Packet's Typical Block Header
typedef struct XR_Block_Header
{
	UInt8  			BlockType;		// 8 Bits
} XR_Block_Header;


// XR Loss RLE Block - XR-RLE

// XR - RLE Chunk
typedef struct XR_RLE_Chunk_tag
{
	UInt8	ChnkType;				// 1 Bit  
	union
	{
		struct
		{
			UInt16	RunType:1;		// 1 Bit
			UInt16	RunLength:14;		// 14 Bits
		} Run_Length_Chunk;
			
		struct
		{
			UInt16	BitVector:15;		// 15 Bits
		} Bit_Vector_Chunk;
	} Chunk;		
} XR_RLE_Chunk;

typedef struct XR_Loss_RLE_Block_tag
{
	XR_Block_Header	xrblkhdr;		// 8 Bits
	UInt8			Reserved:4;		// 4 Bits
	UInt8			Thinning:4;		// 4 Bits
	UInt16			BlockLength;		// 16 Bits
	UInt32			SSRC;			// 32 Bits
	UInt16			BeginSeq;		// 16 Bits
	UInt16			EndSeq; 		// 16 Bits
	XR_RLE_Chunk**		chnk;			// Variable Length	
} XR_Loss_RLE_Block;

// XR Duplicate Loss RLE Block
typedef struct XR_DupLoss_RLE_Block_tag
{
	XR_Block_Header	xrblkhdr;		// 8 Bits
	UInt8			Reserved:4;		// 4 Bits
	UInt8			Thinning:4;		// 4 Bits
	UInt16			BlockLength;		// 16 Bits
	UInt32			SSRC;			// 32 Bits
	UInt16			BeginSeq;		// 16 Bits
	UInt16			EndSeq; 		// 16 Bits
	XR_RLE_Chunk**		chnk;			// Variable Length	
} XR_DupLoss_RLE_Block;

// XR Report Receipt Times Block

// XR - Report Receipt Time
typedef struct XR_Rpt_ReceiptTime_tag
{
	UInt32			ReceiptTime;		// 32 Bits
} XR_Rpt_RcptTime ;

typedef struct XR_Rpt_RcptTime_Block_tag
{
	XR_Block_Header		xrblkhdr;		// 8 Bits
	UInt8			Reserved:4;		// 4 Bits
	UInt8			Thinning:4;		// 4 Bits
	UInt16			BlockLength;		// 16 Bits
	UInt32			SSRC;			// 32 Bits
	UInt16			BeginSeq;		// 16 Bits
	UInt16			EndSeq; 		// 16 Bits
	XR_Rpt_RcptTime**	rptrcpttime;		// Variable Length
} XR_Rpt_RcptTime_Block;

// XR - Receiver Reference Time Block
typedef struct XR_ReceiverRefTime_Block_tag
{
	XR_Block_Header		xrblkhdr;		// 8 Bits
	UInt8			Reserved;		// 8 Bits
	UInt16			BlockLength;		// 16 Bits
	UInt32	 		NTPTimeMSW;		// 32 Bits
	UInt32			NTPTimeLSW; 		// 32 Bits
} XR_ReceiverRefTime_Block;

// XR - DLRR Block
// XR - LRR
typedef struct XR_LRR_tag
{
	UInt32 			SSRC;			// 32 Bits
	UInt32			LRR;			// 32 Bits
	UInt32			DLRR;			// 32 Bits
} XR_LRR;

typedef struct XR_DLRR_tag
{
	XR_Block_Header		xrblkhdr;		// 8 Bits
	UInt8			Reserved;		// 8 Bits
	UInt16			BlockLength;		// 16 Bits
	XR_LRR**		lrr;			// Variable Length
}XR_DLRR_Block;

// XR - Statistics Summary block
typedef struct XR_StatSummary_tag
{
	XR_Block_Header		xrblkhdr;	        // 8 Bits
	UInt8			LossReportFlag:1;	// 1 Bit
	UInt8			DupReportFlag:1; 	// 1 Bit
	UInt8			JitterFlag:1; 		// 1 Bit
	UInt8			ToHFlag:2;		// 2 Bits
	UInt8			Reserved:3; 		// 3 Bits
	UInt16			BlockLength;		// 16 Bits
	UInt32			SSRC; 			// 32 Bits
	UInt16			BeginSeq;		// 16 Bits
	UInt16			EndSeq;	 		// 16 Bits
	UInt32 			LostPackets; 		// 32 Bits
	UInt32      		DupPackets; 		// 32 Bits
	UInt32   		MinJitter; 		// 32 Bits
	UInt32   		MaxJitter; 		// 32 Bits
	UInt32  		MeanJitter; 		// 32 Bits	
	UInt32   		DevJitter; 		// 32 Bits
	UInt8    		MinTOH;	 		// 8 Bits	
	UInt8	    		MaxTOH; 		// 8 Bits
	UInt8    		MeanTOH; 		// 8 Bits
	UInt8    		DevTOH; 		// 8 Bits
} XR_StatSummary_Block;

// XR VOIP Metrics Block
typedef struct XR_VOIP_Metrics_tag
{
	XR_Block_Header	xrblkhdr;		// 8 Bits
	UInt8			Reserved;		// 8 Bits
	UInt16			BlockLength;	// 16 Bits
	UInt32 			SSRC;			// 32 Bits
	UInt8			LossRate;		// 8 bits
	UInt8			DiscardRate;	// 8 bits
	UInt8			BurstDensity;	// 8 bits
	UInt8			GapDensity;		// 8 bits
	UInt16			BurstDuration;	// 16 bits
	UInt16			GapDuration;	// 16 bits
	UInt16			RoundTripDelay;	// 16 bits  
	UInt16			EndSystemDelay;	// 16 bits
	UInt8			SignalLevel;	// 8 bits     
	UInt8			NoiseLevel;		// 8 bits
	UInt8			RERL;			// 8 bits
	UInt8			GMin;			// 8 bits
	UInt8			RFactor;		// 8 bits
	UInt8			ExtRFactor;		// 8 bits
	UInt8			MOS_LQ;			// 8 bits
	UInt8			MOS_CQ;			// 8 bits
	UInt8			PLC:2;			// 8 bits
	UInt8			JBA:2;			// 8 bits
	UInt8			JBRate:4;		// 8 bits
	UInt8			reserved;		// 8 bits
	UInt16			JBNominal;		// 16 bits
	UInt16			JBMax;			// 16 bits
	UInt16			JBAbsMax;		// 16 bits
}XR_VOIP_Metrics_Block;

// XR High Resolution VOIP Metrics Block
typedef struct XR_HR_VOIP_Block_tag
{
	XR_Block_Header	xrblkhdr;		// 8 Bits
	UInt8			Map;			// 8 Bits
	UInt16			BlockLength;	// 16 Bits
	UInt32 			SourceSSRC;		// 32 Bits
	UInt32 			Duration;		// 32 Bits
} XR_HR_VOIP_Block;

// XR High Resolution VOIP Metrics - BasicLoss/Discard Sub-Block
typedef struct XR_HR_VOIP_BasicLossDiscard_tag
{
	double			LossProportion;		// 0:16 			
	double			DiscardProportion;	// 0:16	
	UInt32			NoofframesExpected; // 32 Bits
} XR_HR_VOIP_BasicLossDiscard;

// XR High Resolution VOIP Metrics - Burst/Gap Sub-Block
typedef struct XR_HR_VOIP_BurstGap_tag
{
	UInt8			Threshold;					// 8 Bits
	UInt32 			BurstDuration:24;			// 24 Bits
	UInt32			GapDuration;				// 32 Bits
	double			BurstLoss_DiscProportion;	// 0:16
	double			GapLoss_DiscProportion;		// 0:16
} XR_HR_VOIP_BurstGap;

// XR High Resolution VOIP Metrics - Playout Sub-Block
typedef struct XR_HR_VOIP_Playout_tag
{
	UInt32 			OntimePlayoutDur;			// 32 Bits
	UInt32			OntimeActiveSpchPlayoutDur;	// 32 Bits
	UInt32			LossConcealmentDur;			// 32 Bits
	UInt32			BufferAdjConcealmentDur;	// 32 Bits
} XR_HR_VOIP_Playout;

// XR High Resolution VOIP Metrics - Concealed Seconds Sub_Block
typedef struct XR_HR_VOIP_ConcealedSec_tag
{	
	UInt32 			UnimpairedSec;			// 32 Bits
	UInt32 			ConcealedSec;			// 32 Bits
	UInt16 			SeverelyConcealedSec;	// 16 Bits
	UInt8			Reserved;				// 8 Bits
	UInt8			SCSThreshold; 			// 8 Bits
} XR_HR_VOIP_ConcealedSec;

// XR High Resolution VOIP Metrics - Delay and PDV Sub_Block
typedef struct XR_HR_VOIP_DelayPDV_tag
{
	UInt16			NetworkRoundTripDelay;	// 16 Bits
	UInt16			EndSystemDelay;			// 16 Bits
	UInt16			ExternalDelay;			// 16 Bits
	double			MeanPDV;				// S11:4		
	double			PosThresholdPDV;		// S11:4			
	double			PosPDVPercentile;		// 8:8		
	double			NegThresholdPDV;		// S11:4		
	double			NegPDVPercentile;		// 8:8		
	UInt8			PDVType;				// 8 Bits
	UInt8			JBConfig;				// 8 Bits
	UInt16			JBNominal;				// 16 Bits
	UInt16			JBMaximum;				// 16 Bits
	UInt16			JBAbsMax;				// 16 Bits
	UInt16			JBHighWaterMark;		// 16 Bits
	UInt16			JBLowWaterMark;			// 16 Bits
} XR_HR_VOIP_DelayPDV;
		
 
// XR High Resolution VOIP Metrics - Sub_Block
typedef struct XR_HR_VOIP_CallQuality_tag
{
	double			R_LQ;			// 8:8
	double			R_CQ ;			// 8:8
	double			MOS_LQ;			// 8:8
	double			MOS_CQ;			// 8:8
	double			R_LQExtIn;		// 7:1
	double			R_LQExtOut;		// 7:1
	UInt8			RFC3550Payload;	// 8 Bits
	UInt8			MediaType;		// 8 Bits
	Int8			RxSigLevIP;		// S7
	Int8			RxNoiseLevIP;	// S7
	Int8			LocalRERL;		// S7
	Int8			RemoteRERL;		// S7
	Int8			RxSigLevExt;	// S7
	Int8			RxNoiseLevExt;	// S7
	UInt16			MetricStatus;	// 16 Bits
}  XR_HR_VOIP_CallQuality;


// XR High Resolution Configuration Block
typedef struct XR_HR_Config_Block_tag
{
	XR_Block_Header	xrblkhdr;		// 8 Bits
	UInt8			Map;			// 8 Bits
	UInt16			BlockLength;	// 16 Bits
	UInt32 			SourceSSRC;		// 32 Bits
} XR_HR_Config_Block;

// XR High Resolution Configuration - Correlation Tag Sub_Block
typedef struct XR_HR_Config_Correlation_tag
{
	UInt8			TagType;		// 8 Bits
	UInt8			TagLength;		// 8 Bits
	UInt16*			Tag;			// Variable Length
	
} XR_HR_Config_Correlation;

// XR High Resolution Configuration - Algorithm Sub_Block
typedef struct XR_HR_Config_Alg_tag
{
	UInt8			AlgType;		// 8 Bits
	UInt8			DescLength;		// 8 Bits
	UInt16*			AlgDescriptor;	// Variable Length
	
} XR_HR_Config_Alg;

/* RTCP Parser APIs */
#ifdef __cplusplus
extern "C" {
#endif

// Convenience APIs
UInt8			GetBits8(UInt8 in, UInt8 loc, UInt8 num);
UInt16			GetBits16(UInt16 in, UInt8 loc, UInt8 num);
UInt32			GetBits32(UInt32 in, UInt8 loc, UInt8 num);
UInt16			rtcp_NetToHost16(UInt16 in);
UInt32			rtcp_NetToHost32(UInt32 in);
double			Convert8bitsToDouble(UInt8 in, UInt8 issigned, UInt8 frac);
double			Convert16bitsToDouble(UInt16 in, UInt8 issigned, UInt8 frac);

// General APIs
eRTCP_Ret_Code		rtcp_ValidatePkt(UInt8* rtcp, UInt32 length, UInt8* result);
eRTCP_Ret_Code		rtcp_GetNumPkts(UInt8* rtcp, UInt32 length, UInt8* numpkts);
UInt16				rtcp_GetPktLenInBytes(RTCP_Pkt_Header *rtcp);
RTCP_Pkt_Header*	rtcp_GetNextPktHeaderPtr(RTCP_Pkt_Header *rtcp);
eRTCP_Ret_Code		rtcp_GetPktsPtr(UInt8* rtcp, UInt32 length, RTCP_Pkt_Header **hdrarr, UInt16 arrlen);
eRTCP_Ret_Code		rtcp_GetPktHeader(RTCP_Pkt_Header* rtcphdr, RTCP_Pkt_Header* hdr);


// Sender and Receiver Report APIs
eRTCP_Ret_Code		rtcp_GetSRRpt(RTCP_Pkt_Header* rtcphdr, RTCP_Sender_Report* sr);
eRTCP_Ret_Code		rtcp_GetRRRpt(RTCP_Pkt_Header* rtcphdr, RTCP_Receiver_Report* rr);

eRTCP_Ret_Code		rtcp_GetNumRptBlks(RTCP_Pkt_Header* rpthdr, UInt8* numblks);
SRRR_ReportBlock*	rtcp_GetNextRptBlockPtr(SRRR_ReportBlock* blk);
eRTCP_Ret_Code		rtcp_GetProfExtLen(RTCP_Pkt_Header* rpthdr, UInt16* length);
eRTCP_Ret_Code		rtcp_GetProfExt(RTCP_Pkt_Header* rpthdr, UInt8* profext, int length);

// SDES Report APIs

eRTCP_Ret_Code		rtcp_GetNumSDESChunks(RTCP_Pkt_Header* hdr, UInt8* numchunks);
SDES_Chunk*		rtcp_GetNextChunkPtr(SDES_Chunk* chunk);
eRTCP_Ret_Code		rtcp_GetChunkLen(SDES_Chunk* chunk, UInt16* chunklen);
eRTCP_Ret_Code		rtcp_GetNumItems(SDES_Chunk* chunk, UInt8* numitems);
SDES_Item*		rtcp_GetNextItemPtr(SDES_Item* item);
eRTCP_Ret_Code		rtcp_GetSDES(RTCP_Pkt_Header* hdr, RTCP_SDES* sdes);

// BYE Report APIs
eRTCP_Ret_Code		rtcp_GetBYE(RTCP_Pkt_Header* hdr, RTCP_BYE* bye);
BYE_Block*		rtcp_GetNextBYEBlock(BYE_Block* blk);
eRTCP_Ret_Code		rtcp_GetNumBYEBlks(RTCP_Pkt_Header* hdr, UInt8* numblks);

// APP Report APIs
eRTCP_Ret_Code		rtcp_GetAPP(RTCP_Pkt_Header* hdr, RTCP_APP* app);
eRTCP_Ret_Code		rtcp_GetAPPDataLen(RTCP_Pkt_Header* hdr, UInt8* appdatalen);
eRTCP_Ret_Code		rtcp_GetAPPData(RTCP_APP* app, UInt8* appdata);

// XR Report APIs
// Common APIs
eRTCP_Ret_Code		rtcp_GetXRHeader(RTCP_Pkt_Header* hdr, RTCP_XR_Header* xrhdr);
UInt16				rtcp_GetXRBlkLenInBytes(XR_Block_Header* xrhdr);
eRTCP_Ret_Code		rtcp_GetNumXRBlks(RTCP_XR_Header* xr, UInt8* numblks);
XR_Block_Header*	rtcp_GetNextXRBlkHeaderPtr(XR_Block_Header* blkhdr);
eRTCP_Ret_Code		rtcp_GetXRBlocksPtr(RTCP_XR_Header* xr, XR_Block_Header** blkhdrarr, UInt8 arrlen);
eRTCP_Ret_Code		rtcp_GetXRBlock(XR_Block_Header* xrhdr, XR_Block_Header* blkhdr);

// XR - RLE Block APIs
eRTCP_Ret_Code		rtcp_GetNumXRRLEChunks(XR_Block_Header* xrrle, UInt8 *numchnks);
eRTCP_Ret_Code		rtcp_GetXRRLEChunks(XR_Block_Header* xrrle, XR_RLE_Chunk** xrrlechunk, UInt8 numchnks);

// XR - Receipt Time Block APIs
eRTCP_Ret_Code		rtcp_GetNumRcptTimeBlks(XR_Rpt_RcptTime_Block* rcptblk, UInt8* numblks);
eRTCP_Ret_Code		rtcp_GetXRRcptTimeBlks(XR_Rpt_RcptTime_Block* rcptblk, XR_Rpt_RcptTime** xrrcptarr, UInt8 numblks);

// XR - LRR Block APIs
eRTCP_Ret_Code		rtcp_GetNumXRLRRBlks(XR_DLRR_Block* dlrrblk, UInt8* numblks);
eRTCP_Ret_Code		rtcp_GetXRLRRBlks(XR_DLRR_Block* dlrrblk, XR_LRR** xrlrrarr, UInt8 numblks);

// XR - HR Block APIs
UInt8			tcp_GetXRHRVOIPSubBlockLenInBytes(UInt8 subblocktype);
eRTCP_Ret_Code		rtcp_GetXRHRVOIPJBConfig(UInt8 jb, UInt8* cfg);
eRTCP_Ret_Code		rtcp_GetXRHRVOIPPLCAlg(UInt8 jb, UInt8* alg);
eRTCP_Ret_Code		rtcp_GetXRHRVOIPSubBlockByType(XR_Block_Header* xrhrblk, UInt8* subblk, UInt8 subblocktype);
eRTCP_Ret_Code		rtcp_GetXRHRConfigSubBlockByType(XR_Block_Header* xrhrblk, UInt8* subblk, UInt8 subblocktype);

#ifdef __cplusplus
}
#endif

#pragma pack()
	
#endif /*__RTCPPARSERLIB_H__*/
