/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/


#include "MediaDevice.h"


MediaDevice::MediaDevice()
{
	Print(LOG_DEBUG,"+ MediaDevice::MediaDevice");
	Print(LOG_DEBUG,"- MediaDevice::MediaDevice");
}

MediaDevice::~MediaDevice()
{
	Print(LOG_DEBUG,"+ MediaDevice::~MediaDevice");
	Print(LOG_DEBUG,"- MediaDevice::~MediaDevice");
}

int MediaDevice::Open(const char* a_MediaDevName)
{
	Print(LOG_DEBUG,"+ MediaDevice::Open");
	int rc = 0;
	strcpy(m_DeviceName,a_MediaDevName);
	Print(LOG_INFO,"\tOpening Media device %s", a_MediaDevName);
	if ( (m_DeviceHandle = ipm_Open(a_MediaDevName, NULL, EV_ASYNC)) == -1)
	{
		Print(LOG_ERROR,"\tipm_Open(devicename=%s, mode=EV_ASYNC) Failed", a_MediaDevName);
		rc = -1;
	}
	else
	{
		Print(LOG_INFO,"\tdevicename=%s successfully opened.  Handle = %d", a_MediaDevName, m_DeviceHandle);
	}
	Print(LOG_INFO,"\n");
	Print(LOG_DEBUG,"- MediaDevice::Open");
	return rc;
}

int MediaDevice::Close()
{
	Print(LOG_DEBUG,"+ MediaDevice::Close");
	int rc = 0;
	if (m_DeviceHandle)
	{
		Print(LOG_INFO,"\tClosing Media device %s", m_DeviceName);
		ipm_Close(m_DeviceHandle,NULL);
		m_DeviceHandle = 0;
	}
	Print(LOG_DEBUG,"- MediaDevice::Close");
	return rc;
}

int MediaDevice::StartMedia(sdpSessionDescription* a_pSDP)
{
	Print(LOG_DEBUG,"+ MediaDevice::StartMedia");
	IPM_MEDIA_INFO MediaInfo;
	int i,j;
	bool bFoundG711 = false;

	int rc = 0;
	MediaInfo.unCount = 4;
	MediaInfo.MediaData[0].eMediaType = MEDIATYPE_REMOTE_RTP_INFO;

	Print(LOG_INFO,"\t\tSetting remote media info on Device %s",m_DeviceName);

	Print(LOG_INFO,"\t\tConfirming remote endpoint supports G.711 MuLaw Audio");
	// make sure the remote end supports G.711 MuLaw Audio
	sdpMediaDescription* pMD = NULL;
	sdpMedia* pMedia = NULL;
	int NumMD = a_pSDP->mediaDescriptionList()->numItem();
	for (i=0;i<NumMD;i++)
	{
		pMD = a_pSDP->mediaDescriptionList()->getItem(i);
		pMedia = pMD->media();
		if (!strcmp(pMedia->getMedia(),"audio"))
		{
			int NumFormat = pMedia->getNumFormat();
			for (j=0;j<NumFormat;j++)
			{
				if (!strcmp(pMedia->getFormat(j),"0"))
				{
					// G.711 MuLaw Audio is supported
					bFoundG711 = true;
					break;
				}
			}
		}
	}

	if (bFoundG711 == false)
	{
		// G.711 MuLaw Audio is NOT supported
		Print(LOG_ERROR,"\tRemote endpoint does NOT supports G.711 MuLaw Audio");
		rc = -1;
	}
	else
	{
		MediaInfo.MediaData[0].mediaInfo.PortInfo.unPortId = pMD->media()->getPort();
		strcpy(MediaInfo.MediaData[0].mediaInfo.PortInfo.cIPAddress,a_pSDP->connection()->getAddress());
						
		MediaInfo.MediaData[1].eMediaType = MEDIATYPE_REMOTE_RTCP_INFO;
		MediaInfo.MediaData[1].mediaInfo.PortInfo.unPortId = pMD->media()->getPort()+1;
		strcpy(MediaInfo.MediaData[1].mediaInfo.PortInfo.cIPAddress,a_pSDP->connection()->getAddress());
						
		MediaInfo.MediaData[2].eMediaType = MEDIATYPE_REMOTE_CODER_INFO;
		MediaInfo.MediaData[2].mediaInfo.CoderInfo.eCoderType = CODER_TYPE_G711ULAW64K;
		MediaInfo.MediaData[2].mediaInfo.CoderInfo.eFrameSize = (eIPM_CODER_FRAMESIZE) 30;
		MediaInfo.MediaData[2].mediaInfo.CoderInfo.unFramesPerPkt = 1;
		MediaInfo.MediaData[2].mediaInfo.CoderInfo.eVadEnable = CODER_VAD_DISABLE;
		MediaInfo.MediaData[2].mediaInfo.CoderInfo.unCoderPayloadType = 0;
		MediaInfo.MediaData[2].mediaInfo.CoderInfo.unRedPayloadType = 0;
						
		MediaInfo.MediaData[3].eMediaType = MEDIATYPE_LOCAL_CODER_INFO;
		MediaInfo.MediaData[3].mediaInfo.CoderInfo.eCoderType = CODER_TYPE_G711ULAW64K;
		MediaInfo.MediaData[3].mediaInfo.CoderInfo.eFrameSize = (eIPM_CODER_FRAMESIZE) 30;
		MediaInfo.MediaData[3].mediaInfo.CoderInfo.unFramesPerPkt = 1;
		MediaInfo.MediaData[3].mediaInfo.CoderInfo.eVadEnable =CODER_VAD_DISABLE;
		MediaInfo.MediaData[3].mediaInfo.CoderInfo.unCoderPayloadType = 0;
		MediaInfo.MediaData[3].mediaInfo.CoderInfo.unRedPayloadType = 0;						

		Print(LOG_INFO,"\t\tStarting media on Device %s",m_DeviceName);
		if (rc = ipm_StartMedia(m_DeviceHandle, &MediaInfo, DATA_IP_TDM_BIDIRECTIONAL, EV_ASYNC) != 0)
		{
			Print(LOG_ERROR,"\tipm_StartMedia() Failed");
		}
	}
	Print(LOG_DEBUG,"- MediaDevice::StartMedia");
	return rc;
}

int MediaDevice::StopMedia()
{
	Print(LOG_DEBUG,"+ MediaDevice::StopMedia");
	int rc = 0;
	Print(LOG_INFO,"\t\tStopping media on Device %s",m_DeviceName);
	if (rc = ipm_Stop(m_DeviceHandle, STOP_MEDIA, EV_ASYNC) != 0)
	{
		Print(LOG_ERROR,"\tipm_Stop() Failed");
	}
	Print(LOG_DEBUG,"- MediaDevice::StopMedia");
	return rc;
}

int MediaDevice::GetLocalMediaInfo(IPM_MEDIA_INFO* a_pMediaInfo)
{
	Print(LOG_DEBUG,"+ MediaDevice::GetLocalMediaInfo");
	Print(LOG_INFO,"\t\tRetrieving local media information for device %s", m_DeviceName);
	int rc = 0;
	if (rc = ipm_GetLocalMediaInfo(m_DeviceHandle, a_pMediaInfo, EV_SYNC) != 0)
	{
		Print(LOG_ERROR,"\tipm_GetLocalMediaInfo() Failed");
	}
	Print(LOG_DEBUG,"- MediaDevice::GetLocalMediaInfo");
	return rc;
}

int MediaDevice::GetXmitSlot(SC_TSINFO* a_pTSINFO)
{
	Print(LOG_DEBUG,"+ MediaDevice::GetXmitSlot");
	Print(LOG_INFO,"\tRetrieving XmitSlot for Device %s",m_DeviceName);
	int rc = 0;
	if (rc = ipm_GetXmitSlot(m_DeviceHandle, a_pTSINFO, EV_SYNC) != 0)
	{
		Print(LOG_ERROR,"\tipm_GetXmitSlot() Failed");
	}
	Print(LOG_INFO,"\tDevice %s transmit timeslot = %d",m_DeviceName,*a_pTSINFO->sc_tsarrayp);
	Print(LOG_DEBUG,"- MediaDevice::GetXmitSlot");
	return rc;
}

int MediaDevice::Listen(SC_TSINFO* a_pTSINFO)
{
	Print(LOG_DEBUG,"+ MediaDevice::Listen");
	Print(LOG_INFO,"\tInstructing Device %s to listen to timeslot %d",m_DeviceName,*a_pTSINFO->sc_tsarrayp);
	int rc = 0;
	if (ipm_Listen(m_DeviceHandle, a_pTSINFO, EV_ASYNC) != 0)
	{
		Print(LOG_ERROR,"\tipm_Listen() Failed");
	}
	Print(LOG_DEBUG,"- MediaDevice::Listen");
	return rc;
}

int MediaDevice::UnListen()
{
	Print(LOG_DEBUG,"+ MediaDevice::UnListen");
	Print(LOG_INFO,"\t\tInstructing Device %s to unlisten",m_DeviceName);
	int rc = 0;
	if (ipm_UnListen(m_DeviceHandle, EV_ASYNC) != 0)
	{
		Print(LOG_ERROR,"\tipm_UnListen() Failed");
	}
	Print(LOG_DEBUG,"- MediaDevice::UnListen");
	return rc;
}






