/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/

#ifndef NETWORK_CONNECTION_DEFINE
#define NETWORK_CONNECTION_DEFINE

#include <gcip.h>
#include <gclib.h>
#include <ipmlib.h>
#include <sdpAPI.h>

#include "Device.h"
#include "SipDevice.h"
#include "MediaDevice.h"
#include "BoardDevice.h"
#include "Logger.h"


class SipDevice;
class MediaDevice;

class NetworkConnection : public Logger
{
public:
	NetworkConnection();
	~NetworkConnection();
public:
	int Open(const char* a_SipDevName, const char* a_MediaDevName);
	int Close();
	int GetXmitSlot(SC_TSINFO* a_pTSINFO);
	int Listen(SC_TSINFO* a_pTSINFO);
	int UnListen();
	bool IsOpen();
	Device* GetSipDevice();
	Device* GetMediaDevice();
	void SetObjectId(char* a_ObjectId);
	char* GetObjectId();

	void OnMediaOpen();
	void OnMediaStart();
	void OnMediaStop();
	void OnMediaClose();
	void OnMediaListen();
	void OnMediaUnListen();

	void OnSipOpen(METAEVENT* a_MetaEvent);
	void OnSipOffered(METAEVENT* a_MetaEvent);
	void OnSipAccept(METAEVENT* a_MetaEvent);
	void OnSipAnswered(METAEVENT* a_MetaEvent);
	void OnSipAck(METAEVENT* a_MetaEvent);
	void OnSipDisconnected(METAEVENT* a_MetaEvent);
	void OnSipDropCall(METAEVENT* a_MetaEvent);
	void OnSipReleaseCall(METAEVENT* a_MetaEvent);
	void OnSipReqModifyCall(METAEVENT* a_MetaEvent);
	void OnSipSetConfigData(METAEVENT* a_MetaEvent);
private:
	int StartMedia(sdpSessionDescription* a_pSDP);
	int StopMedia();
private:
	IPM_MEDIA_INFO m_MediaInfo;
	SipDevice* m_pSipDevice;
	MediaDevice* m_pMediaDevice;
	bool m_bMediaDeviceOpen;
	bool m_bMediaStarted;
	bool m_bMediaListening;
	bool m_bSipDeviceOpen;
	char m_ObjectId[IP_SIP_HDR_MAXLEN];
	sdpSessionDescription m_SDP;
};

#endif
