/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/

#ifndef SDP_LISTS_DEFINE
#define SDP_LISTS_DEFINE

class sdpMediaDescription;
class sdpTimeDescription;


///////////////////////////////////////////////////////////////////////////////////
//!  sdpElementList class. 
/*!  Base List Manager object and is inherited by sdpAttributeList, sdpEmailAddressList, sdpMediaDescriptionList, sdpPhoneNumberList, and sdpTimeDescriptionList.*/
class sdpElementList
{
public:
	sdpElementList();
	~sdpElementList();
public:
	//!  Returns number of items in sdpElementList. 
	/*!  This method returns the number of sdpElement items contained in the sdpElementList object.
	\return	int - number of items in list */
	int				numItem();
protected:
	void			addItem(void*);
	void			deleteItem(void*);
	void*			getItem(int a_Index);
protected:
	void**			m_pElements;
	int				m_NumItem;
};
///////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////
//!  sdpCryptoKeyParmList class. 
/*!  List Manager for sdpCryptoKeyParm objects*/
class sdpCryptoKeyParmList : public sdpElementList
{
	public:
	sdpCryptoKeyParmList();
	~sdpCryptoKeyParmList();
public:
	//!  Create and add a sdpCryptoKeyParm object. 
	/*!  This method creates new sdpCryptoKeyParm object and adds it to the list manager.
	\return	sdpCryptoKeyParm* - pointer to newly created sdpCryptoKeyParm */
	sdpCryptoKeyParm*	addItem();
	//!  Add a sdpCryptoKeyParm object.
	/*!  This method adds the given sdpCryptoKeyParm object to the list manager. 
	\param a_sdpCryptoKeyParm* - pointer to a sdpCryptoKeyParm object that needs to be added in the list manager. */
	void addItem(sdpCryptoKeyParm* a_sdpCryptoKeyParm);
	//!  Delete all the sdpCryptoKeyParm objects. 
	/*!  This method deletes all the sdpCryptoKeyParm objects from the list manager.
	\return	void */
	void			clear();
	//!	 Delete a sdpCryptoKeyParm object.
	/*!  This method deletes the given sdpCryptoKeyParm object from the list manager. */ 
	void			deleteItem(sdpCryptoKeyParm* a_sdpCryptoKeyParm);
	//!  Retrieves a sdpCryptoKeyParm object. 
	/*!  This method retrieves a sdpCryptoKeyParm object at a given index from the list manager.
	\param	a_Index - index of a sdpCryptoKeyParm.  Index is 0 based.
	\return	sdpCryptoKeyParm* - pointer to the sdpCryptoKeyParm */
	sdpCryptoKeyParm*	getItem(int a_Index);
};
///////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////
//!  sdpCryptoSessionParmList class. 
/*!  List Manager for sdpCryptoSessionParm objects*/
class sdpCryptoSessionParmList : public sdpElementList
{
	public:
	sdpCryptoSessionParmList();
	~sdpCryptoSessionParmList();
public:
	//!  Create and add a sdpCryptoSessionParm object. 
	/*!  This method creates new sdpCryptoSessionParm object and adds it to the list manager.
	\return	sdpCryptoSessionParm* - pointer to newly created sdpCryptoSessionParm */
	sdpCryptoSessionParm*	addItem();
	//!  Add a sdpCryptoSessionParm object.
	/*!  This method adds the given sdpCryptoSessionParm object to the list manager. 
	\param a_sdpCryptoSessionParm* - pointer to a sdpCryptoSessionParm object that needs to be added in the list manager. */
	void addItem(sdpCryptoSessionParm* a_sdpCryptoSessionParm);
	//!  Delete all the sdpCryptoSessionParm objects. 
	/*!  This method deletes all the sdpCryptoSessionParm objects from the list manager.
	\return	void */
	void			clear();
	//!	 Delete a sdpCryptoSessionParm object.
	/*!  This method deletes the given sdpCryptoSessionParm object from the list manager. */ 
	void			deleteItem(sdpCryptoSessionParm* a_sdpCryptoSessionParm);
	//!  Retrieves a sdpCryptoSessionParm object. 
	/*!  This method retrieves a sdpCryptoSessionParm object at a given index from the list manager.
	\param	a_Index - index of a sdpCryptoSessionParm.  Index is 0 based.
	\return	sdpCryptoSessionParm* - pointer to the sdpCryptoSessionParm */
	sdpCryptoSessionParm*	getItem(int a_Index);
};
///////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////
//!  sdpAttributeList class. 
/*!  List Manager for sdpAttribute objects*/
class sdpAttributeList : public sdpElementList
{
public:
	sdpAttributeList();
	~sdpAttributeList();
public:
	//!  Adds new sdpAttribute object. 
	/*!  This method adds a new sdpAttribute object to the list manager
	\return	sdpAttribute* - pointer to newly created sdpAttrubute */
	sdpAttribute*	addItem();
	//!  Adds the given sdpAttribute object. 
	/*!  This method adds the given sdpAttribute object to the list manager
	\return	void */
	void addItem(sdpAttribute* a_Attribute);
	//!  Deletes existing sdpAttribute object. 
	/*!  This method deletes an existing sdpAttribute object from the list manager
	\return	void */
	void			clear();
	void			deleteItem(sdpAttribute* a_Attribute);
	//!  Retrieves and existing sdpAttribute object. 
	/*!  This method retrieves an existing sdpAttribute object from the list manager
	\param	a_Index - index to existing sdpAttrubute.  Index is 0 based.
	\return	sdpAttribute* - pointer to the sdpAttrubute */
	sdpAttribute*	getItem(int a_Index);
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpEmailAddressList class. 
/*!  List Manager for sdpEmailAddress objects*/
class sdpEmailAddressList : public sdpElementList
{
public:
	sdpEmailAddressList();
	~sdpEmailAddressList();
public:
	//!  Adds new sdpEmailAddress object. 
	/*!  This method adds a new sdpEmailAddress object to the list manager
	\return	sdpEmailAddress* - pointer to newly created sdpEmailAddress */
	sdpEmailAddress*	addItem();
	//!  Deletes existing sdpEmailAddress object. 
	/*!  This method deletes an existing sdpEmailAddress object from the list manager
	\return	void */
	void				clear();
	void				deleteItem(sdpEmailAddress* a_EmailAddress);
	//!  Retrieves and existing sdpEmailAddress object. 
	/*!  This method retrieves an existing sdpEmailAddress object from the list manager
	\param	a_Index - index to existing sdpEmailAddress.  Index is 0 based.
	\return	sdpEmailAddress* - pointer to the sdpEmailAddress */
	sdpEmailAddress*	getItem(int a_Index);
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpMediaDescriptionList class. 
/*!  List Manager for sdpMediaDescription objects*/
class sdpMediaDescriptionList : public sdpElementList
{
public:
	sdpMediaDescriptionList();
	~sdpMediaDescriptionList();
public:
	//!  Adds new sdpMediaDescription object. 
	/*!  This method adds a new sdpMediaDescription object to the list manager
	\return	sdpMediaDescription* - pointer to newly created sdpMediaDescription */
	sdpMediaDescription*	addItem();
	//!  Deletes existing sdpMediaDescription object. 
	/*!  This method deletes an existing sdpMediaDescription object from the list manager
	\return	void */
	void					clear();
	void					deleteItem(sdpMediaDescription* a_MediaDescription);
	//!  Retrieves and existing sdpMediaDescription object. 
	/*!  This method retrieves an existing sdpMediaDescription object from the list manager
	\param	a_Index - index to existing sdpMediaDescription.  Index is 0 based.
	\return	sdpMediaDescription* - pointer to the sdpMediaDescription */
	sdpMediaDescription*	getItem(int a_Index);
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpPhoneNumberList class. 
/*!  List Manager for sdpPhoneNumber objects*/
class sdpPhoneNumberList : public sdpElementList
{
public:
	sdpPhoneNumberList();
	~sdpPhoneNumberList();
public:
	//!  Adds new sdpPhoneNumber object. 
	/*!  This method adds a new sdpPhoneNumber object to the list manager
	\return	sdpPhoneNumber* - pointer to newly created sdpPhoneNumber */
	sdpPhoneNumber*	addItem();
	//!  Deletes existing sdpPhoneNumber object. 
	/*!  This method deletes an existing sdpPhoneNumber object from the list manager
	\return	void */
	void			clear();
	void			deleteItem(sdpPhoneNumber* a_PhoneNumber);
	//!  Retrieves and existing sdpPhoneNumber object. 
	/*!  This method retrieves an existing sdpPhoneNumber object from the list manager
	\param	a_Index - index to existing sdpPhoneNumber.  Index is 0 based.
	\return	sdpPhoneNumber* - pointer to the sdpPhoneNumber */
	sdpPhoneNumber*	getItem(int a_Index);
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpTimeDescriptionList class. 
/*!  List Manager for sdpTimeDescription objects*/
class sdpTimeDescriptionList : public sdpElementList
{
public:
	sdpTimeDescriptionList();
	~sdpTimeDescriptionList();
public:
	//!  Adds new sdpTimeDescription object. 
	/*!  This method adds a new sdpTimeDescription object to the list manager
	\return	sdpTimeDescription* - pointer to newly created sdpTimeDescription */
	sdpTimeDescription*	addItem();
	//!  Deletes existing sdpTimeDescription object. 
	/*!  This method deletes an existing sdpTimeDescription object from the list manager
	\return	void */
	void				clear();
	void				deleteItem(sdpTimeDescription* a_TimeDescription);
	//!  Retrieves and existing sdpTimeDescription object. 
	/*!  This method retrieves an existing sdpTimeDescription object from the list manager
	\param	a_Index - index to existing sdpTimeDescription.  Index is 0 based.
	\return	sdpTimeDescription* - pointer to the sdpTimeDescription */
	sdpTimeDescription*	getItem(int a_Index);
};
///////////////////////////////////////////////////////////////////////////////////


#endif
