BEGIN		{
		  TRUE = 1;
		  FALSE = 0;
		  BOARD_COUNT = 1;
		  PRIMARY_FOUND = FALSE;
		}
/ DM3 /		{
# Prepares full data structure even though we
# only populate most fields with default values
# Slot*
# Model
# Logical ID*
# PCD
# FCD
# Bus Master Status
# TDM Bus Type
# PCM Encoding
# Bus Clock Rate - Master Only
# Group 1 Clock Rate - Master Only
# Group 2 Clock Rate - Master Only
# Group 3 Clock Rate - Master Only
# Group 4 Clock Rate - Master Only
# Clock Source - Master Only
# CT Bus Clock Line - Master Only
# Board IP Address - IPLink w/NIC only
# Board Subnet Mask - IPLink w/NIC only
# Board Name - IPLink w/NIC only
# Host IP Address - IPLink w/NIC only
# Host Name - IPLink w/NIC only
# Host User ID - IPLink w/NIC only
# Gateway IP Address - IPLink w/NIC only
# Active
# Telephony Interface
# NIC Present
# Number of Telephony Interfaces

if ( PRIMARY_FOUND == FALSE ) {
	BM = "PRIMARY";
	CR = 8;
	G1CR = 8;
	G2CR = 8;
	G3CR = 8;
	G4CR = 8;
	CS = "OSC";
	CL = "CT_A";
	PRIMARY_FOUND = TRUE;
} else  {
	BM = "SLAVE";
	CR = "NA";
	G1CR = "NA";
	G2CR = "NA";
	G3CR = "NA";
	G4CR = "NA";
	CS = "NA";
	CL = "NA";
}
BOARD_INFO[BOARD_COUNT++] = \
sprintf("%d:%s:%d:%s:%s:%s:%s:%s:%s:%s:%s:%s:%s:%s:%s:%s:%s:%s%d:%s:%s:%s:%s:%s:%s:%s:%s:%s:%s:%s:\n",\
$5,\
"NOT_SET",\
BOARD_COUNT,\
"NOT_SET",\
"NOT_SET",\
BM,\
"H100",\
"NOT_SET",\
CR,\
G1CR,\
G2CR,\
G3CR,\
G4CR,\
CS,\
CL,\
"000.000.000.000",\
"255.255.255.000",\
"board",\
LOGID,\
"000.000.000.000",\
"NOT_SET",\
"nobody",\
"000.000.000.255",\
"Yes",\
"NOT_SET",\
"NOT_SET",\
"NOT_SET",\
$4,\
$3,\
"NOT_SET");
		}
END		{
		  i = 1;
		  while (i < BOARD_COUNT)
		  {
			printf("%s",BOARD_INFO[i++]);
		  }
		}
