#!/bin/sh
#INTEL_DIALOGIC_DIR=/usr/dialogic
sbcupdate -V >/dev/null
RET=$?
if [ $RET = 0 ]
then
  echo "Updating PSTN RTM, please wait..."
else
  echo "sbcupdate not installed, install sbcutils and then proceed"
  exit $RET
fi

IPMC=`sbcupdate -Minfo | grep "Current firmware" | cut -c27-35`
RTM=`sbcupdate -Minfo -trtm | grep boot | cut -c28-32` 
DOWNGRADE=0

if [ $RTM = '1.08' ]
then 
   if [ $IPMC = '30.06.02' ] 
   then
      DOWNGRADE=0
   else 
      DOWNGRADE=1
   fi
fi

if [ $DOWNGRADE = 1 ]
then
	echo "Downgrading IPMC to older version to update RTM"
	sbcupdate -M direct --force-fw-update ${INTEL_DIALOGIC_DIR}/data/MPCBL0040_FW_1071.hex
	sleep 60
fi

sbcupdate -M direct -t rtm --force-fw-update ${INTEL_DIALOGIC_DIR}/data/TR_00_02.hex
sleep 15

echo "Reading mfg information from fru"

RTM_getfru

status=$?
if [ $status -ne 0 ]; then
        echo "RTM fru read failed"
        exit 1
fi

sbcupdate -M direct -t rtm  --force-fru-update --force-id ${INTEL_DIALOGIC_DIR}/data/MMB496RTMTE01AQ_400.fru
sleep 15

echo "Writing mfg information to fru"

RTM_putfru >/dev/null

status=$?
if [ $status -ne 0 ]; then
        echo "RTM fru write failed"
        exit 1
fi

sbcupdate -M direct -t rtm  --force-sdr-update ${INTEL_DIALOGIC_DIR}/data/MMB496RTMTE01AQ_600.sdr
sleep 30

sbcupdate -Minfo -trtm

if [ $DOWNGRADE = 1 ]
then
	echo "Upgrading IPMC back to original version"
  sbcupdate -M direct --force-fw-update ${INTEL_DIALOGIC_DIR}/data/MPCBL0040_FW_11214.hex
  ipmitool raw 0x30 9 9 0 1 6
  ipmitool raw 0x30 9 9 0 2 120
  ipmitool raw 0x30 9 9 0 3 30
	sleep 15
fi

