/**
 * @file  KMBC_low_mm.h
 * @brief Buffer Pool manager within the KMBC_low driver. (LINUX ONLY)
 * @date  June 26, 2006
 *
 * Dialogic CONFIDENTIAL	
 * Copyright 2013 Dialogic Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to 
 * the source code ("Material") are owned by Dialogic Corporation or its suppliers
 * or licensors.  Title to the Material remains with Dialogic Corporation or its 
 * suppliers and licensors.  The Material contains trade secrets and proprietary
 * and confidential information of Dialogic or its suppliers and licensors.  The
 * Material is protected by worldwide copyright and trade secret laws and treaty
 * provisions.  No part of the Material may be used, copied, reproduced, 
 * modified, published, uploaded, posted, transmitted, distributed, or disclosed
 * in any way without Dialogic's prior express written permission.
 * 
 * No license under any patent, copyright, trade secret or other intellectual 
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise.  Any license under such intellectual property rights must be
 * express and approved by Dialogic in writing.
 * 
 * Unless otherwise agreed by Dialogic in writing, you may not remove or alter this
 * notice or any other notice embedded in Materials by Dialogic or Dialogic's 
 * suppliers or licensors in any way.
 */




#ifndef __KMBC_LOW_MM_H__
#define __KMBC_LOW_MM_H__




#include "KMBC_target.h"



/* Only include the following if building Linux device driver */
#if defined( KMBC_TARGET_LINUX ) && defined( KMBC_KERNEL_MODE )



/* Header Files */
#include <linux/pci.h>
#include "KMBC_low.h"



/* Custom Data Types */
typedef struct _tagKMBC_LOW_MEM_DESC
{
	int            fUsed;
	unsigned long  size;   
	int            num_pages;
	int            order;
	void          *BlockAddr;
	void          *UserAddr;
	void          *KernAddr;
	unsigned long  BusAddr;
	unsigned int   H2B[32];
	unsigned int   B2H[32];
}
KMBC_LOW_MEM_DESC, *PKMBC_LOW_MEM_DESC;

typedef struct _tagKMBC_LOW_MEM_BUF
{
        unsigned int   H2B[32];
        unsigned int   B2H[32];
        unsigned int   maxbridge;
}
KMBC_LOW_MEM_BUF, *PKMBC_LOW_MEM_BUF;

/* Function Prototypes */
int           kmbc_hsi_pool_init( int, int );
void          kmbc_hsi_pool_shutdown( void );
void *        kmbc_hsi_pool_alloc( void );
void          kmbc_hsi_pool_free( void * );
void          kmbc_hsi_pool_set_user_addr( void *, void * );
void *        kmbc_hsi_pool_convert_user_addr( void * );
unsigned long kmbc_hsi_pool_get_bus_addr( void * );
void          kmbc_hsi_buffer_init(PHSI_BRIDGE_INIT_INPUT info);

#endif /* #if defined( KMBC_TARGET_LINUX ) && defined( KMBC_KERNEL_MODE ) */
#endif /* #ifndef __KMBC_LOW_MM_H__ */
