#!/usr/bin/perl -w

#SNMP Command line defaults

my $TARGET_DIR= "/etc/sysconfig/";
my $TARGET_FILE= "hwconf";
my $TARGET_FULLNAME=$TARGET_DIR.$TARGET_FILE;
my $TARGET_TMPDIR= "/tmp/";
my $TARGET_TMPFILE= "hwconf.tvl2";
my $TARGET_TMPFULLNAME=$TARGET_TMPDIR.$TARGET_TMPFILE;
my $SUSECMD="hwinfo --short --network --log $TARGET_TMPFULLNAME"; 



sub myHelp
{
	print "NAME \n";
	print "		genhwinfo- Generate hwinfo file in /etc/sysconfig directory \n";
	print "SYNOPSIS\n";
	print "	gnehwinfo \n";
	print "DESCRIPTION\n";
	print "		genhwinfo- Is called by the Board Manager Executable \n";
	print "		This perl scripts wraps various snmp client commands \n";
	print "		such as snmpget, snmpset, snmptable. This perl  \n";
	print "		script basically hides any snmp manager cli complexity\n";
}


sub genHWFile
{
	#create hwinfo.tvl2 file in /tmp directory
	`$SUSECMD`;

	#Read file 
	open IN, "<$TARGET_TMPFULLNAME" or exit 1;
	open OUT, ">$TARGET_FULLNAME"   or exit 2;


	my @inBuf = <IN>;

	my $iCnt=0;
	my %hwHash;
	my @hwArr;
	my $pciBus;
	my $pciBusSubId;
	my $pciBusFn;

	#iterate thru the hwinfo.tvl2 file and select
	#needed fields 
		
	my $temp;
  my $pciBusString;
	for ( my $i=0 ; $i < @inBuf; $i++ ) {
		# let's get interface information 
		if ( $inBuf[$i] =~ /net interface:\s*name\s*=\s*(\w+)/i )  {
			$temp = $1;
			#if ( $temp =~ /lo/i ) { } elsif ($temp =~ /sit0/i )  { }
			if ( ($temp =~ /lo/i ) || ($temp =~ /sit0/i ) ) { }
			else { 
				$hwArr[$iCnt]{IFNAME} = $temp;
				$i++;
				if ( $inBuf[$i] =~ /hw_addr\s*=\s*(.*)/i )  {
					$hwArr[$iCnt]{IFMAC} = $1;
				}
				$i++;
				if ( $inBuf[$i] =~ /net device:\s*path\s*=\s*(.*)/i )  {
					#($inBuf[$i]) =~ /\/0000:(\w{2})/;
					($inBuf[$i]) =~ /\/([\d:\.]+)$/;
					$pciBusString = $1;
					#$pciBus = $1;
					($pciBusString) =~ /\d{4}:(\d{2})/;
					$pciBus = int($1);
			    #print "  pciBusString = ${pciBusString}\n";
			    #print "  pciBus = ${pciBus}\n";
					#($inBuf[$i]) =~ /\/0000:00:\w{2}\.(\d)/;
					($pciBusString) =~ /\d{4}:\d{2}:\d{2}.(\d)/;
					$pciBusSubId = int($1);
			    #print "  pciBusSubId = ${pciBusSubId}\n";
					#$hwArr[$iCnt]{IFPCIPATHID} = chomp(($inBuf[$i]));
					$hwArr[$iCnt]{IFPCIPATHID} = $inBuf[$i];
					$hwArr[$iCnt]{IFPCIBUSID} = $pciBus;
					$hwArr[$iCnt]{IFPCIBUSSUBID} = $pciBusSubId;
					$iCnt++;
				}
			}
		}
	}
	#loop again and find the rest of the pci information	
	$iCnt=-1;
	$start=0;
	for ( my $i=0 ; $i < @inBuf; $i++ ) {
		if ( $inBuf[$i] =~ /HWClass\s*=\s*network/i )  {
			$iCnt++;
			$hwArr[$iCnt]{HWCLASS} = "network";
			$start=1;
		}

		if ( $start eq  "1" )  {
			if  ( $inBuf[$i] =~ /Model\s*=\s*(.*)/i )  {
				$hwArr[$iCnt]{HWMODEL} = $1;
			}elsif  ( $inBuf[$i] =~ /Bus\s*=\s*(.*)/i )  {
				$hwArr[$iCnt]{HWBUS} = $1;
			}elsif  ( $inBuf[$i] =~ /Slot\s*=\s*(.*)/i )  {
				$hwArr[$iCnt]{HWPCIBUSSLOT} = $1;
			}elsif ( $inBuf[$i] =~ /VendorID\s*=\s*(.*)/i )  {
				$hwArr[$iCnt]{HWVENDORID} = $1;
			} elsif ( $inBuf[$i] =~ /DeviceID\s*=\s*(.*)/i )  {
				$hwArr[$iCnt]{HWDEVICEID} = $1;
			} elsif ( $inBuf[$i] =~ /DeviceName\s*=\s*(.*)/i )  {
				$hwArr[$iCnt]{HWDEVICENAME} = $1;
			} elsif ( $inBuf[$i] =~ /VendorName\s*=\s*(.*)/i )  {
				$hwArr[$iCnt]{HWVENDORNAME} = $1;
			} elsif ( $inBuf[$i] =~ /Drivers\s*=\s*(.*)/i )  {
				$hwArr[$iCnt]{HWDRIVER} = $1;
				$start=0;
			}
		}
	}

	$iCnt=0;
	#for ( my $i=0 ; $i < @hwArr; $i++ ) {
	#		print "---------------------------------------------------------------  \n";
	#		print "IFNAME = $hwArr[$i]{IFNAME}  \n";
	#		print "  => IFMAC = $hwArr[$i]{IFMAC}\n";
	#		print "  => IFPCIPATHID=$hwArr[$i]{IFPCIPATHID}";
	#		print "  => HWCLASS = $hwArr[$i]{HWCLASS} \n";
	#		print "  => HWMODEL= $hwArr[$i]{HWMODEL} \n";
	#		print "  => HWBUS= $hwArr[$i]{HWBUS} \n";
	#		print "  => HWPCIBUSSLOT= $hwArr[$i]{HWPCIBUSSLOT} \n";
	#		print "  => HWVENDORID= $hwArr[$i]{HWVENDORID} \n";
	#		print "  => HWVENDORNAME= $hwArr[$i]{HWVENDORNAME} \n";
	#		print "  => HWDEVICEID= $hwArr[$i]{HWDEVICEID} \n";
			#print "  => HWDEVICENAME= $hwArr[$i]{HWDEVICENAME} \n";
	#		print "  => PCIBUSID = $hwArr[$i]{IFPCIBUSID} \n";
	#		print "  => PCIBUS SUBID = $hwArr[$i]{IFPCIBUSSUBID} \n";
	#		print "  => DRIVER = $hwArr[$i]{HWDRIVER} \n";
	#		print "---------------------------------------------------------------  \n";
	#}

	#write to output file
	for ( my $n=0 ; $n < @hwArr; $n++ ) {
			printf OUT "-\n";
			printf OUT "class: NETWORK\n";
			printf OUT "bus: PCI\n";
			printf OUT "detached: 0\n";
			printf OUT "device: $hwArr[$n]{IFNAME}\n";
			printf OUT "driver: $hwArr[$n]{HWDRIVER}\n";
			printf OUT "desc: $hwArr[$n]{HWMODEL}\n";
			printf OUT "network.hwaddr: ". uc($hwArr[$n]{IFMAC}) ."\n";
			printf OUT "vendorId: $hwArr[$n]{HWVENDORID}\n";
			printf OUT "deviceId: $hwArr[$n]{HWDEVICEID}\n";
			printf OUT "subVendorId: $hwArr[$n]{HWVENDORID}\n";
			printf OUT "subDeviceId: $hwArr[$n]{HWDEVICEID}\n";
			printf OUT "pciType: 1\n";
			printf OUT "pciDom: 0\n";
			printf (OUT "pcibus: %1x\n", $hwArr[$n]{IFPCIBUSID});
			printf (OUT "pcidev: %1x\n", 0);
			printf OUT "pcifn: $hwArr[$n]{IFPCIBUSSUBID}\n";
	}

	close IN;
	close OUT;

	# remove tmp file
	#`rm -rf $TARGET_TMPFULLNAME`;
}


sub MyCmdLine
{
    $argvCnt = @ARGV;
    my $myarg;
    if ( $argvCnt == 0) {
		genHWFile();
    } else  {
		$myarg = shift @ARGV;
		if ($myarg eq "-h" ) {
        	myHelp();
		}
    }
}

MyCmdLine();

