##########@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@###################################
# DIALOGIC CONFIDENTIAL
#
# Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
# The source code contained or described herein and all documents related
# to the source code ("Material") are owned by Dialogic Corporation or its
# suppliers or licensors. Title to the Material remains with Dialogic Corporation
# or its suppliers and licensors. The Material contains trade secrets and
# proprietary and confidential information of Dialogic or its suppliers and
# licensors. The Material is protected by worldwide copyright and trade secret
# laws and treaty provisions. No part of the Material may be used, copied,
# reproduced, modified, published, uploaded, posted, transmitted, distributed,
# or disclosed in any way without Dialogic's prior express written permission.
#
# No license under any patent, copyright, trade secret or other intellectual
# property right is granted to or conferred upon you by disclosure or delivery
# of the Materials, either expressly, by implication, inducement, estoppel or
# otherwise. Any license under such intellectual property rights must be
# express and approved by Dialogic in writing.
#
###################################@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@##########
#!/bin/sh
#
# Use print instead of echo for prints to stdout
#
#

CLI_USER=root
CLI_PASS=public

# See if parent is its_sysinfo
ps -aef | grep $PPID | grep its_sysinfo >/dev/null
if [ $? -ne 1 ]
then
    TARDIR="/tmp"
    print() {
	ZZZZ=0 
    }
else
    TARDIR=`pwd`
    print() { 
	echo $*
    }
fi


# check for enough free disk space
print "Gathering system information..."

trname="ipm_trouble_report$$"
trdir="/tmp/$trname"
mkdir $trdir

# what hardware do we have
print "Hardware config..."
lspci -v >> $trdir/lspci.log
if [ -e "/etc/sysconfig/hwconf" ]
then
    cp /etc/sysconfig/hwconf $trdir/hwconf
fi

# what is the interface status
print "Network config..."
ls /etc/sysconfig/network-scripts/ifcfg-* &> /dev/null
if [ $? -eq 0 ] 
then
    cp /etc/sysconfig/network-scripts/ifcfg-* $trdir/
fi
ifconfig >> $trdir/ifconfig.log

# gather interface names from ifconfig, see what ethtool says about each
for ifn in `ifconfig | grep "Link encap" | grep -v "lo" | cut -d' ' -f 1`
do
  echo "ethtool $ifn"    >> $trdir/ethtool.log
  ethtool $ifn           >> $trdir/ethtool.log
  echo "ethtool -i $ifn" >> $trdir/ethtool.log
  ethtool -i $ifn        >> $trdir/ethtool.log
  echo "ethtool -S $ifn" >> $trdir/ethtool.log
  ethtool -S $ifn        >> $trdir/ethtool.log
  echo "ethtool -g $ifn" >> $trdir/ethtool.log
  ethtool -g $ifn        >> $trdir/ethtool.log
done

# dump the routes, arp table
route -n > $trdir/route.log
arp   -n > $trdir/arp.log
sysctl -A > $trdir/sysctl.log
if [ -e /usr/dialogic/bin/ifext ]
then
  /usr/dialogic/bin/ifext > $trdir/ifext.log
fi

# See what's running
print "Process state..."
ps aux > $trdir/ps.log

# save the message logs
print "Message logs..."
if [ -e /usr/dialogic ]
then
  tar -cvzf $trdir/logs.tgz \
      /var/log/messages   \
      /var/log/ngmit.log  \
      /usr/dialogic/log/* \
      &> /dev/null
else
  tar -cvzf $trdir/logs.tgz \
      /var/log/messages   \
      &> /dev/null
fi

if [ -e /usr/dialogic ]
then
  # dialogic specific files
  print "Dialogic product config..."
  if [ -e "/usr/dialogic/data/Hmp.Uconfig" ] 
  then
    cp /usr/dialogic/data/Hmp.Uconfig $trdir/Hmp.Uconfig
  fi

  tar -cvzf $trdir/cfg.tgz \
    /usr/dialogic/cfg \
    /usr/dialogic/data/*.pcd \
    /usr/dialogic/data/*.fcd \
    /usr/dialogic/data/*.config \
    /usr/dialogic/conf \
    &> /dev/null

   echo "ssp.mlm"                     > $trdir/version.log
   getver /usr/dialogic/data/ssp.mlm >> $trdir/version.log

   devmapdump > $trdir/devmapdump.log
else
  print "No Dialogic product installed..."
fi


print "Gathering CLI (this may take a while)..."
FALLBACK_CLI=1
if [ -e "/usr/dialogic/demos/cli/cte.pl" -a -e "/usr/dialogic/demos/cli/cli_sanity.cfg" ]  
then
   cd $trdir
   perl /usr/dialogic/demos/cli/cte.pl -c /usr/dialogic/demos/cli/cli_sanity.cfg &> /dev/null
   if [ $? -eq 0 ]
   then 
      FALLBACK_CLI=0
   fi
   cd -
fi

if [ $FALLBACK_CLI -eq 1 ]
then
   cd $trdir
   (sleep 1;
       echo -ne "$CLI_USER\r";
       sleep 1;
       echo -ne "$CLI_PASS\r";
       sleep 1;
       echo -ne "show license\r";
       sleep 1;
       echo -ne "show system\r";
       sleep 1; 
       echo -ne "show interface ds1\r";
       sleep 1; 
       echo -ne "show arp\r";
       sleep 1; 
       echo -ne "show controller\r";
       sleep 1; 
       echo -ne "show hardware\r";
       sleep 1; 
       echo -ne "show icmp\r";
       sleep 1; 
       echo -ne "show msml\r";
       sleep 1; 
       echo -ne "show tcp brief\r";
       sleep 1; 
       echo -ne "logout\r") | telnet localhost  &> cliout.txt
   cd -

fi

# Gather up files
cd /tmp 
print "Generating trouble report in file $TARDIR/ipm_trouble_report.tgz"
tar -C /tmp -cvzf $TARDIR/ipm_trouble_report.tgz  $trname &> /dev/null
cd -

# TODO: noclean param would be nice
print "Cleaning up"
rm -rf $trdir

print "Done"

