/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.      Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.      Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.      Neither the name Dialogic Corporation nor the names of its contributors
* may be used to endorse or promote products derived from this software
* without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/****************************************************************************
* FILE:        tvl2pci_ids.h
* PURPOSE:     This file defines the vendor, device, subvendor and
*              subdevice ids used on TVL2 and Zionsville boards.
*
* HISTORY 
* Date       Who   Description  
* 05-09-07   NS    Created
***************************************************************************/
#ifndef __tvl2pci_ids_h__
#define __tvl2pci_ids_h__
#include <linux/pci_ids.h>

/* 
 * Define PCI vendor and device ids.
 * The constants are prefixed with "TVL2" to distinguish them from
 * the constants defined inside the standard Linux header file
 * "linux/pci_ids.h".
 */
#define TVL2_PCI_VENDOR_ID_INTEL              PCI_VENDOR_ID_INTEL
#define TVL2_PCI_VENDOR_ID_PLX                PCI_VENDOR_ID_PLX
#define TVL2_PCI_VENDOR_ID_DIALOGIC           0x12C7

#define TVL2_PCI_DEVICE_ID_PLX_9056           0x9056
#define TVL2_PCI_DEVICE_ID_DIALOGIC_SEAVILLE  0x5356

#define TVL2_PCI_SUBDEVICE_ID_AMC             0x0001
#define TVL2_PCI_SUBDEVICE_ID_RTM             0x0002
#define TVL2_PCI_SUBDEVICE_ID_ZVL             0x0003

/* Define the PCI BAR register numbers */
#define TVL2_PCI_BAR0   0
#define TVL2_PCI_BAR1   1
#define TVL2_PCI_BAR2   2
#define TVL2_PCI_BAR3   3


#endif

