/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.      Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.      Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.      Neither the name Dialogic Corporation nor the names of its contributors
* may be used to endorse or promote products derived from this software
* without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/****************************************************************************
* FILE:        tvl2pcidrv.h
* PURPOSE:     Declarations and type definitions for the tvl2 pci kernel
*		        module.
*
* HISTORY 
* Date       Who   Description  
* 08-Aug-05  JRF   Created
* 11-09-06   NS    Added numOfLicensedtrunks field to the proc pstn.cfg file.
* 04-27-07   NS    Add Zionsville Offload board detection logic.
***************************************************************************/
#ifndef __tvl2pcidrv_h__
#define __tvl2pcidrv_h__
#include <linux/ioctl.h>
#include "tvl2pci_ids.h"

#ifdef ENABLE_ZIONSVILLE_CHANGES
/* CR22070: Adding support for the HSI interface */
#include "hsi_interface.h"
#endif

#define DEVNAME    "tvl2pcidrv"        /* name of module and /dev entry */
#define PSTNCONFIG "pstn.cfg"          /* name of module and /dev entry */
#define N_TVL2_PCI_DEVS    (32)        /* Number of TVL2 PCI devices */

#define FRAMERTYPE ("FramerType")
#define NUMFRAMERS ("NumberOfFramers")
#define TRUNKSPERFRAMER ("TrunksPerFramer")
#define NUMBER_LICENSED_TRUNKS ("NumberOfLicensedTrunks")
#define DEFAULTLINETYPE ("DefaultLineType")
#define DATAVALID ("DataValid")
#define RTMDETECTED ("RtmDetected")


#define PSTN_HW_INFO_DATA_NOT_VALID          (0)
#define	PSTN_HW_INFO_DATA_VALID              (1)

#define	PSTN_HW_INFO_RTM_NOT_PRESENT         (0)
#define	PSTN_HW_INFO_RTM_PRESENT             (1)

#define	PSTN_HW_INFO_QCOMET_FRAMER_TYPE      (0)
#define	PSTN_HW_INFO_OTHER_FRAMER_TYPE       (1)

#define	PSTN_HW_INFO_DEFAULT_LINE_TYPE_T1    (0)
#define	PSTN_HW_INFO_DEFAULT_LINE_TYPE_E1    (1)

enum 
{
	PLX9056_INTR_SOURCE_NONE,
	PLX9056_INTR_SOURCE_DOORBELL,
	PLX9056_INTR_SOURCE_PCI_ABORT,
	PLX9056_INTR_SOURCE_LOCAL1,
	PLX9056_INTR_SOURCE_DMA0,
	PLX9056_INTR_SOURCE_DMA1,
	PLX9056_REG_OUTPOST_INT_MASK,
	PLX9056_INTR_SOURCE_OUTBOUND_POST,
};

/***********************  Typedefs  ***************************************/
/* Pstn interface hardware information */
typedef struct Tvl2PstnHwInfo_s
{
  int isDataValid;                    /* Information is valid only if isDataValid = 1 */
  int isRtmPresent;
  int framerType;
  int numberOfFramers;
  int trunksPerFramer;
  int numberOfLicensedTrunks;
  int defaultLineType;
} Tvl2PstnHwInfo_t; 

typedef enum tvl2RegionEnum  
{ 
    TVL2_IO_REGION, 
    TVL2_MEMORY_REGION 
} tvl2Region_t;

/* PCI memory region information */
typedef struct Region_s
{
  int bar;
  tvl2Region_t type;
  unsigned long base;
  unsigned size;
} Region_t;

/* this is the view that user space applications have from a PCI device. */ 
typedef struct tvl2PciUsrDev_s
{
  int index;                           /* position in the device array */
  char name[32];
 /*
  *   File descriptor of proc entry for
  *   the device (for user space app. only).
  */
  int procEntry;
 /*
  *  PCI address of the device. 
  */  
  int bus;
  int slot;
  int function; 
 /*
  *  PCI configuration registers. 
  */  
  int vendor_id;
  int subvendor_id;
  int device_id;
  int subdevice_id;

  /* Device resources */
  int irq;                       /* interrupt line */  
  Region_t regions[6];           /* memory region(s) accessible to user */
} tvl2PciUsrDev_t;

/********************* IOCTL commands ***************************/
#define TVL2_RTM_DRV_IOC_MAGIC ('r')
/*
 *   Command to retrieve PCI device information.
 */
#define IOC_TVL2_RTM_DRV_GET_DEV _IOR(TVL2_RTM_DRV_IOC_MAGIC, 1, tvl2PciUsrDev_t)
/*
 *  Command to retrieve NW interface information (framers).
 */
#define IOC_TVL2_RTM_DRV_GET_NW_INFO _IOR(TVL2_RTM_DRV_IOC_MAGIC,4, Tvl2PstnHwInfo_t)
#define IOC_TVL2_RTM_DRV_GET_TICKS _IOR(TVL2_RTM_DRV_IOC_MAGIC,5, unsigned long)
/*
 *  Returns number of titusville2 pci devices.
 */
#define IOC_TVL2_RTM_DRV_GET_NUM_DEV _IOR(TVL2_RTM_DRV_IOC_MAGIC,6, int)
#define TVL2_RTM_DRV_IOC_MAXNR (6)



/*
 *  Commands for IRQ control
 */

#define TVL2_IRQ_CTL_IOC_MAGIC ('i')

#define IOC_TVL2_IRQ_CTL_ENABLE_LINT 	_IO(TVL2_IRQ_CTL_IOC_MAGIC,1)
#define IOC_TVL2_IRQ_CTL_DISABLE_LINT 	_IO(TVL2_IRQ_CTL_IOC_MAGIC,2)

#define TVL2_IRQ_CTL_IOC_MAXNR (2)

#endif

