/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.      Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.      Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.      Neither the name Dialogic Corporation nor the names of its contributors
* may be used to endorse or promote products derived from this software
* without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********
*
* 11/07/06 MLB  Add remap to tvl hierarchy
*
****************************************************************************/
#include <linux/module.h>
#include <linux/init.h>
#include <linux/sysctl.h>
#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/if.h>
#include <linux/if_ether.h>
#include <linux/version.h>

#include <asm/uaccess.h>

#include "tvl2_sysctl.h"

// typedefs
typedef struct {
    int  remap;
    char ifName[IFNAMSIZ];
    char ifMAC[ETH_ALEN];
    char dsp0MAC[ETH_ALEN];
    char dsp1MAC[ETH_ALEN];
    char dsp2MAC[ETH_ALEN];
    char dsp3MAC[ETH_ALEN];
} tvl2SysCtl_t;

// static data
static tvl2SysCtl_t tvl2SysCtlData;
static int remapMin[1] = { 0 };
static int remapMax[1] = { 1 };

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,8)
static int tvl2_mac_proc_handler (
    ctl_table *table,
    int write,
    struct file *filp,
    void __user *buffer,
    size_t *lenp,
    loff_t *ppos)
#else
static int tvl2_mac_proc_handler (
    ctl_table *table,
    int write,
    struct file *filp,
    void __user *buffer,
    size_t *lenp)
#endif
{
    size_t len = 0;
    char strMac[19] = ""; // "00:00:00:00:00:00\n\0"
    unsigned int mac[ETH_ALEN] = {0,0,0,0,0,0};

    if (!table->data 
        || !table->maxlen 
        || !*lenp 
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,8)
        || (*ppos && !write)
#else
        || (filp->f_pos && !write)
#endif
       )
    {
        *lenp = 0;
        return 0;
    }

    if (write) 
    {
        int items = 0;

        len = *lenp;
        if (len > sizeof(strMac) - 1)
            len = sizeof(strMac) - 1;
        if (copy_from_user(strMac, buffer, len))
            return -EFAULT;
        strMac[len] = '\0';

        items = sscanf(strMac,"%2x:%2x:%2x:%2x:%2x:%2x", 
                       &mac[0], &mac[1], &mac[2], &mac[3], &mac[4], &mac[5]);
        if (items == ETH_ALEN)
        {
            unsigned char *tMac = (unsigned char *)table->data;

            tMac[0] = (unsigned char)(mac[0] & 0xFF);
            tMac[1] = (unsigned char)(mac[1] & 0xFF);
            tMac[2] = (unsigned char)(mac[2] & 0xFF);
            tMac[3] = (unsigned char)(mac[3] & 0xFF);
            tMac[4] = (unsigned char)(mac[4] & 0xFF);
            tMac[5] = (unsigned char)(mac[5] & 0xFF);
        }
        else
            return -EINVAL;

        *lenp = len;
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,8)
        *ppos += len;
#else
        filp->f_pos += len;
#endif
    }
    else 
    {
        int items = 0;

        len = sizeof(strMac);
        if (len > *lenp)
            len = *lenp;
        if (len)
        {
            unsigned char *tMac = (unsigned char *)table->data;
            items = snprintf(strMac, sizeof(strMac), 
                     "%.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n",
                     tMac[0], tMac[1], tMac[2], tMac[3], tMac[4], tMac[5]);
            if (items < len)
                len = items;
            if (copy_to_user(buffer, strMac, items))
                return -EFAULT;
        }
        *lenp = items;
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,8)
        *ppos += *lenp;
#else
        filp->f_pos += len;
#endif
    }
    return 0;
}

static int tvl2_mac_ctl_handler (
    ctl_table *table, 
    int __user *name, 
    int nlen,
    void __user *oldval, 
    size_t __user *oldlenp,
    void __user *newval, 
    size_t newlen, 
    void **context)
{
    size_t len = 0;

    if (table->data && table->maxlen) 
    {
        if (oldval && oldlenp) 
        {
            if (get_user(len, oldlenp))
                return -EFAULT;
            if (len) 
            {
                if (len != table->maxlen)
                    return -EINVAL;
                if(copy_to_user(oldval, table->data, len))
                    return -EFAULT;
                if(put_user(len, oldlenp))
                    return -EFAULT;
                }
        }
        if (newval && newlen) 
        {
            len = newlen;
            if (len != table->maxlen)
                return -EINVAL;
            if(copy_from_user(table->data, newval, len))
                return -EFAULT;
        }
    }
    return 0;
}
    
static ctl_table tvl2_ctl_dsp_detail_mac_table0[] = {
    {
        .ctl_name = CTL_TVL2_DSP_MAC,
        .procname = "mac",
        .data = &tvl2SysCtlData.dsp0MAC,
        .maxlen = sizeof(tvl2SysCtlData.dsp0MAC),
        .mode = 0666,
        .child = NULL,
        .proc_handler = &tvl2_mac_proc_handler,
        .strategy = &tvl2_mac_ctl_handler,
    },
    {0}
};
static ctl_table tvl2_ctl_dsp_detail_mac_table1[] = {
    {
        .ctl_name = CTL_TVL2_DSP_MAC,
        .procname = "mac",
        .data = &tvl2SysCtlData.dsp1MAC,
        .maxlen = sizeof(tvl2SysCtlData.dsp1MAC),
        .mode = 0666,
        .child = NULL,
        .proc_handler = &tvl2_mac_proc_handler,
        .strategy = &tvl2_mac_ctl_handler,
    },
    {0}
};
static ctl_table tvl2_ctl_dsp_detail_mac_table2[] = {
    {
        .ctl_name = CTL_TVL2_DSP_MAC,
        .procname = "mac",
        .data = &tvl2SysCtlData.dsp2MAC,
        .maxlen = sizeof(tvl2SysCtlData.dsp2MAC),
        .mode = 0666,
        .child = NULL,
        .proc_handler = &tvl2_mac_proc_handler,
        .strategy = &tvl2_mac_ctl_handler, 
    },
    {0}
};
static ctl_table tvl2_ctl_dsp_detail_mac_table3[] = {
    {
        .ctl_name = CTL_TVL2_DSP_MAC,
        .procname = "mac",
        .data = &tvl2SysCtlData.dsp3MAC,
        .maxlen = sizeof(tvl2SysCtlData.dsp3MAC),
        .mode = 0666,
        .child = NULL,
        .proc_handler = &tvl2_mac_proc_handler,
        .strategy = &tvl2_mac_ctl_handler,
    },
    {0}
};

static ctl_table tvl2_ctl_dsp_detail_table[] = {
        {
            .ctl_name = CTL_TVL2_DSP3,
            .procname = "3",
            .data = NULL,
            .maxlen = 0,
            .mode = 0555,
            .child = tvl2_ctl_dsp_detail_mac_table3,
            .proc_handler = NULL,
            .strategy = NULL,
        },
        {
            .ctl_name = CTL_TVL2_DSP2,
            .procname = "2",
            .data = NULL,
            .maxlen = 0,
            .mode = 0555,
            .child = tvl2_ctl_dsp_detail_mac_table2,
            .proc_handler = NULL,
            .strategy = NULL,
        },
        {
            .ctl_name = CTL_TVL2_DSP1,
            .procname = "1",
            .data = NULL,
            .maxlen = 0,
            .mode = 0555,
            .child = tvl2_ctl_dsp_detail_mac_table1,
            .proc_handler = NULL,
            .strategy = NULL,
        },
        {
            .ctl_name = CTL_TVL2_DSP0,
            .procname = "0",
            .data = NULL,
            .maxlen = 0,
            .mode = 0555,
            .child = tvl2_ctl_dsp_detail_mac_table0,
            .proc_handler = NULL,
            .strategy = NULL,
        },
        {
            .ctl_name = CTL_TVL2_IFMAC,
            .procname = "ifMAC",
            .data     = &tvl2SysCtlData.ifMAC,
            .maxlen = sizeof(tvl2SysCtlData.ifMAC),
            .mode     = 0666,
            .child    = NULL,
            .proc_handler = &tvl2_mac_proc_handler,
            .strategy = &tvl2_mac_ctl_handler,
        },
        {
            .ctl_name = CTL_TVL2_IFN,
            .procname = "ifName",
            .data     = &tvl2SysCtlData.ifName,
            .maxlen   = sizeof(tvl2SysCtlData.ifName),
            .mode     = 0666,
            .child    = NULL,
            .proc_handler = &proc_dostring,
            .strategy = &sysctl_string,
        },
        {0}
};

static ctl_table tvl2_ctl_dsp_table[] = {
        {
            .ctl_name = CTL_TVL2_DSP,
            .procname = "dsp",
            .data = NULL,
            .maxlen = 0,
            .mode = 0555,
            .child = tvl2_ctl_dsp_detail_table,
            .proc_handler = NULL,
            .strategy = NULL,
        },
        {
            .ctl_name = CTL_TVL2_REMAP,
            .procname = "remap",
            .data     = &tvl2SysCtlData.remap,
            .maxlen = sizeof(tvl2SysCtlData.remap),
            .mode = 0666,
            .child = NULL,
            .proc_handler = &proc_dointvec_minmax,
            .strategy = &sysctl_intvec,
            .extra1 = &remapMin,
            .extra2 = &remapMax,
        },
        {0}
};

static ctl_table tvl2_ctl_table[] = {
        {
            .ctl_name = CTL_TVL2,
            .procname = "tvl2",
            .data = NULL,
            .maxlen = 0,
            .mode = 0555,
            .child = tvl2_ctl_dsp_table,
            .proc_handler = NULL,
            .strategy = NULL,
        },
        {0}
};
    
static struct ctl_table_header *tvl2_table_header;
    
int __init tvl2_sysctl_init (void)
{
    if (!(tvl2_table_header = register_sysctl_table(tvl2_ctl_table, 0)))
        return EPERM;
    return 0;
}
    
void __exit tvl2_sysctl_exit (void)
{
    if (tvl2_table_header)
        unregister_sysctl_table(tvl2_table_header);
}

module_init(tvl2_sysctl_init);
module_exit(tvl2_sysctl_exit);

MODULE_AUTHOR("Dialogic");
#ifdef  MODULE_LICENSE
MODULE_LICENSE("BSD");
#endif
