##########@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@###################################
# DIALOGIC CONFIDENTIAL
#
# Copyright (C) 2001-2007 Dialogic Corporation. All Rights Reserved.
# The source code contained or described herein and all documents related
# to the source code ("Material") are owned by Dialogic Corporation or its
# suppliers or licensors. Title to the Material remains with Dialogic Corporation
# or its suppliers and licensors. The Material contains trade secrets and
# proprietary and confidential information of Dialogic or its suppliers and
# licensors. The Material is protected by worldwide copyright and trade secret
# laws and treaty provisions. No part of the Material may be used, copied,
# reproduced, modified, published, uploaded, posted, transmitted, distributed,
# or disclosed in any way without Dialogic's prior express written permission.
#
# No license under any patent, copyright, trade secret or other intellectual
# property right is granted to or conferred upon you by disclosure or delivery
# of the Materials, either expressly, by implication, inducement, estoppel or
# otherwise. Any license under such intellectual property rights must be
# express and approved by Dialogic in writing.
#
###################################@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@##########
#!/bin/sh
#
#  Script:		dlgcs7_ftp.sh
#  Description:		ftp get config.txt from SIU, called from GCSS7 daemon

crop() {
    local tmp=${2#\{}
    tmp=${tmp%\}}
    eval "$1=$tmp"
}

crop ldir $1
crop serv $2
crop user $3
crop pw $4
crop rdir $5
crop file $6
crop type $7

myparms="{$ldir} {$serv} {$user} {$pw} {$rdir} {$file} {$type}"
logfile='/usr/dialogic/log/dlgcs7_ftp.log'

#echo $myparms > $logfile
echo $myparms 

if [ $type == "0" ]   # FTP Type is "0" - Normal FTP
then
   ftp -n -v $serv >> $logfile << !stop!it!
   user $user $pw
   cd $rdir 
   lcd $ldir
   bin
   get $file
   bye
!stop!it!
else    # FTP Type is "1" - SSH FTP
   lftp -d -u $user,$pw sftp://$serv >> $logfile 2>&1 << !stop!it!
   cd $rdir 
   lcd $ldir
   get $file
   bye
!stop!it!
fi

# end of script
