#!/bin/csh
#
# Copyright (C) 2000-2008 Dialogic Corporation.  All Rights Reserved.
# All names, products, and services mentioned herein are the trademarks
# or registered trademarks of their respective organizations and are the
# sole property of their respective owners.
#

# Determine OS version
set OS = `uname -s`

if ( "${OS}" == "Linux" ) then
	if ( -f /etc/redhat-release ) then
 		set DIST = 'RedHat'
 		set PKG_QUERY = "rpm --query"
	else if ( -f /etc/SuSE-release ) then
		set DIST = "SuSE"
		set PKG_QUERY = "rpm --query"
	else if ( -f /etc/debian_version ) then
		set DIST = "Debian"
		set PKG_QUERY = "dpkg -l"
	else if ( -f /etc/turbolinux-release ) then
 		set DIST = "Turbolinux"
 		set PKG_QUERY = "rpm --query"
	else
		set DIST = "UNKNOWN"
	endif
else
	#Unsupported OS
	set DIST = "UNKNOWN"
endif

#Enable when deployed as an ATCA Titusville Blade
#Otherwise set it to zero
${PKG_QUERY} lsb-dialogic-ovl-com >& /dev/null
set OVL_INSTALLED = $?
${PKG_QUERY} lsb-dialogic-tvl-com >& /dev/null
set TVL2_INSTALLED = $?
if ( ${OVL_INSTALLED} || ${TVL2_INSTALLED} ) then
	set HMPATCA = 1
	setenv HMPATCA
else
	set HMPATCA = 0
	setenv HMPATCA
endif

# Dialogic Root
setenv DLGCROOT /usr/dialogic
setenv DLGCFWLPATH $DLGCROOT/data
setenv DLGCCFGPATH $DLGCROOT/cfg

# Qscript
setenv QROOT $DLGCROOT
setenv QSCRIPT_DIR $DLGCROOT/qscript

# Where resources are stored
setenv QDNLDDATA $DLGCFWLPATH

# Where binary files are stored
setenv QDNLDBIN $DLGCROOT/bin

#Setup any environment variable needed by HMP ATCA Product
if ( "$HMPATCA" == 1 ) then
	#echo "Setting HMP ATCA Product Environment Variables"
	setenv IPMS_SNMP_CACHE_REFRESH_TIME 2
	setenv INTEL_DIALOGIC_LOG_FACILITY LOCAL2
	setenv BM_LOG_LEVEL 2
	# Interval for polling OS interface data
	setenv BM_INTERFACE_POLL_INTERVAL 30
endif

# NEEDED for UCD-SNMP
setenv MIBS SNMPv2-TC:SNMPv2-MIB:IF-MIB:IP-MIB:TCP-MIB:UDP-MIB:SNMP-VIEW-BASED-ACM-MIB:DLGC-GLOBAL-REG:DLGHWINF-MIB:UCD-DLMOD-MIB

#
# New environment variables
#
# WARNING:  All applications should use the environment variables listed below.  In a
# WARNING:  future release, support for the old variables will be dropped.  The value
# WARNING:	of each variable is not guaranteed to remain the same in subsequent releases.
#

setenv INTEL_DIALOGIC_BASE /usr
setenv INTEL_DIALOGIC_NAME dialogic

# null for now
# when a value is assigned, it must be appended to INTEL_DIALOGIC_DIR
setenv INTEL_DIALOGIC_RELEASE

# replacement for ${DLGCROOT}
setenv INTEL_DIALOGIC_DIR ${INTEL_DIALOGIC_BASE}/${INTEL_DIALOGIC_NAME}

# location of programs
setenv INTEL_DIALOGIC_BIN ${INTEL_DIALOGIC_DIR}/bin

# location of non-firmware configuration files
setenv INTEL_DIALOGIC_CFG ${INTEL_DIALOGIC_DIR}/cfg

# location of firmware and firmware configuration files
setenv INTEL_DIALOGIC_FWL ${INTEL_DIALOGIC_DIR}/data

# location of header files for use in application compilation
# e.g.  cc -o myapp myapp.c -I${INTEL_DIALOGIC_INC}
setenv INTEL_DIALOGIC_INC ${INTEL_DIALOGIC_DIR}/inc

# location of shared libraries for use in application linking
# e.g. cc -o myapp myapp.c -L${INTEL_DIALOGIC_LIB} -lsrl
setenv INTEL_DIALOGIC_LIB ${INTEL_DIALOGIC_DIR}/lib
setenv INTEL_DIALOGIC_LIB_64 ${INTEL_DIALOGIC_DIR}/lib64

# syslog facility name - updated when config.sh is run
setenv INTEL_DIALOGIC_LOG_FACILITY FACILITY_NAME

# location of qscript tools
setenv INTEL_DIALOGIC_QSCRIPT ${INTEL_DIALOGIC_DIR}/qscript

# new environment variables required for vista support
setenv DIALOGIC_CFG_INTERNAL ${INTEL_DIALOGIC_DIR}/cfg
setenv DIALOGIC_FWL_BIN ${INTEL_DIALOGIC_DIR}/data
setenv DIALOGIC_USERDATA_DIR ${INTEL_DIALOGIC_DIR}

# add our directory containing executables to the path
setenv PATH ${INTEL_DIALOGIC_BIN}:$PATH

#
# WARNING: The following environment variables will be eliminated in a future release
#          Forwards-compatible replacements are listed below.
#
#
#		QROOT				( instead use ${INTEL_DIALOGIC_DIR} )
#		QDNLDDATA		( instead use ${INTEL_DIALOGIC_FWL} )
#		QDNLDBIN			( instead use ${INTEL_DIALOGIC_BIN} )
#
#

# bitmapped list of technologies / form factors supported in this release
#
# Bit  0      = PCI form factor supported
# Bit  1      = cPCI form factor supported
# Bit  2      = HMP technology supported
# Bit  3      = ATCA form factor supported
# Bits 4 - 15 = Reserved for Future Use
#

setenv INTEL_DIALOGIC_SUPPORTED_TECH 4

# add our directory containing libraries
if ( $?LD_LIBRARY ) then
  setenv LD_LIBRARY ${INTEL_DIALOGIC_LIB}:$LD_LIBRARY
else
  setenv LD_LIBRARY ${INTEL_DIALOGIC_LIB}
endif

# increase the maximum number of open files
# csh doesn't support ulimit, remove it
#ulimit -n 8192

# media server status (disable=0/enable=1)
setenv INTEL_DIALOGIC_MEDIA_SERVER 0
setenv INTEL_DIALOGIC_MEDIA_SERVER_STATUS 0

if ( -f buildinfo ) then
        set BUILDINFO = buildinfo

	#Using the buildinfo file determine what type of platform
	#i.e hmp or tvl2
	setenv DIALOGIC_PLATFORM `awk  '/Major Number/ {print $6}' ${BUILDINFO} | tr '[a-z]' '[A-Z]'`
	setenv DIALOGIC_RELNUM `awk  '/Release Minor Number/ {print $6}' ${BUILDINFO} | tr '[a-z]' '[A-Z]'`
else if ( -f ${INTEL_DIALOGIC_CFG}/buildinfo ) then
  set BUILDINFO = ${INTEL_DIALOGIC_CFG}/buildinfo
        
	#Using the buildinfo file determine what type of platform
	#i.e hmp or tvl2
	setenv DIALOGIC_PLATFORM `awk  '/Major Number/ {print $6}' ${BUILDINFO} | tr '[a-z]' '[A-Z]'`
	setenv DIALOGIC_RELNUM `awk  '/Release Minor Number/ {print $6}' ${BUILDINFO} | tr '[a-z]' '[A-Z]'`
else
        echo
        echo "WARNING: buildinfo file not found!"
        echo
endif
