#!/bin/sh
#
# Copyright (C) 2000-2012 Dialogic Corporation.  All Rights Reserved.
# All names, products, and services mentioned herein are the trademarks
# or registered trademarks of their respective organizations and are the
# sole property of their respective owners.
#

# check root privilege
if [ $UID -ne 0 ] && shopt -q login_shell
then
    echo "Error: Root privileges are required to run HMP"
fi

# Determine OS version
OS=`uname -s`

#Dialogic Root
DLGCROOT=/usr/dialogic
export DLGCROOT

DLGCFWLPATH=$DLGCROOT/data
export DLGCFWLPATH

DLGCCFGPATH=$DLGCROOT/cfg
export DLGCCFGPATH

QSCRIPT_DIR=$DLGCROOT/qscript
export QSCRIPT_DIR

QROOT=$DLGCROOT
export QROOT

# Where resource files are stored
QDNLDDATA=$DLGCFWLPATH
export QDNLDDATA

# Where binary files are stored
QDNLDBIN=$DLGCROOT/bin
export QDNLDBIN

# needed by ngmit vob
 export IPMS_SNMP_CACHE_REFRESH_TIME=2
 export INTEL_DIALOGIC_LOG_FACILITY=LOCAL2
 export BM_LOG_LEVEL=2
 # Interval for polling OS interface data
 export BM_INTERFACE_POLL_INTERVAL=30

# remove FlexNet /etc/hosts file dependency
export FLEXLM_ANYHOSTNAME=1

# not in use
#MIBS=SNMPv2-TC:SNMPv2-MIB:IF-MIB:IP-MIB:TCP-MIB:UDP-MIB:SNMP-VIEW-BASED-ACM-MIB:DLGC-GLOBAL-REG:UCD-DLMOD-MIB
#export MIBS

#
# New environment variables
#
# WARNING:  All applications should use the environment variables listed below.  In a
# WARNING:  future release, support for the old variables will be dropped.  The value
# WARNING:	of each variable is not guaranteed to remain the same in subsequent releases.
#

INTEL_DIALOGIC_BASE=/usr
export INTEL_DIALOGIC_BASE

INTEL_DIALOGIC_NAME=dialogic
export INTEL_DIALOGIC_NAME

# null for now
# when a value is assigned, it must be appended to INTEL_DIALOGIC_DIR
INTEL_DIALOGIC_RELEASE=
export INTEL_DIALOGIC_RELEASE

# replacement for ${DLGCROOT}
INTEL_DIALOGIC_DIR=${INTEL_DIALOGIC_BASE}/${INTEL_DIALOGIC_NAME}
export INTEL_DIALOGIC_DIR

# location of programs
INTEL_DIALOGIC_BIN=${INTEL_DIALOGIC_DIR}/bin
export INTEL_DIALOGIC_BIN

# location of web agent program
INTEL_DIALOGIC_WEBAGENT=${INTEL_DIALOGIC_DIR}/web/html
export INTEL_DIALOGIC_WEBAGENT

# location of non-firmware configuration files
INTEL_DIALOGIC_CFG=${INTEL_DIALOGIC_DIR}/cfg
export INTEL_DIALOGIC_CFG

# location of firmware and firmware configuration files
INTEL_DIALOGIC_FWL=${INTEL_DIALOGIC_DIR}/data
export INTEL_DIALOGIC_FWL

# location of header files for use in application compilation
# e.g.  cc -o myapp myapp.c -I${INTEL_DIALOGIC_INC}
INTEL_DIALOGIC_INC=${INTEL_DIALOGIC_DIR}/inc
export INTEL_DIALOGIC_INC

# location of shared libraries for use in application linking
# e.g. cc -o myapp myapp.c -L${INTEL_DIALOGIC_LIB} -lsrl
INTEL_DIALOGIC_LIB=${INTEL_DIALOGIC_DIR}/lib
export INTEL_DIALOGIC_LIB

INTEL_DIALOGIC_LIB_64=${INTEL_DIALOGIC_DIR}/lib64
export INTEL_DIALOGIC_LIB_64

# syslog facility name - updated when config.sh is run
if [ "$HMPATCA" = 0 ]
then
INTEL_DIALOGIC_LOG_FACILITY=FACILITY_NAME
export INTEL_DIALOGIC_LOG_FACILITY
fi

# location of qscript tools
INTEL_DIALOGIC_QSCRIPT=${INTEL_DIALOGIC_DIR}/qscript
export INTEL_DIALOGIC_QSCRIPT

# new environment variables required for vista support
DIALOGIC_CFG_INTERNAL=${INTEL_DIALOGIC_DIR}/cfg
export DIALOGIC_CFG_INTERNAL

DIALOGIC_FWL_BIN=${INTEL_DIALOGIC_DIR}/data
export DIALOGIC_FWL_BIN

DIALOGIC_USERDATA_DIR=${INTEL_DIALOGIC_DIR}
export DIALOGIC_USERDATA_DIR

# add the  directory containing our executables to the path
PATH=${INTEL_DIALOGIC_BIN}:${PATH}
export PATH

#
# WARNING: The following environment variables will be eliminated in a future release
#          Forwards-compatible replacements are listed below.
#
#
#		QROOT				( instead use ${INTEL_DIALOGIC_DIR} )
#		QDNLDDATA		( instead use ${INTEL_DIALOGIC_FWL} )
#		QDNLDBIN			( instead use ${INTEL_DIALOGIC_BIN} )
#
#

# bitmapped list of technologies / form factors supported in this release
#
# Bit  0      = PCI form factor supported
# Bit  1      = cPCI form factor supported
# Bit  2      = HMP technology supported
# Bit  3      = ATCA form factor supported
# Bits 4 - 15 = Reserved for Future Use
#

export INTEL_DIALOGIC_SUPPORTED_TECH=4

# add the  directory containing our libraries
LD_LIBRARY=${INTEL_DIALOGIC_LIB}:${LD_LIBRARY}
export LD_LIBRARY

# increase the maximum number of open files only w/ root privilege
if [ $(id -u) = "0" ]; then
    ulimit -n 8192
fi

# media server status (disable=0/enable=1)
INTEL_DIALOGIC_MEDIA_SERVER_STATUS=0
export INTEL_DIALOGIC_MEDIA_SERVER_STATUS

#Using the buildinfo file determine what type of platform
#i.e hmp or tvl2

if [ -f ${INTEL_DIALOGIC_CFG}/buildinfo ]
then
	BUILDINFO=${INTEL_DIALOGIC_CFG}/buildinfo
	
	DIALOGIC_PLATFORM=`awk  '/Major Number/ {print $6}' ${BUILDINFO} | tr '[a-z]' '[A-Z]'`
	export DIALOGIC_PLATFORM

	DIALOGIC_RELNUM=`awk  '/Release Minor Number/ {print $6}' ${BUILDINFO} | tr '[a-z]' '[A-Z]'`
	export DIALOGIC_RELNUM
fi
