/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : dlver.h
 * Description                  : version number specific definitions
 *
 *
 **********************************************************************/


/**********************************************************************
 *
 *    Version number looks like this:
 *    "KEYWORD TMmmBBAA-<build> exename <optional string>"
 *
 * Where:
 *       KEYWORD = DLcid
 *       T  = type (0-Prod, 1-Beta, 2-Alpha, 3-Expr, 4-Special)
 *       M  = major number (0-9)
 *       mm = minor number (00-99)
 *       BB = beta number  (00-99)
 *       AA = alpha/experimental number (00-99)
 *       <build> - build number (reset to 0 when major/minor/alpha/beta change)
 *       <exename> - name of file this is a version of
 *       <optional string> - optional comment string
 *
 * Some examples:
 *
 *  "DLcid 31000002-00 d40drv.exe"
 *       1.00 Exp 0.02 of the file d40drv.exe
 *
 *  "DLcid 11000100-02 d40drv.exe"
 *        1.00 Beta 1 build 2 of d40drv.exe
 *
 ***************************************************************************/

#define  KEYWORD  "DLcid"

/* Where in string these parts of the version number reside */
#define  FIELD_TYPE        (sizeof(KEYWORD))
#define  FIELD_MAJOR       (FIELD_TYPE+1)
#define  FIELD_MINOR_DIG1  (FIELD_MAJOR+1)
#define  FIELD_MINOR_DIG2  (FIELD_MINOR_DIG1+1)
#define  FIELD_BETA_DIG1   (FIELD_MINOR_DIG2+1)
#define  FIELD_BETA_DIG2   (FIELD_BETA_DIG1+1)
#define  FIELD_ALPHA_DIG1  (FIELD_BETA_DIG2+1)
#define  FIELD_ALPHA_DIG2  (FIELD_ALPHA_DIG1+1)
#define  FIELD_BUILD_START (FIELD_ALPHA_DIG2+2)


/* Possible types */
#define  TYPE_PRODUCTION   '0'
#define  TYPE_BETA         '1'
#define  TYPE_ALPHA        '2'
#define  TYPE_EXP          '3'
#define  TYPE_SPEC         '4'


/* Options for String2DiaVersion function */
#define  VER_VERSION    0     /* Standard version number */
#define  VER_WITHBUILD  1     /* include the build number */
#define  VER_BUILDONLY  2     /* Only report back the build number */
#define  VER_EXENAME    3     /* Return the executable name */
#define  VER_COMMENT    4     /* Return only the comment */

/* Prototype */
#ifdef _cplusplus
extern "C"{
#endif
int String2DiaVersion(char *,int, char *);
int DiaVersion2String(char *,int, char *);
#ifdef _cplusplus
}
#endif














