/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : msdlinux.h
 * Description                  : linux include
 *
 *
 **********************************************************************/

#ifndef _MSDLINUX_
#define _MSDLINUX_

#ifdef CONFIG_COMPAT
#include <linux/compat.h>
#endif

#define PCI_VENDOR_ID_DLGC      0x10B5
#define PCI_VENDOR_ID_MPC       0x1957
#define PCI_VENDOR_ID_DLGC_NEW  0x1011
#define PCI_VENDOR_ID_DLGC_21555  0x8086   /* 21555*/

#define PCI_DEVICE_ID_DLGC_906D 0x906D
#define PCI_DEVICE_ID_DLGC_9054 0x9054
#define PCI_DEVICE_ID_DLGC_9056 0x9056 	   /* T1E1 Thin Blades */
#define PCI_DEVICE_ID_DLGC_5356 0x5356     /* Seaville - PCIe */
#define PCI_DEVICE_ID_DLGC_0046 0x0046
#define PCI_DEVICE_ID_DLGC_530D 0x530D
#define PCI_DEVICE_ID_DLGC_21555 0xB555    /* 21555 */
#define PCI_DEVICE_ID_DLGC_4143 0x4143     /* Pacific */
#define PCI_DEVICE_ID_GEM    	0x5012     /* Gemini - PCIe */
#define PCI_DEVICE_ID_GEMMPC 	0x00B7     /* MPC - PCIe */
#define PCI_DEVICE_ID_GEM_AMC  	0x5013     /* Gemini - AMC */
#define PCI_DEVICE_ID_GEMMPC_AMC 0x00C5    /* MPC - AMC */
#define PCI_DEVICE_ID_GEMRTM 	0xAAAA     /* RTM - AMC */

#define PCI_SUBVENDOR_ID_DLGC   0x12C7
#define PCI_SUBDEVICE_ID_DM3    0x4001
#define PCI_SUBDEVICE_ID_DISI   0x4002
#define PCI_SUBDEVICE_ID_DTI16  0x5001
#define PCI_SUBDEVICE_ID_ROZETTA 0x5002
#define PCI_SUBDEVICE_ID_DMVB   0x5005
#define PCI_SUBDEVICE_ID_DMVC   0x5006 	   /* T1E1 Thin Blades */
#define PCI_SUBDEVICE_ID_SEAV   0x5007     /* Seaville - PCIe */
#define PCI_SUBDEVICE_ID_GEM    0x5012     /* Gemini - PCIe */
#define PCI_SUBDEVICE_ID_GEMMPC 0x5012     /* MPC - PCIe */
#define PCI_SUBDEVICE_ID_GEM_AMC 0x5013    /* Gemini - AMC */
#define PCI_SUBDEVICE_ID_GEMMPC_AMC 0x5013 /* MPC - AMC */
#define PCI_SUBDEVICE_ID_GEM_OPAL 0x5014   /* Opal - AMC */
#define PCI_SUBDEVICE_ID_GEMRTM 0xAAAA     /* RTM - AMC */

// These include files must preceed driver specific headers

/*
 * UNIX includes
 */
#ifndef __VMODULE__
#define __NO_VERSION__
//#include <linux/module.h>
#endif /* __VMODULE__ */

#include "msdnative.h"

#include <linux/ioctl.h>
#include <linux/types.h>
#include <linux/errno.h>

#ifdef LiS
#include <sys/dlpi.h>
#include <sys/npi.h>
#include <sys/tihdr.h>
#include <sys/mkdev.h>
#endif

#include <linux/pci.h>
#ifdef LINUX24
#include <linux/init.h>
#endif
#include <linux/fs.h>
#include <linux/types.h>
#include <linux/string.h>
#include <linux/poll.h>
#include <linux/slab.h>
#include <linux/kernel.h>
#include <asm/system.h>
#include <asm/segment.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/delay.h>
#include <linux/timer.h>
#include <linux/timex.h>
#include <linux/signal.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/delay.h>

#ifdef LiS
#include <sys/cred.h>
#include <sys/osif.h>
#include <sys/lislocks.h>
#include <sys/lismem.h>
#else
#include <linux/spinlock.h>
#endif

#ifdef LINUX24
#ifndef IRQ_NONE
typedef void irqreturn_t;
#define IRQ_NONE
#define IRQ_HANDLED
#define IRQ_RETVAL(x)
#endif
#endif

/*
 * Some common typedefs definitions
 */
typedef void                   *IBLOCK_COOKIE;
typedef unsigned long 		DEV_ACC_ATTR;
typedef unsigned long		DEV_ACC_HANDLE;
typedef unsigned long 		SOFT_INTR_ID;
typedef unsigned int 		mercd_dpc_rt;

typedef struct pci_dev 	DEV_INFO;
typedef struct pci_dev  mercd_dev_info_T;
typedef struct pci_dev *pmercd_dev_info_T;

#ifdef LiS
typedef lis_spin_lock_t mercd_mutex_T;
typedef queue_t        *pmercd_strm_queue_sT;
#else
typedef spinlock_t 	mercd_mutex_T;
typedef msgb_t 		mblk_t;
#endif
typedef int             md_status_t;
typedef int             mercd_kcondvar_t;
typedef int             mercd_acc_attr_T;
typedef int            *pdevice_information_T ;
typedef void           *mercd_iblock_cookie_T;
typedef clock_t         mercd_clock_t;

typedef unsigned long   mercd_dev_acc_handle_T;
typedef unsigned long  *mercd_softintr_T;
typedef unsigned long  *pmercd_function_T;
typedef unsigned short *pmercd_adapter_map_T;
typedef struct	tasklet_struct	mercd_taskqueue_sT;

typedef struct _MercdMajor_ {
#ifdef LiS
#define MERCD_MAX_MAJOR_DEV 5
#else
#define MERCD_MAX_MAJOR_DEV 1
#endif /* LiS */
	int major[ MERCD_MAX_MAJOR_DEV ] ;
	int openCount;

} MercdMajorTable;

#define PCI_CONF_SUBSYSID	0x2e
#define PCI_CONF_SUBVENID	0x2c
#define PCI_CONF_COMM		0x4
#define PCI_COMM_MAE		0x0002
#define PCI_COMM_ME		0x0004

#endif // _MSDLINUX_
