/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2011 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/****************************************************************************
 * FILE:         qtypes.h
 ***************************************************************************/

#ifndef __QTYPES_H__
#define __QTYPES_H__

#include <qoscommon.h>

#ifndef QCPU
#error QCPU is not defined
#endif

#ifdef __cplusplus
extern "C" {
#endif
    
/*
 *  Note:  Is it really necessary to exclude non VxWorks and Winos kernels
 *  from this Char typedef?
 */
typedef char   Char;

typedef short  QD_UINT16;
typedef long   QD_UINT32;

#if (QCPU < QHOST)
#ifdef __cplusplus
typedef bool boolean;
#else
typedef enum {false, true} boolean;
#endif
#endif /* (QCPU < QHOST) */

typedef  unsigned char        UInt8;
typedef  unsigned char        Uint8;
typedef  char                 Int8;

typedef  unsigned short int   UInt16;
typedef  unsigned short int   Uint16;
typedef  short int            Int16;

typedef  unsigned int         UInt24;
typedef  unsigned int         Uint24;
typedef  int                  Int24;


#if (QCPU == QM56301)
typedef  unsigned long        UInt32;
typedef  unsigned long        Uint32;
typedef  long                 Int32;
#else
typedef  unsigned int         UInt32;
typedef  unsigned int         Uint32;
typedef  int                  Int32;
#endif  /* (QCPU == QM56301) */

typedef	long					Int3264;
typedef	unsigned long			UInt3264;

#include "qstrtype.h"

typedef unsigned int          QError;
typedef unsigned int          QMemRef;
typedef unsigned int          QParm;

/* prototype for task entrypoints created by qTaskCreate2 */
typedef  void  (*QFuncPtr)(void);

/* prototype for task entrypoints created by qTaskCreate2 */
typedef void (*QFuncPtr2)(void *pArgs);
    

#ifdef __cplusplus
}
#endif

#endif
