# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#This class is a new form of the class object, it contains methods special to 
#dm3 classes, such as a method for automatically defining methods for sending
#messages

#don't source the script more then once
if [info exists AddressableClass] {
    return
}


#this line helps the auto loader find this class
proc AddressableClass {} {}

catch {class new -Name AddressableClass -init {-Extends class}}





#defineMsgMethod - automaticaly define a method which will send a message
#***Inputs****
#-MethodName - name of method to define
#-Type - Msg type to send
#[-TypeDef] - typedef for method, lookup = registry lookup
#[-RetType] - return type to wait for
#[-RetTypeDef] - just like typedef, if lookup is used RetType must be specified
#[-Defaults] - a list of optional fields and there defaults values
#[-RequestFlags] - a list of flags and data to add to the request line
#***Outputs****
#***Exceptions***
#***Note***
#The created method will take in the fields in TypeDef as arguments, only the first
#level of the typedef is checked for accuracy
AddressableClass method defineMsgMethod {args} {

    array set check [CheckParms -Proc AddressableClass_defineMsgMethod \
			 -Provided $args \
			 -Required {-MethodName -Type} \
			 -Optional {-TypeDef -RetTypeDef -RetType -Defaults \
					-RequestFlags}]


    #record command line for c++ generation
    $this public defined_commands
    lappend defined_commands [list $this $args]


    array set parms $check(Flags)

    #handle required arguments

    set type $parms(-Type)
    set methodname $parms(-MethodName)
    

    #handle optional arguments
    if [catch {set reqFlags $parms(-RequestFlags)}] {
	set reqFlags ""
    }

    catch {set rettype $parms(-RetType)}

    if ![catch {set typedef $parms(-TypeDef)} result] {
	#typedef supplied
	if {$typedef == "lookup"} {
	    set tdr [$this set typeDefRegistry]
	    set typedef [$tdr lookup -MsgType $type]
	}
    } else {
	set typedef {}
    }

    if ![catch {set rettypedef $parms(-RetTypeDef)} result] {
	#rettypedef supplied
	if ![info exists rettype] {
	    error "-RetTypeDef supplied without -RetType"
	}
	if {$rettypedef == "lookup"} {
	    set tdr [$this set typeDefRegistry]
	    set rettypedef [$tdr lookup -MsgType $rettype]
	}
    }

    #add dashes to front of first level parms on typedef
    set origtd $typedef
    set otd {}
    for {set i 0} {[expr $i < [llength $typedef]]} {incr i} {
	lappend otd -[lindex $typedef $i]
	lappend otd [lindex $typedef [expr $i +1]]
	incr i
    }
    set typedef $otd
		   

    if [catch {array set defaults $parms(-Defaults)} result] {
	set optional {}
	set defaults {}
    } else {
	set optional [array names defaults]
    }

    #build command which will be used in the method

    set cmd "\$this request -Type $type $reqFlags"
    set required {}

    if [info exists typedef] {
	set cmd "$cmd -TypeDef \{$origtd\}"
	array set td $typedef
	foreach item [array names td] {
	    if {[lsearch -exact $optional $item] == -1} {
		lappend required $item
	    }
	}
    } else {
	set cmd "$cmd -TypeDef \{\}"
    }


    if [info exists rettypedef] {
	set cmd "$cmd -RetTypeDef \{$rettypedef\}"
    }

    if [info exists rettype] {
	set cmd "$cmd -RetType $rettype"
    }


    #define the new method

    set procdata "$this method $methodname \{args\} \{
            array set check \[CheckParms -Proc ${this}_$methodname \
			 -Provided \$args \
			 -Required \{$required\} \
			 -Optional \{$optional\} \]

         
            array set tdata \{[array get defaults]\}
            array set tdata \$check(Flags)

            set data {}
            \#remove leading dashes
            foreach elm \[array names tdata\] \{
                lappend data \[string range \$elm 1 end\]
                lappend data \$tdata(\$elm)
            \}

            return \[$cmd -Data \$data\]
 
          \}"

#    puts $procdata
#    puts "\n\n\n\n"
    eval $procdata
    

    
};#endof AddressableClass_defineMsgMethod



