# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#Class Addressable
#The Addressable class is basically a DM3 component, it contains a Target Address for
#messages (TgtDesc) and a message queue to use in sending them (MsgQueue) it also
#contains methods for issuing requests (request) and for handeling asyncronous
#messages
#


#don't source the script more then once
if [info exists Addressable] {
    return
}



#this line helps the auto loader find this class
proc Addressable {} {}

catch {AddressableClass new -Name Addressable}




Addressable set instanceCounter 0
Addressable set typeDefRegistry Addressable_TypeDefs

#Addressable_init - init a new Addressable object
#***Inputs***
#[-TgtDesc] - address to send message to
#[-MsgQueue] - queue to send messages on, if not specified a new one is created
#***Switches***
#***Outputs***
#***Exceptions***
Addressable method init {args} {
    $this super init

    $this public TgtDesc MsgQueue ResponseTimeout ErrorWaitTime UniqueId
    global QS_GlobalValues

    array set check [CheckParms -Proc Addressable_init -Provided $args \
			 -Required {-TgtDesc} -Optional {-MsgQueue} \
			 -Switches {-NoCancel -NoUse -NoUnuseOnDestroy}]

    array set parms $check(Flags)

    set ResponseTimeout $QS_GlobalValues(ResponseTimeout)
    set ErrorWaitTime $QS_GlobalValues(ErrorWaitTime)   
    set UniqueId [$this Class incr instanceCounter]


    set TgtDesc $parms(-TgtDesc)
    

    if [info exists parms(-MsgQueue)] {
	$this MsgQueueAttach $parms(-MsgQueue)
    } else {
	$this MsgQueueAttach [MsgQueue new -init [list -Desc $TgtDesc]]
    }


};#endof Addressable_init


Addressable method clone {} {
    error "Class Addressable uncloneable"
}

#Addressable_destroy - Destroy a Addressable object
#***Inputs***
#Addressableobj
#***Outputs***
#***Exceptions***
Addressable method destroy {} {
    
    $this public MsgQueue callback

    if [info exists callback] {
	$callback destroy
    }
    #detach from the queue
    $MsgQueue detach

    $this super destroy
};#endof Addressable_destroy


#Addressable_MsgQueueAttach - switch which MsgQueue is being used
Addressable method MsgQueueAttach {newMsgQueue} {
    $this public MsgQueue

    if [info exists MsgQueue] {
	$MsgQueue detach
    }

    $newMsgQueue attach
    set MsgQueue $newMsgQueue

};#endof Addressable_MsgQueueAttach


#Addressable_request Format and sends a message to a DM3 instance
#***Inputs***
#Addressableobj        - the instance to send the message to                      
#-Type       - the msg type
#[-Data]       - Outbound Msg data
#[-TypeDef]    - TypeDef of outbound data
#[-RetType]    - Expected Type on Return Message
#[-RetTypeDef] - TypeDef of expected inbound data  
#[-ErrTypeDef] - TypeDef to use on Error Messages
#[-Timeout]    - milisecond timeout for response message, 0 indicates wait forever
#[-TransactionId] - transId to use, defaults to unique
#***Switches***
#[-IgnoreSource] - Ignore Source address in routing
#[-ReturnMsg] - Return the Msg rather then a parsed data
#***Outputs***
#the message data if there is any
#***Exceptions***
#TIMEOUT - no response message arrived, within timeout period
#AddressableMsgError - a AddressableMsgError was returned when not expected
Addressable method request {args} {
    array set check [CheckParms -Proc Addressable_request -Provided $args \
			 -Required {-Type} \
			 -Optional {-TypeDef -Data -RetType -RetTypeDef -ErrTypeDef 
			     -Timeout -TransactionId} \
			 -Switches {-IgnoreSource -ReturnMsg}]
		       
    global errorInfo
    
    array set parms $check(Flags)

    set expect_response 0
    #required fields in this
    $this public MsgQueue TgtDesc

    #required flags
    set type $parms(-Type)

    #optional flags
    catch {set transId $parms(-TransactionId)}

    set returnMsgRef 0
    if {[lsearch -exact $check(Switches) "-ReturnMsg"]!=-1} {
	set returnMsgRef 1
    }


    if [catch {set data $parms(-Data)} result] {
	set data {}
    }
    if [catch {set typedef $parms(-TypeDef)} result] {
	set typedef {}
    }

    if [info exists parms(-RetType)] {
	set rettype $parms(-RetType)
	set expect_response 1
    }
    if {[info exists parms(-RetTypeDef)]} {
	set rettypedef $parms(-RetTypeDef)
	if {$expect_response==0} {
	    #a RetTypeDef was specified but not RetType
	    error "-RetTypeDef supplied without -RetType"
	}
    }
    if {[info exists parms(-ErrTypeDef)]} {
	set ErrTypeDef $parms(-ErrTypeDef)
    }

    if {[catch {set timeout $parms(-Timeout)} result]} {
	if {$expect_response} {
	    set timeout [$this set ResponseTimeout]
	} else {
	    set timeout [$this set ErrorWaitTime]
	}
    }

    #create the msg
    set msg [Msg new]
    $msg bodySet -Data $data -TypeDef $typedef


    #construct request
    set cmd [list $MsgQueue request -Msg $msg  \
		 -MsgType $type -DestDesc $TgtDesc -Timeout $timeout]

    #switches
    if {[lsearch -exact $check(Switches) "-IgnoreSource"]!=-1} {
	lappend cmd -IgnoreSource
    } 

    if [info exists rettype] {
	lappend cmd -ResponseMsgType $rettype
    }

    if [info exists transId] {
	lappend cmd -TransactionId $transId
    }

    #send the thing and get response
    if [catch {set msgin [eval $cmd]} result] {
	#exception occured
	set orig_errorInfo $errorInfo
	if [catch {array set exception $result} new_result] {
	    error $result $orig_errorInfo
	}
	if ![info exists exception(Error)] {
	    error $result $orig_errorInfo
	}
	if {$exception(Error) == "StdMsgError"} {
	    #an error was returned
	    array set exdata $exception(Data)
	    set msgin $exdata(Msg)

	    global QS_ErrorCode_Descriptions Std_MsgError

	    if {![info exists ErrTypeDef]} {
		#no ErrTypeDef supplied
		#check to see if this class has a definiton for Std_MsgError
		set tdr [$this Class set typeDefRegistry]
		if [catch {set ErrTypeDef [$tdr lookup -MsgType $Std_MsgError]} result] {
		    #not defined, use default
		    global Std_MsgError_t
		    set ErrTypeDef $Std_MsgError_t
		}
	    }

	    array set error_data [$msgin bodyGet -TypeDef $ErrTypeDef]

	    $msgin destroy

	    QS_Error -Error $error_data(ErrorCode) -Data [array get error_data]
		    
	}


	if {$exception(Error) == "QResultError"} {
	    array set exdata $exception(Data)
	    set msgin $exdata(Msg)
	    #a QResultError was returned
	    global QS_ErrorCode_Descriptions
	    if {![info exists ErrTypeDef]} {
		#no ErrTypeDef supplied, use default
		global QResultError_t
		set ErrTypeDef $QResultError_t
	    }
	
	    array set error_data [$msgin bodyGet -TypeDef $ErrTypeDef]

	    $msgin destroy
	    
	    QS_Error -Error $error_data(ErrorCode) -Data [array get error_data]	
	    
	}

	#didn't match anything I was watching for rethrow
	
	error $result $errorInfo
    };#endof msgRequest catch

    #we've got a good message
    

    if {$msgin != {}} {

	if {$returnMsgRef} {
	    #if a rettypedef was supplied, set the msgs internal to it
	    if [info exists rettypedef] {
		$msgin set TypeDef $rettypedef
	    }
	    return $msgin
	}

	if [info exists rettypedef] {

	    #unpack msg and return its data
	    set msg_data [$msgin bodyGet -TypeDef $rettypedef]
	    $msgin destroy
	    return $msg_data
	}
	$msgin destroy
    }

    #no message returned, or blank returned do the same
    return

};#endof Addressable_request


#Addressable_asyncRegister - register callback for async events
#***Inputs***
#-Proc - callback procedure
#[-TypeDef] - typeDef used to parse msg data, Msg = return the Msg
#[-MsgType] - MsgType
#[-EvtGroup] - event group
#***Switches****
#[-Unregistered] - sets callback for unregistered events
Addressable method asyncRegister {args} {

    $this public callback

    if ![info exists callback] {
	#make a callback object, if one doesn't exist for this object
	set callback [EvtCallback new -init [list -Addressable $this]]
	$callback set typeDefRegistry [$this Class set typeDefRegistry]
    }

    eval $callback register $args

    return
};#endof Addressable_asyncRegister



#Addressable_asyncCancel - cancel async callback
#***Inputs****
#-Proc - callback to cancel
#[-MsgType] - Type to cancel (defaults to Std_EvtDetected)
#[-EvtGroup] - eventGroup to cancel (defaults to 0)
#[-Obj] - object that proc refers to
Addressable method asyncCancel {args} {
    $this public callback

    eval $callback cancel $args
    return
};#endof Addressable_asyncCancel



#Addressable_asyncWait - wait for a async msg or event to arive
#****Inputs*****
#[-MsgType] - Type to cancel (defaults to Std_EvtDetected)
#[-EvtGroup] - eventGroup to cancel (defaults to 0)
#[-TypeDef] - typeDef used to parse msg data, Msg = return the Msg
#[-Timeout] - timeout in miliseconds to wait, defaults to forever
#****Outputs***
#msg data if it is returned before timeout
#****Exceptions****
#TIMEOUT - msg or event not received before timeout
Addressable method asyncWait {args} {
    array set check [CheckParms -Proc Addressable_asyncWait -Provided $args \
		       	 -Optional {-MsgType -EvtGroup -Timeout -TypeDef}]

    array set parms $check(Flags)

    $this public callback

    if ![info exists callback] {
	#make a callback object, if one doesn't exist for this object
	set callback [EvtCallback new -init [list -Addressable $this]]
	$callback set typeDefRegistry [$this Class set typeDefRegistry]
    }

    set temp [[EvtCallback set AsyncWait] new -init [list -EvtCallback $callback]]
    
    if ![catch {set timeout $parms(-Timeout)}] {
	unset parms(-Timeout)
    }

    eval $temp enable [array get parms]

    if [catch {
	if [info exists timeout] {
	    set data [$temp wait -Timeout $timeout]
	} else {
	    set data [$temp wait]
	}
    } result] {
	#timeout
	catch {$temp destroy}
	error $result
    }
    
    $temp destroy
    return $data
};#endof Addressable_asyncWait

Addressable method getNewAsyncWait {args} {
    array set check [CheckParms -Proc Addressable_getNewAsyncWait -Provided $args \
		       	 -Optional {-MsgType -EvtGroup -TypeDef}]

    set parms $check(Flags)
    $this public callback

    if ![info exists callback] {
	#make a callback object, if one doesn't exist for this object
	set callback [EvtCallback new -init [list -Addressable $this]]
	$callback set typeDefRegistry [$this Class set typeDefRegistry]
    }

    set temp [[EvtCallback set AsyncWait] new -init [list -EvtCallback $callback]]

    if [catch {
	eval $temp enable $parms
    } result] {
	catch {$temp destroy}
	error $result
    }
    
    return $temp

};#endof Addressable_getNewAsyncWait


#***Addressable_TypeDefs*****
#this object is a database of typedefs which can be automatically recognized by
#the an Addressable object

catch {TypeDefRegistry new -Name Addressable_TypeDefs}

#none are defined at this time

