# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#The Cluster class doesn't directly send any messages, instead it calls methods on the Resource and Cluster Managers

#don't source the script more then once
if [info exists Cluster] {
    return
}

#this line helps the auto loader find this class
proc Cluster {} {}



catch {AddressableClass new -Name Cluster -init {-Extends Addressable}}

Cluster set typeDefRegistry Cluster_TypeDefs



#Error code descriptions
set QS_ErrorCode_Descriptions($QCLUST_ErrDesc) {QCLUST_ErrDesc: Bad comp/cluster descriptor}
set QS_ErrorCode_Descriptions($QCLUST_ErrPortId) {QCLUST_ErrPortId: Bad Port Id}
set QS_ErrorCode_Descriptions($QCLUST_ErrDesc1) {QCLUST_ErrDesc1: Bad descriptor 1}
set QS_ErrorCode_Descriptions($QCLUST_ErrPortId1) {QCLUST_ErrPortId1: Bad Port Id 1}
set QS_ErrorCode_Descriptions($QCLUST_ErrDesc2) {QCLUST_ErrDesc2: Bad descriptor 2}
set QS_ErrorCode_Descriptions($QCLUST_ErrPortId2) {QCLUST_ErrPortId2: Bad Port Id 2}
set QS_ErrorCode_Descriptions($QCLUST_ErrPortNotFound) {QCLUST_ErrPortNotFound: No matching port found}
set QS_ErrorCode_Descriptions($QCLUST_ErrClusterNotFound) {QCLUST_ErrClusterNotFound: Cluster does not exist or cannot be found}
set QS_ErrorCode_Descriptions($QCLUST_ErrRemote) {QCLUST_ErrRemote: Descriptor corresponds to a remote address, i.e. off-board or off-node address}
set QS_ErrorCode_Descriptions($QCLUST_ErrNotBound) {QCLUST_ErrNotBound: }
set QS_ErrorCode_Descriptions($QCLUST_ErrAssigned) {QCLUST_ErrAssigned: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNotAssigned) {QCLUST_ErrNotAssigned: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNoConnection) {QCLUST_ErrNoConnection: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNoPath) {QCLUST_ErrNoPath: }
set QS_ErrorCode_Descriptions($QCLUST_ErrActive) {QCLUST_ErrActive: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNotActive) {QCLUST_ErrNotActive: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNotSuspended) {QCLUST_ErrNotSuspended: }
set QS_ErrorCode_Descriptions($QCLUST_ErrReject) {QCLUST_ErrReject: }
set QS_ErrorCode_Descriptions($QCLUST_ErrUnknownMsg) {QCLUST_ErrUnknownMsg: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNoMem) {QCLUST_ErrNoMem: }
set QS_ErrorCode_Descriptions($QCLUST_ErrAttrPortType) {QCLUST_ErrAttrPortType: }
set QS_ErrorCode_Descriptions($QCLUST_ErrAttrPortDir) {QCLUST_ErrAttrPortDir: }
set QS_ErrorCode_Descriptions($QCLUST_ErrAttrPortCount) {QCLUST_ErrAttrPortCount: }
set QS_ErrorCode_Descriptions($QCLUST_ErrExpired) {QCLUST_ErrExpired: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNullArgument) {QCLUST_ErrNullArgument: }
set QS_ErrorCode_Descriptions($QCLUST_ErrCompNotFound) {Component not found in Cluster}
set QS_ErrorCode_Descriptions($QCLUST_ErrAttribute) {QCLUST_ErrAttribute: }
set QS_ErrorCode_Descriptions($QCLUST_ErrAttrListSize) {QCLUST_ErrAttrListSize: }
set QS_ErrorCode_Descriptions($QCLUST_ErrSlotId) {QCLUST_ErrSlotId: }
set QS_ErrorCode_Descriptions($QCLUST_ErrSlotWidth) {QCLUST_ErrSlotWidth: }
set QS_ErrorCode_Descriptions($QCLUST_ErrSlotGroup) {QCLUST_ErrSlotGroup: }
set QS_ErrorCode_Descriptions($QCLUST_ErrFatal) {QCLUST_ErrFatal: }
set QS_ErrorCode_Descriptions($QCLUST_ErrInstNotAllocated) {QCLUST_ErrInstNotAllocated: }
set QS_ErrorCode_Descriptions($QCLUST_ErrClusterNotAllocated) {QCLUST_ErrClusterNotAllocated: }
set QS_ErrorCode_Descriptions($QCLUST_ErrAttrNotPresent) {QCLUST_ErrAttrNotPresent: }
set QS_ErrorCode_Descriptions($QCLUST_ErrExhausted) {QCLUST_ErrExhausted: }
set QS_ErrorCode_Descriptions($QCLUST_ErrAttrListFull) {QCLUST_ErrAttrListFull: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNotAnAllocator) {QCLUST_ErrNotAnAllocator: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNotAnOwner) {QCLUST_ErrNotAnOwner: }
set QS_ErrorCode_Descriptions($QCLUST_ErrDestroyPending) {QCLUST_ErrDestroyPending: }
set QS_ErrorCode_Descriptions($QCLUST_ErrCannotCmpltSync) {QCLUST_ErrCannotCmpltSync: }
set QS_ErrorCode_Descriptions($QCLUST_ErrFreePending) {QCLUST_ErrFreePending: }
set QS_ErrorCode_Descriptions($QCLUST_ErrMax) {QCLUST_ErrMax: }
set QS_ErrorCode_Descriptions($QCLUST_ErrSyncCallOnSp) {QCLUST_ErrSyncCallOnSp: }
set QS_ErrorCode_Descriptions($QCLUST_ErrWrongStdComponent) {QCLUST_ErrWrongStdComponent: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNoSlots1) {QCLUST_ErrNoSlots1: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNoSlots2) {QCLUST_ErrNoSlots2: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNoSlots3) {QCLUST_ErrNoSlots3: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNoSlots4) {QCLUST_ErrNoSlots4: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNoSlots5) {QCLUST_ErrNoSlots5: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNoSlots6) {QCLUST_ErrNoSlots6: }
set QS_ErrorCode_Descriptions($QCLUST_ErrNoSlots7) {QCLUST_ErrNoSlots7: }


#Cluster_init
#**Inputs***
#-TgtDesc - address to work on
#[-MsgQueue] - queue to send messages on, if not specified a new one is created
Cluster method init {args} {

    array set check [CheckParms -Proc Cluster_init -Provided $args \
			 -Required {-TgtDesc} -Optional {-MsgQueue}]

    array set parms $check(Flags)


    eval $this super init $check(Flags)


    $this public TgtDesc resourceMgr clusterMgr DestroyResourceOnDestroy MsgQueue

    #handle required arguments
    set TgtDesc $parms(-TgtDesc)
    
    array set desc $TgtDesc

    set resourceMgr [ResourceMgr new -init [list -BoardNum $desc(Board) -MsgQueue $MsgQueue]]
    set clusterMgr [ClusterMgr new -init [list -BoardNum $desc(Board) -MsgQueue $MsgQueue]]

    #if 1 then cluster resource will be destroyed on destroy of the object
    set DestroyResourceOnDestroy 0
    return
};#endof Cluster_init

Cluster method destroy {} {
    $this public resourceMgr clusterMgr DestroyResourceOnDestroy TgtDesc

    if {$DestroyResourceOnDestroy == 1} {
	$clusterMgr ClusterDestroy $TgtDesc
    }

    if [info exists resourceMgr] {
	$resourceMgr destroy
    }
    if [info exists clusterMgr] {
	$clusterMgr destroy
    }

    $this super destroy
    return
}

#Cluster_MsgQueueAttach - switch which MsgQueue is being used
Cluster method MsgQueueAttach {newMsgQueue} {
    $this super MsgQueueAttach $newMsgQueue

    $this public resourceMgr clusterMgr

    #reattach the msgqueues of the embeded object
    if [info exists resourceMgr] {
	$resoruceMgr MsgQueueAttach $newMsgQueue
    }

    if [info exists clusterMgr] {
	$clusterMgr MsgQueueAttach $newMsgQueue
    }

    return

};#endof Addressable_MsgQueueAttach

# Build a binary port definition attribute value
#this is a port of the C macro in qkernel/mercdefs.h
Cluster method DefinePortId {args} {
    array set check [CheckParms -Proc Cluster_DefinePort -Provided $args \
			 -Optional {-UserType -PortType -Direction -Instance} ]

    array set parms $check(Flags)
    global QTS_TYPE_ANY QTS_DIR_ANY

    if [catch {set userType $parms(-UserType)} result] {
	set userType 0
    }

    if [catch {set portType $parms(-PortType)} result] {
	set portType $QTS_TYPE_ANY
    }

    if [catch {set direction $parms(-Direction)} result] {
	set direction $QTS_DIR_ANY
    }

    if [catch {set instance $parms(-Instance)} result] {
	set instance 0xff
    }

    set portId [expr (($userType & 0xff) << 16) | ($direction << 14) | ($portType << 8) | ($instance & 0xff) ]

    return [format "0x%x" $portId]
}

# read a binary port definition attribute value
Cluster method ReadDefinedPortId {args} {
    array set check [CheckParms -Proc Cluster_ReadDefinedPort -Provided $args \
			 -Required {-portId} ]

    array set parms $check(Flags)

    set portId $parms(-portId)

    set portDef(Instance) [format "0x%x" [expr $portId & 0xff]]
    set portDef(PortType) [format "0x%x" [expr ($portId >> 8) & 0x3f]]
    set portDef(Direction) [format "0x%x" [expr ($portId >> 14) & 0x3]]
    set portDef(UserType) [format "0x%x" [expr ($portId >> 16) & 0xff]]

    return [array get portDef]	  
}

#Cluster_FindInst
#***Inputs***
#[-InstClass] - Class of object to create, defaults to Instance
#[-CompType] - instance type to search for, unneded if -InstClass was supplied
#[-Attrs] - attributes to use to find
#[-Init] -  Init parameters for instance
#***Switches****
#-AutoAllocate - if inst not found try to allocate
#***Exceptions***
#QCLUST_ErrCompNotFound
Cluster method find {args} {
    array set check [CheckParms -Proc Cluster_FindInst -Provided $args \
			 -Optional {-Attrs -InstClass -CompType -Init} \
			 -Switches {-AutoAllocate}]

    array set parms $check(Flags)

    set comptype 0
    #required arguments
    
    #optional arguments
    if [catch {set attrs $parms(-Attrs)} result] {
	set attrs {}
    }

    if [catch {set instclass $parms(-InstClass)} result] {
	set instclass Instance
    }

    #handle switches
    if {[lsearch $check(Switches) "-AutoAllocate"]==-1} {
	set autoAllocate 0
    } else {
	set autoAllocate 1
    }
	
    #get comptype from the provided class
    set comptype [$instclass set ComponentType]

    #override comptype if given
    catch {set comptype $parms(-CompType)}

    if {$comptype} {
	#append comptype to attr search
	global Std_ComponentType
	lappend attrs [list -key $Std_ComponentType \
			   -value $comptype]
    }


    $this public MsgQueue TgtDesc clusterMgr
			      

    #fill in request data
    set req [list \
		 -CompType $comptype \
		 -Count [llength $attrs] \
		 -Attrs $attrs \
		]


    #issue the request to the cluster maanger


    if [catch {
	array set retval [eval $clusterMgr ClusterFindInst -ClustDesc [list $TgtDesc] $req]
    } result] {
	if {$autoAllocate == 1} {
	    #not found try to allocate
	    #call allocate with same arguments that were provided here
	    if [info exists parms(-Init)] {
	    	return [$this allocateInst -InstClass $instclass -Attrs $attrs -Init $parms(-Init)]
	    } else {
	    	return [$this allocateInst -InstClass $instclass -Attrs $attrs]
	    }
	}
	error $result
    }
    
    # Check for instance initialization options to use for allocate
    # or for inst new method
    if {![info exists parms(-Init)]} {
	# No parms - set an empty list for "new" method
	set parms(-Init) {}
    }

    #returned with descriptor of Component
    #create new instance for this Component
    $instclass new -init [concat [list -MsgQueue $MsgQueue -TgtDesc $retval(desc)] $parms(-Init)]

};#Cluster_FindInst

#Cluster_free - free this cluster
Cluster method free {} {
    
    $this public TgtDesc MsgQueue clusterMgr

    return [$clusterMgr free -Cluster $this]
};#endof Cluster_free


#Cluster_AllocateInst - allocate an instance into this cluster
#***Inputs***
#[-InstClass] - class to create for found components, defaults to Instance
#[-CompType] - Component type to allocate, unneded if InstClass specified
#[-Attrs] - attribute list {{-key # -value #}...}
Cluster method allocateInst {args} {
    
    $this public resourceMgr
   
    set inst [eval $resourceMgr allocate -Cluster $this $args]

    return $inst
    
};#endof Cluster_AllocateInst


#Cluster_FreeInst - frees an instance from this cluster
#***Inputs***
#[-Instance] - object instnace to free
Cluster method freeInst {args} {
    
    $this public TgtDesc MsgQueue resourceMgr

    
    set inst [eval $resourceMgr free $args]
    return $inst
    
};#endof Cluster_FreeInst


#Cluster_Activate
#***Inputs***
#-portId
#-talker
#[-options]
Cluster method Activate {args} {
    array set check [CheckParms -Proc Cluster_Activate -Provided $args \
			 -Required {-portId} -Optional {-talker -options}]

    #default values
    array set parms [list -options 0]

    array set parms $check(Flags)

    global QResultComplete QClusterActivate QS_Nil_CompDesc
 
    #get the descriptor from the talker
    
    if [catch {set parms(-talkerDesc) [$parms(-talker) set TgtDesc]} result] {
	set parms(-talkerDesc) $QS_Nil_CompDesc
    } else {
	unset parms(-talker)
    }

    

    $this public TgtDesc


    set parms(-ClustDesc) $TgtDesc



    set msgtype $QClusterActivate
    #setup typedefs
    set typedef [Cluster_TypeDefs lookup -MsgType $msgtype]

    array set tdata {}
    array set tdata [array get parms]

    set data {}
    #remove leading dashes
    foreach elm [array names tdata] {
	lappend data [string range $elm 1 end]
	lappend data $tdata($elm)
    }


    #issue request
    $this request -Type $msgtype -TypeDef $typedef -Data $data -RetType $QResultComplete -RetTypeDef {} -IgnoreSource
    

    return
};#endof Cluster_Activate



#Cluster_Connect
#***Inputs***
#-portId1 - port on Inst1 to connect
#-portId2 - port on Inst2 to connect
Cluster method Connect {args} {
    array set check [CheckParms -Proc Cluster_Connect -Provided $args \
			 -Required {-portId1 -portId2} -Optional {-Inst1 -Inst2}]

    array set parms $check(Flags)
 
    #get the descriptor and stuff

    $this public TgtDesc

    if ![info exists parms(-Inst1)] {
	set parms(-Inst1) $this
    }
    if ![info exists parms(-Inst2)] {
	set parms(-Inst2) $this
    }
    

    set parms(-InstDesc1) [$parms(-Inst1) set TgtDesc]
    set parms(-InstDesc2) [$parms(-Inst2) set TgtDesc]
	
    unset parms(-Inst1)
    unset parms(-Inst2)


    global QResultComplete QClusterConnect
    set msgtype $QClusterConnect
    #setup typedefs
    set typedef [Cluster_TypeDefs lookup -MsgType $msgtype]

    array set tdata {}
    array set tdata [array get parms]

    set data {}
    #remove leading dashes
    foreach elm [array names tdata] {
	lappend data [string range $elm 1 end]
	lappend data $tdata($elm)
    }


    #issue request
    $this request -Type $msgtype -TypeDef $typedef -Data $data -RetType $QResultComplete -RetTypeDef {} -IgnoreSource
 

    return    
};#endof Cluster_Connect




#Cluster_Deactivate
#***Inputs***
#-portId
Cluster method Deactivate {args} {
    array set check [CheckParms -Proc Cluster_Deactivate -Provided $args \
			 -Required {-portId}]

    array set parms $check(Flags)

 
    $this public TgtDesc


    set parms(-ClustDesc) $TgtDesc


    global QResultComplete QClusterDeactivate
    set msgtype $QClusterDeactivate
    #setup typedefs
    set typedef [Cluster_TypeDefs lookup -MsgType $msgtype]

    array set tdata {}
    array set tdata [array get parms]

    set data {}
    #remove leading dashes
    foreach elm [array names tdata] {
	lappend data [string range $elm 1 end]
	lappend data $tdata($elm)
    }


    #issue request
    $this request -Type $msgtype -TypeDef $typedef -Data $data -RetType $QResultComplete -RetTypeDef {} -IgnoreSource
    
    return
};#endof Cluster_Deactivate



#Cluster_Disconnect
#***Inputs***
#-portId1 - port on Inst1 to disconnect
#-portId2 - port on Inst2 to disconnect
Cluster method Disconnect {args} {
    array set check [CheckParms -Proc Cluster_Disconnect -Provided $args \
			 -Required {-portId1 -portId2} -Optional {-Inst1 -Inst2}]

    array set parms $check(Flags)
 
    #get the descriptor and stuff

    $this public TgtDesc
    if ![info exists parms(-Inst1)] {
	set parms(-Inst1) $this
    }
    if ![info exists parms(-Inst2)] {
	set parms(-Inst2) $this
    }
    

    set parms(-InstDesc1) [$parms(-Inst1) set TgtDesc]
    set parms(-InstDesc2) [$parms(-Inst2) set TgtDesc]
	
    unset parms(-Inst1)
    unset parms(-Inst2)


    global QResultComplete QClusterDisconnect
    set msgtype $QClusterDisconnect
    #setup typedefs
    set typedef [Cluster_TypeDefs lookup -MsgType $msgtype]

    array set tdata {}
    array set tdata [array get parms]

    set data {}
    #remove leading dashes
    foreach elm [array names tdata] {
	lappend data [string range $elm 1 end]
	lappend data $tdata($elm)
    }


    #issue request
    $this request -Type $msgtype -TypeDef $typedef -Data $data -RetType $QResultComplete -RetTypeDef {} -IgnoreSource
 
    return    
};#endof Cluster_Disconnect

#Cluster_TSAssign
#***Inputs***
#-portId 
#[-encoding]
#[-idlePattern]
#-slotIds - a list of slot ids 
Cluster method TSAssign {args} {
    array set check [CheckParms -Proc Cluster_TSAssign -Provided $args \
			 -Required {-portId -slotIds} -Optional {-encoding -idlePattern}]

    global QSCBUS_ENCODING_MULAW QSCBUS_IDLE_MULAW
    #defaults
    array set parms [list -encoding $QSCBUS_ENCODING_MULAW -idlePattern $QSCBUS_IDLE_MULAW]

    array set parms $check(Flags)
    


    $this public TgtDesc


    set parms(-ClustDesc) $TgtDesc


    global QResultComplete QClusterSlotAssign
    set msgtype $QClusterSlotAssign
    #setup typedefs
    set typedef [Cluster_TypeDefs lookup -MsgType $msgtype]

    array set tdata {}
    array set tdata [array get parms]

    set data {}
    #remove leading dashes
    foreach elm [array names tdata] {
	lappend data [string range $elm 1 end]
	lappend data $tdata($elm)
    }

    #issue request
    $this request -Type $msgtype -TypeDef $typedef -Data $data -RetType $QResultComplete -RetTypeDef {} -IgnoreSource
 
    return
};#endof Cluster_TSAssign


#Cluster_TSUnassign
#***Inputs***
#-portId 
Cluster method TSUnassign {args} {
    array set check [CheckParms -Proc Cluster_TSUnassign -Provided $args \
			 -Required {-portId}]

    
    array set parms $check(Flags)


    $this public TgtDesc


    set parms(-ClustDesc) $TgtDesc


    global QResultComplete QClusterSlotUnassign
    set msgtype $QClusterSlotUnassign
    #setup typedefs
    set typedef [Cluster_TypeDefs lookup -MsgType $msgtype]

    array set tdata {}
    array set tdata [array get parms]

    set data {}
    #remove leading dashes
    foreach elm [array names tdata] {
	lappend data [string range $elm 1 end]
	lappend data $tdata($elm)
    }

    #issue request
    $this request -Type $msgtype -TypeDef $typedef -Data $data -RetType $QResultComplete -RetTypeDef {} -IgnoreSource
 
    return
};#endof Cluster_TSUnassign



#Cluster_TSInfo
#***Inputs***
#-portId 
Cluster method TSInfo {args} {
    array set check [CheckParms -Proc Cluster_TSInfo -Provided $args \
			 -Required {-portId}]

    
    array set parms $check(Flags)



    $this public TgtDesc


    set parms(-ClustDesc) $TgtDesc


    global QResultComplete QClusterSlotInfo QClusterSlotInfoResult
    set msgtype $QClusterSlotInfo
    set retmsgtype $QClusterSlotInfoResult
    #setup typedefs
    set typedef [Cluster_TypeDefs lookup -MsgType $msgtype]
    set rettypedef [Cluster_TypeDefs lookup -MsgType $retmsgtype]

    array set tdata {}
    array set tdata [array get parms]

    set data {}
    #remove leading dashes
    foreach elm [array names tdata] {
	lappend data [string range $elm 1 end]
	lappend data $tdata($elm)
    }

    #issue request
    return [$this request -Type $msgtype -TypeDef $typedef -Data $data -RetType $retmsgtype -RetTypeDef $rettypedef -IgnoreSource]
 
};#endof Cluster_TSInfo

#Cluster_CompInfo
# Description: Finds all of the instances in a cluster
#***Inputs***
# None.
Cluster method CompInfo {} {
    
    $this public TgtDesc

    set parms(-ClustDesc) $TgtDesc

    global QClusterCompInfoResult QClusterCompInfo
    set msgtype $QClusterCompInfo
    set retmsgtype $QClusterCompInfoResult
    #setup typedefs
    set typedef [Cluster_TypeDefs lookup -MsgType $msgtype]
    set rettypedef [Cluster_TypeDefs lookup -MsgType $retmsgtype]

    array set tdata {}
    array set tdata [array get parms]

    set data {}
    #remove leading dashes
    foreach elm [array names tdata] {
	   lappend data [string range $elm 1 end]
	   lappend data $tdata($elm)
    }

    #issue request
    return [$this request -Type $msgtype -TypeDef $typedef -Data $data -RetType $retmsgtype -RetTypeDef $rettypedef -IgnoreSource]
 
};#endof Cluster_CompInfo

# Allow the cluster instance address to be changed
Cluster method SetInstance { newInstance } {
    
	$this public TgtDesc

	array set desc $TgtDesc

	set desc(Instance) $newInstance

	set TgtDesc [array get desc]

};#endof Cluster_SetInstance




#***Cluster_TypeDefs*****
#this object is a database of typedefs which can be automatically recognized by
#the an Cluster object, it also recognizes all types specified in Addressable_TypeDefs


TypeDefRegistry new -Name Cluster_TypeDefs \
    -init [list -Extends [[Cluster set Extends] set typeDefRegistry]]


Cluster_TypeDefs define -MsgType QClusterAttrAdd \
    -TypeDef [list \
		  Count $QClusterAttrAdd_count \
		  Attrs [list -Count Count -DataType $QCompAttr] \
		 ]

Cluster_TypeDefs define -MsgType QClusterAttrRemove \
    -TypeDef [list \
		  Count $QClusterAttrRemove_count \
		  Attrs [list -Count Count -DataType $QCompAttr] \
		 ]

Cluster_TypeDefs define -MsgType QClusterLock \
    -TypeDef {}

Cluster_TypeDefs define -MsgType QClusterUnlock \
    -TypeDef {}

Cluster_TypeDefs define -MsgType QClusterUnlockCmplt \
    -TypeDef [list \
		  unlocked $QClusterUnlockCmplt_clusterUnlocked \
		  count $QClusterUnlockCmplt_count \
		  unlockedList [list -Count count -DataType $QCompDesc] \
		 ]			  

Cluster_TypeDefs define -MsgType QClusterActivate \
    -TypeDef [list \
		  ClustDesc $QS_CompDesc \
		  portId $QPortDef \
		  options $QClusterActivate_options \
		  talkerDesc $QS_CompDesc \
		 ]


Cluster_TypeDefs define -MsgType QClusterConnect \
    -TypeDef [list \
		  InstDesc1 $QS_CompDesc \
		  portId1 $QPortDef \
		  InstDesc2 $QS_CompDesc \
		  portId2 $QPortDef \
		 ]


Cluster_TypeDefs define -MsgType QClusterDeactivate \
    -TypeDef [list \
		  ClustDesc $QS_CompDesc \
		  portId $QPortDef \
		 ]


Cluster_TypeDefs define -MsgType QClusterDisconnect \
    -TypeDef [list \
		  InstDesc1 $QS_CompDesc \
		  portId1 $QPortDef \
		  InstDesc2 $QS_CompDesc \
		  portId2 $QPortDef \
		 ]


Cluster_TypeDefs define -MsgType QClusterSlotAssign \
    -TypeDef [list \
		  ClustDesc $QS_CompDesc \
		  portId $QPortDef \
		  width $QS_Uint8 \
		  encoding $QS_Uint8 \
		  idlePattern $QS_Uint8 \
		  slotIds [list -DataType $QT_UINT16 -Count width] \
		 ]

Cluster_TypeDefs define -MsgType QClusterSlotUnassign \
    -TypeDef [list \
		  ClustDesc $QS_CompDesc \
		  portId $QPortDef \
		 ]

Cluster_TypeDefs define -MsgType QClusterSlotInfo \
    -TypeDef [list \
		  ClustDesc $QS_CompDesc \
		  portId $QPortDef \
		 ]

Cluster_TypeDefs define -MsgType QClusterSlotInfoResult \
    -TypeDef [list \
		  ClustDesc $QS_CompDesc \
		  portId $QPortDef \
		  width $QS_Uint8 \
		  encoding $QS_Uint8 \
		  idlePattern $QS_Uint8 \
		  slotIds [list -DataType $QT_UINT16 -Count width] \
		 ]

Cluster_TypeDefs define -MsgType QResultComplete \
    -TypeDef {}

Cluster_TypeDefs define -MsgType QClusterCompInfo \
    -TypeDef [list \
		  ClustDesc $QS_CompDesc \
		 ]

Cluster_TypeDefs define -MsgType QClusterCompInfoResult \
    -TypeDef [list \
		  ClustDesc $QS_CompDesc \
		  count $QClusterCompInfoResult_count \
		  instances [list -DataType $QCompDesc -Count count] \
		 ]


#auto method defintions

Cluster defineMsgMethod -MethodName AttrAdd \
    -Type $QClusterAttrAdd -TypeDef lookup -Defaults {-Count {}} \
    -RetType $QResultComplete -RetTypeDef lookup

Cluster defineMsgMethod -MethodName AttrRemove \
    -Type $QClusterAttrRemove -TypeDef lookup -Defaults {-Count {}} \
    -RetType $QResultComplete -RetTypeDef lookup


Cluster defineMsgMethod -MethodName Lock \
    -Type $QClusterLock -TypeDef lookup \
    -RetType $QResultComplete -RetTypeDef lookup

Cluster defineMsgMethod -MethodName Unlock \
    -Type $QClusterUnlock -TypeDef lookup -RetType $QClusterUnlockCmplt \
    -RetTypeDef lookup





#Some convenient defines for TSAssign  to use in PortID argument.
set QSCBUS_PORT_IN [Cluster_DefinePortId {} -PortType $QTS_TYPE_SCBUS -Direction $QTS_DIR_IN -Instance 1]
set QSCBUS_PORT_OUT [Cluster_DefinePortId {} -PortType $QTS_TYPE_SCBUS -Direction $QTS_DIR_OUT -Instance 1]


