# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#Instance Class - base class for all Instances

#don't source the script more then once
if [info exists Instance] {
    return
}


#this line helps the auto loader find this class
proc Instance {} {}


catch {AddressableClass new -Name Instance -init {-Extends StdResource}}



Instance method init {args} {

    $this public CancelAllEvtsOnDestroy unuseOnDestroy compUse

    if {[lsearch -exact $args "-NoCancel"]==-1} {
        set CancelAllEvtsOnDestroy 1
    } else {
    	set CancelAllEvtsOnDestroy 0
    }

    if {[lsearch -exact $args "-NoUse"]==-1} {
        set compUse 1
    } else {
    	set compUse 0
    }


    # Invoke parent class init method
    eval $this super init $args

    if {$compUse == 1} {
    	if {[lsearch -exact $args "-NoUnuseOnDestroy"]==-1} {
    	    set unuseOnDestroy 1
	} else {
    	    set unuseOnDestroy 0
	}

	# Enable exit notification for instance
    	$this use
#	puts stdout "$this used"
#	puts stdout "$this exit notification enabled"
    } else {
	# Disable exit notification
    	set unuseOnDestroy 0
#	puts stdout "$this exit notification disabled"
    }

    return
};#enof Instance_init


Instance method destroy {} {
    $this public MsgQueue unuseOnDestroy CancelAllEvtsOnDestroy compUse

    if {$CancelAllEvtsOnDestroy == 1} {
	catch {$this CancelAllEvts}
    }

    if {[info exists MsgQueue] && ($compUse == 1) && ($unuseOnDestroy == 1)} {
#	puts stdout "$this unused"
	$this unuse
    }

    $this super destroy
};#endof Instance_destroy


#Instance_MsgQueueAttach - attaches to a MsgQueue, performs use/unuse
#***Inputs***
#MsgQueue - the message queue to attach to
Instance method MsgQueueAttach {newMsgQueue} {

    $this public MsgQueue compUse

    if [info exists MsgQueue] {
	if {$compUse == 1} {
	    $this unuse
#	    puts stdout "$this (msgqueue) unuse"
	}

        $this super MsgQueueAttach $newMsgQueue

	    if {$compUse == 1} {
		$this use
#		puts stdout "$this (msgqueue) used"
	    }
    } else {
    	$this super MsgQueueAttach $newMsgQueue
    }

};#endof Instance_MsgQueueAttach

