# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if [info exists Player] {
    return
}

source ${qscript_library}/playdefs.qs
source ${qscript_library}/coders.qs
unset Player

#this line helps the auto loader find this class
proc Player {} {}
catch {AddressableClass new -Name Player -init {-Extends Instance}}
Player set ComponentType $Player_Std_ComponentType
Player set typeDefRegistry Player_TypeDefs
Player method StopPlay Player_Stop ;#this maps to the method defined by defineMsgMethod
Player method init {args} {
    eval $this super init $args
    $this public CancelAllEvtsOnDestroy
    #the player resource doesn't support or send an error for CancelAllEvts
    #it would then have to wait to timeout
    set CancelAllEvtsOnDestroy 0
    global Player_MsgStopped
    $this asyncRegister -MsgType $Player_MsgStopped -Obj $this -Proc cleanup
    return
}

#StartPlay
#***Inputs****
#-FileName - file to play, (note: if @name will get audio from a audio server 
#            on machine specified by name, name may be hostname or ip address
#            if @name:port name will be remote machine port will specify the port
#            this can also be a list of files to play in a concatinated format
#***Switches***
#-Block - block until play finishes
Player method StartPlay {args} {
    array set check [CheckParms -Proc "Player_StartPlay" -Provided $args \
			 -Required {-FileName} -Optional {-Decoding -StartMode} \
			 -Switches {-Block}]
    array set parms $check(Flags)
    set files $parms(-FileName)
    set block 1
    if {[lsearch -exact $check(Switches) "-Block"]==-1} {
	set block 0
    }
    $this public myStreamer

    #if we're currently streaming, throw an error
    if [info exists myStreamer] {
		QS_Error -Error PlayerInUse
    }

    #create streams
    set input_streams {}
    foreach filename $files {
	if {[string range $filename 0 0] == "@"} {
	    #get data from socket
	    set hostname [string range $filename 1 end]
	    set portindex [string first ":" $hostname]
	    if {$portindex == -1} {
		#audio server
		set myInputStream [AudioInputStream new -init [list -Address $hostname]]
	    } else {
		#raw socket		
		set port [string range $hostname [expr $portindex + 1] end]
		set hostname [string range $hostname 0 [expr $portindex - 1]]
		set myInputStream [SocketInputStream new -init [list -Address $hostname \
								    -Port $port -Raw]]
	    }
	} else {
	    #get data from file
	    set myInputStream [FileInputStream new -init [list -FileName $filename]]
	}
	lappend input_streams $myInputStream
    }
    set myInputStream [ConcatInputStream new -init [list -InputStreams $input_streams]]
    set myOutputStream [BlockOutputStream new -init [list -Target $this]]

    #create streamer
    set myStreamer [Streamer new -init [list -Input $myInputStream \
					    -Output $myOutputStream]]
    $myStreamer registerCallback -Obj $this -Proc cleanup
    if [catch {
	$myStreamer Start
	#remove invalid parms for Start method
	unset parms(-FileName)
	#issue player start command
	eval $this Start -StreamId [$myOutputStream GetStreamId] [array get parms] 
    } result] {
	#error in playing file
	#cancel the cleanup
	#after cancel $cleanup
	$myStreamer destroy
	$this unset myStreamer
	error $result
    }

    if {$block == 1} {
	$this WaitPlay
    }

    return
}

#cleans up a streamer stuff
Player method cleanup {args} {
    $this public myStreamer
    if [info exists myStreamer] {
	$myStreamer destroy
	$this unset myStreamer
    }
}

#WaitPlay - wait for the play to finish which was started with StartPlay
Player method WaitPlay {} {
    global Player_MsgStopped
    $this asyncWait -MsgType $Player_MsgStopped
    return
}

#***PLAYER_TypeDefs*****
#this object is a database of typedefs which can be automatically recognized by
#the an PLAYER object, it also recognizes all types specified in Addressable_TypeDefs
TypeDefRegistry new -Name Player_TypeDefs \
    -init [list -Extends [[Player set Extends] set typeDefRegistry]]
Player_TypeDefs define -MsgType Player_MsgStart \
    -TypeDef [list \
		  StreamId $Player_MsgStart_StreamID \
		  Decoding $Player_MsgStart_Decoding \
		  StartMode $Player_MsgStart_StartMode \
		  StartPos $Player_MsgStart_StartPos \
		  ]
Player_TypeDefs define -MsgType Player_MsgStopped \
    -TypeDef [list \
		  Reason $Player_MsgStopped_Reason \
		  RtcLabel $Player_MsgStopped_RtcLabel \
		  TimePlayed $Player_MsgStopped_TimePlayed \
		  BytesPlayed $Player_MsgStopped_BytesPlayed
		  ]
Player_TypeDefs define -MsgType Player_MsgAdjSpeed \
    -TypeDef [list \
		  SpeedMode $Player_MsgAdjSpeed_SpeedMode \
		  ]
Player_TypeDefs define -MsgType Player_MsgAdjSpeedCmplt \
    -TypeDef [list \
		  NewSpeed $Player_MsgAdjSpeedCmplt_NewSpeed \
		  ]
Player_TypeDefs define -MsgType Player_MsgAdjVolume \
    -TypeDef [list \
		  VolumeMode $Player_MsgAdjVolume_VolumeMode \
		  ]
Player_TypeDefs define -MsgType Player_MsgAdjVolumeCmplt \
    -TypeDef [list \
		  NewVolume $Player_MsgAdjVolumeCmplt_NewVolume \
		  ]
Player_TypeDefs define -MsgType Player_MsgSetSpeedAdjTable \
    -TypeDef [list \
		  SpeedTable $Player_MsgSetSpeedAdjTable_SpeedTable \
		  ]
Player_TypeDefs define -MsgType Player_MsgSetVolumeAdjTable \
    -TypeDef [list \
		  VolumeTable $Player_MsgSetVolumeAdjTable_VolumeTable \
		  ]
Player_TypeDefs define -MsgType Player_MsgGetSpeedAdjTableCmplt \
    -TypeDef [list \
		  SpeedTable $Player_MsgGetSpeedAdjTableCmplt_SpeedTable \
		  ]
Player_TypeDefs define -MsgType Player_MsgGetVolumeAdjTableCmplt \
    -TypeDef [list \
		  VolumeTable $Player_MsgGetVolumeAdjTableCmplt_VolumeTable \
		  ]
Player_TypeDefs define -MsgType Player_MsgPlayNextSegment \
    -TypeDef [list \
		  Decoding $Player_MsgPlayNextSegment_Decoding \
		  ]
Player_TypeDefs define -MsgType Player_MsgEndOfSegment \
    -TypeDef [list \
		  TimePlayed $Player_MsgEndOfSegment_TimePlayed \
		  BytesPlayed $Player_MsgEndOfSegment_BytesPlayed \
		  ]
Player_TypeDefs define -EvtGroup Player_Event_Type_EvtStopped \
    -TypeDef [list \
		  EvtGroup $Player_EvtStopped_Label \
		  Reason $Player_EvtStopped_Reason \
		  RtcLabel $Player_EvtStopped_RtcLabel \
		  TimePlayed $Player_EvtStopped_TimePlayed \
		  BytesPlayed $Player_EvtStopped_BytesPlayed \
		 ]
Player_TypeDefs define -EvtGroup Player_Event_Type_EvtSpeed \
    -TypeDef [list \
		  EvtGroup $Player_EvtSpeed_Label \
		  NewSpeed $Player_EvtSpeed_NewSpeed
		 ]
Player_TypeDefs define -EvtGroup Player_Event_Type_EvtVolume \
    -TypeDef [list \
		 NewVolume $Player_EvtVolume_NewVolume
		 ]
Player_TypeDefs define -EvtGroup Player_Event_Type_EvtStatus \
    -TypeDef [list \
		  EvtGroup $Player_EvtVolume_Label \
		  BytesPlayed $Player_EvtStatus_BytesPlayed
		 ]
Player defineMsgMethod -MethodName Start \
    -Type $Player_MsgStart -TypeDef lookup \
    -Defaults [list -Decoding $MULAW64D -StartMode $Player_MsgStart_StartMode_NORMAL \
		   -StartPos 0] \
    -RetType $Player_MsgStartCmplt
Player defineMsgMethod -MethodName Stop \
    -Type $Player_MsgStop
Player defineMsgMethod -MethodName Pause \
    -Type $Player_MsgPause \
    -RetType $Player_MsgPauseCmplt
Player defineMsgMethod -MethodName Resume \
    -Type $Player_MsgResume \
    -RetType $Player_MsgResumeCmplt
Player defineMsgMethod -MethodName AdjSpeed \
    -Type $Player_MsgAdjSpeed -TypeDef lookup \
    -RetType $Player_MsgAdjSpeedCmplt -RetTypeDef lookup
Player defineMsgMethod -MethodName AdjVolume \
    -Type $Player_MsgAdjVolume -TypeDef lookup \
    -RetType $Player_MsgAdjVolumeCmplt -RetTypeDef lookup
Player defineMsgMethod -MethodName SetSpeedAdjTable \
    -Type $Player_MsgSetSpeedAdjTable -TypeDef lookup \
    -RetType $Player_MsgSetSpeedAdjTableCmplt
Player defineMsgMethod -MethodName SetVolumeAdjTable \
    -Type $Player_MsgSetVolumeAdjTable -TypeDef lookup \
    -RetType $Player_MsgSetVolumeAdjTableCmplt
Player defineMsgMethod -MethodName GetSpeedAdjTable \
    -Type $Player_MsgGetSpeedAdjTable \
    -RetType $Player_MsgGetSpeedAdjTableCmplt -RetTypeDef lookup
Player defineMsgMethod -MethodName GetVolumeAdjTable \
    -Type $Player_MsgGetVolumeAdjTable \
    -RetType $Player_MsgGetVolumeAdjTableCmplt -RetTypeDef lookup
Player defineMsgMethod -MethodName PlayNextSegment \
    -Type $Player_MsgPlayNextSegment -TypeDef lookup \
    -Defaults [list -Decoding $MULAW64D] \
    -RetType $Player_MsgPlayNextSegmentCmplt
return

