# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if [info exists Recorder] {
    return
}

source ${qscript_library}/recdefs.qs
source ${qscript_library}/coders.qs
unset Recorder

#this line helps the auto loader find this class
proc Recorder {} {}
catch {AddressableClass new -Name Recorder -init {-Extends Instance}}
Recorder set ComponentType $Recorder_Std_ComponentType
Recorder set typeDefRegistry Recorder_TypeDefs
Recorder method StopRecord Recorder_Stop ;#this maps to the method defined by defineMsgMethod
Recorder method init {args} {
    eval $this super init $args
    global Recorder_MsgStopped
    $this asyncRegister -MsgType $Recorder_MsgStopped -TypeDef {} -Proc {}
    return
}

#StartRecord
#***Inputs****
#-FileName - file to Record, (note: if @name will get audio from a audio server on machine
#            specified by name, name may be hostname or ip address
#            if @name:port name will be remote machine port will specify the port
#***Switches***
#-Block - block until Record finishes
Recorder method StartRecord {args} {
    array set check [CheckParms -Proc "Recorder_StartRecord" -Provided $args \
			 -Required {-FileName} -Optional {-Encoding -StartMode} \
			 -Switches {-Block}]
    array set parms $check(Flags)
    set filename $parms(-FileName)
    set block 1
    if {[lsearch -exact $check(Switches) "-Block"]==-1} {
	set block 0
    }
    $this public myInputStream myOutputStream myStreamer

    #if we're currently streaming, stop,wait then continue
    if [info exists myStreamer] {
	QS_Error -Error RecorderInUse
    }

    #create streams
    if {[string range $filename 0 0] == "@"} {
	#get data from socket
	set hostname [string range $filename 1 end]
	set portindex [string first ":" $hostname]
	if {$portindex == -1} {
	    #audio server
	    set myOutputStream [AudioOutputStream new -init [list -Address $hostname]]
	} else {
	    #raw socket	    
	    set port [string range $hostname [expr $portindex + 1] end]
	    set hostname [string range $hostname 0 [expr $portindex - 1]]
	    set myOutputStream [SocketOutputStream new -init [list -Address $hostname \
								-Port $port -Raw]]
	}
    } else {
	#get data from file
	set myOutputStream [FileOutputStream new -init [list -FileName $filename]]
    }

    set myInputStream [BlockInputStream new -init [list -Source $this]]

    #create streamer
    set myStreamer [Streamer new -init [list -Input $myInputStream \
					    -Output $myOutputStream]]
    $myStreamer registerCallback -Obj $this -Proc cleanup
    if [catch {
	$myStreamer Start
	#remove invalid parms for Start method
	unset parms(-FileName)
	#issue recorder start command
	eval $this Start -StreamId [$myInputStream GetStreamId] [array get parms]
    } result] {
	#error in recording file
	$myStreamer destroy
	$this unset myStreamer
	error $result
    }
    if {$block == 1} {
	$this WaitRecord
    }
    return
}

#cleans up a streamer stuff
Recorder method cleanup {args} {
    $this public myStreamer
    if [info exists myStreamer] {
	$myStreamer destroy
	$this unset myStreamer
    }
}

#WaitRecord - wait for the Record to finish which was started with StartRecord
Recorder method WaitRecord {} {
    global Recorder_MsgStopped
    $this asyncWait -MsgType $Recorder_MsgStopped
    return
}

#***RecordER_TypeDefs*****
#this object is a database of typedefs which can be automatically recognized by
#the an RecordER object, it also recognizes all types specified in Addressable_TypeDefs
TypeDefRegistry new -Name Recorder_TypeDefs \
    -init [list -Extends [[Recorder set Extends] set typeDefRegistry]]
Recorder_TypeDefs define -MsgType Recorder_MsgStart \
    -TypeDef [list \
		  StreamId $Recorder_MsgStart_StreamID \
		  Encoding $Recorder_MsgStart_Encoding \
		  StartMode $Recorder_MsgStart_StartMode \
		  ]
Recorder_TypeDefs define -MsgType Recorder_MsgStopped \
    -TypeDef [list \
		  Reason $Recorder_MsgStopped_Reason \
		  RtcLabel $Recorder_MsgStopped_RtcLabel \
		  TimeRecorded $Recorder_MsgStopped_TimeRecorded \
		  BytesRecorded $Recorder_MsgStopped_BytesRecorded
		  ]
Recorder_TypeDefs define -EvtGroup Recorder_Event_Type_EvtStopped \
    -TypeDef [list \
		  EvtGroup $Recorder_EvtStopped_Label \
		  Reason $Recorder_EvtStopped_Reason \
		  RtcLabel $Recorder_EvtStopped_RtcLabel \
		 ]
Recorder_TypeDefs define -EvtGroup Recorder_Event_Type_EvtStatus \
    -TypeDef [list \
		  EvtGroup $Recorder_EvtStatus_Label \
		  BytesRecorded $Recorder_EvtStatus_BytesRecorded
		 ]
Recorder defineMsgMethod -MethodName Start \
    -Type $Recorder_MsgStart -TypeDef lookup \
    -Defaults [list -Encoding $MULAW64E \
		   -StartMode $Recorder_MsgStart_StartMode_NORMAL] \
    -RetType $Recorder_MsgStartCmplt
Recorder defineMsgMethod -MethodName Stop \
    -Type $Recorder_MsgStop
Recorder defineMsgMethod -MethodName Pause \
    -Type $Recorder_MsgPause \
    -RetType $Recorder_MsgPauseCmplt
Recorder defineMsgMethod -MethodName Resume \
    -Type $Recorder_MsgResume \
    -RetType $Recorder_MsgResumeCmplt
return

