# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#Class StdResource is the base class for all DM3 resources including components and
#instances

#don't source the script more then once
if [info exists StdResource] {
    return
}


#this line helps the auto loader find this class
proc StdResource {} {}


catch {AddressableClass new -Name StdResource -init {-Extends Addressable}}

StdResource set ComponentType 0
StdResource set typeDefRegistry StdResource_TypeDefs


#Error code descriptions
set QS_ErrorCode_Descriptions($Std_ErrNone) {System level error occurred while executing a command.}
set QS_ErrorCode_Descriptions($Std_ErrSystem) {Component or Instance was busy executing a pevious command when another command was received.}
set QS_ErrorCode_Descriptions($Std_ErrUnexpectedMsg) {Unexpected message was received.}
set QS_ErrorCode_Descriptions($Std_ErrInstInUse) {Instances in use.}
set QS_ErrorCode_Descriptions($Std_ErrParmNum) {Std_ErrParmNum}
set QS_ErrorCode_Descriptions($Std_ErrParmValue) {Std_ErrParmValue}
set QS_ErrorCode_Descriptions($Std_ErrBusy) {Std_ErrBusy}
set QS_ErrorCode_Descriptions($Std_ErrInstCreate) {Std_ErrInstCreate}
set QS_ErrorCode_Descriptions($Std_ErrEvtType) {Std_ErrEvtType}
set QS_ErrorCode_Descriptions($Std_ErrEvtLabel) {Std_ErrEvtLabel}
set QS_ErrorCode_Descriptions($Std_ErrLabelTrans) {Std_ErrLabelTrans}
set QS_ErrorCode_Descriptions($Std_ErrUnsupportedMsg) {Std_ErrUnsupportedMsg}
set QS_ErrorCode_Descriptions($Std_ErrParmReadOnly) {Std_ErrParmReadOnly}
set QS_ErrorCode_Descriptions($Std_ErrParmReadOnly) {Std_ErrParmReadOnly}
set QS_ErrorCode_Descriptions($Std_ErrParmReadOnly) {Std_ErrParmReadOnly}
set QS_ErrorCode_Descriptions($Std_ErrParmWriteOnly) {Std_ErrParmWriteOnly}
set QS_ErrorCode_Descriptions($Std_ErrNotEnabled) {Std_ErrNotEnabled}
set QS_ErrorCode_Descriptions($Std_ErrListEmpty) {Std_ErrListEmpty}





#methods

StdResource method init {args} {
    $this public usePayload freeOnDestroy

    set usePayload {}

    set freeOnDestroy 0

    eval $this super init $args

};#enof Std_init


StdResource method destroy {} {
    $this public freeOnDestroy


    if {$freeOnDestroy == 1} {
	$this free
    }

    $this super destroy
};#endof Std_destroy








#Std_GetParm
#INPUTS
#parm - parmeter number
#[-Parm] - parameter to get
#**Switches***
#[-Text] - intpret as text data
#OUTPUTS
#{Val # Text {}}
StdResource method GetParm {{parmnum -?} args} {

    if [catch {expr $parmnum} result] {
	#parmnum isn't a number, the user may have specified -Parm
	set args [linsert $args 0 $parmnum]
    }

    array set check [CheckParms -Proc "Std_GetParm \[parm\]" -Provided $args \
			 -Optional {-Parm} -Switches {-Text}]
    

    array set parms $check(Flags)

    if [info exists parms(-Parm)] {
	set parmnum $parms(-Parm)
    }

    if {[lsearch -exact $check(Switches) "-Text"]==-1} {
	set count 0
    } else {
	set count TextSize
    }

    global Std_MsgGetParm Std_MsgGetParm_Num
    #setup typedefs
   global Std_MsgGetParm Std_MsgGetParmCmplt

   set typedef [StdResource_TypeDefs lookup -MsgType $Std_MsgGetParm]

    set tdr [$this Class set typeDefRegistry]

   set rettypedef [$tdr lookup -MsgType $Std_MsgGetParmCmplt]

    #fill in msg data
    set data [list Num $parmnum]

    #issue request
    array set retval [$this request -Data $data \
		    -Type $Std_MsgGetParm -TypeDef $typedef \
		    -RetType $Std_MsgGetParmCmplt -RetTypeDef $rettypedef \
		    ]

    #remove unwanted fields

    if {($count=="TextSize") && [info exists retval(Text)]} {
	#interpret as text
	set retval(Val) $retval(Text)
    }

    if {$tdr == "StdResource_TypeDefs"} {
	unset retval(Text)
	unset retval(TextSize)
    }

    #return result
    return [array get retval]
};#endof Std_GetParm


#Std_use
#***Inputs****
#[-Payload] - payload to send with use command
StdResource method use {args} {

    array set check [CheckParms -Proc StdResource_SetParm -Provided $args \
			 -Optional {-Payload}]
    
    array set parms $check(Flags)

    $this public TgtDesc MsgQueue usePayload
    
    #optional arguments
    if [catch {set payload $parms(-Payload)} result] {
	set payload $usePayload
    }


    #create temporary ResourceMgr to send this msg
    array set desc $TgtDesc
    
    set rsMgr [ResourceMgr new -init [list -BoardNum $desc(Board) -MsgQueue $MsgQueue]]

    $rsMgr use -StdResource $this -Payload $payload

    $rsMgr destroy
    
    return
};#endof Std_use


#Std_unuse
#***Inputs****
StdResource method unuse {} {

    $this public TgtDesc MsgQueue
    
    #create temporary ResourceMgr to send this msg
    array set desc $TgtDesc
    
    set rsMgr [ResourceMgr new -init [list -BoardNum $desc(Board) -MsgQueue $MsgQueue]]

    $rsMgr unuse -Desc $TgtDesc

    $rsMgr destroy
    
    return
};#endof Std_unuse

#StdResource_Free - frees the instance
StdResource method free {} {
    
    $this public TgtDesc MsgQueue

    array set desc $TgtDesc

    #create temporary resource manager
    set rsmgr [ResourceMgr new -init [list -BoardNum $desc(Board) -MsgQueue $MsgQueue]]
    
    set inst [eval $rsmgr free -Instance $this]

    $rsmgr destroy
    
    return $inst
    
};#endof StdResource_FreeInst




#Std_DetectEvt
#***INPUTS***
#-EvtType - event Type to enable
#[-Receiver] - object who's target should receive the events, defaults to sending evts to this object (not it's target)
#[-EvtGroup] - group this event is in, defaults to EvtType
#[-Extra] - extra data and typedef format = {TypeDef tdArg Data dataArg}
#***Outputs***
StdResource method DetectEvt {args} {

    array set check [CheckParms -Proc StdResource_DetectEvt -Provided $args \
			 -Required {-EvtType} -Optional {-EvtGroup -Extra -Receiver}]
    
    array set parms $check(Flags)

    #required arguments
    set type $parms(-EvtType)

    #optional args
    if [catch {set label $parms(-EvtGroup)} result] {
	set label $type
    }


    catch {array set extra $parms(-Extra)}

    #get retaddr
    $this public UniqueId MsgQueue
    set retAddr [$MsgQueue set CompDesc]
    set transId $UniqueId

    #change the retAddr if specified
    if [info exists parms(-Receiver)] {
	set retAddr [$parms(-Receiver) set TgtDesc]
	set transId [$parms(-Receiver) set UniqueId]
    }

    global Std_MsgDetectEvt Std_MsgDetectEvtCmplt
    
   set typedef [StdResource_TypeDefs lookup -MsgType $Std_MsgDetectEvt]
   set rettypedef [StdResource_TypeDefs lookup -MsgType $Std_MsgDetectEvtCmplt]

    #fill in msg data
    set data [list RetAddr $retAddr EvtType $type EvtGroup $label]

    #add on extra stuff if any
    if [info exists extra] {
	set typedef [concat $typedef $extra(TypeDef)]
	set data [concat $data $extra(Data)]
    }


    #issue request
    $this request -Type $Std_MsgDetectEvt -TypeDef $typedef -Data $data \
	-RetType $Std_MsgDetectEvtCmplt -TransactionId $transId
    
    return
};#endof Std_DetectEvt




#Std_CancelEvt
#***INPUTS***
#-EvtType - event Type to enable
#[-Receiver] - intance which was receiving this event, defaults to this one
#[-Extra] - extra data and typedef format = {TypeDef tdArg Data dataArg}
#***Outputs***
StdResource method CancelEvt {args} {

    array set check [CheckParms -Proc StdResource_CancelEvt -Provided $args \
			 -Required {-EvtType} -Optional {-Receiver -Extra}]
    
    array set parms $check(Flags)

    #required arguments
    set type $parms(-EvtType)

    #optional args
 
    catch {array set extra $parms(-Extra)}

    #get retaddr
    $this public UniqueId MsgQueue
    set retAddr [$MsgQueue set CompDesc]

    global Std_MsgCancelEvt Std_MsgCancelEvtCmplt
    #setup typedefs
   set typedef [StdResource_TypeDefs lookup -MsgType $Std_MsgCancelEvt]

    set transId $UniqueId

    #change the retAddr if specified
    if [info exists parms(-Receiver)] {
	set transId [$parms(-Receiver) set UniqueId]
    }

    #fill in msg data
    set data [list Type $type]

    #add on extra stuff if any
    if [info exists extra] {
	set Std_MsgCancelEvt_t [concat $Std_MsgCancelEvt_t $extra(TypeDef)]
	set data [concat $data $extra(Data)]
    }


    #issue request
    $this request -Type $Std_MsgCancelEvt -TypeDef $typedef -Data $data \
	-RetType $Std_MsgCancelEvtCmplt -TransactionId $transId
    
    return
};#endof Std_CancelEvt



#Std_DetectxEvts
#***INPUTS***
#[-EvtTypeList] - list of types, label will default to type unless EvtGroup is specified
#[-EvtList] - list of type, [group] pairs {{EvtType # EvtGroup #}...}
#           EvtGroup is optional, default is to be set to EvtType unless below is set
#[-EvtGroup] - if specified, overides EvtGroup value for all list members
#***Outputs***
StdResource method DetectxEvts {args} {

    array set check [CheckParms -Proc StdResource_DetectxEvts -Provided $args \
			 -Optional {-EvtTypeList -EvtList -EvtGroup -Receiver}]
    
    array set parms $check(Flags)

    #optional arguments
    if [catch {set evtTypeList $parms(-EvtTypeList)} result] {
	set tempList {}
    } else {
	#add all items to list
	foreach item $evtTypeList {
	    lappend tempList [list EvtType $item]
	}
    }

    catch {set tempList [concat $tempList $parms(-EvtList)]}

    if ![catch {set label $parms(-EvtGroup)} result] {
	#EvtGroup was supplied, replace all group values in list
	foreach item $tempList {
	    array set evt $item
	    set evt(EvtGroup) $label
	    lappend evtList [array get evt]
	}
    } else {
	#EvtGroup no supplied, set all unset group values to their type value
	foreach item $tempList {
	    array set evt $item
	    if ![info exist evt(EvtGroup)] {
		set evt(EvtGroup) $evt(EvtType)
	    }
	    lappend evtList [array get evt]
	}
    }


    #get retaddr
    $this public UniqueId MsgQueue
    set retAddr [$MsgQueue set CompDesc]
    set transId $UniqueId

    #change the retAddr if specified
    if [info exists parms(-Receiver)] {
	set retAddr [$parms(-Receiver) set TgtDesc]
	set transId [$parms(-Receiver) set UniqueId]
    }

    global Std_MsgDetectxEvts Std_MsgDetectxEvtsCmplt

    #setup typedefs
    set typedef [StdResource_TypeDefs lookup -MsgType $Std_MsgDetectxEvts]

  
    #fill in msg data
    set data [list RetAddr $retAddr List $evtList]

    #issue request
    $this request -Type $Std_MsgDetectxEvts -TypeDef $typedef -Data $data \
	-RetType $Std_MsgDetectxEvtsCmplt -TransactionId $transId
    
    return
};#endof Std_DetectxEvts

#Std_CancelxEvts
#***INPUTS***
#-EvtTypeList - list of types, label will default to type unless EvtGroup is specified
#[-Receiver] - instance which was receiving these events
#***Outputs***
StdResource method CancelxEvts {args} {

    array set check [CheckParms -Proc StdResource_CancelxEvts -Provided $args \
			 -Required {-EvtTypeList} -Optional {-Receiver}]
    
    array set parms $check(Flags)

    #required arguments
    set evtTypeList $parms(-EvtTypeList)


    #optional arguments


    #get retaddr
    $this public UniqueId
    set transId $UniqueId

    #change the transid if receiver specified
    if [info exists parms(-Receiver)] {
	set transId [$parms(-Receiver) set UniqueId]
    }

    global Std_MsgCancelxEvts Std_MsgCancelxEvtsCmplt

    #setup typedefs
    set typedef [StdResource_TypeDefs lookup -MsgType $Std_MsgCancelxEvts]

  
    #fill in msg data
    set data [list EvtTypeList $evtTypeList]

    #issue request
    $this request -Type $Std_MsgCancelxEvts -TypeDef $typedef -Data $data \
	-RetType $Std_MsgCancelxEvtsCmplt -TransactionId $transId
    
    return
};#endof Std_CancelxEvts


#Std_CancelAllEvts
#***INPUTS***
#[-Receiver] - intance which was receiving this event, defaults to this one
#***Outputs***
StdResource method CancelAllEvts {args} {

    array set check [CheckParms -Proc StdResource_CancelAllEvts -Provided $args \
			 -Optional {-Receiver}]
    
    array set parms $check(Flags)


    #optional args
 

    #get retaddr
    $this public UniqueId

    global Std_MsgCancelAllEvts Std_MsgCancelAllEvtsCmplt
    #setup typedefs
   set typedef [StdResource_TypeDefs lookup -MsgType $Std_MsgCancelAllEvts]

    set transId $UniqueId

    #change the retAddr if specified
    if [info exists parms(-Receiver)] {
	set transId [$parms(-Receiver) set UniqueId]
    }

    #issue request
    $this request -Type $Std_MsgCancelAllEvts -TypeDef $typedef -Data {} \
	-RetType $Std_MsgCancelAllEvtsCmplt -TransactionId $transId
    
    return
};#endof Std_CancelAllEvts

#***StdResource_TypeDefs*****
#this object is a database of typedefs which can be automatically recognized by
#the an StdResource object, it also recognizes all types specified in Addressable_TypeDefs

catch {TypeDefRegistry new -Name StdResource_TypeDefs 
    -init [list -Extends [[StdResource set Extends] set typeDefRegistry]]}


StdResource_TypeDefs define -MsgType Std_MsgError \
    -TypeDef [list \
		  ErrorMsg $Std_MsgError_ErrorMsg \
		  ErrorCode $Std_MsgError_ErrorCode \
		  Data [list -Switch ErrorMsg \
			    -Cases [list \
					$Std_MsgSetParm [list -DataType [list Num $ErrParm_Num Val $ErrParm_Val]] \
					$Std_MsgSetxParms [list -DataType [list Num $ErrParm_Num Val $ErrParm_Val]] \
					$Std_MsgGetxParms [list -DataType [list Num $ErrParm_Num Val $ErrParm_Val]] \
					$Std_MsgGetParm [list -DataType [list Num $ErrParm_Num Val $ErrParm_Val]] \
					$Std_MsgSetVParm [list -DataType [list Num $ErrParm_Num Val $ErrParm_Val]] \
					$Std_MsgGetVParm [list -DataType [list Num $ErrParm_Num Val $ErrParm_Val]] \
					default [list -DataType $QT_UINT32 -Count -1] \
					] \
			    ] \
		  ]

StdResource_TypeDefs define -MsgType Std_MsgDetectEvt \
    -TypeDef [list \
		RetAddr $QS_CompDesc \
		EvtType $Std_MsgDetectEvt_Type \
		EvtGroup $Std_MsgDetectEvt_Label \
	  ]


StdResource_TypeDefs define -MsgType Std_MsgDetectEvtCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgCancelEvt \
    -TypeDef [list \
		Type $Std_MsgCancelEvt_Type \
	  ]

StdResource_TypeDefs define -MsgType Std_MsgCancelEvtCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgDetectxEvts \
    -TypeDef [list \
		  RetAddr $QS_CompDesc \
		  Count $Std_MsgDetectxEvts_Count \
		  List [list -Count Count \
			-DataType [list \
				       EvtType $Std_MsgDetectxEvts_List_Type \
				       EvtGroup $Std_MsgDetectxEvts_List_Label \
				      ]\
			] \
	  ]

StdResource_TypeDefs define -MsgType Std_MsgDetectxEvtsCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgGetParm \
    -TypeDef [list \
		    Num $Std_MsgGetParm_Num \
		  ]

StdResource_TypeDefs define -MsgType Std_MsgGetParmCmplt \
    -TypeDef [list \
		   Num $Std_MsgGetParmCmplt_Num \
		   Val $Std_MsgGetParmCmplt_Val \
		   TextSize $Std_MsgGetParmCmplt_TextSize \
		   Text [list -DataType $QT_CHAR -Count -1] \
		   ]



StdResource_TypeDefs define -MsgType Std_MsgSetParm \
    -TypeDef [list \
		  Parm $Std_MsgSetParm_Num \
		  Val $Std_MsgSetParm_Val \
		 ]

StdResource_TypeDefs define -MsgType Std_MsgSetParmCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgSetxParms \
    -TypeDef [list \
		  Count $Std_MsgSetxParms_Count \
		  Parms [list -Count Count \
			     -DataType [list \
					    Parm $Std_MsgSetxParms_List_Num \
					    Val $Std_MsgSetxParms_List_Val \
					   ] \
			    ]
	     ]


StdResource_TypeDefs define -MsgType Std_MsgSetxParmsCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgGetxParms \
    -TypeDef [list \
		  Count $Std_MsgGetxParms_Count \
		  Parms [list -Count Count \
			      -DataType [list \
				     Parm $Std_MsgGetxParms_List_Num \
				     Val $Std_MsgGetxParms_List_Val \
				    ] \
			  ] \
	      ]

StdResource_TypeDefs define -MsgType Std_MsgGetxParmsCmplt \
    -TypeDef [list \
		  Count $Std_MsgGetxParmsCmplt_Count \
		  Parms [list -Count Count \
			     -DataType [list \
					  Parm $Std_MsgGetxParmsCmplt_List_Num \
					  Val $Std_MsgGetxParmsCmplt_List_Val \
					 ] \
			    ] \
		 ]

StdResource_TypeDefs define -MsgType Std_MsgSetVParm \
    -TypeDef [list \
		  Count $Std_MsgSetVParm_Count \
		  Parms [list -Count Count \
			     -DataType [list \
					    Parm $Std_MsgSetVParm_ParmId \
					    Val $Std_MsgSetVParm_FieldDef \
					   ] \
			    ]
	     ]


StdResource_TypeDefs define -MsgType Std_MsgSetVParmCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgGetVParm \
    -TypeDef [list \
		  Count $Std_MsgGetVParm_Count \
		  Parms [list -Count Count \
			      -DataType [list \
				     Parm $Std_MsgGetVParm_ParmId \
				    ] \
			  ] \
	      ]

StdResource_TypeDefs define -MsgType Std_MsgGetVParmCmplt \
    -TypeDef [list \
		  Count $Std_MsgGetVParmCmplt_Count \
		  Parms [list -Count Count \
			     -DataType [list \
					  Parm $Std_MsgGetVParmCmplt_ParmId \
					  Val $Std_MsgGetVParmCmplt_FieldDef \
					 ] \
			    ] \
		 ]

StdResource_TypeDefs define -MsgType Std_MsgSetParmDef \
    -TypeDef [list Parm $Std_MsgSetParmDef_Num]

StdResource_TypeDefs define -MsgType Std_MsgSetParmDefCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgSetxParmsDef \
    -TypeDef [list Count $Std_MsgSetxParmsDef_Count \
		  Parms [list -Count Count \
			     -DataType [list Parm $Std_MsgSetxParmsDef_List_Num] \
			    ] \
		 ]
					    
StdResource_TypeDefs define -MsgType Std_MsgSetxParmsDefCmplt \
    -TypeDef {}

array set QS_temp [QS_FieldDefGet $Std_MsgCancelxEvts_List_Type]

StdResource_TypeDefs define -MsgType Std_MsgCancelxEvts \
    -TypeDef [list \
		  Count $Std_MsgCancelxEvts_Count \
		  EvtTypeList [list -Count Count \
				-DataType $QS_temp(DataType)] \
		 ]

StdResource_TypeDefs define -MsgType Std_MsgCancelxEvtsCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgArmRTC \
    -TypeDef [list \
		  EvtGroup $Std_MsgArmRTC_Label \
		  Action $Std_MsgArmRTC_Action \
		 ]

StdResource_TypeDefs define -MsgType Std_MsgArmRTCCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgArmxRTCs \
    -TypeDef [list \
		  Count $Std_MsgArmxRTCs_Count \
		  EventGroupList [list -Count Count \
				       -DataType [list \
					      EvtGroup $Std_MsgArmxRTCs_List_Label \
					      Action $Std_MsgArmxRTCs_List_Action \
					    ] \
				       ] \
		  ]

StdResource_TypeDefs define -MsgType Std_MsgArmxRTCsCmplt \
    -TypeDef {}


StdResource_TypeDefs define -MsgType Std_MsgSetAllParmsDef \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgSetAllParmsDefCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgDisarmRTC \
    -TypeDef [list \
		  EvtGroup $Std_MsgDisarmRTC_Label \
		 ]

StdResource_TypeDefs define -MsgType Std_MsgDisarmRTCCmplt \
    -TypeDef {}

array set QS_temp [QS_FieldDefGet $Std_MsgDisarmxRTCs_List_Label]

StdResource_TypeDefs define -MsgType Std_MsgDisarmxRTCs \
    -TypeDef [list \
		  Count $Std_MsgDisarmxRTCs_Count \
		  EventGroupList [list -Count Count \
				       -DataType $QS_temp(DataType) \
				       ] \
		  ]
unset QS_temp

StdResource_TypeDefs define -MsgType Std_MsgDisarmxRTCsCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgDisarmAllRTCs \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgDisarmAllRTCsCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgComtest \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgComtestCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgInit \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgInitCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgAck \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgExit \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgExitCmplt \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgCancelAllEvts \
    -TypeDef {}

StdResource_TypeDefs define -MsgType Std_MsgEvtDetected \
    -TypeDef [list EvtGroup $Std_MsgEvtDetected_Label \
		  Data [list -DataType $QT_UINT8 -Count -1] \
		  ]




#auto define some msg methods, this must be belowe the typedef registry stuff

StdResource defineMsgMethod -MethodName Error \
    -Type $Std_MsgError -TypeDef lookup -Defaults {-Data {}}

StdResource defineMsgMethod -MethodName ComTest \
    -Type $Std_MsgComtest \
    -RetType $Std_MsgComtestCmplt

StdResource defineMsgMethod -MethodName SetParm \
    -Type $Std_MsgSetParm -TypeDef lookup \
    -RetType $Std_MsgSetParmCmplt

StdResource defineMsgMethod -MethodName SetxParms \
    -Type $Std_MsgSetxParms -TypeDef lookup -Defaults {-Count {}} \
    -RetType $Std_MsgSetxParmsCmplt

StdResource defineMsgMethod -MethodName GetxParms \
    -Type $Std_MsgGetxParms -TypeDef lookup -Defaults {-Count {}} \
    -RetType $Std_MsgGetxParmsCmplt -RetTypeDef lookup

StdResource defineMsgMethod -MethodName SetVParm \
    -Type $Std_MsgSetVParm -TypeDef lookup -Defaults {-Count {}} \
    -RetType $Std_MsgSetVParmCmplt

StdResource defineMsgMethod -MethodName GetVParm \
    -Type $Std_MsgGetVParm -TypeDef lookup -Defaults {-Count {}} \
    -RetType $Std_MsgGetVParmCmplt -RetTypeDef lookup

StdResource defineMsgMethod -MethodName Init \
    -Type $Std_MsgInit \
    -RetType $Std_MsgInitCmplt

StdResource defineMsgMethod -MethodName Ack \
    -Type $Std_MsgAck

StdResource defineMsgMethod -MethodName Exit \
    -Type $Std_MsgExit

StdResource defineMsgMethod -MethodName SetParmDef \
    -Type $Std_MsgSetParmDef -TypeDef lookup \
    -RetType $Std_MsgSetParmDefCmplt

StdResource defineMsgMethod -MethodName SetxParmsDef \
    -Type $Std_MsgSetxParmsDef -TypeDef lookup \
    -Defaults {-Count {}} \
    -RetType $Std_MsgSetxParmsDefCmplt

StdResource defineMsgMethod -MethodName SetAllParmsDef \
    -Type $Std_MsgSetAllParmsDef \
    -RetType $Std_MsgSetAllParmsDefCmplt

StdResource defineMsgMethod -MethodName ArmRTC \
    -Type $Std_MsgArmRTC -TypeDef lookup \
    -RetType $Std_MsgArmRTCCmplt \
    -RequestFlags {-TransactionId [$this set UniqueId]}

StdResource defineMsgMethod -MethodName ArmxRTCs \
    -Type $Std_MsgArmxRTCs -TypeDef lookup \
    -Defaults {-Count {}} \
    -RetType $Std_MsgArmxRTCsCmplt \
    -RequestFlags {-TransactionId [$this set UniqueId]}


StdResource defineMsgMethod -MethodName DisarmRTC \
    -Type $Std_MsgDisarmRTC -TypeDef lookup \
    -RetType $Std_MsgDisarmRTCCmplt \
    -RequestFlags {-TransactionId [$this set UniqueId]}

StdResource defineMsgMethod -MethodName DisarmxRTCs \
    -Type $Std_MsgDisarmxRTCs -TypeDef lookup \
    -Defaults {-Count {}} \
    -RetType $Std_MsgDisarmxRTCsCmplt \
    -RequestFlags {-TransactionId [$this set UniqueId]}


StdResource defineMsgMethod -MethodName DisarmAllRTCs \
    -Type $Std_MsgDisarmAllRTCs \
    -RetType $Std_MsgDisarmAllRTCsCmplt \
    -RequestFlags {-TransactionId [$this set UniqueId]}








return

