# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

source ${qscript_path}/pdk_parser_tools.qs
puts "CDPParser rev 1.21 (c) 2005 Intel Corporation"
catch {wm withdraw .}

# removeComments - Make a temporary file with all comments stripped
proc removeComments {infilename outfilename} {
    set infile [open $infilename r]
    set outfile [open $outfilename w+]
    while [expr 1] {
	if [catch {
	    set line [string tolower [readLine $infile {} {/*} {*/}]]
	} result] {
	    if {$result == "eof"} {
		close $infile
		close $outfile
		return
	    }
	    error $result
	}

	#remove any comment which are between // and end of line
	set index [string first "//" $line]
	if [expr $index != -1] {
	    set line [string range $line 0 [expr $index - 1]]
	}

	set line [string trim $line]

	if {$line != {}} {
	    puts $outfile $line
	}
    }
}

# makeCode - Generate CAS signal code
proc makeCode {code} {
    global sys
    set mask $code
    set dm3code 0

    set bits [split $code {}]
    set bitpos 3

    #check all bits, start with A, end with D
    foreach bit $bits {

	switch -exact $bit {
	    0 {
		#put a 1 in the mask, the 0 is already in the value section
		set dm3code [expr $dm3code | (1 << ($bitpos +4))]

		#make sure paired bit has same value
		set pairedbitpos [expr ($bitpos + 2) % 4]

		set pairedlistpos [expr abs($pairedbitpos - 3)]
	    }
	    1 {
		#put a 1 in mask and value section
		set dm3code [expr $dm3code | (1 << ($bitpos +4)) | (1 << $bitpos)]

		set pairedbitpos [expr ($bitpos + 2) % 4]
		set pairedlistpos [expr abs($pairedbitpos - 3)]

		if {[lindex $bits $pairedlistpos] != "0"} {
		    set dm3code [expr $dm3code | (1 << $pairedbitpos)]
		}
	    }
	    x {
		#don't change the mask, 0 already there.
		if {!$sys(linetypet1)} {

		    #force bit value in signal to 1 for E1.
		    set dm3code [expr $dm3code | (1 << $bitpos)]
		}
	    }
	    default {
		upvar line line
		puts "Error: unknown bit value $bit in CAS bit code in $code in $line"
		exit
	    }
	}
	incr bitpos -1
    }
    return [format 0x%x $dm3code]
}

proc getPSLvalue {index} {
    global psl

    set index [string tolower $index]
    if [info exists psl($index)] {
	return $psl($index)
    }

    #does not exist this is an error
    puts "Error: required PSL parameter $index not defined"
    exit
}

proc parse {filename} {
    global  cdp makemap opt_level mapfilename protocolname \
	    psl vparmlist maxMsgSize cdp_types \
	    sizeof psl_alias parms hotload sys board
    global supported_psl_parms supported_sys_parms
    global ToneSignalList CASSignalList
    global pulseDialS pulseDialT

    puts "removing comments from $filename ..."
    removeComments $filename ${filename}.${board}.nc
    set origname [file rootname $filename]
    set infile [open ${filename}.${board}.nc r]
    set outfile [open ${origname}.${board}.pdkconfig w+]
    if [expr $makemap] {
	#open map file for writing
	if ![info exists mapfilename] {
	    #no map file name supplied, guess based on cdp file name
	    set mapfilename "[file rootname $cdpfilename].map"
	}
	set mapfile [open $mapfilename w]
	set loadmap 0
    } else {
	#load map, this is required
	set loadmap 1
    }
    set CASSignalList {}
    set ToneSignalList {}

    #generate file headers

    puts $outfile "\# ${origname}.pdkconfig generated from ${filename} on [clock format [clock seconds]]"
    puts $outfile "\# just cut and paste from this file into your normal config file"
    #this variable controls if anything is written to the file
    set output 0

    puts "scanning file..."

    set depth 0
    array set cdp {}

    #parse the rest of the file
    while [expr 1] {
	if [catch {
	    set line [string tolower [readLine $infile {} {/*} {*/}]]
	    #remove single quotes
	    set line [ReplaceStringInLine $line ' {}]
	} result] {
	    if {$result == "eof"} {
		#end of infile reached

		#Check that protocolname was specified.
		if {![info exists sys(protocolname)] } {
		    puts "Error: SYS_ProtocolName parameter not specified in CDP file."
		    exit
		} else {
		    set protocolname $sys(protocolname)
		}

		#Load mapfile now if necessary
		if {$loadmap} {
		    if {![info exists mapfilename]} {
			set mapfilename "$sys(protocolname).qs"
		    }
		    if [catch {
			source $mapfilename
			set_map_data
		    }] {
			puts "Missing or corrupt qs file $mapfilename"
			uplevel \#0 return
		    }
		}

		# if length > 8, then warn about truncation
		if {[string length $sys(variantname)] > 8} {
		    puts "Warning: variant name will be truncated to 8 characters.\n"
		}

		set n1a 0
		set n1b 0
		set n1c 0
		set n1d 0
		set n2a 0
		set n2b 0
		set n2c 0
		set n2d 0

		puts "Registering as $sys(variantname)"
		scan $sys(variantname) "%c%c%c%c%c%c%c%c" n1a n1b n1c n1d \
			n2a n2b n2c n2d

            set psl(name_1) [gen_crc32 $origname [string length $origname]]
            set psl(name_2) [format "0x%02x%02x%02x%02x" $n1a $n1b $n1c $n1d]

		#output configfile

		if ($hotload) {
		    puts $outfile "include ${protocolname}.qs"
		    puts $outfile "set_chp_pdk_defs"
		} else {
		    puts $outfile ";include ${protocolname}.qs"
		    puts $outfile ";set_chp_pdk_defs"
		}

		#tone section

		#check if tonesigbase psl parameter was defined
		if [expr $psl(tonesigbase) == 0] {
		    set variantId [getPSLvalue variantid]
		    set psl(tonesigbase) [format 0x%x [expr 0x11500000 + ($board * 0x1000) + ($variantId * 0x100)]]
		}

		puts $outfile "\n\n\#Tone Section"
		puts $outfile "\n\#ToneMapping: Assign a signalId value to each tone variable\n"
		if ($hotload) {
		    puts $outfile "set ${protocolname}_tone_base $psl(tonesigbase)";
		} else {
		    puts $outfile ";set ${protocolname}_tone_base $psl(tonesigbase)";
		}
		foreach signal $ToneSignalList {
		    array set siginfo $signal
		    puts $outfile ";\# $siginfo(SigName) = $signal"
		    if [info exists siginfo(ToneRef)] {
			if ($hotload) {
			    puts $outfile "set ${protocolname}_$siginfo(SigName) $siginfo(ToneRef)"
			} else {
			    puts $outfile ";set ${protocolname}_$siginfo(SigName) $siginfo(ToneRef)"
			}
		    } else {
			# Output tone signal

			if ($hotload) {
			    puts $outfile "set ${protocolname}_$siginfo(SigName) \[incr ${protocolname}_tone_base\]"
			} else {
			    puts $outfile ";set ${protocolname}_$siginfo(SigName) \[incr ${protocolname}_tone_base\]"
			}
		    }
		    unset siginfo
		}

		# Tone Defintions
		puts $outfile "#Tone Definitions"
		foreach signal $ToneSignalList {
		    array set siginfo $signal
		    array set ToneSigInfo_$siginfo(SigName) $signal
		    if {![info exists siginfo(ToneRef)]} {
			# tonegen defintion
			puts $outfile "catch \{\$tgen DeleteTone -SignalId \$${protocolname}_$siginfo(SigName)\}"
			puts $outfile "\$tgen CreateTone -SignalId \$${protocolname}_$siginfo(SigName) -SignalLabel {} -SegList \[list \[list \\"
			if {$siginfo(Freq2) == 0} {
			    puts $outfile "   SignalType \$SigType_Singletone \\"
			} else {
			    puts $outfile "   SignalType \$SigType_Dualtone \\"
			}
			puts $outfile "	  Freq1 $siginfo(Freq1) \\"
			puts $outfile "	  Amp1 [expr 4*$siginfo(Amp1)] \\"
			puts $outfile "	  Freq2 $siginfo(Freq2) \\"
			puts $outfile "	  Amp2 [expr 4*$siginfo(Amp2)] \\"
			if {$siginfo(OnDuration) < 0} {
			    puts $outfile "   OnDuration $siginfo(OnDuration) \\"
			} else {
			    puts $outfile "   OnDuration [expr 8*$siginfo(OnDuration)] \\"
			}
			puts $outfile "	  OffDuration [expr 8*$siginfo(OffDuration)] \\"
			puts $outfile "	  Reps $siginfo(Reps) \\"
			puts $outfile "	  NextSeg 0x7f \]\]"


			# sigdet definition
			if {[format %d $siginfo(DetMode)] != 3} {
			    puts $outfile "\$sigdet CreateTone -SignalId \$${protocolname}_$siginfo(SigName) -SignalLabel {} \\"
			    puts $outfile "  -Reps $siginfo(Reps) \\"
			    puts $outfile "  -SegCount 1 \\"
			    puts $outfile "  -SegList \[list \[list \\"
			    if {$siginfo(Freq2) == 0} {
				puts $outfile "	 Mask 0x0 \\"
				set siginfo(Freq2Dev) 0
			    } else {
				puts $outfile "	 Mask 0x1 \\"
			    }
			    puts $outfile "  qtmplt 0x2 \\"
			    puts $outfile "  pqtmplt 0x2 \\"
			    puts $outfile "  Freq1Min [expr $siginfo(Freq1)-$siginfo(Freq1Dev)] \\"
			    puts $outfile "  Freq1Max [expr $siginfo(Freq1)+$siginfo(Freq1Dev)] \\"
			    puts $outfile "  Amp1Min 0 \\"
			    puts $outfile "  Amp1Max 0 \\"
			    puts $outfile "  Freq2Min [expr $siginfo(Freq2)-$siginfo(Freq2Dev)] \\"
			    puts $outfile "  Freq2Max [expr $siginfo(Freq2)+$siginfo(Freq2Dev)] \\"
			    puts $outfile "  Amp2Min 0 \\"
			    puts $outfile "  Amp2Max 0 \\"
			    if {abs($siginfo(Freq2) - $siginfo(Freq1)) < 130} {
				puts $outfile "	 FTwinMin $siginfo(Freq1) \\"
				puts $outfile "	 FTwinMax $siginfo(Freq2) \\"
			    } else {
				puts $outfile "	 FTwinMin 0 \\"
				puts $outfile "	 FTwinMax 0 \\"
			    }
			    if {$siginfo(OnDuration) <= 0} {
				puts $outfile "	 OnTimeMin 0 \\"
				puts $outfile "	 OnTimeMax 0 \\"
				puts $outfile "	 OffTimeMin 0 \\"
				puts $outfile "	 OffTimeMax 0 \\"
			    } else {
				puts $outfile "	 OnTimeMin [expr ($siginfo(OnDuration)-$siginfo(OnDurationDev))/10] \\"
				puts $outfile "	 OnTimeMax [expr ($siginfo(OnDuration)+$siginfo(OnDurationDev))/10] \\"
				puts $outfile "	 OffTimeMin [expr ($siginfo(OffDuration)-$siginfo(OffDurationDev))/10] \\"
				switch -exact [format %d $siginfo(DetMode)] {
				    4 {
					puts $outfile "	 OffTimeMax 0 \\"
				    }
				    default {
					puts $outfile "	 OffTimeMax [expr ($siginfo(OffDuration)+$siginfo(OffDurationDev))/10] \\"
				    }
				}
			    }
			    puts $outfile "\]\]"
			}
		    }
		    unset siginfo
		}

		if [expr $makemap] {
		    #output tone map to map file
		    set ToneMap {}
		    puts $mapfile "set ToneMap \[list \\"
		    foreach signal $ToneSignalList {
			array set siginfo $signal
			lappend ToneMap $siginfo(SigName)
			puts $mapfile "\t\t$siginfo(SigName) \\"
			unset siginfo
		    }
		    puts $mapfile "\t\]\n"

		    #output tone alias to map file
		    foreach signal [array names Tone_MapAllias] {
			puts $mapfile "set Tone_MapAllias($signal) $Tone_MapAllias($signal)"
		    }
		}

		puts $outfile "\n\#ToneModeMapping: this is a one to one map to the ToneMap,\n\#you may change the values but the order is fixed"
		if ($hotload) {
		    puts $outfile "set ToneModeMap_${protocolname} \[list \\"
		} else {
		    puts $outfile ";set ToneModeMap_${protocolname} \[list \\"
		}
		foreach signal $ToneMap {
		    array set siginfo [array get ToneSigInfo_$signal]
		    set mode [format %d $siginfo(DetMode)]
		    switch -exact [format %d $mode] {
			0 {
			    puts $outfile "\t\t\$CHP_PDK_Variant_ToneModeMap_Off \\"
			}
			1 {
			    puts $outfile "\t\t\$CHP_PDK_Variant_ToneModeMap_On \\"
			}
			2 {
			    puts $outfile "\t\t\$CHP_PDK_Variant_ToneModeMap_OnOff \\"
			}
			3 {
			    puts $outfile "\t\t\$CHP_PDK_Variant_ToneModeMap_None \\"
			}
			4 {
			    puts $outfile "\t\t\$CHP_PDK_Variant_ToneModeMap_On \\"
			}
			default {
			    puts "Warning: Unknown ToneMode values $mode, assuming On"
			    puts $outfile "\t\t\$CHP_PDK_VParm_ToneModeMap_On \\"
			}
		    }
		    unset siginfo
		}
		puts $outfile "\t\]"

		puts $outfile "\n\#ToneMap defintion, this may not be modified"
		if ($hotload) {
		    puts $outfile "set ToneMap_${protocolname} \[list \\"
		} else {
		    puts $outfile ";set ToneMap_${protocolname} \[list \\"
		}
		foreach signal $ToneMap {
		    puts $outfile "\t\t\$${protocolname}_$signal \\"
		}
		puts $outfile "\t\]"

		#cas signal definition

		#check if cassigbase psl parameter was defined
		if [expr $psl(cassigbase) == 0] {
		    set variantId [getPSLvalue variantid]
		    set psl(cassigbase) [format 0x%x [expr 0x715CA000 + ($variantId * 0x100)]]
		}

		if ($hotload) {
		    # don't print [] section if hotload
		} else {
		    puts $outfile "\n\n\[CASComponent\]"
		}
		puts $outfile "\#CAS Component Section"

		puts $outfile "\n\#CASMapping: Assign a value to the variable ${protocolname}_cas_sig_base, all other \n\#sigIds will be generated from this, or you may set the individual variables yourself\n"
		if ($hotload) {
		    puts $outfile "set ${protocolname}_cas_sig_base $psl(cassigbase)\n"
		} else {
		    puts $outfile ";set ${protocolname}_cas_sig_base $psl(cassigbase)\n"
		}
		foreach signal $CASSignalList {
		    array set siginfo $signal
		    if ($hotload) {
			puts $outfile "set ${protocolname}_$siginfo(SigName) \[incr ${protocolname}_cas_sig_base\]"
		    } else {
			puts $outfile ";set ${protocolname}_$siginfo(SigName) \[incr ${protocolname}_cas_sig_base\]"
		    }
		    unset siginfo
		}

		puts $outfile "\n\#CAS Signal Definitions\n"

		foreach signal $CASSignalList {
		    array set siginfo $signal
		    set comment $siginfo(SigName)
		    foreach sig [array names CAS_MapAllias] {
			if {$CAS_MapAllias($sig) == $siginfo(SigName)} {
			    lappend comment $sig
			}
		    }
		    switch -exact $siginfo(SigType) {
			Trans {
			    if ($hotload) {
				puts $outfile "\$cas DefineTransition -SignalId \$${protocolname}_$siginfo(SigName) -PreTransCode $siginfo(PreCode) -PostTransCode $siginfo(PostCode) \\\n\t-PreTransInterval $siginfo(PreTime) -PostTransInterval $siginfo(PostTime) ;# $comment"
			    } else {
				puts $outfile "DefineTransition -SignalId \$${protocolname}_$siginfo(SigName) -PreTransCode $siginfo(PreCode) -PostTransCode $siginfo(PostCode) \\\n\t-PreTransInterval $siginfo(PreTime) -PostTransInterval $siginfo(PostTime) ;# $comment"
			    }
			}
			Pulse {
			    if ($hotload) {
				puts $outfile "\$cas DefinePulse -SignalId \$${protocolname}_$siginfo(SigName) -OffPulseCode $siginfo(OffCode) -OnPulseCode $siginfo(OnCode) \\\n\t-PrePulseInterval $siginfo(PreTime) -PulseIntervalMin $siginfo(MinOnTime) -PulseIntervalNom $siginfo(NomOnTime)  -PulseIntervalMax $siginfo(MaxOnTime) -PostPulseInterval $siginfo(PostTime);# $comment"
			    } else {
				puts $outfile "DefinePulse -SignalId \$${protocolname}_$siginfo(SigName) -OffPulseCode $siginfo(OffCode) -OnPulseCode $siginfo(OnCode) \\\n\t-PrePulseInterval $siginfo(PreTime) -PulseIntervalMin $siginfo(MinOnTime) -PulseIntervalNom $siginfo(NomOnTime)  -PulseIntervalMax $siginfo(MaxOnTime) -PostPulseInterval $siginfo(PostTime);# $comment"
			    }
			}
			default {
			    puts "Error: unsupported CAS Signal type $siginfo(SigType)"
			}
		    }
		    unset siginfo
		}

		if [info exists pulseDialT] {
		    set trainSigId [format "0x%x" [expr $psl(cassigbase) + 0x21]]
		    set seqSigId [format "0x%x" [expr $trainSigId + 1]]
		    if ($hotload) {
			set cas "\$cas "
		    } else {
			set cas {}
		    }
		    puts $outfile "${cas}DefineTrain -SignalId $trainSigId \\
			    -OffPulseCode $pulseDialT(OffCode) -OnPulseCode $pulseDialT(OnCode) \\
			    -PreTrainInterval $pulseDialT(PreTrain) -PostTrainInterval $pulseDialT(PostTrain) \\
			    -PulseIntervalMin $pulseDialT(PulseMin) -PulseIntervalNom $pulseDialT(PulseNom) -PulseIntervalMax $pulseDialT(PulseMax) \\
			    -InterPulseIntervalMin $pulseDialT(InterPulseMin) -InterPulseIntervalMax $pulseDialT(InterPulseMax) -InterPulseIntervalNom $pulseDialT(InterPulseNom) \\
			    -DigitList { \
			{ PulseCount 1 Label \"1\" } \
			{ PulseCount 2 Label \"2\" } \
			{ PulseCount 3 Label \"3\" } \
			{ PulseCount 4 Label \"4\" } \
			{ PulseCount 5 Label \"5\" } \
			{ PulseCount 6 Label \"6\" } \
			{ PulseCount 7 Label \"7\" } \
			{ PulseCount 8 Label \"8\" } \
			{ PulseCount 9 Label \"9\" } \
			{ PulseCount 10 Label \"0\" } \
		    }"

		    puts $outfile "${cas}DefineSequence -SignalId $seqSigId -PulseTrainRef $trainSigId\\
			    -PreSeqInterval $pulseDialS(PreSeq) -PostSeqInterval $pulseDialS(PostSeq)\\
			    -InterTrainIntervalMin $pulseDialS(InterTrainMin) -InterTrainIntervalNom $pulseDialS(InterTrainNom) -InterTrainIntervalMax $pulseDialS(InterTrainMax)"
		    set psl(caspulsedialsignalid) $seqSigId
		}
		if [expr $makemap] {
		    #output vendor, and protocol ids
		    puts $mapfile "set vendorId [format 0x%x [getPSLvalue vendorid]]"
		    puts $mapfile "set protocolId [format 0x%x [getPSLvalue protocolid]]"
		    puts $mapfile "set version [format 0x%x [getPSLvalue version]]"
		    puts $mapfile "set compatibilitymask [format 0x%x [getPSLvalue compatibilitymask]]"

		    #output cas map to map file
		    set CASMap {}
		    puts $mapfile "\nset CASMap \[list \\"
		    foreach signal $CASSignalList {
			array set siginfo $signal
			lappend CASMap $siginfo(SigName)
			puts $mapfile "\t\t$siginfo(SigName) \\"
			unset siginfo
		    }
		    puts $mapfile "\t\]\n"

		    #output cas alias to map file
		    foreach signal [array names CAS_MapAllias] {
			puts $mapfile "set CAS_MapAllias($signal) $CAS_MapAllias($signal)"
		    }

		}

		puts $outfile "\n\#CASMap defintion, this may not be modified"
		if ($hotload) {
		    puts $outfile "set CASMap_${protocolname} \[list \\"
		} else {
		    puts $outfile ";set CASMap_${protocolname} \[list \\"
		}
		foreach signal $CASMap {
		    puts $outfile "\t\t\$${protocolname}_$signal \\"
		}
		puts $outfile "\t\]"

		#variant definition
		if ($hotload) {
		    # skip [] for hotload
		} else {
		    puts $outfile "\n\n\[TSCComponent\]"
		}
		puts $outfile "\#TSC Component Section"
		puts $outfile "\#$protocolname Variant defintion"
		if ($hotload) {
		    puts $outfile "\n\$tsc SetxParms -Parms \[list \\"
		} else {
		    puts $outfile "\nSetxParms -Parms \[list \\"
		}

		#output standard variant section
		puts $outfile "\t\t\t\[list Parm \$CHP_VParm_VariantId \t\tFieldDef \$CHP_Variant_VariantId \t\tVal [getPSLvalue variantId]\] \\"
		puts $outfile "\t\t\t\[list Parm \$CHP_VParm_VariantFormat \t\tFieldDef \$CHP_Variant_Format \t\tVal [getPSLvalue variantFormat]\] \\"

		foreach vparmname $vparmlist {
		    if {$vparmname == "VariantId" || $vparmname == "VariantFormat"} {
			#ignore
		    } else {
			puts $outfile "\t\t\t\[list Parm \$CHP_PDK_VParm_${vparmname} \t\tFieldDef \$CHP_PDK_Variant_${vparmname} \t\tVal [getPSLvalue ${vparmname}]\] \\"
		    }
		}

		#maps
		if [expr [llength $CASMap] > 0] {
		    puts $outfile "\t\t\t\[list Parm \$CHP_PDK_VParm_CASMap \t\tFieldDef \$CHP_PDK_Variant_${protocolname}_CASMap \t\tVal \$CASMap_${protocolname}\] \\"
		}
		if [expr [llength $ToneMap] > 0] {
		    puts $outfile "\t\t\t\[list Parm \$CHP_PDK_VParm_ToneMap \t\tFieldDef \$CHP_PDK_Variant_${protocolname}_ToneMap \t\tVal \$ToneMap_${protocolname}\] \\"
		    puts $outfile "\t\t\t\[list Parm \$CHP_PDK_VParm_ToneModeMap \t\tFieldDef \$CHP_PDK_Variant_${protocolname}_ToneModeMap \t\tVal \$ToneModeMap_${protocolname}\] \\"
		}

		if [info exists maxMsgSize] {
		    puts $outfile "\t\t\]\n"
		    puts $outfile "\#$protocolname Variant defintion continued"
		    if ($hotload) {
			puts $outfile "\n\$tsc SetxParms -Parms \[list \\"
		    } else {
			puts $outfile "\nSetxParms -Parms \[list \\"
		    }

		    #output standard variant section header
		    puts $outfile "\t\t\t\[list Parm \$CHP_VParm_VariantId \t\tFieldDef \$CHP_Variant_VariantId \t\tVal [getPSLvalue variantId]\] \\"
		    puts $outfile "\t\t\t\[list Parm \$CHP_VParm_VariantFormat \t\tFieldDef \$CHP_Variant_Format \t\tVal [getPSLvalue variantFormat]\] \\"
		    set msgSize 52
		}

		#PDP part of variant definition specific to this protocol
		foreach cdpParm [lsort [array names cdp]] {
		    if [info exists maxMsgSize] {
			set fieldSize [expr 8 + $sizeof($cdp_types($cdpParm))]; # the 8 allocates room for the parmId and fielddef
			if [expr ($msgSize + $fieldSize) > $maxMsgSize] {
			    #msg size reached
			    puts $outfile "\t\t\]\n"
			    puts $outfile "\#$protocolname Variant defintion continued"
			    if ($hotload) {
				puts $outfile "\n\$tsc SetxParms -Parms \[list \\"
			    } else {
				puts $outfile "\nSetxParms -Parms \[list \\"
			    }

			    #output standard variant section header
			    puts $outfile "\t\t\t\[list Parm \$CHP_VParm_VariantId \t\tFieldDef \$CHP_Variant_VariantId \t\tVal [getPSLvalue variantId]\] \\"
			    puts $outfile "\t\t\t\[list Parm \$CHP_VParm_VariantFormat \t\tFieldDef \$CHP_Variant_Format \t\tVal [getPSLvalue variantFormat]\] \\"
			    set msgSize [expr 52 + $fieldSize]
			} else {
			    incr msgSize $fieldSize
			}

		    }
		    puts $outfile "\t\t\t\[list Parm \$CHP_PDK_VParm_${protocolname}_$cdpParm \t\tFieldDef \$CHP_PDK_Variant_${protocolname}_$cdpParm \t\tVal $cdp($cdpParm)\] \\"
		}

		puts $outfile "\t\t\]"

		close $infile

		#infile was just a temp, delete it
		file delete ${filename}.${board}.nc

		close $outfile
		puts "\ncreated ${origname}.pdkconfig from ${filename}"

		return
	    }
	    error $result
	}

	############# parsing happens here.
	set tmpline $line

	set key [lindex $tmpline 0]
	switch -glob $key {
	    r4 {
		#R4 tag ignore
	    }
	    all -
	    dm3 -
	    default {
		if {$key != {dm3} && $key != {all}} {
		    #assume there was no tag, set it to all
		    set key all
		    set tmpline [linsert $tmpline 0 all]
		}

		set key2 [lindex $tmpline 1]
		switch -glob $key2 {
		    integer -
		    integer_t -
		    boolean -
		    boolean_t -
		    duration -
		    duration_t -
		    character -
		    character_t -
		    digitstring_t -
		    r2mftonestring_t -
		    digittype_t -
		    r2mftone_t -
		    r2mftonemask_t -
		    charstring_t {
			#declaring a parameter, first four characters
			#should be cdp_, psl_ or sys_

			# Use '=' to locate parm name and value
			set index [string first "=" $line]

			# Parm name is last item in string prior to '='
			set parmName [lindex [string range $line -1 [expr $index - 1]] end]

			# Value is rest of line after '='
			# Use lindex to strip quotes from strings
			set parmVal [lindex [string range $line [expr $index + 1] end] 0]

			# Trim prefix from parameter
			set prefix [string range $parmName 0 3]
			set parmName [string range $parmName 4 end]

			#If a string type then check if empty. Use {} if it is.
			switch -exact $key2 {
			    character - character_t -
			    digitstring_t - r2mftonestring_t - charstring_t {
				if {$parmVal == ""} {
				    set parmVal "{}"
				}
			    }
			    default {
				#nothing to do.
			    }
			}
			#If r2mftone then validate parmVal. Use NullTone if not '0'-'9' or 'a'-'f'
			if {$key2 == "r2mftone_t"} {
			    switch -exact $parmVal {
				0 - 1 - 2 - 3 - 4 - 5 - 6 - 7 -
				8 - 9 - a - b - c - d - e - f {
				    #Leave it alone
				}
				default {
				    #Replace with NullTone
				    set parmVal "{}"
				}
			    }
			}

			switch -exact $prefix {
			    cdp_ {
				set cdp($parmName) $parmVal
				set cdp_types($parmName) [lindex $tmpline 1]
			    }
			    psl_ {
				#check that this is a supported PSL parameter
				if [expr [lsearch -exact $supported_psl_parms $parmName] == -1] {
				    puts "Warning PSL Parameter $parmName unsupported"
				} else {
				    if [info exists psl_alias($parmName)] {
					#psl parameter is really an alias, use real name
					set parmName $psl_alias($parmName)
				    }

				    # Check for variant id, and override it if an
				    # override was provided on the command line
				    if {($parmName == "variantid") && [info exists parms(-variantId)]} {
					# Use command line variant id
					puts stdout "Replacing VariantId $parmVal with $parms(-variantId)"
					set psl($parmName) $parms(-variantId)

				    } else {

					#record the psl value
					set psl($parmName) $parmVal
				    }
				}
			    }
			    sys_ {
				#check that this is a supported SYS parameter
				if [expr [lsearch -exact $supported_sys_parms \
					$parmName] == -1] {
				    puts "Warning SYS Parameter $parmName unsupported"
				} else {
				    #record sys value
				    set sys($parmName) $parmVal

				    # if protocolname and variantname not set yet, copy it in.
				    if {($parmName == "protocolname") \
					    && ![info exists sys(variantname)]} {
					set sys(variantname) $parmVal
				    }
				    # if features, parse to set sysfeatures psl parameter
				    if {($parmName == "features")} {
					Parse_SysFeatures $parmVal
				    }
				    # if linetypet1 is 0, set to 0 else set to 1
				    if {($parmName == "linetypet1")} {
					if {($parmVal == 0)} {
					    puts "E1 line type detected."
					    set sys(linetypet1) 0
					} else {
					    puts "T1 line type detected."
					    set sys(linetypet1) 1
					}
				    }
				}
			    }
			    default {
				#not a cdp or psl or sys parameter
				puts "Error: declaration of $parmName prefix unknown"
			    }

			}
			    #endof switch prefix
		    }
		    cas_signal_trans_t {
			Parse_CAS_Signal_Trans $line
		    }
		    cas_signal_pulse_t {
			Parse_CAS_Signal_Pulse $line
		    }
		    cas_signal_sequence_t {
			Parse_CAS_Signal_Sequence $line
		    }
		    toneref {
			Parse_ToneRef $line
		    }
		    tone_t {
			Parse_Tone $line
		    }
		    default {
			#key2 is recognized
			puts "Error: Unrecognized symbol $key2 in line $line"
		    }
		    # switch -glob key2
		}
	    }
	}
    }
    return
}

proc Parse_ToneRef { line } {
    global opt_level ToneSignalList

    #maps a tone signal to a pre existing dm3 tone signal id
    #the remainder of the line after = is the defintion
    set index [string first "=" $line]
    set siginfo(SigName) [lindex [string range $line -1 [expr $index - 1]] end]

    set def [string range $line [expr $index + 1] end]

    #the definition is sepearted by commas
    set deflist [split $def {,}]

    set siginfo(ToneRef) [string trim [lindex $deflist 0]]
    set siginfo(DetMode) [string trim [lindex $deflist 1]]

    lappend ToneSignalList [array get siginfo]

    unset siginfo
}

proc Parse_Tone { line } {
    global opt_level ToneSignalList makemap

    #interpret tone definition

    #the remainder of the line after = is the defintion
    set index [string first "=" $line]
    set siginfo(SigName) [lindex [string range $line -1 [expr $index -1]] end]
    set def [string range $line [expr $index +1] end]

    #the definition is sepearted by commas
    set deflist [split $def {,}]

    if [expr [llength $deflist] == 1] {
	#just a single element, this should be an alias
	set alias_name [string trim [lindex $deflist 0]]

	# Store name for update
	set sig_name $siginfo(SigName)

	if [expr $opt_level >= 1] {
	    set Tone_MapAllias($siginfo(SigName)) $alias_name
	    puts "Tone Signal $siginfo(SigName) is aliased to $Tone_MapAllias($siginfo(SigName))"
	}

	#search for alias alias
	foreach sig $ToneSignalList {
	    array set tmp $sig
	    if {$tmp(SigName) == $alias_name} {
		break;
	    }
	    unset tmp
	}

	if [info exists tmp] {
	    #copy aliased info
	    array set siginfo [array get tmp]
	    set siginfo(SigName) $sig_name
	    unset tmp
	} else {
	    puts "Error: Tone Signal $siginfo(SigName) aliased to $alias_name, alias not found"
	    uplevel 0 return
	}

	set sigval [array get siginfo]

    } else {
	#new signal definition
	set freq1 [string trim [lindex $deflist 0]]
	set freq1dev [string trim [lindex $deflist 1]]
	set freq2 [string trim [lindex $deflist 2]]
	set freq2dev [string trim [lindex $deflist 3]]
	set amp1 [string trim [lindex $deflist 4]]
	set amp2 [string trim [lindex $deflist 5]]
	set ontime [string trim [lindex $deflist 6]]
	set ontimedev [string trim [lindex $deflist 7]]
	set offtime [string trim [lindex $deflist 8]]
	set offtimedev [string trim [lindex $deflist 9]]
	set mode [string trim [lindex $deflist 10]]
	set repcount [string trim [lindex $deflist 11]]
	set siginfo(Freq1) $freq1
	set siginfo(Freq1Dev) $freq1dev
	set siginfo(Amp1) $amp1
	set siginfo(Freq2) $freq2
	set siginfo(Freq2Dev) $freq2dev
	set siginfo(Amp2) $amp2
	set siginfo(OnDuration) $ontime
	set siginfo(OnDurationDev) $ontimedev
	set siginfo(OffDuration) $offtime
	set siginfo(OffDurationDev) $offtimedev
	set siginfo(DetMode) $mode
	set siginfo(Reps) $repcount
	set sigval [array get siginfo]

	if [expr ($makemap) && ($opt_level >= 2)] {
	    #search the Tone Signal list to see if there are other
	    #signals with the same value, if so then make this
	    #one an alias

	    foreach sig $ToneSignalList {
		array set tmp $sig
		if [compareArrays siginfo tmp {SigName}] {
		    #found a match, this is an alias
		    set Tone_MapAllias($siginfo(SigName)) $tmp(SigName)
		    puts "Tone Signal $siginfo(SigName) is aliased to $Tone_MapAllias($siginfo(SigName))"
		    unset tmp
		    break
		}
		unset tmp
	    }
	}
    }
    if ![info exists Tone_MapAllias($siginfo(SigName))] {
	if [expr [lsearch -exact $ToneSignalList $sigval] == -1] {
	    lappend ToneSignalList $sigval
	}
    } else {
	#this is an aliased signal, verify that it's definition matches it's alias
	#find siginal it is aliased to
	foreach sig $ToneSignalList {
	    array set tmp $sig
	    if {$tmp(SigName) == $Tone_MapAllias($siginfo(SigName))} {
		break;
	    }
	    unset tmp
	}

	if [info exists tmp] {
	    if ![compareArrays siginfo tmp {SigName}] {
		#does not match
		puts "Error: Tone Signal $siginfo(SigName) is aliased to $Tone_MapAllias($siginfo(SigName)), and must match its value"
		uplevel 0 return
	    }
	    unset tmp
	} else {
	    puts "Error: Tone Signal $siginfo(SigName) aliased to $Tone_MapAllias($siginfo(SigName)), alias not found"
	    uplevel 0 return
	}
    }

    unset siginfo
}

proc Parse_CAS_Signal_Trans { line } {
    global CASSignalList opt_level makemap

    #cas transition definition
    set siginfo(SigType) Trans
    #the line is further split at = is the defintion
    set index [string first "=" $line]
    set siginfo(SigName) [lindex [string range $line -1 [expr $index - 1]] end]
    set def [string range $line [expr $index + 1] end]

    #the definition is sepearted by commas
    set deflist [split $def {,}]

    if [expr [llength $deflist] == 1] {
	#just a single element, this should be an alias
	set alias_name [string trim [lindex $deflist 0]]

	# Store name for update
	set sig_name $siginfo(SigName)

	if [expr $opt_level >= 1 ] {
	    set CAS_MapAllias($siginfo(SigName)) $alias_name
	    puts "CAS Signal $siginfo(SigName) is aliased to $CAS_MapAllias($siginfo(SigName))"
	}
	#copy value of the alias
	foreach sig $CASSignalList {
	    array set tmp $sig
	    if {$tmp(SigName) == $alias_name} {
		break;
	    }
	    unset tmp
	}

	if [info exists tmp] {
	    array set siginfo [array get tmp]
	    set siginfo(SigName) $sig_name
	    unset tmp
	} else {
	    puts "Error: CAS Signal $siginfo(SigName) aliased to $alias_name, alias not found"
	    uplevel 0 return
	}

	set sigval [array get siginfo]

    } else {
	#new signal definition
	set precode [string trim [lindex $deflist 0]]
	set postcode [string trim [lindex $deflist 1]]
	set genPreTime [string trim [lindex $deflist 2]]
	set genPostTime [string trim [lindex $deflist 3]]

	#convert CDP values to DM3 values
	set siginfo(PreCode) [makeCode $precode]
	set siginfo(PostCode) [makeCode $postcode]
	set siginfo(PreTime) $genPreTime
	set siginfo(PostTime) $genPostTime

	set sigval [array get siginfo]

	if [expr $makemap && ($opt_level >=2)] {
	    #search the CAS Signal list to see if there are other
	    #signals with the same value, if so then make this
	    #one an alias

	    foreach sig $CASSignalList {
		array set tmp $sig

		if [compareArrays siginfo tmp {SigName}] {
		    #found a match, this is an alias
		    set CAS_MapAllias($siginfo(SigName)) $tmp(SigName)
		    puts "CAS Signal $siginfo(SigName) is aliased to $CAS_MapAllias($siginfo(SigName))"
		    unset tmp
		    break
		}
		unset tmp
	    }
	}
    }

    #check if this signal is an alias
    if ![info exists CAS_MapAllias($siginfo(SigName))] {
	if [expr [lsearch -exact $CASSignalList $sigval] == -1] {
	    lappend CASSignalList $sigval
	}
    } else {
	#this is an aliased signal, verify that it's definition matches it's alias
	#find siginal it is aliased to
	foreach sig $CASSignalList {
	    array set tmp $sig
	    if {$tmp(SigName) == $CAS_MapAllias($siginfo(SigName))} {
		break;
	    }
	    unset tmp
	}

	if [info exists tmp] {
	    if ![compareArrays siginfo tmp {SigName}] {
		#does not match
		puts "Error: CAS Signal $siginfo(SigName) is aliased to $CAS_MapAllias($siginfo(SigName)), and must match its value"
		uplevel 0 return
	    }
	    unset tmp
	} else {
	    puts "Error: CAS Signal $siginfo(SigName) aliased to $CAS_MapAllias($siginfo(SigName)), alias not found"
	    uplevel 0 return
	}
    }

    unset siginfo
}

proc Parse_CAS_Signal_Pulse { line } {
    global CASSignalList opt_level makemap

    #cas pulse definition
    set siginfo(SigType) Pulse
    #the remainder of the line after = is the defintion
    set index [string first "=" $line]
    set siginfo(SigName) [lindex [string range $line -1 [expr $index - 1]] end]

    set def [string range $line [expr $index + 1] end]

    #the definition is sepearted by commas
    set deflist [split $def {,}]

    if [expr [llength $deflist] == 1] {
	#just a single element, this should be an alias
	set alias_name [string trim [lindex $deflist 0]]

	# Store name for update
	set sig_name $siginfo(SigName)

	if [expr $opt_level >=1] {
	    set CAS_MapAllias($siginfo(SigName)) $alias_name
	    puts "CAS Signal $siginfo(SigName) is aliased to $CAS_MapAllias($siginfo(SigName))"
	}
	#copy value of the alias
	foreach sig $CASSignalList {
	    array set tmp $sig
	    if {$tmp(SigName) == $alias_name} {
		break;
	    }
	    unset tmp
	}

	if [info exists tmp] {
	    array set siginfo [array get tmp]
	    set siginfo(SigName) $sig_name
	    unset tmp
	} else {
	    puts "Error: CAS Signal $siginfo(SigName) aliased to $alias_name, alias not found"
	    uplevel 0 return
	}

	set sigval [array get siginfo]

    } else {
	#new signal definition

	set offcode [string trim [lindex $deflist 0]]
	set oncode [string trim [lindex $deflist 1]]
	set genPreTime [string trim [lindex $deflist 2]]
	set genPostTime [string trim [lindex $deflist 3]]
	set MinOnTime [string trim [lindex $deflist 6]]
	set NomOnTime [string trim [lindex $deflist 7]]
	set MaxOnTime [string trim [lindex $deflist 8]]

	#convert CDP values to DM3 values
	set siginfo(OffCode) [makeCode $offcode]
	set siginfo(OnCode) [makeCode $oncode]
	set siginfo(PreTime) $genPreTime
	set siginfo(PostTime) $genPostTime
	set siginfo(MinOnTime) $MinOnTime
	set siginfo(NomOnTime) $NomOnTime
	set siginfo(MaxOnTime) $MaxOnTime

	set sigval [array get siginfo]

	if [expr $makemap && ($opt_level >=2)] {
	    #search the CAS Signal list to see if there are other
	    #signals with the same value, if so then make this
	    #one an alias

	    foreach sig $CASSignalList {
		array set tmp $sig

		if [compareArrays siginfo tmp {SigName}] {
		    #found a match, this is an alias
		    set CAS_MapAllias($siginfo(SigName)) $tmp(SigName)
		    puts "CAS Signal $siginfo(SigName) is aliased to $CAS_MapAllias($siginfo(SigName))"
		    unset tmp
		    break
		}
		unset tmp
	    }
	}
    }

    if ![info exists CAS_MapAllias($siginfo(SigName))] {
	if [expr [lsearch -exact $CASSignalList $sigval] == -1] {
	    lappend CASSignalList $sigval
	}
    } else {
	#this is an aliased signal, verify that it's definition matches it's alias
	#find siginal it is aliased to
	foreach sig $CASSignalList {
	    array set tmp $sig
	    if {$tmp(SigName) == $CAS_MapAllias($siginfo(SigName))} {
		break;
	    }
	    unset tmp
	}

	if [info exists tmp] {
	    if ![compareArrays siginfo tmp {SigName}] {
		#does not match
		puts "Error: CAS Signal $siginfo(SigName) is aliased to $CAS_MapAllias($siginfo(SigName)), and must match its value"
		uplevel 0 return
	    }
	    unset tmp
	} else {
	    puts "Error: CAS Signal $siginfo(SigName) aliased to $CAS_MapAllias($siginfo(SigName)), alias not found"
	    uplevel 0 return
	}

    }

    unset siginfo
}

proc Parse_CAS_Signal_Sequence { line } {
    global pulseDialS pulseDialT opt_level makemap

    #cas pulse definition
    set pulseDialS(SigType) Sequence
    set pulseDialT(SigType) Train

    #the remainder of the line after = is the defintion
    set index [string first "=" $line]
    set pulseDialS(SigName) [lindex [string range $line -1 [expr $index - 1]] end]
    set pulseDialT(SigName) $pulseDialS(SigName)

    set def [string range $line [expr $index + 1] end]

    #the definition is sepearted by commas
    set deflist [split $def {,}]

    #new signal definition

    set offcode [string trim [lindex $deflist 0]]
    set oncode [string trim [lindex $deflist 1]]
    set pulseMin [string trim [lindex $deflist 2]]
    set pulseMax [string trim [lindex $deflist 3]]
    set pulseNom [string trim [lindex $deflist 4]]
    set iPulseMin [string trim [lindex $deflist 5]]
    set iPulseMax [string trim [lindex $deflist 6]]
    set iPulseNom [string trim [lindex $deflist 7]]
    set preSeqTime [string trim [lindex $deflist 8]]
    set postSeqTime [string trim [lindex $deflist 9]]
    set interTrainMin [string trim [lindex $deflist 10]]
    set interTrainMax [string trim [lindex $deflist 11]]
    set interTrainNom [string trim [lindex $deflist 12]]

    #convert CDP values to DM3 values
    set pulseDialT(OffCode) [makeCode $offcode]
    set pulseDialT(OnCode) [makeCode $oncode]
    set pulseDialT(PulseMin) $pulseMin
    set pulseDialT(PulseMax) $pulseMax
    set pulseDialT(PulseNom) $pulseNom
    set pulseDialT(PreTrain) $preSeqTime
    set pulseDialT(PostTrain) $postSeqTime
    set pulseDialT(InterPulseMin) $iPulseMin
    set pulseDialT(InterPulseMax) $iPulseMax
    set pulseDialT(InterPulseNom) $iPulseNom

    set pulseDialS(PreSeq) $preSeqTime
    set pulseDialS(PostSeq) $postSeqTime
    set pulseDialS(InterTrainMin) $interTrainMin
    set pulseDialS(InterTrainMax) $interTrainMax
    set pulseDialS(InterTrainNom) $interTrainNom
}

#parse command line arguments
if [catch {array set check \
	[CheckParms -Proc cdpparser.qs -Provided $argv -Required {} \
	-Optional {-variantId -OptLevel -mapFile -sdpFile -cdpFile -maxMsgSize -board}\
	-Switches {-MakeMap -hotload}]} result ] {
    puts $result
    return
}

array set parms $check(Flags)

#optional args
catch {set mapfilename $parms(-mapFile)}
catch {set sdpfilename $parms(-sdpFile)}
catch {set maxMsgSize $parms(-maxMsgSize)}; #specifies the maximum message size to output
catch {set variantId $parms(-variantId)}; #overrides VariantId in CDP/SDP file

if [info exists parms(-board)] {
    set board $parms(-board)
} else {
    set board {}
}

if [catch {set cdpfilename $parms(-cdpFile)}] {
    #cdp filename not supplied, assume that it has the same root as sdp file
    if ![info exists sdpfilename] {
	#no sdp file name supplied, error
	puts "error: no .sdp or .cdp file supplied, use -sdpFile or -cdpFile"
	uplevel \#0 return 1
    }
    set cdpfilename "[file rootname $sdpfilename].cdp"
}

#chose output filename
if [info exists sdpfilename] {
    set catfilename "[file rootname [file tail $sdpfilename]].cat"
    #create a new file which is the concatination of the cdp and sdp file
    set sdpfile [open $sdpfilename r]
    set cdpfile [open $cdpfilename r]
    set catfile [open $catfilename w]

    puts $catfile [read $cdpfile]
    puts $catfile [read $sdpfile]

    close $sdpfile
    close $cdpfile
    close $catfile

    set filename $catfilename
} else {
    set filename $cdpfilename
}

#optimization levels
array set opt_levels {
    0 none
    1 {use signal alias defined in CDP file}
    2 {alias any signals with same values in CDP file}
}

if [info exists parms(-OptLevel)] {
    set opt_level $parms(-OptLevel)
    #make sure the level is recognized
    if [expr [lsearch -exact [array names opt_levels] $opt_level] == -1] {
	puts "Error: Unknown optimization level $opt_level"
	foreach opt_level [array names opt_levels] {
	    puts "$opt_level - $opt_levels($opt_level)"
	}
	uplevel 0 return 0
    }

} else {
    set opt_level 1
}

if {[lsearch -exact $check(Switches) {-MakeMap}] != -1} {
    set makemap 1
} else {
    set makemap 0
}

if {[lsearch -exact $check(Switches) {-hotload}] != -1} {
    set hotload 1
} else {
    set hotload 0
}

#the sizeof array keeps byte sizes of data types
set sizeof(integer) 4
set sizeof(integer_t) 4
set sizeof(duration) 4
set sizeof(duration_t) 4
set sizeof(boolean) 1
set sizeof(boolean_t) 1
set sizeof(character) 1
set sizeof(character_t) 1
set sizeof(charstring_t) 64
set sizeof(digitstring_t) 64
set sizeof(r2mftonestring_t) 64
set sizeof(digittype_t) 1
set sizeof(r2mftone_t) 1
set sizeof(r2mftonemask_t) 4

#this is a list of all vparms, order determines order they will be in the setparm
if ($hotload) {
    set vparmlist {
	VariantId
	VariantFormat
	ProtocolId
	VendorId
	Version
	CompatibilityMask
	CountryId
	Name_1
	Name_2
	MakeCallTimeout
	InterCallDelay
	CASAlloc
	CASPulseDialSignalId
	ToneGenAlloc
	ToneDetAlloc
	ToneBufAlloc
	ToneR2Alloc
	ToneDTMFSet
	ToneMFSet
	ToneR2MFFwdSet
	ToneR2MFBckSet
	TonePreDigitTimeout
	ToneInterDigitTimeout
	CaAlloc
	CaCallProgressOverride
	CaMediaDetectOverride
	CaRingingSet
	CaBusySet
	CaSitSet
	CaFaxSet
	CaPvdId
	CaPamdId
	CaSignalTimeout
	CaAnswerTimeout
	CaPvdTimeout
	SysFeatures
	DialDNISTimeout
	CaHdgLoHiGl
	CaAnsdglPSV
    }
} else {
    set vparmlist {
	VariantId
	VariantFormat
	ProtocolId
	VendorId
	Version
	CompatibilityMask
	CountryId
	MakeCallTimeout
	InterCallDelay
	CASAlloc
	CASPulseDialSignalId
	ToneGenAlloc
	ToneDetAlloc
	ToneBufAlloc
	ToneR2Alloc
	ToneDTMFSet
	ToneMFSet
	ToneR2MFFwdSet
	ToneR2MFBckSet
	TonePreDigitTimeout
	ToneInterDigitTimeout
	CaAlloc
	CaCallProgressOverride
	CaMediaDetectOverride
	CaRingingSet
	CaBusySet
	CaSitSet
	CaFaxSet
	CaPvdId
	CaPamdId
	CaSignalTimeout
	CaAnswerTimeout
	CaPvdTimeout
	SysFeatures
	DialDNISTimeout
	CaHdgLoHiGl
	CaAnsdglPSV
    }
}
#supported PSL parameters
set supported_psl_parms {
    variantid
    variantformat
    cassigbase
    protocolid
    vendorid
    version
    compatibilitymask
    countryid
    name_1
    name_2
    makecalltimeout
    intercalldelay
    casalloc
    caspulsedialsignalid
    tonegenalloc
    tonedetalloc
    tonebufalloc
    toner2alloc
    tonedtmfset
    tonemfset
    toner2mffwdset
    toner2mfbckset
    tonepredigittimeout
    toneinterdigittimeout
    caalloc
    caringingset
    cabusyset
    casitset
    cafaxset
    capvdid
    capamdid
    casignaltimeout
    caanswertimeout
    capvdtimeout
    defaultmakecalltimeout
    makecall_callprogress
    cacallprogressoverride
    makecall_mediadetect
    camediadetectoverride
    tonesigbase
    sysfeatures
    dialdnistimeout
    cahdglohigl
    caansdglpsv
}

set required_sys_parms {
    protocolname
}

set supported_sys_parms {
    protocolname
    variantname
    i960hotfile
    armhotfile
    pq2hotfile
    features
    linetypet1
}

set sys(linetypet1) 0

#psl alias names and real vparm names
#this is used for PWG/GC compatibility
array set psl_alias {
    defaultmakecalltimeout makecalltimeout
    makecall_callprogress cacallprogressoverride
    makecall_mediadetect camediadetectoverride
}

proc Parse_SysFeatures { data } {
    global features psl

    set result 0

    #ignore quotation marks
    set data [string trim $data "\t\" "]

    #split on commas
    set featurelist [split $data ,]

    #foreach entry, check it exists in features array then bitor into mask
    foreach {feature} $featurelist {
	set feature [string trim $feature]
	if {[info exists features($feature)]} {
	    set result [expr $result | $features($feature)]
	    #puts "Found $feature Result = $result"
	} else {
	    puts "Warning $feature is undefined."
	}
    }
    set psl(sysfeatures) $result
}

#valid feature values
array set features [list \
	feature_ani	     0x1 \
	feature_billing	     0x2 \
	feature_cat	     0x4 \
	feature_cat2	     0x8 \
	feature_dnis	     0x10 \
	feature_drop_on_hold 0x20 \
	feature_hold	     0x40 \
	feature_inbound	     0x80 \
	feature_morednis     0x100 \
	feature_outbound     0x200 \
	feature_transfer     0x400 \
	]

#default vparm psl values
array set psl [list \
	variantformat 4 \
	compatibilitymask 0xffffffff \
	name_1 0x0 \
	name_2 0x0 \
	countryid 0 \
	cassigbase 0 \
	makecalltimeout 60000 \
	intercalldelay 0 \
	casalloc 1 \
	caspulsedialsignalid 0 \
	tonegenalloc 1 \
	tonedetalloc 1 \
	tonebufalloc 1 \
	toner2alloc 1 \
	tonedtmfset 0xe660 \
	tonemfset 0x14bc0 \
	toner2mffwdset 0x346c0 \
	toner2mfbckset 0x39b40 \
	tonepredigittimeout 10000 \
	toneinterdigittimeout 1000 \
	caalloc 1 \
	caringingset 0x024940 \
	cabusyset 0x004de0 \
	casitset 0x02f240 \
	cafaxset 0x014b80 \
	capvdid 0x01f4c1 \
	capamdid 0x01a041 \
	casignaltimeout 2000 \
	caanswertimeout 3000 \
	capvdtimeout 450 \
	cacallprogressoverride 0 \
	camediadetectoverride 2 \
	tonesigbase 0 \
	sysfeatures 0x280 \
	dialdnistimeout 20000 \
	cahdglohigl 0xff020f13 \
	caansdglpsv 0xffffff01 \
	]

parse $filename

exit


