# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

if [catch {array set check [CheckParms -Proc tspmon.qs -Provided $argv_clean -Required {-board} \
				-Optional {-lines -line -chan}]} result ] {
    puts stderr $result
    return
}

array set parms $check(Flags)
set boardNum $parms(-board)
set board(a) $boardNum
set board(b) $boardNum
set lines 1
set chans 1
set line(a) 1
set line(b) 1

if [info exists parms(-line)] {
	set lines $parms(-line)
}

if [info exists parms(-lines)] {
	set lines $parms(-lines)
}

if [expr [llength $lines] > 1] {
	set sides {a b}
	set all {a b}
	set line(a) [lindex $lines 0]
	set line(b) [lindex $lines 1]
} else {
	set sides a
	set all a
	set line(a) $lines
}

set inst(a) 1
set inst(b) 1

if [info exists parms(-chan)] {
	set inst(a) $parms(-chan)
	set inst(b) $parms(-chan)
	set chanNum $parms(-chan)
}

set graphics_display 1
set auto auto
source ${qscript_path}/tscdefs_ext.qs
source ${qscript_path}/tspmon.cfg
source ${qscript_path}/isdn_ext.qs
set all2 " "
set sp " "
foreach l $all {
    if { $inst($l) != 0 } {
	set all2 $all2$sp$l
    }
}
set all $all2
unset sp
unset all2
set font -*-$font_name-$font_weight-$font_style-normal-*-$font_size-*-*-*-*-*-*-*
set smallfont -*-$font_name-$font_weight-$font_style-normal-*-[expr $font_size / 1]-*-*-*-*-*-*-
set pixels_per_msec [expr ${pixels_per_sec}e+0 / 1000]
set compress_time_msec [expr ${compress_time_sec}e+0 * 1000]
set a_data(next_timestamp_location) 0
set b_data(next_timestamp_location) 0
set canvas_padx [expr 3 * $font_size]
set canvas_max_width [expr [expr $canvas_time_sec * $pixels_per_sec] + $canvas_padx + $canvas_padx]
set canvas_region [list 0 0 $canvas_max_width $canvas_height]
set gutter_start    [expr $canvas_height - [expr $font_size*2]]
set event_space	    [expr $canvas_height * $event_label_space]
set event_start      0
set bit_start  [expr $event_space + ($font_size / 2)]
set bit_space   [expr ($gutter_start - $font_size) - $bit_start]
set bit_height      [expr $bit_space / 9]
set bit_start  [expr $bit_start + $bit_height]
set time_start [expr $gutter_start + ($font_size / 2) ]
set delta_start   [expr $time_start + $font_size]
set canvas_percent [expr ${canvas_width}.0 / $canvas_max_width]
set scroll_to [expr .9 * $canvas_percent]
set compress_time_msec [expr $compress_time_sec * 1000]
set tx_a0 [expr $bit_start + (0 * $bit_space / 8) + $bit_height]
set tx_a1 [expr $bit_start + (0 * $bit_space / 8)]
set rx_a0 [expr $bit_start + (4 * $bit_space / 8) + $bit_height]
set rx_a1 [expr $bit_start + (4 * $bit_space / 8)]
set tx_b0 [expr $bit_start + (1 * $bit_space / 8) + $bit_height]
set tx_b1 [expr $bit_start + (1 * $bit_space / 8)]
set rx_b0 [expr $bit_start + (5 * $bit_space / 8) + $bit_height]
set rx_b1 [expr $bit_start + (5 * $bit_space / 8)]
set tx_c0 [expr $bit_start + (2 * $bit_space / 8) + $bit_height]
set tx_c1 [expr $bit_start + (2 * $bit_space / 8)]
set rx_c0 [expr $bit_start + (6 * $bit_space / 8) + $bit_height]
set rx_c1 [expr $bit_start + (6 * $bit_space / 8)]
set tx_d0 [expr $bit_start + (3 * $bit_space / 8) + $bit_height]
set tx_d1 [expr $bit_start + (3 * $bit_space / 8)]
set rx_d0 [expr $bit_start + (7 * $bit_space / 8) + $bit_height]
set rx_d1 [expr $bit_start + (7 * $bit_space / 8)]
set location_offset -$canvas_width
if { $graphics_display == 1 } {
wm title . $window_name
wm iconname . $icon_name
wm grid . 5 2 1 1
wm protocol . WM_DELETE_WINDOW quit
proc syncClocks {eventTimeMs} {
    global syncClockInfo
    set clicks [clock clicks]
}

#for events without timestamps this procedure
#can be used to estimate what the timestamp would have
#been
proc estimateEventTimeMs {} {
    global syncClockInfo
}

proc allScroll {list args} {
     foreach l $list {
	 eval {.display.$l.canvas xview} $args
	 }
}

proc draw_line {c tag color line width extra} {
    eval {.display.$c.canvas create line} $line -fill $color -tags $tag \
	 -capstyle projecting -width $width $extra
} 

proc draw_text {c tag color location text} {
    global font
     eval {.display.$c.canvas create text} $location \
	  -fill $color \
	  -text $text \
	  -tags $tag \
	  -font $font
}

proc draw_bits {c tag location time_compressed} {
    upvar \#0 ${c}_tx_bits tx_bit_vals
    upvar \#0 ${c}_rx_bits rx_bit_vals
    global bit_line_width bit_height color
    upvar \#0 .display.$c.tag_info tag_info
    upvar \#0 ${c}_data cnvs
    set arrows {}
    if {$time_compressed == 1} {
	set arrows "-arrow both"
    }
    foreach bs {tx_bit_vals rx_bit_vals} {
	set tag ${tag}${bs}
	catch {set tag_info($tag) $cnvs($bs)}
	upvar 0 $bs bitset
	foreach bit [array names bitset] {
	    set height [lindex $bitset($bit) 1]
	    set last_loc [lindex $bitset($bit) 0]
	    if {$last_loc >= $location} {
		break
	    }
	    set line [concat $bitset($bit) $location $height]
	    set bitset($bit) [concat $location $height]
	    set bit_color $color(BIT_[string toupper $bit])
	    draw_line $c $tag $bit_color $line $bit_line_width $arrows
	}
    }
}

proc transitionHandler {src msgType data} {
    global which_canvas pixels_per_msec start_time CAS_EvtDetectedTransition_Direction_Inbound \
	bit_line_width color canvas_max_width all last_time location_offset compress_time_msec font_size
    set c $which_canvas($src)
   upvar \#0 ${c}_data cnvs
    upvar \#0 .display.$c.tag_info tag_info
    array set event $data
    set time [format "%d" $event(Timestamp)]
    set tag $c${time}trans
    if ![info exists cnvs(last_time)] {
	#first event for this channel
	set cnvs(last_time) $time
	set cnvs(label_height) $font_size
    }
	if ![info exists start_time] {
	    #first event overall
	    set start_time [expr $time - 1000]
	}
    if ![info exists last_time] {
	set last_time $time
    }

    #time compression
    set time_compressed 0
    if [expr $compress_time_msec && (($time - $last_time) > $compress_time_msec)] {
	set location_offset [expr $location_offset + (($time - $last_time) - $compress_time_msec)*$pixels_per_msec]
	set time_compressed 1
    }
    set last_time $time
    set location [expr (($time - $start_time)*$pixels_per_msec) - $location_offset]
    if {$location >= $canvas_max_width} {
	canvas_clear
    }
    if {$location >= $canvas_max_width} {
	canvas_clear
    }
    set delta [expr $time - $cnvs(last_time)]
    set cnvs(last_time) $time

    #reformat time and delta to be in seconds
    set delta [expr ${delta}.0 / 1000]
    set time [expr ${time}.0 / 1000]
	set event(*Time) $time
	
    #append delta time to event
	set event(*Delta) $delta
	unset event(Timestamp) event(EvtGroup)

    #update bit lines
    draw_bits $which_canvas($src) $tag $location $time_compressed

    #change bit values
    if {$event(Direction) == $CAS_EvtDetectedTransition_Direction_Inbound} {
	set d rx
    } else {
	set d tx
    }

    foreach t {a b c d} {
	global ${d}_${t}0 ${d}_${t}1
    }

    upvar \#0 ${c}_${d}_bit_vals prev_bit_vals

    if ![info exists prev_bit_vals] {
	set prev_bit_vals [format "0x%x" [expr $event(PreTransCode) & 0x0f]]
    }

    set event(PreTransCode) [format "0x%x" [expr $event(PreTransCode) & 0x0f]]
    set bitval $event(PostTransCode);
    upvar \#0 ${c}_${d}_bits b
    set l $location
    switch -exact -- $bitval {
	0x0 { set b(d) [list $l [set ${d}_d0]];set b(c) [list $l [set ${d}_c0]];set b(b) [list $l [set ${d}_b0]];set b(a) [list $l [set ${d}_a0]];set cnvs(${d}_bit_vals) [list ${d}A 0 ${d}B 0 ${d}C 0 ${d}D 0] }
	0x1 { set b(d) [list $l [set ${d}_d1]];set b(c) [list $l [set ${d}_c0]];set b(b) [list $l [set ${d}_b0]];set b(a) [list $l [set ${d}_a0]];set cnvs(${d}_bit_vals) [list ${d}A 0 ${d}B 0 ${d}C 0 ${d}D 1] }
	0x2 { set b(d) [list $l [set ${d}_d0]];set b(c) [list $l [set ${d}_c1]];set b(b) [list $l [set ${d}_b0]];set b(a) [list $l [set ${d}_a0]];set cnvs(${d}_bit_vals) [list ${d}A 0 ${d}B 0 ${d}C 1 ${d}D 0] }
	0x3 { set b(d) [list $l [set ${d}_d1]];set b(c) [list $l [set ${d}_c1]];set b(b) [list $l [set ${d}_b0]];set b(a) [list $l [set ${d}_a0]];set cnvs(${d}_bit_vals) [list ${d}A 0 ${d}B 0 ${d}C 1 ${d}D 1] }
	0x4 { set b(d) [list $l [set ${d}_d0]];set b(c) [list $l [set ${d}_c0]];set b(b) [list $l [set ${d}_b1]];set b(a) [list $l [set ${d}_a0]];set cnvs(${d}_bit_vals) [list ${d}A 0 ${d}B 1 ${d}C 0 ${d}D 0] }
	0x5 { set b(d) [list $l [set ${d}_d1]];set b(c) [list $l [set ${d}_c0]];set b(b) [list $l [set ${d}_b1]];set b(a) [list $l [set ${d}_a0]];set cnvs(${d}_bit_vals) [list ${d}A 0 ${d}B 1 ${d}C 0 ${d}D 1] }
	0x6 { set b(d) [list $l [set ${d}_d0]];set b(c) [list $l [set ${d}_c1]];set b(b) [list $l [set ${d}_b1]];set b(a) [list $l [set ${d}_a0]];set cnvs(${d}_bit_vals) [list ${d}A 0 ${d}B 1 ${d}C 1 ${d}D 0] }
	0x7 { set b(d) [list $l [set ${d}_d1]];set b(c) [list $l [set ${d}_c1]];set b(b) [list $l [set ${d}_b1]];set b(a) [list $l [set ${d}_a0]];set cnvs(${d}_bit_vals) [list ${d}A 0 ${d}B 1 ${d}C 1 ${d}D 1] }
	0x8 { set b(d) [list $l [set ${d}_d0]];set b(c) [list $l [set ${d}_c0]];set b(b) [list $l [set ${d}_b0]];set b(a) [list $l [set ${d}_a1]];set cnvs(${d}_bit_vals) [list ${d}A 1 ${d}B 0 ${d}C 0 ${d}D 0] }
	0x9 { set b(d) [list $l [set ${d}_d1]];set b(c) [list $l [set ${d}_c0]];set b(b) [list $l [set ${d}_b0]];set b(a) [list $l [set ${d}_a1]];set cnvs(${d}_bit_vals) [list ${d}A 1 ${d}B 0 ${d}C 0 ${d}D 1] }
	0xa { set b(d) [list $l [set ${d}_d0]];set b(c) [list $l [set ${d}_c1]];set b(b) [list $l [set ${d}_b0]];set b(a) [list $l [set ${d}_a1]];set cnvs(${d}_bit_vals) [list ${d}A 1 ${d}B 0 ${d}C 1 ${d}D 0] }
	0xb { set b(d) [list $l [set ${d}_d1]];set b(c) [list $l [set ${d}_c1]];set b(b) [list $l [set ${d}_b0]];set b(a) [list $l [set ${d}_a1]];set cnvs(${d}_bit_vals) [list ${d}A 1 ${d}B 0 ${d}C 1 ${d}D 1] }
	0xc { set b(d) [list $l [set ${d}_d0]];set b(c) [list $l [set ${d}_c0]];set b(b) [list $l [set ${d}_b1]];set b(a) [list $l [set ${d}_a1]];set cnvs(${d}_bit_vals) [list ${d}A 1 ${d}B 1 ${d}C 0 ${d}D 0] }
	0xd { set b(d) [list $l [set ${d}_d1]];set b(c) [list $l [set ${d}_c0]];set b(b) [list $l [set ${d}_b1]];set b(a) [list $l [set ${d}_a1]];set cnvs(${d}_bit_vals) [list ${d}A 1 ${d}B 1 ${d}C 0 ${d}D 1] }
	0xe { set b(d) [list $l [set ${d}_d0]];set b(c) [list $l [set ${d}_c1]];set b(b) [list $l [set ${d}_b1]];set b(a) [list $l [set ${d}_a1]];set cnvs(${d}_bit_vals) [list ${d}A 1 ${d}B 1 ${d}C 1 ${d}D 0] }
	0xf { set b(d) [list $l [set ${d}_d1]];set b(c) [list $l [set ${d}_c1]];set b(b) [list $l [set ${d}_b1]];set b(a) [list $l [set ${d}_a1]];set cnvs(${d}_bit_vals) [list ${d}A 1 ${d}B 1 ${d}C 1 ${d}D 1] }
	default {error "unknow bit value $bitval"}
    }


    #figure out which bits changed
    set trans {}

    #xor the pre and post codes
    set changed [format "0x%x" [expr $bitval ^ $prev_bit_vals]]
    set prev_bit_vals $bitval
    switch -exact -- $changed {
	0x0 {set trans {}}
	0x1 {set trans {d}}
	0x2 {set trans {c}}
	0x3 {set trans {c d}}
	0x4 {set trans {b}}
	0x5 {set trans {b d}}
	0x6 {set trans {b c}}
	0x7 {set trans {b c d}}
	0x8 {set trans {a}}
	0x9 {set trans {a d}}
	0xa {set trans {a c}}
	0xb {set trans {a c d}}
	0xc {set trans {a b}}
	0xd {set trans {a b d}}
	0xe {set trans {a b c}}
	0xf {set trans {a b c d}}
	default {error "unexpected bit change $changed"}
    }

    array set bit_vals $cnvs(${d}_bit_vals)
    foreach bit $trans {
	set bbit [string toupper $bit]
	set val $bit_vals(${d}$bbit)
	set bit_vals(${d}${bbit}) "[expr !$val] -> $val"
	set line [list $location [set ${d}_${bit}0] $location [set ${d}_${bit}1]]
	set bit_color $color(BIT_[string toupper $bit])
	draw_line $c $tag $bit_color $line $bit_line_width {}
    }
    set tag_info($tag) [concat Time $time Delta $delta [array get bit_vals]]
    canvas_scroll $all $location
}

proc draw_event {c evt_color label data} {
    global canvas_height start_time event_line_width $c font_size pixels_per_msec \
	event_space color gutter_start all canvas_max_width location_offset last_time compress_time_msec \
	time_start delta_start
    upvar \#0 ${c}_data cnvs
    array set event $data
    set time $event(Timestamp)
    set tag $c$time$label
    if ![info exists cnvs(last_time)] {
	#first event for this channel
	set cnvs(last_time) $time
	set cnvs(label_height) $font_size

    }
	if ![info exists start_time] {
	    #first event overall
	    set start_time [expr $time - 1000]
	}
    if ![info exists last_time] {
	set last_time $time
    }
    set delta [expr $time - $cnvs(last_time)]

    #time compression
    set time_compressed 0
    if [expr $compress_time_msec && (($time - $last_time) > $compress_time_msec)] {
	set location_offset [expr $location_offset + (($time - $last_time) - $compress_time_msec)*$pixels_per_msec]
	set time_compressed 1
    }
    set last_time $time
    set location [expr (($time - $start_time)*$pixels_per_msec) - $location_offset]

    if {$location >= $canvas_max_width} {
	canvas_clear
    }

    set cnvs(last_time) $time

	#reformat time and delta to be in seconds
	set delta [expr ${delta}.0 / 1000]
	set time [expr ${time}.0 / 1000]	
	set event(*Time) $time
	
    #append delta time to event
	set event(*Delta) $delta
	unset event(Timestamp)

    #attach label
    draw_text $c $tag $evt_color [list $location $cnvs(label_height)] $label    

    #draw vertical line
    draw_line $c $tag $evt_color [list $location 0 $location $canvas_height] $event_line_width {}

	#determine if a timestamp won't overlapp last timestamp
	if [expr $location > $cnvs(next_timestamp_location)] {
		#attach timestamp
		draw_text $c $tag $color(TIME_E) [list $location $time_start] $time
		draw_text $c $tag $color(TIME_D) [list $location $delta_start] $delta
		set cnvs(next_timestamp_location) [expr $location + [expr [string length $time] * [expr $font_size / 2]]]
	}

    upvar \#0 .display.$c.tag_info tag_info
    #set info
    set tag_info($tag) [array get event]

    #increment label height
    incr cnvs(label_height) $font_size

    if [expr $cnvs(label_height) > $event_space] {
	set cnvs(label_height) $font_size
    }

    #update bit lines
    draw_bits $c $tag $location $time_compressed

    #scroll with events
    canvas_scroll $all $location
}

proc canvas_scroll {args where} {
    if [expr $where == 0] {
	return
    }

    global scroll_lock canvas_max_width scroll_to
    set percent [expr ($where / $canvas_max_width) - $scroll_to]
    if {$scroll_lock == 1} {
	foreach l $args {
	    .display.$l.canvas xview moveto $percent	    
	}
    }
}

proc canvas_erase {} {
    global all start_time last_time location_offset
    catch {unset  start_time}
    set location_offset -1000
    catch {unset last_time}
    foreach l $all {
        upvar \#0 .display.$l.tag_info tag_info
        set tag_info(a) 0
        unset tag_info
        eval {.display.$l.canvas delete all}
	upvar ${l}_data cnvs
	set cnvs(next_timestamp_location) 0
    }
}

proc canvas_clear {} {
    canvas_erase
}

proc canvas_disp { disp_list } {
    foreach l $disp_list {
	upvar \#0 $l a
	pack forget .display.$l
	if {$a==1} {
	    pack .display.$l -fill x -side top
	}
    }
}

proc canvas_window {canvas x y tag} {
    frame .display.$canvas.canvas.$tag -relief raised -borderwidth 2
    pack .display.$canvas.canvas.$tag
    set anch c
    set a [expr [.display.$canvas.canvas cget -height] / 3]
    if {$y<$a} {
	set anch n
    }
    if {$y>[expr $a * 2]} {
	set anch s
    }
    if {$x<80} {
	if {$anch!="c"} {
	    set anch ${anch}w
	} else {
	    set anch w
	}
    }
    eval {.display.$canvas.canvas create window} $x $y \
	-tags $tag \
	-window .display.$canvas.canvas.$tag \
	-anchor $anch
}

proc canvas_window_destroy {canvas a} {
    upvar \#0 cb cb
    set cb 0
    destroy .display.$canvas.canvas.$a
    .display.$canvas.canvas delete $a
}


proc canvas_click_more {canvas curr} {
    global font
    upvar \#0 .display.$canvas.tag_info tag_info
    set a [lrange [.display.$canvas.canvas gettags $curr] 0 0]
    set b [llength [.display.$canvas.canvas gettags w$a]]
    if {[string index $a 0]=="w"||$b>0} {
	if {[string index $a 0]=="w"} {
	    set a [string range $a 1 end]
	}
	canvas_window_destroy $canvas w$a
    }
    set xy [.display.$canvas.canvas coords [list $a]]
    canvas_window $canvas [lindex $xy 0] [lindex $xy 1] w$a
    checkbutton .display.$canvas.canvas.w$a.0 \
	-variable cb -indicatoron 0 -width 0 \
	-command [list canvas_window_destroy $canvas w$a]
    pack .display.$canvas.canvas.w$a.0 -side left -fill y
    set txt ""
    array set data $tag_info($a)
    set spc ""
    set names [lsort [array names data]]
    foreach l $names {
       set txt "$txt$spc$l $data($l)"
	set spc "\n"
    }
    button .display.$canvas.canvas.w$a.b \
	-text $txt -font $font \
	-command [list canvas_click_more $canvas $a]
    pack .display.$canvas.canvas.w$a.b -side left
    checkbutton .display.$canvas.canvas.w$a.1 \
	-variable cb -indicatoron 0 -width 0 \
	-command [list canvas_window_destroy $canvas w$a]
    pack .display.$canvas.canvas.w$a.1 -side left -fill y
}

proc canvas_click {canvas} {
    upvar \#0 .display.$canvas.tag_info .display.$canvas.tag_info
    canvas_click_more $canvas current
}

proc tag_set {canvas tag value} {
    global .display.$canvas.tag_info
    set .display.$canvas.tag_info($tag) $value
}

proc canvas_print {} {
    global all font printer_color
    foreach l $all {
	.display.$l.canvas postscript -file pt_$l.eps -fontmap $font -colormap $printer_color
    }
}

proc start_audio { side } {
    global board line inst audio_dir
    set brd $board($side)
    set ln $line($side)
    set ch $inst($side)
    set curr_dir [pwd]
    catch {cd $audio_dir}
    exec audio -board $brd -line $ln -chan $ch &
    cd $curr_dir
}

proc cleanup {} {
    global destroy_list
    foreach obj $destroy_list {
	if ![catch {set cancel_list [$obj set cancel_evts]} result] {
	    #object contains embeded list of events to cancel
	    if [catch {$obj CancelxEvts -EvtTypeList $cancel_list} result] {
		puts stderr "error sending CancelxEvts to $obj, with event list $cancel_list"
		puts stderr $result
	    }
	}
	$obj set unuseOnDestroy 0
	if [catch {$obj destroy} result] {
	    #force object to be destroyed
	    catch {uplevel \#0 unset $obj}
	}
    }
    unset destroy_list
}

proc quit {} {
    cleanup
    exit
}

proc callStateHandler {src msgType event} {
    global call_state_names call_state_reason_name which_canvas color
    array set data $event

    #reformat certain fields
    set data(Timestamp) [format "%d" $data(Timestamp)]
    catch {set data(CallState) $call_state_names($data(CallState))}
    catch {set data(Reason) $call_state_reason_name($data(Reason))}
    unset data(Type) data(EvtGroup)
    draw_event $which_canvas($src) $color(TSC_STATE) $data(CallState) [array get data]
}

proc callInfoHandler {src msgType event} {
    global call_info_names which_canvas color
    array set data $event

    #reformat certain fields
    set data(Timestamp) [format "%d" $data(Timestamp)]
    catch {set data(InfoId) $call_info_names($data(Type))}

    #remove unwanted fiels
    unset data(Type) data(EvtGroup)

    draw_event $which_canvas($src) $color(TSC_INFO) $data(InfoId) [array get data]
}

proc chanStateHandler {src msgType event} {
    global chan_state_name which_canvas color
    array set data $event

    #reformat certain fields
    set data(Timestamp) [format "%d" $data(Timestamp)]
    catch {set data(ChanState) $chan_state_name($data(ChanState))}

    #remove unwanted fiels
    unset data(Type) data(EvtGroup)
    draw_event $which_canvas($src) $color(TSC_CHANSTATE) $data(ChanState) [array get data]
}

proc traceHandler {src msgType msg} {
	global TSC_EvtTrace_Type_CallControl color which_canvas  msg_names
	set evt_td [TSC_TypeDefs lookup -EvtGroup $TSC_EvtTrace_Type_CallControl]
	array set event [$msg bodyGet -Offset 0 -TypeDef $evt_td]
    set offset [$msg set Offset]
	set msgType $event(MsgType)
	set td [TSC_TypeDefs lookup -MsgType $msgType]
    	array set data [$msg bodyGet -TypeDef $td]
	$msg destroy

	#reformat data
	set data(Timestamp) [format "%d" $event(Timestamp)]

    if [catch {set data(CallControl) $msg_names($msgType)} result] {
	set data(CallControl) $msgType
    }
	if [info exists data(Reason)] {
	    catch {
		if {$data(CallControl) == "RejectCall"} {
		    upvar \#0 RejectCall_reason_names names
		} else {
		    upvar \#0 call_state_reason_name names
		}
		set data(Reason) $names($data(Reason))
	    }
	}
	draw_event $which_canvas($src) $color(TSC_CNTRL) $data(CallControl) [array get data]
}

upvar \#0 cas_signal cas_signal_names
proc signalHandler {src msgType event} {
    
    global chan_state_name which_canvas color \
	CAS_RTCEvtDetectedSignal_Direction_Inbound CAS_RTCEvtDetectedSignal_Direction_Outbound cas_signal_names
    array set data $event

    #reformat certain fields
    set data(Timestamp) [format "%d" $data(Timestamp)]
    if [catch {set data(SignalName) $cas_signal_names($data(SignalId))} result] {
	set data(SignalName) $data(SignalId)
    }
    if {$data(Direction) == $CAS_RTCEvtDetectedSignal_Direction_Inbound} {
	set the_color $color(CAS_FROM)
    } else {
	set the_color $color(CAS_TO)
    }
    catch {unset data(Direction) data(EvtGroup) data(Format) data(SignalList) data(Count)}
    draw_event $which_canvas($src) $the_color $data(SignalName) [array get data]
}

proc ccs_l2Handler {src msgType event} {
    global chan_state_name which_canvas color CCS_EvtL2Trace_Direction_RCVD
    array set data $event

    #reformat certain fields
    set data(Timestamp) [format "%d" $data(Timestamp)]
    set data(Label) L2_TRACE
    if {$data(Direction) == $CCS_EvtL2Trace_Direction_RCVD} {
	set the_color $color(CCS_FROM)
    } else {
	set the_color $color(CCS_TO)
    }    
    draw_event $which_canvas($src) $the_color $data(Label) [array get data]
}

proc chp_ccs_trace {src msgType msg} {
    global chan_state_name which_canvas color isdn_l3_msg_names CHP_EvtTrace_Type_MsgToCCS isdn_ie_names ie_typedef
    array set data [$msg bodyGet -Offset 0]

    #reformat certain fields
    set data(Timestamp) [format "%d" $data(Timestamp)]
    if {$data(Type) == $CHP_EvtTrace_Type_MsgToCCS} {
	set the_color $color(CCS_TO)
    } else {
	set the_color $color(CCS_FROM)
    }

    unset data(Type)
    unset data(EvtGroup)
    array set more_data [$msg bodyGet -TypeDef $ie_typedef]
    set more_data(ISDN_CallId) $more_data(CallId)
    unset more_data(CallId)
    unset more_data(IEPrivBufLen)
    catch {set more_data(MessageId) $isdn_l3_msg_names($more_data(MessageId))}
    set ielist $more_data(IEPubData)

    #parse private data manually
    set priv_data $more_data(IEPrivData)
    unset more_data(IEPrivData)
    set index 1
    global CODESET_SHIFT_IE MORE_DATA_IE SENDING_COMPLETE_IE NOT_CONGESTED_IE CONGESTED_IE REPEAT_IND_IE
    for {set index 1} {$index < [llength $priv_data]} {incr index 2} {
	set iedata(IEId) [lindex $priv_data $index]
	switch -exact $iedata(IEId) [list \
					 $CODESET_SHIFT_IE - \
					 $MORE_DATA_IE - \
					 $SENDING_COMPLETE_IE - \
					 $CONGESTED_IE - \
					 $NOT_CONGESTED_IE - \
					 $REPEAT_IND_IE {
					     set iedata(Value) {}
					 } \
					 default {
						  set lengthIndex [expr [lindex $priv_data [expr $index +1]] + $index + 1 ]
						  set iedata(Value) [lrange $priv_data [expr $index + 2] $lengthIndex]
						  set index $lengthIndex
					      } \
						  ]
	
	if [catch {set more_data($isdn_ie_names($iedata(IEId))) $iedata(Value)} result] {
	    set more_data(IE_$iedata(IEId)) $iedata(Value)
	}
	unset iedata
    }

    #overwrite private data with public data
    unset more_data(IEPubData)
    foreach ie $ielist {
	array set iedata $ie
	if [catch {set more_data($isdn_ie_names($iedata(IEId))) $iedata(Value)} result] {
	    set more_data(IE_$iedata(IEId)) $iedata(Value)
	}
	unset iedata	     
    }
    array set data [array get more_data]
    draw_event $which_canvas($src) $the_color $data(MessageId) [array get data]
    $msg destroy
}

if [info exists testing] {
    return
}

frame .display
set canvas_color black
set canvas_name_width 0
foreach l $all {
    if {[string length $canvas_name($l)] > $canvas_name_width} {
	set canvas_name_width [string length $canvas_name($l)]
    }
}

foreach l $all {
    set $l 1
    frame .display.$l
    frame .display.$l.control
    label .display.$l.control.key \
	-text "\n\n\n\n\nTx\na\nb\nc\nd\nRx\na\nb\nc\nd"
    set comp_line($l) 10
    label .display.$l.control.label -text $canvas_name($l) \
	-fg black -width $canvas_name_width
    button .display.$l.control.audio -text "Audio" -command [list start_audio $l]
    canvas .display.$l.canvas -width $canvas_width -height $canvas_height \
	-scrollregion $canvas_region \
	-xscrollcommand [list .controls.xs.xscroll set] \
	-background $canvas_color
    pack .display.$l.control.label
    pack .display.$l.control.audio
    pack .display.$l.control.key -anchor s
    pack .display.$l.control -side left
    pack .display.$l.canvas -side left -fill x -expand true
    .display.$l.canvas bind all <ButtonPress> [list canvas_click $l]
}

canvas_disp $all
pack .display -fill x
frame .controls
frame .controls.xs
frame .controls.std
frame .controls.disp
set sc_lck 1
button .controls.std.exit -text "Exit" -command quit
button .controls.std.restart -text "Restart" -command {cleanup;canvas_clear;start}
label .controls.xs.l -width $canvas_name_width
scrollbar .controls.xs.xscroll -orient horizontal \
	 -command [list allScroll $all]
frame .controls.disp.show -relief sunken -borderwidth 1
label .controls.disp.show.l -text "Display:"
pack .controls.disp.show.l -side left
foreach l $all {
    checkbutton .controls.disp.show.$l -variable $l \
	-command [list canvas_disp $all]
    pack .controls.disp.show.$l -side left
}

button .controls.disp.clear -text "Clear" -command canvas_clear
checkbutton .controls.disp.scroll -text "Scroll Lock" -variable scroll_lock
pack .controls.xs.l -side left
pack .controls.xs.xscroll -side left -fill x -expand true
pack .controls.disp.clear -side left
pack .controls.disp.scroll -side left
pack .controls.disp.show -side left
pack .controls.std.restart -side left
pack .controls.std.exit -side left
pack .controls.xs -fill x
pack .controls.disp -side left
pack .controls.std -side right
pack .controls -fill x
}

proc start { } {
    global boardNum line inst which_canvas sides destroy_list
set brd [Board new -init [list -BoardNum $boardNum]]
lappend destroy_list $brd
foreach side $sides {
	set clust [$brd findClustByTSC -Line $line($side) -Chan $inst($side)]
    lappend destroy_list $clust
    #find the tsc
    if ![catch {set tsc [$clust find -InstClass TSC]}] {
	lappend destroy_list $tsc
	global TSC_EvtCallState_Type_Null TSC_EvtCallInfo_Type_BearerChanId TSC_EvtChanState_Type_Active \
	    call_state_evt_list call_info_evt_list chan_state_evt_list TSC_EvtTrace_Type_CallControl
	set which_canvas($tsc) $side
	#register for callstate events
	$tsc asyncRegister -EvtGroup $TSC_EvtCallState_Type_Null -Proc callStateHandler
	$tsc DetectxEvts -EvtTypeList $call_state_evt_list -EvtGroup $TSC_EvtCallState_Type_Null
	#register for callinfo events
	$tsc asyncRegister -EvtGroup $TSC_EvtCallInfo_Type_BearerChanId  -Proc callInfoHandler
	$tsc DetectxEvts -EvtTypeList $call_info_evt_list -EvtGroup $TSC_EvtCallInfo_Type_BearerChanId  
	#register for channel state events
	$tsc asyncRegister -EvtGroup $TSC_EvtChanState_Type_Active -Proc chanStateHandler
	$tsc DetectxEvts -EvtTypeList $chan_state_evt_list -EvtGroup $TSC_EvtChanState_Type_Active 
	#register for trace events
	$tsc asyncRegister -EvtGroup $TSC_EvtTrace_Type_CallControl -Proc traceHandler -TypeDef Msg
	$tsc DetectEvt -EvtType $TSC_EvtTrace_Type_CallControl
	#$tsc set cancel_evts [concat $call_state_evt_list $call_info_evt_list $chan_state_evt_list $TSC_EvtTrace_Type_CallControl ]
    }
    #try to find CAS, it may not exist
    if ![catch {set cas [$clust find -InstClass CAS]}] {
	global CAS_EventId_AllSignals CAS_EventId_AllTransitions
	#cas found
        lappend destroy_list $cas
	set which_canvas($cas) $side
	#register for signal events
	$cas asyncRegister -EvtGroup $CAS_EventId_AllSignals -Proc signalHandler
	catch {$cas DetectEvt -EvtType $CAS_EventId_AllSignals}
	#register for bit transitions
	$cas asyncRegister -EvtGroup $CAS_EventId_AllTransitions -Proc transitionHandler
	catch {$cas DetectEvt -EvtType $CAS_EventId_AllTransitions}
    } elseif ![catch {set ccs [$brd findInst -InstClass CCS]}] {
	global L2_TRACE CCS_EvtL2Trace_Label_L2Trace CHP_EvtTrace_Type_MsgFromCCS CHP_EvtTrace_Type_MsgToCCS
	#ccs found
        lappend destroy_list $ccs
	global event_space gutter_start event_start
	#bits are not drawn, use all space for events
	set event_space [expr $gutter_start - $event_start]
	set which_canvas($ccs) $side
	#chp layer3 trace
	if ![catch {set chp [$clust find -InstClass CHP]} result] {
	    lappend destroy_list $chp
	    set which_canvas($chp) $side
	    global CHP_EvtTrace_Type_MsgToCCS CHP_EvtTrace_Type_MsgFromCCS ie_typedef CCS_ieMessage
	    set ie_typedef [[CCS set typeDefRegistry] lookup -MsgType $CCS_ieMessage]
	    $chp asyncRegister -EvtGroup $CHP_EvtTrace_Type_MsgToCCS -Proc chp_ccs_trace -TypeDef Msg
	    $chp DetectEvt -EvtType $CHP_EvtTrace_Type_MsgToCCS
	    $chp asyncRegister -EvtGroup $CHP_EvtTrace_Type_MsgFromCCS -Proc chp_ccs_trace -TypeDef Msg
	    $chp DetectEvt -EvtType $CHP_EvtTrace_Type_MsgFromCCS
	    $chp set cancel_evts [list $CHP_EvtTrace_Type_MsgToCCS $CHP_EvtTrace_Type_MsgFromCCS]
	}
    }
}
}

start

