# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

set iclass CAS
source ${qscript_library}/TSC_Class.qs
source ${qscript_path}/tscdefs_ext.qs
source ${qscript_path}/tracer_defs.qs

set linebreak "********************************************************************************\n"
set tablebreak "--------------------------------------------------------------------------------"
set CALLINFODBG  2
set CHANSTATEDBG 3
set APITRACEDBG  4

proc header {} {
    global tablebreak linecount 
    trace $tablebreak
    trace "|BOARD EVT| DELTA ms |  ELASPSED  |DIR|TRANSCODE|   SIGNAL (DEFAULT TRACE)     |"
    trace "| (HOST)  | BETWEEN  |  TIME FROM |   | RX | TX |    ID     |     NAME         |" 
    trace "|TIMESTAMP| EVENTS   |  1st EVENT |   |BITS|BITS|           |                  |" 
    trace "| HH:MM:SS|        MS|       SS:MS|   |ABCD|ABCD|           |                  |"
    trace $tablebreak
    set linecount 0
}

proc setuserparms {} {
    global argv_clean linecount boardnum line chan inst callevts
    set linecount 0

#set default values
    set boardnum 0
    set line 1
    set chan 1
    set callevts 4

#set values from command line arguments or user selections.
    array set argvarr $argv_clean
    if [info exists argvarr(-board)] {set boardnum $argvarr(-board)}
    if [info exists argvarr(-line)] {set line $argvarr(-line)}
    if [info exists argvarr(-chan)] {set chan $argvarr(-chan)}
}

proc createcasinstance {} {

    global iclass TSC_Std_ComponentType Std_ComponentType
    global TSC_AttrLineId TSC_AttrChanId boardnum line chan 
    global board comptype clust inst 
# This is the basic function used in most qscript scripts 
# which shows how to find and use a component instance
# It sets the following variables in order to run the CAS tester
# board - board number to attach to
# line - line to use
# chan - chan to use
# iclass - class of instance to find or allocate
# compclass - class of component to find
# comptype - type of instnace to find or allocate if iclass is not set
# board is the only one that must be specified by the user 
# if all goes well the following object will have been created
# board - a board object
# clust - cluster object
# comp  - component object of class compclass
# inst  - instance object of class iclass

#set iclass component type
    if ![info exists iclass] {
       if ![info exists comptype] {
	 set comptype $TSC_Std_ComponentType
       }
       set iclass Instance
    } else {
       set comptype [$iclass set ComponentType]
    }

#attach to the board
    set board [Board new -init [list -BoardNum $boardnum]]

#find the component
    if ![info exist compclass] {
       set compclass Component
    } else {
       set comptype [$compclass set ComponentType]
    }

#find cluster on board for line and channel
    set clust [$board findClust -Attrs [list \
	      [list -key $Std_ComponentType -value $TSC_Std_ComponentType] \
	      [list -key $TSC_AttrLineId -value $line] \
	      [list -key $TSC_AttrChanId -value $chan] ] ]

#allocate or get appropriate CAS instances in cluster
    set inst [$clust find -CompType $comptype -InstClass $iclass -AutoAllocate]
}

proc createtscinstance {} {
    global clust tsc

#Cluster required is already found earlier, so just find TSC instance in it
    set tsc [$clust find -InstClass TSC]
}

proc rtcSignalEvt {obj type data} {
    global prev_time hosttime abstime tablebreak CAS_SIGIDS linecount
    global TRANSCODES i_oldpostrans o_oldpostrans
    set hosttime [clock format [clock seconds] -format %T]
    array set darr $data
    if {$darr(Direction)==1} {
	set direction "I "
    } else {
	set direction "O " 
    }
    if ![info exists prev_time] {
	set prev_time $darr(Timestamp)
    }
    set delta_time [expr $darr(Timestamp) - $prev_time]
    set prev_time $darr(Timestamp)
    set board_time [clock format [ expr [format "%d" $darr(Timestamp)] / 1000 ] -format %T ]
    set abstime [expr $delta_time + $abstime]
    set absecs  [expr $abstime/1000]
    set abms    [expr $abstime%1000]
    if ![info exists CAS_SIGIDS($darr(SignalId))] {
	set signame "UNKNOWN" 
    } else {
    	set signame $CAS_SIGIDS($darr(SignalId))
    }
    set linedata [format "|%9s|%10d|%8d:%3d|%3s|%4s|%4s|%11s|%18s|" \
		  $hosttime $delta_time $absecs $abms \
		  $direction $TRANSCODES($i_oldpostrans) $TRANSCODES($o_oldpostrans) \
		  $darr(SignalId) $signame ]
    trace $linedata
    trace $tablebreak 
    set linecount [expr $linecount + 2]
    if {$linecount >= 48} {
    	trace "\f"
    	header
    }
    return
}

proc rtcTransEvt {obj type data} {
    global prev_time hosttime abstime tablebreak TRANSCODES linecount
    global i_oldpostrans o_oldpostrans firstin firstout
    set hosttime [clock format [clock seconds] -format %T]
    array set darr $data
    if ![info exists prev_time] {
	set prev_time $darr(Timestamp)
    }
    set delta_time [expr $darr(Timestamp) - $prev_time]
    set prev_time $darr(Timestamp)
    set abstime [expr $delta_time + $abstime]
    set absecs  [expr $abstime/1000]
    set abms    [expr $abstime%1000]
    if {$darr(Direction)==1} {
	set direction "I "
	if {$firstin == 0} {
	    set posttrans [ format "0x%x" [expr $darr(PreTransCode) & 0x0f] ]
	    incr firstin
            set linedata [format "|%9s|%10s|%12s|%3s|%4s|%4s|%11s|%18s|" \
		          " " " " " " \
	   	          $direction $TRANSCODES($posttrans) $TRANSCODES($o_oldpostrans) \
			  " " " "] 
            trace $linedata
            trace $tablebreak 
            set linecount [expr $linecount + 2]
        }
	set posttrans [ format "0x%x" [expr $darr(PostTransCode) & 0x0f] ]
        set linedata [format "|%9s|%10d|%8d:%3d|%3s|%4s|%4s|%11s|%18s|" \
		      $hosttime $delta_time $absecs $abms \
		      $direction $TRANSCODES($posttrans) $TRANSCODES($o_oldpostrans) \
		      " " " " ]
    } else {
	set direction "O "
	if {$firstout == 0} {
	    set posttrans [ format "0x%x" [expr $darr(PreTransCode) & 0x0f] ]
	    incr firstout
            set linedata [format "|%9s|%10s|%12s|%3s|%4s|%4s|%11s|%18s|" \
		          " " " " " " \
	  	          $direction $TRANSCODES($i_oldpostrans) $TRANSCODES($posttrans) \
		          " " " "]
            trace $linedata
            trace $tablebreak 
            set linecount [expr $linecount + 2]
        }
	set posttrans [ format "0x%x" [expr $darr(PostTransCode) & 0x0f] ]
        set linedata [format "|%9s|%10d|%8d:%3d|%3s|%4s|%4s|%11s|%18s|" \
			$hosttime $delta_time $absecs $abms \
			$direction $TRANSCODES($i_oldpostrans) $TRANSCODES($posttrans) \
			" " " " ]
    }
    trace $linedata
    trace $tablebreak 
    set linecount [expr $linecount + 2]
    if {$linecount >= 48} {
    	trace "\f"
    	header
    }
    if {$darr(Direction)==1} {
        set i_oldpostrans $posttrans
    } else {
	set o_oldpostrans $posttrans
    }
    return
}

proc handle_TSCCallState { this type data } {
    global call_state_names call_state_reason_name
    global prev_time hosttime abstime tablebreak linecount
    set hosttime [clock format [clock seconds] -format %T]
    array set darr $data
    if ![info exists prev_time] {
	set prev_time $darr(Timestamp)
    }
    set delta_time [expr $darr(Timestamp) - $prev_time]
    set prev_time $darr(Timestamp)
    set abstime [expr $delta_time + $abstime]
    set absecs  [expr $abstime/1000]
    set abms    [expr $abstime%1000]
    set linedata [format "|%9s|%10s|%8d:%3d|%3s|%4s|%4s|%30s|" \
			  $hosttime $delta_time $absecs $abms \
			  " " " " " " "CALL STATE TRACE"]
    trace $linedata
    incr linecount
    set linedata [format "|%47s|CALL ID:%-22s|" " " $darr(CallId)]
    trace $linedata
    incr linecount
    set linedata [format "|%47s|STATE:%-24s|" " " $call_state_names($darr(CallState))]
    trace $linedata
    incr linecount
    set linedata [format "|%47s|REASON:%-23s|" " " $call_state_reason_name($darr(Reason))]
    trace $linedata
    trace $tablebreak
    set linecount [expr $linecount + 2]
    if {$linecount >= 48} {
    	trace "\f"
    	header
    }
}

proc handle_TSCEvtInfo { this type data } {
    global TSC_EvtCallInfo_Type_CalledId TSC_EvtCallInfo_Type_CallerId 
    global TSC_EvtCallInfo_Type_CallAnalysis ANALYSIS
    global prev_time hosttime abstime tablebreak linecount
    set hosttime [clock format [clock seconds] -format %T]
    array set darr $data
    if ![info exists prev_time] {
	set prev_time $darr(Timestamp)
    }
    set delta_time [expr $darr(Timestamp) - $prev_time]
    set prev_time $darr(Timestamp)
    set abstime [expr $delta_time + $abstime]
    set absecs  [expr $abstime/1000]
    set abms    [expr $abstime%1000]
    set linedata [format "|%9s|%10s|%8d:%3d|%3s|%4s|%4s|%30s|" \
			  $hosttime $delta_time $absecs $abms \
			  " " " " " " "CALL INFORMATION TRACE"]
    trace $linedata
    incr linecount
    set linedata [format "|%47s|CALL ID:%-22s|" " " $darr(CallId)]
    trace $linedata
    incr linecount
    if { $darr(Type) == $TSC_EvtCallInfo_Type_CalledId } {
        set linedata [format "|%47s|DNIS:%-25s|" " " $darr(Value)]
    } elseif {$darr(Type) == $TSC_EvtCallInfo_Type_CallerId } {
        set linedata [format "|%47s|ANI :%-25s|" " " $darr(Value)]
    } elseif {$darr(Type) == $TSC_EvtCallInfo_Type_CallAnalysis } {
        set linedata [format "|%47s|CALL ANALYSIS:%-16s|" " " $ANALYSIS($darr(Value))]
    }
    trace $linedata
    trace $tablebreak
    set linecount [expr $linecount + 2]
    if {$linecount >= 48} {
    	trace "\f"
    	header
    }
}

proc handle_TSCChanState { this type data } {
    global chan_state_name 
    global prev_time hosttime abstime tablebreak linecount
    set hosttime [clock format [clock seconds] -format %T]
    array set darr $data
    if ![info exists prev_time] {
	set prev_time $darr(Timestamp)
    }
    set delta_time [expr $darr(Timestamp) - $prev_time]
    set prev_time $darr(Timestamp)
    set abstime [expr $delta_time + $abstime]
    set absecs  [expr $abstime/1000]
    set abms    [expr $abstime%1000]
    set linedata [format "|%9s|%10s|%8d:%3d|%3s|%4s|%4s|%30s|" \
			  $hosttime $delta_time $absecs $abms \
			  " " " " " " "CHANNEL STATE TRACE"]
    trace $linedata
    incr linecount
    set linedata [format "|%47s|CH STATE:%-21s|" " " $chan_state_name($darr(ChanState))]
    trace $linedata
    trace $tablebreak
    set linecount [expr $linecount + 2]
    if {$linecount >= 48} {
    	trace "\f"
    	header
    }
}

proc apitraceEvt {obj msgtype msg} {
    global prev_time hosttime abstime tablebreak API_MSG linecount
    global call_state_reason_name
    #get trace part of message, does not include embedded msg
    array set darr [$msg bodyGet -Offset 0]
    set hosttime [clock format [clock seconds] -format %T]
    if ![info exists prev_time] {
	set prev_time $darr(Timestamp)
    }
    set delta_time [expr $darr(Timestamp) - $prev_time]
    set prev_time $darr(Timestamp)
    set board_time [clock format [ expr [format "%d" $darr(Timestamp)] / 1000 ] -format %T ]
    set abstime [expr $delta_time + $abstime]
    set absecs  [expr $abstime/1000]
    set abms    [expr $abstime%1000]
    if ![info exists API_MSG($darr(MsgType))] {
	append msgname "UNKNOWN " $darr(MsgType) 
    } else {
    	set msgname $API_MSG($darr(MsgType))
    }
    if ![info exists API_MSG($darr(Type))] {
	append msgtype "UNKNOWN " $darr(Type) 
    } else {
    	set msgtype $API_MSG($darr(Type))
    }
    set linedata [format "|%9s|%10s|%8d:%3d|%3s|%4s|%4s|%30s|" \
			  $hosttime $delta_time $absecs $abms \
			  " " " " " " "API MESSAGE TRACE"]
    trace $linedata
    incr linecount
    set linedata [format "|%47s|MSG:%-26s|" " " $msgname]
    trace $linedata
    incr linecount
    set linedata [format "|%47s|TYPE:%-25s|" " " $msgtype]
    trace $linedata
    incr linecount

    #get the typedef registry object from the resource object
    set tdr [$obj Class set typeDefRegistry]

    #lookup the typedef for the associated msg type
    set td [$tdr lookup -MsgType $darr(MsgType)]

    #read remainder of message using the typedef
    set emb [$msg bodyGet -TypeDef $td]

    array set embarr $emb
    foreach {name value} [array get embarr] {
	if {[string compare $name "Reason"] == 0} {
	    set value $call_state_reason_name($value)
	}
	if {[string compare $name "KVSet"] == 0} {
            set linedata [format "|%10s:%-67s|" $name $value]
            trace $linedata
	    incr linecount
        } else {
            set linedata [format "|%47s|%-15s%-15s|" " " $name $value]
            trace $linedata
	    incr linecount
        }
    }
    trace $tablebreak
    incr linecount
    if {$linecount >= 48} {
    	trace "\f"
    	header
    }
    $msg destroy
}

proc displaytracer { } {
    global inst boardnum line chan logwin log callevts
    wm title . "TRACER Version 1.0"
#Build Tracer Menu
    set cas [frame .casmenu -bg white -height 20 -width 700]
    pack propagate $cas false 
    pack $cas -side top -fill both
    button $cas.select -text "SELECT" -relief raised -command [list selectcas $cas]
    pack $cas.select -ipadx 10 -ipady 10 -side left -fill x
    button $cas.start -text "START TRACE" -relief raised -command \
	   [list startcastrace $cas]
    pack $cas.start -ipadx 10 -ipady 10 -side left -fill x
    button $cas.exit -text "EXIT" -relief raised -command exittrace
    pack $cas.exit -ipadx 10 -ipady 10 -side left -fill x
#Build CAS instance selected, Call state trace selected and Log file labels
    set cassel [frame .cassel -bg white -height 40 -width 700]
    pack propagate $cassel false
    pack $cassel -side top -fill both
    label $cassel.casboard -bg grey -relief sunken -text "BOARD" 
    label $cassel.actboard -bg white -textvariable boardnum 
    label $cassel.casline -bg grey  -relief sunken -text "TRUNK"
    label $cassel.actline -bg white -textvariable line 
    label $cassel.caschan -bg grey -relief sunken -text "CHANNEL" 
    label $cassel.actchan -bg white -textvariable chan  
    label $cassel.callst -bg grey -relief sunken -text "CALLSTATE TRACE" 
    label $cassel.actst -bg white -textvariable callevts  
    label $cassel.caslog -bg grey -relief sunken -text "LOGFILE" 
    label $cassel.actlog -bg white -textvariable caslog  
    pack $cassel.callst -side left 
    pack $cassel.actst -side left 
    pack $cassel.caslog -padx 40 -side left 
    pack $cassel.actlog -side left 
    pack $cassel.actchan -side right 
    pack $cassel.caschan -side right 
    pack $cassel.actline -side right 
    pack $cassel.casline -side right 
    pack $cassel.actboard -side right 
    pack $cassel.casboard -side right 
#Build CAS tracer logging frame
    set logwin [frame .caslog -bg grey50 -height 400 -width 700]
    pack propagate $logwin false
    pack $logwin -side top -fill both
    set log [text $logwin.log -height 400 -yscrollcommand [list $logwin.scroll set ] \
	    -bg SkyBlue1 -fg black -setgrid true]
    scrollbar $logwin.scroll -command { $logwin.log yview } -bg grey 
    pack $logwin.scroll -side right -fill y
    pack $logwin.log -side left -fill both -expand true
    pack $logwin -side top -fill both -expand true
}

proc selectcas {casmenu} {
    destroyinst
    $casmenu.start config -text "START TRACE" -command [list startcastrace $casmenu] 
#Build CAS selection dialog for user input
    set casentry .prompt
    if [Dialog_Create $casentry "CAS SELECT" -borderwidth 10] {
	message $casentry.bmsg -text "Please enter board number (1-17)" -aspect 500
        entry $casentry.eboard -textvariable boardnum -relief sunken
	message $casentry.lmsg -text "Please enter trunk number (1-4)" -aspect 500
        entry $casentry.eline -textvariable line -relief sunken
	message $casentry.cmsg -text "Please enter channel number (1-24/30)" -aspect 500
        entry $casentry.echan -textvariable chan -relief sunken
	message $casentry.smsg -text "Enable Call tracing? (0-No, 1-Include Call State, 2-Include Call Info, 3-Include Channel State, 4-Include API Event Trace)" -aspect 500
        entry $casentry.eevt -textvariable callevts -relief sunken
	set b [frame $casentry.buttons]
	pack $casentry.bmsg $casentry.eboard $casentry.lmsg $casentry.eline \
	     $casentry.cmsg $casentry.echan  $casentry.smsg $casentry.eevt \
	     $casentry.buttons -side top -fill x
        pack $casentry.eboard -pady 5
	pack $casentry.eline -pady 5
	pack $casentry.echan -pady 5
	pack $casentry.eevt -pady 5
	button $b.ok -text OK -command {set prompt(ok) 1}
	pack $b.ok -pady 5 -side top 
	bind $casentry.echan <Return> {set prompt(ok) 1; break}
	bind $casentry.eevt <Return> {set prompt(ok) 1; break}
     }
     set prompt(ok) 0
     Dialog_Wait $casentry prompt(ok) $casentry.echan
     Dialog_Dismiss $casentry
}

proc Dialog_Create {top title args} {
    global dialog
    if [winfo exists $top] {
	switch -- [wm state $top] {
	    normal {
	        # Raise a buried window
	        raise $top
	    }
	    withdrawn -
	    iconified {
		# Open and restore geometry
		wm deiconify $top
		catch {wm geometry $top $dialog(geo,$top)}
	    }
	}
	return 0
    } else {
        eval {toplevel $top} $args
        wm title $top $title
        return 1
    }
}

proc Dialog_Wait {top varName {focus {}}} {
    upvar $varName var
    # Poke the variable if the user nukes the window
    bind $top <Destroy> [list set $varName $var]
    # Grab focus for the dialog
    if {[string length $focus] == 0} {
	set focus $top
    }
    set old [focus -displayof $top]
    focus $focus
    catch {tkwait visibility $top}
    catch {grab $top}
    # Wait for the dialog to complete
    tkwait variable $varName
    catch {grab release $top}
	focus $old
}

proc Dialog_Dismiss {top} {
    global dialog
    # Save current size and position
    catch {
        # window may have been deleted
	set dialog(geo,$top) [wm geometry $top]
	wm withdraw $top
    }
}

proc startcastrace {casframe} {
    global CALLINFODBG CHANSTATEDBG APITRACEDBG
    global linebreak boardnum line chan hosttime abstime 
    global i_oldpostrans o_oldpostrans firstin firstout inst
    global CAS_EventId_AllSignals CAS_EventId_AllTransitions
    global callevts tsc
    global TSC_EvtCallState_Type_Null TSC_EvtCallInfo_Type_BearerChanId \
	   TSC_EvtChanState_Type_Active call_state_evt_list \
	   TSC_EvtCallInfo_Type_CallerId chan_state_evt_list \
	   TSC_EvtTrace_Type_CallControl TSC_EvtCallInfo_Type_CallAnalysis \
	   TSC_EvtCallInfo_Type_CalledId
    set hosttime [clock seconds]
    set abstime  0
    set i_oldpostrans na
    set o_oldpostrans na
    set firstin 0
    set firstout 0
    createcasinstance 
    opencaslog
    trace "\nRTC TRACER WAITING FOR EVENTS...STARTED ON [clock format $hosttime]\n"
    trace "BOARD : $boardnum 	TRUNK : $line	CHANNEL : $chan"
    trace $linebreak
    header
    #register callback for signal group
    $inst asyncRegister -EvtGroup $CAS_EventId_AllSignals -Proc rtcSignalEvt
    $inst asyncRegister -EvtGroup $CAS_EventId_AllTransitions -Proc rtcTransEvt
    $inst DetectEvt -EvtType $CAS_EventId_AllSignals
    $inst DetectEvt -EvtType $CAS_EventId_AllTransitions
    $casframe.start config -text "STOP TRACE" -command [list stopcastrace $casframe]
    if {$callevts} {
	createtscinstance
	$tsc asyncRegister -EvtGroup $TSC_EvtCallState_Type_Null \
			   -Proc handle_TSCCallState
	$tsc asyncRegister -EvtGroup $TSC_EvtCallInfo_Type_BearerChanId \
			   -Proc handle_TSCEvtInfo
	$tsc asyncRegister -EvtGroup $TSC_EvtChanState_Type_Active \
			   -Proc handle_TSCChanState
	#register the handler for API Evt trace messages.
	#NOTE: Set the TypeDef to Msg, this means, don't auto parse
	#the message, instead pass in a raw Msg Object
	$tsc asyncRegister -EvtGroup $TSC_EvtTrace_Type_CallControl \
    			   -Proc apitraceEvt -TypeDef Msg
        #first cancel any enabled events
	catch {$tsc CancelAllEvts}
        #enable call state change detection
	$tsc DetectxEvts -EvtGroup $TSC_EvtCallState_Type_Null \
			 -EvtTypeList $call_state_evt_list
        #enable call info detection
	if {$callevts >= $CALLINFODBG } {
	    $tsc DetectxEvts -EvtGroup $TSC_EvtCallInfo_Type_BearerChanId \
	                     -EvtTypeList [list $TSC_EvtCallInfo_Type_CalledId \
			                        $TSC_EvtCallInfo_Type_CallerId \
						$TSC_EvtCallInfo_Type_CallAnalysis]
        }
	#enable chan state detection
	if {$callevts >= $CHANSTATEDBG } {
	    $tsc DetectxEvts -EvtGroup $TSC_EvtChanState_Type_Active  \
			     -EvtTypeList $chan_state_evt_list
        }
	#Enable API event trace messages ie. register with TSC to send the event
	if {$callevts >= $APITRACEDBG } {
	    $tsc DetectEvt -EvtType $TSC_EvtTrace_Type_CallControl
        }
    }
}

proc trace {traceline} {
    global log hlog
    set tracetext [format "$traceline\n"]
    $log tag configure courier -font {Courier 8}
    $log insert end $tracetext courier 
    $log see end
    if [info exists hlog] {
        puts $hlog $traceline
    }
}

proc exittrace {} {
    destroyinst 
    exit
}

proc stopcastrace {casframe} {
    global prev_time abstime 
    if [info exists prev_time] {
		unset prev_time
	}
    set abstime 0
    destroyinst
    $casframe.start config -text "START TRACE" -command [list startcastrace $casframe] 
}

proc opencaslog {} {
    global boardnum line chan caslog hlog
       set caslog "CAS_"
       append caslog $boardnum "_" $line "_" $chan ".LOG"
    if [catch {open $caslog a} hlog] {
       puts stderr [format "Cannot open CAS Log file %s" $caslog]
    }
}

proc closecaslog {} {
    global hlog
    if [info exists hlog] {
	if [info exists $hlog] {
            close $hlog
        }
	unset hlog
    }
}

proc destroyinst {} {
    global CALLINFODBG CHANSTATEDBG APITRACEDBG
    global board comptype clust inst tsc callevts linecount
    global TSC_EvtCallState_Type_Null TSC_EvtCallInfo_Type_CalledId \
	   TSC_EvtChanState_Type_Active call_state_evt_list \
	   TSC_EvtCallInfo_Type_CallerId chan_state_evt_list \
	   TSC_EvtTrace_Type_CallControl TSC_EvtCallInfo_Type_CallAnalysis 
    set hosttime [clock seconds]
    if [info exists inst] { 
        $inst destroy
	unset inst
    }
    if [info exists tsc] { 
        #disable call state change detection
	$tsc CancelxEvts -EvtTypeList $call_state_evt_list
        #disable call info detection
	if {$callevts >= $CALLINFODBG } {
	    $tsc CancelxEvts -EvtTypeList [list $TSC_EvtCallInfo_Type_CalledId \
			  		        $TSC_EvtCallInfo_Type_CallerId \
						$TSC_EvtCallInfo_Type_CallAnalysis]
	}

	#disable chan state detection
	if {$callevts >= $CHANSTATEDBG } {
	    $tsc CancelxEvts -EvtTypeList $chan_state_evt_list
        }
	
	#Disable API event trace messages ie. register with TSC to cancel the event
	if {$callevts >= $APITRACEDBG } {
	    $tsc CancelEvt -EvtType $TSC_EvtTrace_Type_CallControl
        }

        $tsc destroy
	unset tsc
    }

    if [info exists clust] { 
        $clust destroy
	unset clust 
    }

    if [info exists board] { 
        $board destroy
	unset board 
    }

    trace "\nRTC TRACER ....STOPPED ON [clock format $hosttime]\n"
    trace "\f"
    incr linecount
    closecaslog
}

setuserparms
displaytracer

