# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

# Build list of valid parameters for error or help display
proc CheckParmsVList { procname required optional switches } {

    set valid_list "- ${procname} "

    foreach parm $required {
	lappend valid_list ${parm} arg
    }

    foreach parm $optional {
	set valid_list [concat $valid_list "\[${parm} arg\]"]
    }

    foreach parm $switches {
	set valid_list [concat $valid_list "\[${parm}\]"]
    }

    return $valid_list
}


#CheckParms - check for valid, required, and optional parmaters
#Required Inputs
#-Proc name - the name of the procedure being checked
#-Provided list - the list of provided parameters
#Optional Inputs
#-Required list - the list of required inputs
#-Optional list - the list of optional inputs
#-Switches list - the list of optional switches
proc CheckParms {args} {

    if [catch {
    	#puts $args
	array set parms $args
	set procname $parms(-Proc)
	set prov_tmp $parms(-Provided)
	set cp_valid [list -Proc -Provided -Required -Optional -Switches]

	foreach parm [array names parms] {
	    if [expr [lsearch -exact $cp_valid $parm]==-1] {
		#not a valid option
		error "$parm invalid"
	    }
	}
    } result] {
	#there was an error calling CheckParms
	error "- CheckParms -Proc arg -Provided arg \[-Required arg\] \[-Optional arg\] \[-Switches arg\]"
    }

    if [catch {set required $parms(-Required)} result] {
	set required {}
    }
    if [catch {set optional $parms(-Optional)} result] {
	set optional {}
    }
    if [catch {set switches $parms(-Switches)} result] {
	set switches {}
    }

    # Valid set of parameters (not including switches)
    set valid [concat $required $optional]

    #check if provided == -?, if so return list of valid parms
    if {$prov_tmp == "-?"} {
	error [CheckParmsVList $procname $required $optional $switches]
    }

    #start checking

    #check to see if provided is properly formatted
    set activated_switches {}
    
    #remove the switches
    foreach parm $switches {
	if [expr [set a [lsearch -exact $prov_tmp $parm]]>-1] {
	    set prov_tmp [lreplace $prov_tmp $a $a]
	    lappend activated_switches $parm
	}
    }

    # Scan for concatenated flags and arguments and expand them
    set skiparg 0
    foreach parm $prov_tmp {
       if {$skiparg == 0} {
	  if [expr [lsearch -exact $valid $parm]==-1] {
	    puts stderr "no match on $parm, trying split"
	    set ind [lsearch $valid $parm* ]
	    if {$ind == -1} {
	      puts stdout "Tried to find split, failed for $parm"
	      error "$parm not a valid flag to [CheckParmsVList $procname $required $optional $switches]"
	    } else {
	      puts stderr "Spliting for parm $parm"
	      # parm and value are concatenated
	      # so separate them

	      # Get actual parm for valid parm list
	      set cparm [lindex $valid $ind]
	      puts stderr "input is $cparm"

	      # Delete item from argument list
	      set prov_tmp [lreplace $prov_tmp $ind $ind]

	      # split parm and value and append to arg list
	      lappend prov_tmp2 $cparm [string range $parm [string length $cparm] end]
	      puts stderr "New list is $prov_tmp"

	      # No argument to skip
	      set skiparg 0
	    }
	  } else {
	     # next item in list is argument 
	     set skiparg 1
	  }
       }
    }
    unset skiparg

    #check to see that all flags have a paired argument
    if [catch {array set provarr $prov_tmp}] {
	error "error in switches [CheckParmsVList $procname $required $optional $switches]\n  $args"
    }
   set provided [array names provarr]

    #check to make sure all required are provided
    foreach parm $required {
	if [expr [lsearch -exact $provided $parm]==-1] {
	    error "$parm is a required flag for [CheckParmsVList $procname $required $optional $switches]"
	}
    }

    #return a list of switches, and flag arg pairs
    return [concat Switches [list $activated_switches] Flags [list $prov_tmp]]
};#endof CheckParms



#this is a much faster version of checkparms, it doesn't actually check anything, it only seperates out
#the switches from the flags, NO ERROR CHECKING IS DONE, its about twice as fast
proc quickCheckParms {args} {

    array set parms $args

    set flags {}
    set switches {}
    set provided {}

    set used_switches {}
    set used_flags {}

    catch {set flags $parms(-Required)}
    catch {set flags [concat $flags $parms(-Optional)]}
   
    catch {set provided $parms(-Provided)}
    catch {set switches $parms(-Switches)}

    foreach parm $switches {
	if {[set index [lsearch -exact $provided $parm]]>-1} {
	    lappend used_switches $parm
	    set provided [lreplace $provided $index $index]
	}
    }

    return [list Switches $used_switches Flags $provided]
}

proc toggleCheckParms {} {
    rename CheckParms oldCheckParms
    rename quickCheckParms CheckParms
    rename oldCheckParms quickCheckParms
    return
}

