/**
 * @file  kmbc_target.h
 * @brief Creates platform-independent macros.
 * @date  April 13, 2006
 *
 * INTEL CONFIDENTIAL	
 * Copyright 2006 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to the
 * source code ("Material") are owned by Intel Corporation or its suppliers or
 * licensors.  Title to the Material remains with Intel Corporation or its suppliers
 * and licensors.  The Material contains trade secrets and proprietary and
 * confidential information of Intel or its suppliers and licensors.  The Material is 
 * protected by worldwide copyright and trade secret laws and treaty provisions. No
 * part of the Material may be used, copied, reproduced, modified, published,
 * uploaded, posted, transmitted, distributed, or disclosed in any way without Intel's
 * prior express written permission.
 * 
 * No license under any patent, copyright, trade secret or other intellectual property
 * right is granted to or conferred upon you by disclosure or delivery of the
 * Materials,  either expressly, by implication, inducement, estoppel or otherwise.
 * Any license under such intellectual property rights must be express and approved by
 * Intel in writing.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or alter this notice
 * or any other notice embedded in Materials by Intel or Intel's suppliers or licensors
 * in any way.
 */


#ifndef __KMBC_TARGET_H__
#define __KMBC_TARGET_H__


/* Determine the Target OS */
#if defined( __linux__ ) || defined( __CYGWIN__ )
    #define KMBC_TARGET_LINUX
#elif defined( _WIN32 ) || defined( WIN32 ) || defined( __WINDOWS__ )
    #define KMBC_TARGET_WIN32
#else
    #define KMBC_TARGET_UNKNOWN
#endif  // #if define( __linux__ ) || defined( __CYGWIN__ )




/* Determine the Compiler */
#if defined( __GNUG__ )
    #define KMBC_COMPILER_GCC
#elif defined( _MSC_VER )
    #define KMBC_COMPILER_INTEL_WIN32
#else
    #define KMBC_COMPILER_UNKNOWN
#endif  // #if defined( __GNUG__ )




/* Determine User or Kernel Mode */
#if defined( BUILDING_DRIVER )
    #define KMBC_KERNEL_MODE
#else
    #define KMBC_USER_MODE
#endif




/* Linkage Definitions */
#if defined( KMBC_TARGET_WIN32 )
    #if defined( KMBC_COMPILER_GCC )
        #define KMBC_EXPORT __attribute__(( dllexport ))
        #define KMBC_IMPORT __attribute__(( dllimport ))
    #elif defined( KMBC_COMPILER_INTEL_WIN32 )
        #define KMBC_EXPORT __declspec( dllexport )
        #define KMBC_IMPORT __declspec( dllimport )
    #else
        #define KMBC_EXPORT
        #define KMBC_IMPORT
    #endif  // #if defined( KMBC_COMPILER_GCC )
#else
    #define KMBC_EXPORT
    #define KMBC_IMPORT
#endif  // #if defined( KMBC_TARGET_WIN32 )


#if defined( KMBC_EXPORTS )
    #define KMBC_API KMBC_EXPORT
#else
    #define KMBC_API KMBC_IMPORT
#endif  // #if defined( KMBC_EXPORTS )

#endif  // #ifndef __KMBC_TARGET_H__
