/**
* @file baseendpoint.h
* @brief Declaration of SIP endpoint class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _BASEENDPOINT_H
#define  _BASEENDPOINT_H

#include "defines.h"
#include "bridgedcall.h"
#include "bridgedmedia.h"
#include "bridgedhairp.h"
#include "bridgedrtsp.h"
#include "gclib.h"
#include "videodefs.h"


typedef enum {
  M3G_ENDPOINT = 0,
  SIP_ENDPOINT,
  MM_ENDPOINT,
  ISDN_ENDPOINT,
  SS7_ENDPOINT,
  RTSP_ENDPOINT
} T_ENDPOINT;

//*****************************************************************************
// Class: ::BaseEndpoint
// Description: Common functionality for M3G and SIP endpoints
//*****************************************************************************
class BaseEndpoint
{
public:
   BaseEndpoint(): m_pBridgedCall(NULL), m_pBridgedRtsp(NULL), m_pBridgedMedia(NULL), m_pBridgedHairp(NULL),
                                 m_SelectedVideoCoder(VID_CODER_NONE), 
                                 m_SelectedAudioCoder(AUD_CODER_NONE),
                                 m_SelectedMMFileType(MM_FILE_TYPE_DMF),
                                 m_IsAudTranscodeEnabled(false),
                                 m_IsVidTranscodeEnabled(false){;}
   ~BaseEndpoint(){;}
   
   void SetEndpointType(T_ENDPOINT type){m_endpointType = type;}
   T_ENDPOINT GetEndpointType (){return m_endpointType;}
   
   void SetBridgedCall(BridgedCall* pBridgedCall){m_pBridgedCall = pBridgedCall;}
   BridgedCall* GetBridgedCall (){return m_pBridgedCall;}
   
   void SetBridgedMedia(BridgedMedia* pBridgedMedia){m_pBridgedMedia = pBridgedMedia;}
   BridgedMedia* GetBridgedMedia (){return m_pBridgedMedia;}
   
   void SetBridgedHairp(BridgedHairp* pBridgedHairp){m_pBridgedHairp = pBridgedHairp;}
   BridgedHairp* GetBridgedHairp (){return m_pBridgedHairp;}
   
   void SetBridgedRtsp(BridgedRtsp* pBridgedRtsp){m_pBridgedRtsp = pBridgedRtsp;}
   BridgedRtsp* GetBridgedRtsp (){return m_pBridgedRtsp;}
  
   E_SEL_MM_FILE_TYPE GetSelectedMMFileType() {return m_SelectedMMFileType;}
   E_SEL_VID_CODER GetSelectedVideoCoder() {return m_SelectedVideoCoder;}
   E_SEL_VID_RES   GetSelectedVideoResolution() {return m_SelectedVideoResolution;}
   eVIDEO_FRAMESPERSEC GetSelectedVideoFramesPerSec() {return m_SelectedVideoFramesPerSec;}
   eVIDEO_BITRATE  GetSelectedVideoBitRate() {return m_SelectedVideoBitRate;}
   E_SEL_AUD_CODER GetSelectedAudioCoder() {return m_SelectedAudioCoder;}
   void SetSelectedMMFileType(E_SEL_MM_FILE_TYPE mmFileType) {m_SelectedMMFileType = mmFileType;}
   void SetSelectedVideoCoder(E_SEL_VID_CODER VidCoder) {m_SelectedVideoCoder = VidCoder;}
   void SetSelectedVideoResolution(E_SEL_VID_RES VidRes) {m_SelectedVideoResolution = VidRes;}
   void SetSelectedVideoFramesPerSec(eVIDEO_FRAMESPERSEC VidFps) {m_SelectedVideoFramesPerSec = VidFps;}
   void SetSelectedVideoBitRate(eVIDEO_BITRATE VidBitRate) {m_SelectedVideoBitRate = VidBitRate;}
   void SetSelectedAudioCoder(E_SEL_AUD_CODER AudCoder) {m_SelectedAudioCoder = AudCoder;}
   const char* GetSelVidCoderStr();
   const char* GetSelVidResStr();
   const char* GetSelVidFpsStr();
   const char* GetSelAudCoderStr();
   void SetAudTranscodeEnabled(bool enabled) { m_IsAudTranscodeEnabled = enabled;}
   void SetVidTranscodeEnabled(bool enabled) { m_IsVidTranscodeEnabled = enabled;}
   bool GetAudTranscodeEnabled() { return m_IsAudTranscodeEnabled;}
   bool GetVidTranscodeEnabled() { return m_IsVidTranscodeEnabled;}
 
   void Notify(int event)
   {
      if (m_pBridgedCall)
      {
         METAEVENT metaevent;
         metaevent.evttype =  event;
         metaevent.evtdev = 0;
         m_pBridgedCall->ProcessEvent(metaevent);
      }
      else if (m_pBridgedMedia)
      {
         METAEVENT metaevent;
         metaevent.evttype =  event;
         metaevent.evtdev = 0;
         m_pBridgedMedia->ProcessEvent(metaevent);
      }
#ifdef USE_RTSP
      else if (m_pBridgedRtsp)
      {
         METAEVENT metaevent;
         metaevent.evttype =  event;
         metaevent.evtdev = 0;
         m_pBridgedRtsp->ProcessEvent(metaevent);
      }
#endif
   }

protected:
   BridgedCall          *m_pBridgedCall;
   BridgedRtsp          *m_pBridgedRtsp;
   BridgedMedia         *m_pBridgedMedia;
   BridgedHairp         *m_pBridgedHairp;
 
   E_SEL_VID_CODER	m_SelectedVideoCoder;
   E_SEL_VID_RES	m_SelectedVideoResolution;
   eVIDEO_FRAMESPERSEC	m_SelectedVideoFramesPerSec;
   eVIDEO_BITRATE	m_SelectedVideoBitRate;
   E_SEL_AUD_CODER      m_SelectedAudioCoder;
   E_SEL_MM_FILE_TYPE	m_SelectedMMFileType;
   bool                 m_IsAudTranscodeEnabled;
   bool                 m_IsVidTranscodeEnabled;

   static const char* m_szSelectedVideoCoder[];
   static const char* m_szSelectedAudioCoder[];
private:
   T_ENDPOINT  m_endpointType;
   
};

#endif


