/**
* @file bridgedcalldisconnecting_state.h
* @brief Declaration of BridgedCallDisconnectingState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _BRIDGEDCALLDISCONNECTING_STATE_H
#define  _BRIDGEDCALLDISCONNECTING_STATE_H

#include "bridgedcallstate.h"


//*****************************************************************************
// Class: ::BridgedCallDisconnectingState
// Description: This BridgedCallState subclass is for when a BridgedCall object
//              is waiting for the two endpoints to disconnect.
//*****************************************************************************
class BridgedCallDisconnectingState : public BridgedCallState
{
public:
   BridgedCallDisconnectingState(BridgedCall* pBridgedCall);
   virtual ~BridgedCallDisconnectingState();
   const char *GetStateStr() { return "DISCONNECTING  ";}
   E_BRIDGEDCALLSTATE GetState() { return DISCONNECTING_STATE;}
   void ProcessEvent(METAEVENT metaevent);

private:
   static const int SIP_DISCONNECTED;
   static const int M3G_DISCONNECTED;
   static const int DISCONNECT_CMD_SENT;
   static const int FULL_DISCONNECT_WITH_CMD;
   static const int FULL_DISCONNECT_NO_CMD;

   bool IsIsdnGwCallFullyDisconnected() { return(FULL_DISCONNECT_WITH_CMD == m_StatusBitmask);}
   bool IsNonIsdnGwCallFullyDisconnected() { return(FULL_DISCONNECT_NO_CMD == m_StatusBitmask);}
   bool HasDisconnectBeenSent() {return (IsStatusSet(DISCONNECT_CMD_SENT));}
   void ProcessEndpointDisconnected(METAEVENT metaevent);
};

#endif


