/**
* @file bridgedcallidle_state.cpp
* @brief Definition of BridgedCallIdleState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "bridgedcallidle_state.h"
#include "bridgedcall.h"
#include "endpointmgr.h"
#include "logger.h"
#include "appevents.h"
#include "epstate.h"
#include "main.h"


//*****************************************************************************
// Function: BridgedCallIdleState::BridgedCallIdleState(BridgedCall *pBridgedCall)
// Description: Initializing constructor
// Return:  BridgedCallIdleState*
// Parameters: BridgedCall *pBridgedCall 
//*****************************************************************************
BridgedCallIdleState::BridgedCallIdleState(BridgedCall* pBridgedCall) :
   BridgedCallState(pBridgedCall)
{
}


//*****************************************************************************
// Function: BridgedCallIdleState::~BridgedCallIdleState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
BridgedCallIdleState::~BridgedCallIdleState()
{
}

//*****************************************************************************
// Function: void BridgedCallIdleState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedCallIdleState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case APP_H245_START_REQUEST:
         LOG_ENTRY(metaevent.evtdev, "BridgedCall[%d] BridgedCallIdleState rcvd: APP_H245_START_REQUEST\n",m_pBridgedCall->Index());
         ProcessStartH245Request(metaevent);
         break;
      case APP_SIP_ENDPOINT_ANSWERED:
         LOG_ENTRY(metaevent.evtdev, "BridgedCall[%d] BridgedCallIdleState rcvd: APP_SIP_ENDPOINT_ANSWERED\n",m_pBridgedCall->Index());
	 ProcessSipAnswered(metaevent);
         break;
      case APP_SIP_ENDPOINT_DISCONNECT:
         LOG_ENTRY(metaevent.evtdev, "BridgedCall[%d] BridgedCallIdleState rcvd: APP_SIP_ENDPOINT_DISCONNECT\n",m_pBridgedCall->Index());
         break;
      case APP_SIP_ENDPOINT_DISCONNECTED:
         LOG_ENTRY(metaevent.evtdev, "BridgedCall[%d] BridgedCallIdleState rcvd: APP_SIP_ENDPOINT_DISCONNECTED\n",m_pBridgedCall->Index());
      break;
      case APP_M3G_ENDPOINT_DISCONNECTED:
      case APP_M3G_ENDPOINT_DISCONNECT:
         LOG_ENTRY(metaevent.evtdev, "BridgedCall[%d] BridgedCallIdleState rcvd: APP_M3G_ENDPOINT_DISCONNECTED\n",m_pBridgedCall->Index());
      break;
      default:
         LOG_ERROR(metaevent.evtdev,"BridgedCall[%d] BridgedCallIdleState: Unexpected event type: 0x%x\n",
		   m_pBridgedCall->Index(),metaevent.evttype);
         break;
   }
}

//*****************************************************************************
// Function: void BridgedCallIdleState::ProcessSipAnswered(METAEVENT metaevent)
// Description: Process a SIP Answered event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedCallIdleState::ProcessSipAnswered(METAEVENT metaevent)
{
  Endpoint *pEndpoint = EndpointMngr::Instance()->GetEPFromIdx( m_pBridgedCall->M3gIndex());

  if (pEndpoint->IsClearChannel()) {
    // To distinguish a crossover connection from one dti span to another on the MMP from
    // connections to an ISDN gateway, look at the Loopback peer colunm.  If it is zero,
    // the ISDN gateway will tell us what connection to make.  
    if (pEndpoint->GetLoopbackPeer() == 0)  {
      
      LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - external ISDN GW\n", 
		m_pBridgedCall->Index(), pEndpoint->GetIndex());	
      char command[80];
      // What to connect to is taken from the MapID field in the config file
      sprintf(command, "C %s", pEndpoint->MapID());
      LOG_ENTRY(0, "BridgedCall[%d] Sending connect command %s to ISDN gateway\n", 
		m_pBridgedCall->Index(), command);
      sendCmdToISDNGW(command);
    } // end if no loopback peer 

    else  {  // clear channel with loopback connection
      LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - external loopback, no external ISDN GW\n", 
		m_pBridgedCall->Index(), pEndpoint->GetIndex());	
      // Do a StartMedia() at this endpoint
      LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for endpoint[%d]\n", m_pBridgedCall->Index(), pEndpoint->GetIndex());
      pEndpoint->ChangeState(EPState::H245_STARTING_STATE);
      pEndpoint->StartH245();
      
      LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for its loopback peer endpoint\n", m_pBridgedCall->Index());
      (pEndpoint->GetLoopbackPeer())->ChangeState(EPState::H245_STARTING_STATE);
      (pEndpoint->GetLoopbackPeer())->StartH245();
    }
  }  // end if clear channel

  else  if (pEndpoint->IsSigProtocolManaged()) {  // Direct ISDN/SS7 connection
    if (pEndpoint->GetLoopbackPeer()) {
      LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - direct ISDN/SS7 connection with loopback peer not allowed\n", 
 	        m_pBridgedCall->Index(), pEndpoint->GetIndex());	
      /******************
      JH - now that outbound ISDN/SS7 works, don't want to allow loopback peer and starting of peer's 3G endpoint

      // Do a StartMedia() at this endpoint
      LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - direct ISDN/SS7 connection with loopback peer\n", 
 	        m_pBridgedCall->Index(), pEndpoint->GetIndex());	
      LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for endpoint[%d]\n", m_pBridgedCall->Index(), pEndpoint->GetIndex());
      pEndpoint->ChangeState(EPState::H245_STARTING_STATE);
      pEndpoint->StartH245();
      // Loopback requires startup of 3G on the loopback peer's endpoint from here
      LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for its loopback peer endpoint\n", m_pBridgedCall->Index());
      (pEndpoint->GetLoopbackPeer())->ChangeState(EPState::H245_STARTING_STATE);
      (pEndpoint->GetLoopbackPeer())->StartH245();
      *********************************************************/
    } 
    else  { // no loopback - need to do outbound ISDN/SS7 call
      LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - direct ISDN/SS7 connection doing outbound ISDN/SS7 call\n", 
 	        m_pBridgedCall->Index(), pEndpoint->GetIndex());	

      Endpoint *pEndpoint = EndpointMngr::Instance()->GetEPFromIdx( m_pBridgedCall->M3gIndex());
      if ( pEndpoint )  {
        ISDNEndpoint *pSigEndpoint = pEndpoint->GetSigProtocolEndpoint();
        if (pSigEndpoint) {
          LOG_ENTRY(0, "BridgedCall[%d] - initiating outbound ISDN/SS7 call\n", m_pBridgedCall->Index());
          METAEVENT tmpMetaevent;
          tmpMetaevent.evttype = (long) APP_CALLREQ;
          tmpMetaevent.evtdev = pSigEndpoint->GetGCISDNHandle();
          pSigEndpoint->ProcessEvent(tmpMetaevent);
        }
        else  {
          LOG_ERROR(0,"BridgedCall[%d] Expected SS7/ISDN device, found none\n", m_pBridgedCall->Index());
        }
      }
    }
  } // end direct ISDN connection 
  else  { // Nbup or internal loopback
    if (pEndpoint->GetLoopbackPeer()) {
      // Do a StartMedia() at this endpoint
      LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - Nbup or internal connection with loopback peer\n", 
 	        m_pBridgedCall->Index(), pEndpoint->GetIndex());	
      LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for endpoint[%d]\n", m_pBridgedCall->Index(), pEndpoint->GetIndex());
      pEndpoint->ChangeState(EPState::H245_STARTING_STATE);
      pEndpoint->StartH245();
      // Loopback requires startup of 3G on the loopback peer's endpoint from here
      LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for its loopback peer endpoint\n", m_pBridgedCall->Index());
      (pEndpoint->GetLoopbackPeer())->ChangeState(EPState::H245_STARTING_STATE);
      (pEndpoint->GetLoopbackPeer())->StartH245();
    }  // no loopback - need to do outbound ISDN call
  } // end Nbup or internal loopback

  // Advance BridgedCall's state machine to CONNECTING
  // BrdigedCall's CONNECTING state needs to be notified that a SIP call is connected so that it can
  // advance to a connected state
  m_pBridgedCall->ChangeState(CONNECTING_STATE);
  METAEVENT tmpMetaevent;
  tmpMetaevent.evttype = (long) APP_SIP_ENDPOINT_ANSWERED;
  tmpMetaevent.evtdev = 0;
  tmpMetaevent.evtdatap = 0;
  tmpMetaevent.evtlen = 0;
  m_pBridgedCall->ProcessEvent(tmpMetaevent);
  
}  // end process SipAnswered


/***************************** Delete when rework above is done and working correctly *****************************

  // If we are doing an external loopback scenario, send connect command to whomever is listening
  // on the other end - either an ISDN Mux3G Gateway or another 3G-SIP pair at the end of a crossover
  // cable on another DTI span to warn it of 3G activity on a clear channel DS0
  
      if (pEndpoint->GetTransportName()[0] != 'N' && pEndpoint->GetTransportName()[0] != 'n')  {

	// To distinguish a crossover connection from one dti span to another on the MMP from
	// connections to an ISDN gateway, look at the Loopeback peer colunm.  If it is zero,
        // the ISDN gateway will tell us what connections to make.  If it is non-zero, we use the
	// Loopback peer endpoint numbers to decide which 3G channels to start.

        if (pEndpoint->GetLoopbackPeer() == 0)  {
  	  LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - external loopback  w/ ISDN GW scenario\n", 
		    m_pBridgedCall->Index(), pEndpoint->GetIndex());	
	  char command[80];
          // What to connect to is taken from the MapID field in the config file
	  sprintf(command, "C %s", pEndpoint->MapID());
	  LOG_ENTRY(0, "BridgedCall[%d] Sending connect command %s to ISDN gateway\n", 
		    m_pBridgedCall->Index(), command);
	  sendCmdToISDNGW(command);
        }
        else  {
	  LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - external loopback, no ISDN GW scenario\n", 
		    m_pBridgedCall->Index(), pEndpoint->GetIndex());	
          // Do a StartMedia() at this endpoint
	  LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for endpoint[%d]\n", m_pBridgedCall->Index(), pEndpoint->GetIndex());
	  pEndpoint->ChangeState(EPState::H245_STARTING_STATE);
	  pEndpoint->StartH245();
	  
	  LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for its loopback peer endpoint\n", m_pBridgedCall->Index());
	  (pEndpoint->GetLoopbackPeer())->ChangeState(EPState::H245_STARTING_STATE);
	  (pEndpoint->GetLoopbackPeer())->StartH245();
        }
      }
      else  {
	// Internal loopback scenario
	LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - internal loopback scenario\n", 
		  m_pBridgedCall->Index(), pEndpoint->GetIndex());	
	if (pEndpoint->GetLoopbackPeer()) {
	  // Do a StartMedia() at this endpoint
	  LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for endpoint[%d]\n", m_pBridgedCall->Index(), pEndpoint->GetIndex());
	  pEndpoint->ChangeState(EPState::H245_STARTING_STATE);
	  pEndpoint->StartH245();
	  
	  // Internal loopback requires startup of 3G on the loopback peer's endpoint from here
	  LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for its loopback peer endpoint\n", m_pBridgedCall->Index());
	  (pEndpoint->GetLoopbackPeer())->ChangeState(EPState::H245_STARTING_STATE);
	  (pEndpoint->GetLoopbackPeer())->StartH245();
	}
      }

      // Advance BridgedCall's state machine to CONNECTING
      // BrdigedCall's CONNECTING state needs to be notified that a SIP call is connected
      m_pBridgedCall->ChangeState(CONNECTING_STATE);
      METAEVENT tmpMetaevent;
      tmpMetaevent.evttype = (long) APP_SIP_ENDPOINT_ANSWERED;
      tmpMetaevent.evtdev = 0;
      tmpMetaevent.evtdatap = 0;
      tmpMetaevent.evtlen = 0;
      m_pBridgedCall->ProcessEvent(tmpMetaevent);

}

****************************** ORIGINAL - save for reference **************************

void BridgedCallIdleState::ProcessSipAnswered(METAEVENT metaevent)
{
  Endpoint *pEndpoint = EndpointMngr::Instance()->GetEPFromIdx( m_pBridgedCall->M3gIndex());
  if ( pEndpoint )
    {

#define NEWMETHOD
#ifdef NEWMETHOD
      
      // If we are doing an external loopback scenario, send connect command to whomever is listening
      // on the other end - either an ISDN Mux3G Gateway or another 3G-SIP pair at the end of a crossover
      // cable on another DTI span to warn it of 3G activity on a clear channel DS0

      if (pEndpoint->GetTransportName()[0] != 'N' && pEndpoint->GetTransportName()[0] != 'n')  {

	// To distinguish a crossover connection from one dti span to another on the MMP from
	// connections to an ISDN gateway, look at the Loopeback peer colunm.  If it is zero,
        // the ISDN gateway will tell us what connections to make.  If it is non-zero, we use the
	// Loopback peer endpoint numbers to decide which 3G channels to start.

        if (pEndpoint->GetLoopbackPeer() == 0)  {
  	  LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - external loopback  w/ ISDN GW scenario\n", 
		    m_pBridgedCall->Index(), pEndpoint->GetIndex());	
	  char command[80];
          // What to connect to is taken from the MapID field in the config file
	  sprintf(command, "C %s", pEndpoint->MapID());
	  LOG_ENTRY(0, "BridgedCall[%d] Sending connect command %s to ISDN gateway\n", 
		    m_pBridgedCall->Index(), command);
	  sendCmdToISDNGW(command);
        }
        else  {
	  LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - external loopback, no ISDN GW scenario\n", 
		    m_pBridgedCall->Index(), pEndpoint->GetIndex());	
          // Do a StartMedia() at this endpoint
	  LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for endpoint[%d]\n", m_pBridgedCall->Index(), pEndpoint->GetIndex());
	  pEndpoint->ChangeState(EPState::H245_STARTING_STATE);
	  pEndpoint->StartH245();
	  
	  LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for its loopback peer endpoint\n", m_pBridgedCall->Index());
	  (pEndpoint->GetLoopbackPeer())->ChangeState(EPState::H245_STARTING_STATE);
	  (pEndpoint->GetLoopbackPeer())->StartH245();
        }
      }
      else  {
	// Internal loopback scenario
	LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - internal loopback scenario\n", 
		  m_pBridgedCall->Index(), pEndpoint->GetIndex());	
	if (pEndpoint->GetLoopbackPeer()) {
	  // Do a StartMedia() at this endpoint
	  LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for endpoint[%d]\n", m_pBridgedCall->Index(), pEndpoint->GetIndex());
	  pEndpoint->ChangeState(EPState::H245_STARTING_STATE);
	  pEndpoint->StartH245();
	  
	  // Internal loopback requires startup of 3G on the loopback peer's endpoint from here
	  LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for its loopback peer endpoint\n", m_pBridgedCall->Index());
	  (pEndpoint->GetLoopbackPeer())->ChangeState(EPState::H245_STARTING_STATE);
	  (pEndpoint->GetLoopbackPeer())->StartH245();
	}
      }

#else

      // Christophe - this is what you previously had here.  You may want to go back to this, but for the
      // general demo, we are going to use the above.  Alsdo look at bridgedcalldisconnecting_state.cpp.

      // If we are doing an external loopback scenario, send connect command to whomever is listening
      // on the other end - either an ISDN Mux3G Gateway or another 3G-SIP pair at the end of a crossover
      // cable on another DTI span to warn it of 3G activity on a clear channel DS0

      if (pEndpoint->GetTransportName()[0] != 'N' && pEndpoint->GetTransportName()[0] != 'n')  {
	LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - external loopback scenario\n", 
		  m_pBridgedCall->Index(), pEndpoint->GetIndex());	
	// Parse ordinal channel number out of dti name.  (dtiBxTy - assume one digit "x", and find "y")
	char command[80];
	int chanNo = atoi(&(pEndpoint->GetTransportName()[6]));
	sprintf(command, "C %d", chanNo);
	LOG_ENTRY(0, "BridgedCall[%d] Sending connect command %s to ISDN gateway\n", 
		  m_pBridgedCall->Index(), command);
	sendCmdToISDNGW(command);
      }
      else  {
	// Internal loopback scenario
	LOG_ENTRY(0, "BridgedCall[%d] ProcessSipAnswered for 3G endpoint[%d] - internal loopback scenario\n", 
		  m_pBridgedCall->Index(), pEndpoint->GetIndex());	
	if (pEndpoint->GetLoopbackPeer()) {
	  // Do a StartMedia() at this endpoint
	  LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for endpoint[%d]\n", m_pBridgedCall->Index(), pEndpoint->GetIndex());
	  pEndpoint->ChangeState(EPState::H245_STARTING_STATE);
	  pEndpoint->StartH245();
	  
	  // Internal loopback requires startup of 3G on the loopback peer's endpoint from here
	  LOG_ENTRY(0, "BridgedCall[%d] Starting H245 for its loopback peer endpoint\n", m_pBridgedCall->Index());
	  (pEndpoint->GetLoopbackPeer())->ChangeState(EPState::H245_STARTING_STATE);
	  (pEndpoint->GetLoopbackPeer())->StartH245();
	}
      }
#endif

      // Advance BridgedCall's state machine to CONNECTING
      // BrdigedCall's CONNECTING state needs to be notified that a SIP call is connected
      m_pBridgedCall->ChangeState(CONNECTING_STATE);
      METAEVENT tmpMetaevent;
      tmpMetaevent.evttype = (long) APP_SIP_ENDPOINT_ANSWERED;
      tmpMetaevent.evtdev = 0;
      tmpMetaevent.evtdatap = 0;
      tmpMetaevent.evtlen = 0;
      m_pBridgedCall->ProcessEvent(tmpMetaevent);

    }  // end if pEndpoint
}
***************************************************/

//*****************************************************************************
// Function: void BridgedCallIdleState::ProcessStartH245Request(METAEVENT metaevent)
// Description: Process a start H245 request
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedCallIdleState::ProcessStartH245Request(METAEVENT metaevent)
{
   m_pBridgedCall->ChangeState(CONNECTING_STATE);
}

