/**
* @file bridgedcallopening_state.h
* @brief Declaration of BridgedCallOpeningState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _BRIDGEDCALLOPENING_STATE_H
#define  _BRIDGEDCALLOPENING_STATE_H

#include "bridgedcallstate.h"


//*****************************************************************************
// Class: ::BridgedCallOpeningState
// Description: This BridgedCallState subclass handles the opening of 
//              BridgedCall objects
//*****************************************************************************
class BridgedCallOpeningState : public BridgedCallState
{
public:
   BridgedCallOpeningState(BridgedCall* pBridgedCall);
   virtual ~BridgedCallOpeningState();
   const char *GetStateStr() { return "OPENING        ";}
   E_BRIDGEDCALLSTATE GetState() { return OPENING_STATE;}
   void ProcessEvent(METAEVENT metaevent);

private:
   static const int SIP_OPENED;
   static const int M3G_OPENED;
   static const int SIP_PORT_CONNECTED;
   static const int M3G_PORT_CONNECTED;
   static const int FULLY_OPENED;
   static const int FULLY_PORT_CONNECTED;

   bool IsBridgedCallFullyOpened() { return(FULLY_OPENED == m_StatusBitmask);}
   bool IsBridgedCallFullyPortConnected() { return(FULLY_PORT_CONNECTED == m_StatusBitmask);}
   void ProcessEndpointOpened(METAEVENT metaevent);
   void ProcessEndpointPortConnected(METAEVENT metaevent);
};

#endif



