/**
* @file bridgedhairpconnected_state.cpp
* @brief Definition of BridgedHairpConnectedState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "bridgedhairpconnected_state.h"
#include "bridgedhairp.h"
#include "endpointmgr.h"
#include "epstate.h"
#include "logger.h"
#include "appevents.h"

//*****************************************************************************
// Function: BridgedHairpConnectedState::BridgedHairpConnectedState(BridgedHairp *pBridgedHairp)
// Description: Initializing constructor
// Return:  BridgedHairpConnectedState*
// Parameters: BridgedHairp *pBridgedHairp 
//*****************************************************************************
BridgedHairpConnectedState::BridgedHairpConnectedState(BridgedHairp* pBridgedHairp) :
   BridgedHairpState(pBridgedHairp)
{
}


//*****************************************************************************
// Function: BridgedHairpConnectedState::~BridgedHairpConnectedState()
// Description: Defstructor
// Return:  none
// Parameters: none 
//*****************************************************************************
BridgedHairpConnectedState::~BridgedHairpConnectedState()
{
}

//*****************************************************************************
// Function: void BridgedHairpConnectedState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedHairpConnectedState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case APP_BRIDGEDHAIRP_DISCONNECT:
         LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] BridgedHairpConnectedState rcvd:APP_BRIDGEDHAIRP_DISCONNECT\n",m_pBridgedHairp->Index());
         ProcessDisconnect(metaevent);
         break;

      case APP_M3G_ENDPOINT_DISCONNECT:
      case APP_M3G_ENDPOINT_DISCONNECTED:
         LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] BridgedHairpConnectedState rcvd:APP_M3G_ENDPOINT_DISCONNECTED\n",m_pBridgedHairp->Index());
         ProcessDisconnect(metaevent);
         break;

      case APP_H245_START_REQUEST:
         LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] BridgedHairpConnectedState rcvd:APP_H245_START_REQUEST\n",m_pBridgedHairp->Index());
         break;

      case APP_M3G_ENDPOINT_CONNECTED:
         LOG_ENTRY(metaevent.evtdev, "BridgedCall[%d] BridgedHairpConnectedState rcvd:APP_M3G_ENDPOINT_CONNECTED\n",m_pBridgedHairp->Index());
      break;

      default:
         LOG_ERROR(metaevent.evtdev,"BridgedHairp[%d] BridgedHairpConnectedState: Unexpected event type: 0x%x\n",
         m_pBridgedHairp->Index(),metaevent.evttype);
         break;
   }
}

//*****************************************************************************
// Function: void BridgedHairpConnectedState::ProcessDisconnect(METAEVENT metaevent)
// Description: Process a disconnect event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedHairpConnectedState::ProcessDisconnect(METAEVENT metaevent)
{
  switch (metaevent.evttype)
  {
    case APP_M3G_ENDPOINT_DISCONNECT:   // fall-thru
    case APP_M3G_ENDPOINT_DISCONNECTED:
    {
       m_pBridgedHairp->ChangeState(DISCONNECTING_STATE);
       LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] rcvd:APP_ENDPOINT_DISCONNECT\n", m_pBridgedHairp->Index());

       // determine which endpoint to disconnect which is the opposite of this one which just disconnected
       int hairpinPeerIndex;

       // if this is the caller, reset its index, and stop the media on the callee
       if (m_pBridgedHairp->CallerIndex() == (*(int *)metaevent.evtdatap))
       {
          m_pBridgedHairp->ClearCallerIndex();
          hairpinPeerIndex = m_pBridgedHairp->CalleeIndex();
       }
       else // else reset the callee index and stop the media on the caller
       {
          m_pBridgedHairp->ClearCalleeIndex();
          hairpinPeerIndex = m_pBridgedHairp->CallerIndex();
       }

       Endpoint* pEndpoint = EndpointMngr::Instance()->GetEPFromIdx(hairpinPeerIndex);

       LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] Stopping 3G EP Index = %d\n",
                 m_pBridgedHairp->Index(), hairpinPeerIndex );

       pEndpoint->StopMedia();
       if (pEndpoint->GetLoopbackPeer())  
       {
          LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] Stopping 3G EP Index = %d\n",
                    m_pBridgedHairp->Index(), pEndpoint->GetLoopbackPeer()->GetIndex());
          pEndpoint->GetLoopbackPeer()->StopMedia();
       }
       break;
    }
    default:
       break;  // no-op
  }
}
