/**
* @file bridgedhairpopening_state.cpp
* @brief Definition of BridgedHairpOpeningState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "bridgedhairpopening_state.h"
#include "bridgedhairp.h"
#include "endpointmgr.h"
#include "logger.h"
#include "appevents.h"

// static constant members:
const int BridgedHairpOpeningState::M3G1_OPENED           = 0x01;
const int BridgedHairpOpeningState::M3G2_OPENED           = 0x02;
const int BridgedHairpOpeningState::FULLY_OPENED         =  0x03;
const int BridgedHairpOpeningState::M3G1_PORT_CONNECTED   = 0x10;
const int BridgedHairpOpeningState::M3G2_PORT_CONNECTED   = 0x20;
const int BridgedHairpOpeningState::FULLY_PORT_CONNECTED =  0x30;

//*****************************************************************************
// Function: BridgedHairpOpeningState::BridgedHairpOpeningState(BridgedHairp *pBridgedHairp)
// Description: Initializing constructor
// Return:  BridgedHairpOpeningState*
// Parameters: BridgedHairp *pBridgedHairp 
//*****************************************************************************
BridgedHairpOpeningState::BridgedHairpOpeningState(BridgedHairp* pBridgedHairp)
   : BridgedHairpState(pBridgedHairp)
{
}

//*****************************************************************************
// Function: BridgedHairpOpeningState::~BridgedHairpOpeningState()
// Description: Descructor
// Return:  none
// Parameters: none 
//*****************************************************************************
BridgedHairpOpeningState::~BridgedHairpOpeningState()
{
}

//*****************************************************************************
// Function: void BridgedHairpOpeningState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedHairpOpeningState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case APP_M3G_ENDPOINT_OPENED:
         LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] BridgedHairpOpeningState rcvd:APP_M3G_ENDPOINT_OPENED\n", m_pBridgedHairp->Index());
         // Need to figure out which of the two 3G endpoints has opened.  A ptr to its index was put in 
         // metaevent.evtddatap.
         if (m_pBridgedHairp->isIndex1(*((int *)metaevent.evtdatap)))
           SetStatus(M3G1_OPENED);
         else if (m_pBridgedHairp->isIndex2(*((int *)metaevent.evtdatap))) 
           SetStatus(M3G2_OPENED);
         ProcessEndpointOpened(metaevent);
         break;
      case APP_M3G_ENDPOINT_PORT_CONNECTED:
         LOG_ENTRY(metaevent.evtdev, "BridgedHairp[%d] BridgedHairpOpeningState rcvd:APP_M3G_ENDPOINT_PORT_CONNECTED\n", m_pBridgedHairp->Index());
         if (m_pBridgedHairp->isIndex1(*((int *)metaevent.evtdatap)))
           SetStatus(M3G1_PORT_CONNECTED);
         else if (m_pBridgedHairp->isIndex2(*((int *)metaevent.evtdatap))) 
           SetStatus(M3G2_PORT_CONNECTED);
         ProcessEndpointPortConnected(metaevent);
         break;
      default:
         LOG_ERROR(metaevent.evtdev,"BridgedHairp[%d] BridgedHairpOpeningState: Unexpected event type: 0x%x\n", 
		   m_pBridgedHairp->Index(),metaevent.evttype);
         break;
   }
}

//*****************************************************************************
// Function: void BridgedHairpOpeningState::ProcessEndpointOpened(METAEVENT metaevent)
// Description: Process endpoint opened event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedHairpOpeningState::ProcessEndpointOpened(METAEVENT metaevent)
{
   if (IsBridgedHairpFullyOpened())
   {
      // send commands to M3G endpoints to connect to each other
      Endpoint *pEndpoint1 = EndpointMngr::Instance()->GetEPFromIdx( m_pBridgedHairp->M3gIndex1());
      Endpoint *pEndpoint2 = EndpointMngr::Instance()->GetEPFromIdx( m_pBridgedHairp->M3gIndex2());

      if (pEndpoint1 && pEndpoint2)
      {
         pEndpoint1->ConnectToPeer(pEndpoint2->GetAudioRxPortInfo(), pEndpoint2->GetVideoRxPortInfo());
         pEndpoint2->ConnectToPeer(pEndpoint1->GetAudioRxPortInfo(), pEndpoint1->GetVideoRxPortInfo());
      }
      else
      {
         LOG_ENTRY(0,"BridgedHairp[%d] 3G Endpoint(s) not found\n",m_pBridgedHairp->Index());
      }
   }
}

//*****************************************************************************
// Function: void BridgedHairpOpeningState::ProcessEndpointPortConnected(METAEVENT metaevent)
// Description: Process endpoint port connected event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedHairpOpeningState::ProcessEndpointPortConnected(METAEVENT metaevent)
{
   if ( IsBridgedHairpFullyPortConnected() )
   {
      m_pBridgedHairp->ChangeState(IDLE_STATE);
   }
}

