/**
* @file bridgedhairpopening_state.h
* @brief Declaration of BridgedHairpOpeningState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _BRIDGEDHAIRPOPENING_STATE_H
#define  _BRIDGEDHAIRPOPENING_STATE_H

#include "bridgedhairpstate.h"

//*****************************************************************************
// Class: ::BridgedHairpOpeningState
// Description: This BridgedHairpState subclass handles the opening of 
//              BridgedHairp objects
//*****************************************************************************
class BridgedHairpOpeningState : public BridgedHairpState
{
public:
   BridgedHairpOpeningState(BridgedHairp* pBridgedHairp);
   virtual ~BridgedHairpOpeningState();
   const char *GetStateStr() { return "OPENING        ";}
   E_BRIDGEDHAIRPSTATE GetState() { return OPENING_STATE;}
   void ProcessEvent(METAEVENT metaevent);

private:
   static const int M3G1_OPENED;
   static const int M3G2_OPENED;
   static const int M3G1_PORT_CONNECTED;
   static const int M3G2_PORT_CONNECTED;
   static const int FULLY_OPENED;
   static const int FULLY_PORT_CONNECTED;

   bool IsBridgedHairpFullyOpened() { return(IsStatusSet(FULLY_OPENED));}
   bool IsBridgedHairpFullyPortConnected() { return(IsStatusSet(FULLY_PORT_CONNECTED));}

   void ProcessEndpointOpened(METAEVENT metaevent);
   void ProcessEndpointPortConnected(METAEVENT metaevent);
};

#endif



