/**
* @file bridgedrtsp.h
* @brief Declaration of BridgedRtsp class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _BRIDGEDRTSP_H
#define  _BRIDGEDRTSP_H

#include "defines.h"
#include "locker.h"
#include "bridgedrtspopening_state.h"
#include "bridgedrtspidle_state.h"
#include "bridgedrtspplaying_state.h"
#include "bridgedrtsprecording_state.h"

//*****************************************************************************
// Class: ::BridgedRtsp
// Description: Class to cordinate activities of an RTSP endpoint and a M3G endpoint
//*****************************************************************************
class BridgedRtsp
{
public:
   BridgedRtsp(int index, int m3gIndex, int rtspIndex);
   ~BridgedRtsp();

   BridgedRtspState::E_BRIDGEDRTSPSTATE GetState();
   char *GetStateString();
   void ChangeState(BridgedRtspState::E_BRIDGEDRTSPSTATE eNewCallState);
   void SetLastMessageString(char *pMessageStr);
   int Index() { return m_Index;}
   int M3gIndex() { return m_m3gIndex;}
   int RTSPIndex() { return m_rtspIndex;}
   void ProcessEvent(METAEVENT metaevent);
   void Open();

private:
   BridgedRtsp();
   char                          m_StateBuffer[MAX_STATE_STRING];
   char                          m_CurrentStateStr[MAX_CURRENT_STATE_STR];
   BridgedRtspOpeningState       *m_pBridgedRtspOpeningState;
   BridgedRtspIdleState          *m_pBridgedRtspIdleState;
   BridgedRtspPlayingState       *m_pBridgedRtspPlayingState;
   BridgedRtspRecordingState     *m_pBridgedRtspRecordingState;
   BridgedRtspState              *m_pCurrentState;
   CLocker                       m_StateLock;
   char                          m_LastMessageBuff[MAX_LAST_MSG_STRING];
   int                           m_Index;
   int                           m_m3gIndex;
   int 				 m_rtspIndex;
};

#endif

