/**
* @file bridgedrtspplaying_state.cpp
* @brief Definition of BridgedRtspPlayingState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "bridgedrtspplaying_state.h"
#include "bridgedrtsp.h"
#include "endpointmgr.h"
#include "logger.h"
#include "appevents.h"
#include "epstate.h"

//*****************************************************************************
// Function: BridgedRtspPlayingState::BridgedRtspPlayingState(BridgedRtsp *pBridgedRtsp)
// Description: Initializing constructor
// Return:  BridgedRtspPlayingState*
// Parameters: BridgedRtsp *pBridgedRtsp 
//*****************************************************************************
BridgedRtspPlayingState::BridgedRtspPlayingState(BridgedRtsp* pBridgedRtsp) :
   BridgedRtspState(pBridgedRtsp)
{
}


//*****************************************************************************
// Function: BridgedRtspPlayingState::~BridgedRtspPlayingState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
BridgedRtspPlayingState::~BridgedRtspPlayingState()
{
}

//*****************************************************************************
// Function: void BridgedRtspPlayingState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedRtspPlayingState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case APP_M3G_ENDPOINT_DISCONNECT:
      LOG_ENTRY(metaevent.evtdev, "BridgedRtsp[%d] BridgedRtspPlayingState::rcvd:APP_M3G_ENDPOINT_DISCONNECT\n",m_pBridgedRtsp->Index());
      break;
      case APP_M3G_ENDPOINT_DISCONNECTED:
      LOG_ENTRY(metaevent.evtdev, "BridgedRtsp[%d] BridgedRtspPlayingState::rcvd:APP_M3G_ENDPOINT_DISCONNECTED\n",m_pBridgedRtsp->Index());
      Process3GDisconnected(metaevent);
      break;
      case APP_RTSP_ENDPOINT_DISCONNECTED: 
      LOG_ENTRY(metaevent.evtdev, "BridgedRtsp[%d] BridgedRtspPlayingState::rcvd:APP_RTSP_ENDPOINT_DISCONNECTED\n",m_pBridgedRtsp->Index());
      break;
      case APP_RTSP_ENDPOINT_IDLE:
      LOG_ENTRY(metaevent.evtdev, "BridgedRtsp[%d] BridgedRtspPlayingState::rcvd:APP_RTSP_ENDPOINT_IDLE\n",m_pBridgedRtsp->Index());
      // RTSP play has terminated
      ProcessRtspDone(metaevent);
      break;
      default:
         LOG_ERROR(metaevent.evtdev,"BridgedRtsp[%d] BridgedRtspPlayingState: Unexpected event type: 0x%x\n",
		   m_pBridgedRtsp->Index(),metaevent.evttype);
         break;
   }
}

//*****************************************************************************
// Function: void BridgedRtspPlayingState::ProcessRTSPPlaying(METAEVENT metaevent)
// Description: Process an RTSP playing  event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void BridgedRtspPlayingState::ProcessRtspDone(METAEVENT metaevent)
{
      // Done playing; advance BridgedRtsp's state machine to IDLE 
      m_pBridgedRtsp->ChangeState(IDLE_STATE);
}


void BridgedRtspPlayingState::Process3GDisconnected(METAEVENT metaevent)
{
  // Want to stop the play in progress
  RTSPEndpoint *pRTSPEndpoint = EndpointMngr::Instance()->GetRTSPEPFromIdx( m_pBridgedRtsp->RTSPIndex());
  if (pRTSPEndpoint)  {
    pRTSPEndpoint->StopRTSPPlay();
  } 
}

