/**
*
* DIALOGIC CONFIDENTIAL
* Copyright � 2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "isdnwaitcall_state.h"
#include "isdnendpoint.h"
#include "endpointmgr.h"
#include "logger.h"

// Temp here
#include "appevents.h"



//*****************************************************************************
// Function: ISDNWaitCallState::ISDNWaitCallState(ISDNEndpoint *pISDNEndpoint)
// Description: Initializing constructor
// Return:  ISDNWaitCallState*
// Parameters: ISDNEndpoint *pISDNEndpoint 
//*****************************************************************************
ISDNWaitCallState::ISDNWaitCallState(ISDNEndpoint* pISDNEndpoint) :
   ISDNEPState(pISDNEndpoint)
{
}


//*****************************************************************************
// Function: ISDNWaitCallState::~ISDNWaitCallState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
ISDNWaitCallState::~ISDNWaitCallState()
{
}

//*****************************************************************************
// Function: bool ISDNWaitCallState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: bool 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void ISDNWaitCallState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case GCEV_BLOCKED:
         LOG_ERROR(metaevent.evtdev, "ISDNWaitCallState: GCEV_BLOCKED received - channel may not recover\n");
         //TODO: ALARM_STATE not implemented - instead log error, hope for UNBLOCKED
         //m_pISDNEndpoint->ChangeState(ALARM_STATE);
         break;
      case GCEV_UNBLOCKED:
         LOG_ENTRY(metaevent.evtdev, "ISDNWaitCallState: GCEV_UNBLOCKED received\n");
         break;
     case GCEV_OFFERED:
         LOG_ENTRY(metaevent.evtdev, "ISDNWaitCallState: GCEV_OFFERED received\n");
         if (m_pISDNEndpoint->AnswerCall(metaevent.crn) == true)
        	 m_pISDNEndpoint->ChangeState(ACCEPTED_STATE);
         break;         
     case APP_CALLREQ:
         LOG_ENTRY(metaevent.evtdev, "ISDNWaitCallState: APP_CALLREQ received\n");
	 ProcessCallRequest();
         break;
     case GCEV_DISCONNECTED:
         LOG_ENTRY(metaevent.evtdev, "ISDNWaitCallState: GCEV_DISCONNECTED received - ignore\n");
         break;         
      default:
         LOG_ERROR(metaevent.evtdev,"ISDNWaitCallState: Unexpected event type:%d\n",metaevent.evttype);
         break;
   }
}


//*****************************************************************************
// Function: void ISDNWaitCallState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void ISDNWaitCallState::Shutdown()
{
  LOG_ENTRY(m_pISDNEndpoint->GetGCISDNHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
  //m_pISDNEndpoint->CloseSubDevs();
}

//*****************************************************************************
// Function: void ISDNWaitCallState::ProcessCallRequest()
// Description: Process request to make an outbound
// Return: void 
// Parameters: none 
//*****************************************************************************
void ISDNWaitCallState::ProcessCallRequest()
{
   LOG_ENTRY(m_pISDNEndpoint->GetGCISDNHandle(), "Making outbound ISDN/SS7 call\n");
   m_pISDNEndpoint->MakeCall();
   m_pISDNEndpoint->ChangeState(ISDNEPState::CALLING_STATE);
}


