/**
* @file m3g-sip_gateway_version.cpp
* @brief m3g-sip_gateway version information
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
*
*          DESCRIPTION:
*                      This is the 'more recent' version history file for the m3g-sip_gateway demo
*
*                      Version number looks like this:
*                      "KEYWORD TMmmBBAA-<build> exename <optional string>"
*
* Where:
*       KEYWORD = DLcid
*       T  = type (0-Prod, 1-Beta, 2-Alpha, 3-Expr, 4-Special)
*       M  = major number (0-9)
*       mm = minor number (00-99)
*       BB = beta number  (00-99)
*       AA = alpha/experimental number (00-99)
*       <build> - build number (reset to 0 when major/minor/alpha/beta change)
*       <exename> - name of file this is a version of
*       <optional string> - optional comment string
*
************************************************************************************************/

/*
 *                                                                ---Type: 0=Prod, 1=Beta, 2=Alpha, 3=Exp
 *                                                               | -----Major Number
 *                                                               ||  -----Minor Number
 *                                                               || |  -----Beta Number
 *                                                               || | |  -----Alpha/Exp Number
 *                                                               || | | |
 *                                                               || | | |
 *                                                               vv v v v
*/
const char * M3G_SIP_GATEWAY_BINARY_VERSION_STRING	= "DLcid 01200000-04 m3g-sip_gateway";
const char * M3G_SIP_GATEWAY_VERSION_STRING		= "01200000-04";
const char * M3G_SIP_GATEWAY_RELEASE_STRING         	= "M3G-SIP_GW";

/******************************************************************************************
*
********* m3g-sip_gateway-Version 1.20-Build-4************************* Jul-2010 [PL]
1. added H264 support
/******************************************************************************************
*
********* m3g-sip_gateway-Version 1.20-Build-3************************* Sep-2009 [JM]
1. Fixed compilation errors with RH5u2
2. Added .3gp play support (MPEG4/AMR-NB)
*******************************************************************************************
*
********* m3g-sip_gateway-Version 1.20-Build-2************************* Mar-2009 [JM/SK/JS]
1. Added MPEG4 DCI handling
2. Added file rotate (-r option)
*******************************************************************************************

********* m3g-sip_gateway-Version 1.20-Build-1************************* Nov-21-2008 [JM/JS]
1. Added RTSP support - new RTSP Endpoint and Bridged RTSP endpoints
2. Enhanced Transcode capabilities 
	- Added directional Video and Audio Transcoding per port connection
3. Added G729 support
4. Enhanced MM Play/Record support 
	- Added support for PCM and native (g711u/a, g723, g729, amr) file types
	- Added Video resolution, bitrate and frame rate specification per file
5. Added DTMF section (H245UII) of PLAY/RECORD MM operations
6. Added Dynamic coder support (base on SDP) for inbound SIP calls
	- Video (mpeg4,h263)
    - Audio (g711u, g711a, amr, g723, g729)
7. Enhanced terminal display output to track codecs, transcoding and file names
8. Added compile option for Runtime Control b/c RTC is not supported for all MM file types
9. Enabled earlier application logging of configuration parsing and validation.
10. Fix bug in config file parsing to allow lowercase for SIPAUD/SIPVID coders
11. Fixed SDP parsing bugs
12.  Fixed other bugs in demo
*******************************************************************************************

********* m3g-sip_gateway-Version 1.00-Build-2************************* Aug-12-2008 [SKS/JM]
1. Added dynamic file naming for record
2. Added playback recorded file immediately after user presses any dtmf digit
4. Added hangup after playback of recorded data
5. Added Runtime Control for mm_Play() and mm_Record()
6. Added fast call teardown api call
7. Disabled tracing in config files

//15-07-2008
1. Added automatic update bitrate / frame rate / video size based on Answer SDP
2. Added automatic selection of audio/video coded for mm_Play() / mm_Record() based on m3g
3. Removed unnecessory code from mm_Play() and mm_Record()
4. Added disconnect after play finished in either case PLAY or Play after RECORD
5. changed video size to QCIF, if only one offered as SQCIF it would be SQCIF
6. Implemented G723.1 audio codec for  mm_Play() and mm_Record()
 
********************************************************************************************
*
********* m3g-sip_gateway-Version 1.00-Build-1*************************** June-27-2008 [RW]
* Updated to support MONA
*******************************************************************************************
*
********* m3g-sip_gateway-Version 0.60-Build-3***************************** May-02-2008 [JM]
* Update to compile on SUSE
* Files: openinglcs_state.cpp, bridgedcall.cpp
*******************************************************************************************
*
*******************************************************************************************
* Version 0.60 Build 2
* March 28 2008: JM - fixed typo in default MPEG4 DCI, updated default DCI value to remove
*				 data partitioning
* Files:         endpoint.cpp
*******************************************************************************************
*
*******************************************************************************************
* Version 0.60 Build 1
* March 21 2008: JM - This is the MMK baseline
*                Baselines Supported: HMP3.1, MMP1.1, MMP2.0, MMK1.0
*                Features Supported: MM, ISDN, NbUP, Transcode 
*******************************************************************************************
*
*
******************************************************************************************/
