/**
* @file mmopening_state.cpp
* @brief Definition of MMOpeningState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "mmlib.h"
#include "mmopening_state.h"
#include "mmendpoint.h"
#include "endpointmgr.h"
#include "logger.h"

#include "appevents.h"

// static constant members:
const int MMOpeningState::TX_PORTS_RCVD = 0x01;
const int MMOpeningState::RX_PORTS_RCVD = 0x02;
const int MMOpeningState::MMEP_OPENED   = 0x04;
const int MMOpeningState::MMEP_READY    = 0x07;


//*****************************************************************************
// Function: MMOpeningState::MMOpeningState(MMEndpoint *pMMEndpoint)
// Description: Initializing constructor
// Return:  MMOpeningState*
// Parameters: MMEndpoint *pMMEndpoint 
//*****************************************************************************
MMOpeningState::MMOpeningState(MMEndpoint* pMMEndpoint) :
   MMEPState(pMMEndpoint)
{
}

//*****************************************************************************
// Function: MMOpeningState::~MMOpeningState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
MMOpeningState::~MMOpeningState()
{
}

//*****************************************************************************
// Function: void MMOpeningState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void MMOpeningState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
    case MMEV_OPEN:
      LOG_ENTRY(metaevent.evtdev, "Event MMEV_OPEN received\n");
      SetStatus(MMEP_OPENED);
      ProcessMMOpen(metaevent);
        break;
    case DMEV_GET_TX_PORT_INFO:
      LOG_ENTRY(metaevent.evtdev, "Event DMEV_GET_TX_PORT_INFO received\n");
      ProcessTxPortInfo(metaevent);
        break;
    case DMEV_GET_RX_PORT_INFO:
      LOG_ENTRY(metaevent.evtdev, "Event DMEV_GET_RX_PORT_INFO received\n");
      ProcessRxPortInfo(metaevent);
        break;
    default:
      LOG_ERROR(metaevent.evtdev,"MMOpening state: Unexpected event type: 0x%x\n",
		metaevent.evttype);
        break;
   }
}

void MMOpeningState::ProcessMMOpen(METAEVENT metaevent)
{
      m_pMMEndpoint->GetMMPortInfo();
}

void MMOpeningState::ProcessTxPortInfo(METAEVENT metaevent)
{
   DM_PORT_INFO_LIST* pTxPortInfoList = reinterpret_cast<DM_PORT_INFO_LIST*>(metaevent.evtdatap);
 
   m_pMMEndpoint->RecordPortInfoList(metaevent, pTxPortInfoList);
   m_pMMEndpoint->SetTxPortInfoList(pTxPortInfoList);
   SetStatus(TX_PORTS_RCVD);
 
   if ( IsMMEndpointReady() )
   {
      LOG_ENTRY(metaevent.evtdev, "MM endpoint ready for port connect\n");
      m_pMMEndpoint->ChangeState(PORTCONNECTING_STATE);
      m_pMMEndpoint->Notify(APP_MM_ENDPOINT_OPENED);
   }
}
 
void MMOpeningState::ProcessRxPortInfo(METAEVENT metaevent)
{
   DM_PORT_INFO_LIST* pRxPortInfoList = reinterpret_cast<DM_PORT_INFO_LIST*>(metaevent.evtdatap);
 
   m_pMMEndpoint->RecordPortInfoList(metaevent, pRxPortInfoList);
   m_pMMEndpoint->SetRxPortInfoList(pRxPortInfoList);
   SetStatus(RX_PORTS_RCVD);
 
   if ( IsMMEndpointReady() )
   {
      LOG_ENTRY(metaevent.evtdev, "MM endpoint ready for port connect\n");
      m_pMMEndpoint->ChangeState(PORTCONNECTING_STATE);
      m_pMMEndpoint->Notify(APP_MM_ENDPOINT_OPENED);
   }
}

//*****************************************************************************
// Function: void MMOpeningState::ProcessUserPrompt(MMEPState::E_USER_PROMPT_TYPE eUserPrompt)
// Description: Procerss request from user interface
// Return: void 
// Parameters: MMEPState::E_USER_PROMPT_TYPE eUserPrompt 
//*****************************************************************************
/*********
void  MMOpeningState::ProcessUserPrompt(MMEPState::E_USER_PROMPT_TYPE eUserPrompt)
{
   LOG_ERROR(0,"Unexpected user prompt on MM endpoint in OPENING state: %d\n",
             static_cast<int>(eUserPrompt));
}
****************/

//*****************************************************************************
// Function: void MMOpeningState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void MMOpeningState::Shutdown()
{
  LOG_ENTRY(m_pMMEndpoint->GetMMHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
}

//*****************************************************************************
// Function: void MMOpeningState::ProcessDeviceOpen(METAEVENT metaevent)
// Description: Process device open completion event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void MMOpeningState::ProcessDeviceOpen(METAEVENT metaevent)
{
   LOG_ENTRY(metaevent.evtdev,"ProcessDeviceOpen\n");

   //if ( true == IsEndpointFullyOpened() )
//   {
      LOG_ENTRY(metaevent.evtdev,"MMEndpoint -  GC and IPM devices both open, GC Unblocked received, waiting for call on even numbered devices\n");
   //}
}

